/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import mikera.tyrant.Chest;
import mikera.tyrant.Effect;
import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.Personality;
import mikera.tyrant.Poison;
import mikera.tyrant.Potion;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;
import mikera.tyrant.util.LibMetaData;
import mikera.tyrant.util.MetaData;
import mikera.tyrant.util.MetaDataEntry;

public class LibMetaDataHandler {
    private static final String THING = "thing";
    private static final String ITEM = "item";
    private static final String BEING = "being";
    private static final String EFFECT = "effect";
    private static final String TEMPORARY_EFFECT = "temporary effect";
    private static final String FOOD = "food";
    private static final String SCROLL = "scroll";
    private static final String MISSILE = "missile";
    private static final String RANGED_WEAPON = "ranged weapon";
    private static final String POTION = "potion";
    private static final String THROWING_WEAPON = "throwing weapon";
    private static final String WAND = "wand";
    private static final String RING = "ring";
    private static final String COIN = "coin";
    private static final String ARMOUR = "armour";
    private static final String HELMET = "helmet";
    private static final String BOOTS = "boots";
    private static final String WEAPON = "weapon";
    private static final String SWORD = "sword";
    private static final String HAMMER = "hammer";
    private static final String AXE = "axe";
    private static final String POLEARM = "polearm";
    private static final String MACE = "mace";
    private static final String UNARMED_WEAPON = "unarmed weapon";
    private static final String SECRET = "secret";
    private static final String SECRET_DOOR = "secret door";
    private static final String SECRET_PASSAGE = "secret passage";
    private static final String SECRET_ITEM = "secret item";
    private static final String SPELLBOOK = "spellbook";
    private static final String CHEST = "chest";
    private static final String DECORATION = "decoration";
    private static final String SCENERY = "scenery";
    private static final String DOOR = "door";
    private static final String FURNITURE = "furniture";
    private static final String SIGN = "sign";
    private static final String PLANT = "plant";
    private static final String TREE = "tree";
    private static final String PORTAL = "portal";
    private static final String INVISIBLE_PORTAL = "invisible portal";
    private static final String STAIRS = "stairs";
    private static final String TRAP = "trap";
    private static final String MONSTER = "monster";
    private static final String HUMANOID = "humanoid";
    private static final String BANDIT = "bandit";
    private static final String GOBLINOID = "goblinoid";
    private static final String GOBLIN = "goblin";
    private static final String ORC = "orc";
    private static final String INSECT = "insect";
    private static final String SNAKE = "snake";
    private static final String CRITTER = "critter";
    private static final String PERSON = "person";
    private static TreeMap DESCRIPTIONS = null;

    protected static void createLibraryItems(LinkedHashMap linkedHashMap) {
        System.out.println("Inserting " + linkedHashMap.size() + " items into the library");
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TreeMap treeMap = (TreeMap)linkedHashMap.get(string);
            String string2 = string.substring(string.indexOf("$") + 1);
            MetaData metaData = LibMetaData.instance().get(string2);
            LibMetaDataHandler.createLibraryItem(treeMap, metaData);
        }
    }

    private static void createLibraryItem(TreeMap treeMap, MetaData metaData) {
        String string = (String)treeMap.remove("Name");
        Thing thing = new Thing();
        thing.set("Name", string);
        boolean bl = false;
        System.out.println(" Inserting " + string);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            bl = false;
            String string2 = (String)iterator.next();
            Object object = treeMap.get(string2);
            MetaDataEntry metaDataEntry = metaData.get(string2);
            Object object2 = metaDataEntry.getValue();
            if (object2 instanceof Integer) {
                object = new Integer((String)object);
            }
            if (object2 instanceof Double) {
                object = new Double((String)object);
            }
            if (object instanceof TreeMap) {
                System.out.println("DEBUG: found meta data: " + string2 + ": " + object);
                thing.set(string2, LibMetaDataHandler.createLibraryItemFromMetaData(string2, (TreeMap)object));
                bl = true;
            }
            if (object.getClass().getName().startsWith("mikera.tyrant")) {
                System.out.println("DEBUG: found tyrant object: " + string2 + ": " + object + " = " + object2);
                if (((String)object).indexOf("ChestCreate") >= 0) {
                    thing.set(string2, new Chest.ChestCreation());
                }
                if (((String)object).indexOf("ChestOpen") >= 0) {
                    thing.set(string2, new Chest.ChestOpen());
                }
                if (((String)object).indexOf("ChestClosed") >= 0) {
                    thing.set(string2, new Chest.ChestClosed());
                }
                if (((String)object).indexOf("HealingScript") >= 0) {
                    thing.set(string2, new Potion.HealingScript());
                }
                bl = true;
            }
            if (bl) continue;
            thing.set(string2, object);
        }
        Lib.add(thing);
    }

    private static Object createLibraryItemFromMetaData(String string, TreeMap treeMap) {
        if (string.equals("AddEffectScript")) {
            Integer n = (Integer)treeMap.get("Chance");
            Thing thing = Lib.create((String)treeMap.get("Effect"));
            if (n == null) {
                return Scripts.addEffect((String)treeMap.get("TargetProperty"), thing);
            }
            return Scripts.addEffect((String)treeMap.get("TargetProperty"), thing, n);
        }
        if (string.equals("TemporaryEffect")) {
            Integer n = (Integer)treeMap.get("Multiplier");
            Integer n2 = (Integer)treeMap.get("Chance");
            Thing thing = n == null ? Effect.temporary(Modifier.bonus((String)treeMap.get("Stat"), (Integer)treeMap.get("Bonus")), (Integer)treeMap.get("Time")) : Effect.temporary(Modifier.linear((String)treeMap.get("Stat"), n, (Integer)treeMap.get("Bonus")), (Integer)treeMap.get("Time"));
            if (n2 == null) {
                return Scripts.addEffect((String)treeMap.get("TargetProperty"), thing);
            }
            return Scripts.addEffect((String)treeMap.get("TargetProperty"), thing, n2);
        }
        if (string.equals("SimpleModifier")) {
            Integer n = (Integer)treeMap.get("Multiplier");
            if (n == null) {
                return Modifier.bonus((String)treeMap.get("Stat"), (Integer)treeMap.get("Bonus"));
            }
            return Modifier.linear((String)treeMap.get("Stat"), n, (Integer)treeMap.get("Bonus"));
        }
        if (string.equals("Personality")) {
            Integer n = (Integer)treeMap.get("State");
            if (n == null) {
                return new Personality((Integer)treeMap.get("Type"));
            }
            return new Personality((Integer)treeMap.get("Type"), (Integer)treeMap.get("SubType"));
        }
        return null;
    }

    protected static MetaData createMetaDataFromObject(Object object) {
        MetaData metaData = new MetaData();
        String string = object.getClass().getName();
        if (string.indexOf("ChestOpen") >= 0) {
            metaData.add("TypeInfo", "ChestOpen", null, 0, 6);
            return metaData;
        }
        if (string.indexOf("ChestCreated") >= 0) {
            metaData.add("TypeInfo", "ChestCreate", null, 0, 6);
            return metaData;
        }
        if (string.indexOf("ChestClosed") >= 0) {
            metaData.add("TypeInfo", "ChestClosed", null, 0, 7);
            return metaData;
        }
        if (string.indexOf("HealingScript") >= 0) {
            metaData.add("TypeInfo", "HealingScript", null, 0, 6);
            return metaData;
        }
        if (string.indexOf("AddEffectScript") >= 0) {
            metaData.add("TypeInfo", "AddEffectScript", null, 0, 6);
            metaData.add("Effect", "Poison", null, 1, 6);
            metaData.add("TargetProperty", "Target", null, 1, 6);
            metaData.add("Chance", new Integer(100), null, 2, 7);
            return metaData;
        }
        if (string.indexOf("Modifier") >= 0) {
            metaData.add("TypeInfo", "SimpleModifier", null, 0, 6);
            metaData.add("Stat", new String(), null, 1, 6);
            metaData.add("Bonus", new Integer(0), null, 1, 6);
            metaData.add("Multiplier", new Integer(0), null, 1, 7);
            return metaData;
        }
        if (string.indexOf("Personality") >= 0) {
            metaData.add("TypeInfo", "Personality", null, 0, 6);
            metaData.add("Type", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
            metaData.add("SubType", new Integer(0), new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8)}, 5, 6);
            metaData.add("State", new Integer(0), null, 2, 7);
            return metaData;
        }
        return null;
    }

    protected static LibMetaData createLibMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData();
        metaData.add("IsThing", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Items", null, 1, 6);
        metaData.add("Image", new Integer(0), null, 2, 6);
        metaData.add("Number", new Integer(1), null, 2, 6);
        libMetaData.add(THING, metaData);
        metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsItem", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Items", null, 1, 6);
        metaData.add("Image", new Integer(1), null, 2, 6);
        metaData.add("Name", "Thing", null, 1, 6);
        metaData.add("NameType", new Integer(0), null, 0, 6);
        metaData.add("Z", new Integer(20), null, 0, 6);
        libMetaData.add(ITEM, metaData);
        metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsBeing", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Creatures", null, 1, 6);
        metaData.add("Image", new Integer(340), null, 2, 6);
        metaData.add("IsMobile", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("MoveCost", new Integer(100), null, 2, 6);
        metaData.add("DeathDecoration", "blood pool", null, 1, 6);
        metaData.add("NameType", new Integer(0), null, 0, 6);
        metaData.add("Z", new Integer(40), null, 0, 6);
        libMetaData.add(BEING, metaData);
        libMetaData = LibMetaDataHandler.createEffectMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createPoisonMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createFoodMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createScrollMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createMissileMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createRangedWeaponMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createPotionMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createWandMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createRingMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createCoinMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createArmourMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createWeaponMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createSecretMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createSpellBookMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createChestMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createDecorationMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createSceneryMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createPortalMetaData(libMetaData);
        libMetaData = LibMetaDataHandler.createTrapMetaData(libMetaData);
        LibMetaDataHandler.createMonsterMetaData(libMetaData);
        LibMetaDataHandler.createPersonMetaData(libMetaData);
        return libMetaData;
    }

    private static LibMetaData createEffectMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsEffect", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Effects", null, 1, 6);
        metaData.add("Image", new Integer(45), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("EffectName", EFFECT, null, 1, 6);
        libMetaData.add(EFFECT, metaData);
        metaData = new MetaData(libMetaData.get(EFFECT));
        metaData.add("IsTemporaryEffect", new Integer(1), null, 0, 6);
        metaData.add("IsActive", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        libMetaData.add(TEMPORARY_EFFECT, metaData);
        return libMetaData;
    }

    private static LibMetaData createPoisonMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(EFFECT));
        metaData.add("IsPoison", new Integer(1), null, 0, 6);
        metaData.add("IsActive", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("OnAction", new Poison.PoisonAction(), null, 0, 6);
        metaData.add("Damage", new Integer(3), null, 2, 6);
        metaData.add("DamageType", "poison", null, 1, 6);
        metaData.add("DamageMessage", "You feel the poison weakening you...", null, 1, 6);
        metaData.add("EffectName", "poisoned", null, 1, 6);
        metaData.add("LifeTime", new Integer(30000), null, 2, 6);
        metaData.add("Strength", new Integer(200), null, 2, 6);
        metaData.add("AttributeAddMessage", "You feel poisoned!", null, 1, 6);
        libMetaData.add(POTION, metaData);
        return libMetaData;
    }

    private static LibMetaData createFoodMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsFood", new Integer(1), null, 0, 6);
        metaData.add("IsEdible", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Image", new Integer(226), null, 2, 6);
        metaData.add("HPS", new Integer(4), null, 2, 6);
        metaData.add("Nutrition", new Integer(10), null, 2, 6);
        metaData.add("ItemWeight", new Integer(1000), null, 2, 6);
        metaData.add("Frequency", new Integer(100), null, 2, 6);
        libMetaData.add(FOOD, metaData);
        return libMetaData;
    }

    private static LibMetaData createScrollMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsScroll", new Integer(1), null, 0, 6);
        metaData.add("IsReadable", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Image", new Integer(280), null, 2, 6);
        metaData.add("HPS", new Integer(2), null, 2, 6);
        metaData.add("ItemWeight", new Integer(200), null, 2, 6);
        metaData.add("Frequency", new Integer(40), null, 2, 6);
        metaData.add("ScrollPower", new Integer(10), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("LevelMax", new Integer(30), null, 2, 6);
        metaData.add("NamePlural", "scrolls of spell name", null, 1, 6);
        metaData.add("UName", "scroll titled title", null, 1, 6);
        metaData.add("UNamePlural", "scrolls titled title", null, 1, 6);
        metaData.add("ScrollSpell", "spell name", null, 1, 6);
        libMetaData.add(SCROLL, metaData);
        return libMetaData;
    }

    private static LibMetaData createMissileMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsMissile", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(80), null, 2, 6);
        metaData.add("MissileRecovery", new Integer(50), null, 2, 6);
        metaData.add("MissileType", "bullet", null, 1, 6);
        metaData.add("WieldType", new Integer(21), null, 0, 6);
        metaData.add("HPS", new Integer(4), null, 2, 6);
        metaData.add("ItemWeight", new Integer(500), null, 2, 6);
        metaData.add("Frequency", new Integer(40), null, 2, 6);
        metaData.add("RSKMul", new Integer(30), null, 2, 6);
        metaData.add("RSKBonus", new Integer(0), null, 2, 6);
        metaData.add("RSTMul", new Integer(30), null, 2, 6);
        metaData.add("RSTBonus", new Integer(0), null, 2, 6);
        libMetaData.add(MISSILE, metaData);
        return libMetaData;
    }

    private static LibMetaData createRangedWeaponMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsRangedWeapon", new Integer(1), null, 0, 6);
        metaData.add("RangedWeaponType", "arrow", null, 1, 6);
        metaData.add("Image", new Integer(120), null, 2, 6);
        metaData.add("WieldType", new Integer(20), null, 0, 6);
        metaData.add("HPS", new Integer(120), null, 2, 6);
        metaData.add("ItemWeight", new Integer(4000), null, 2, 6);
        metaData.add("Frequency", new Integer(100), null, 2, 6);
        metaData.add("RSKMul", new Integer(40), null, 2, 6);
        metaData.add("RSKBonus", new Integer(0), null, 2, 6);
        metaData.add("RSTMul", new Integer(40), null, 2, 6);
        metaData.add("RSTBonus", new Integer(0), null, 2, 6);
        libMetaData.add(RANGED_WEAPON, metaData);
        return libMetaData;
    }

    private static LibMetaData createPotionMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData();
        metaData.add("TypeInfo", "HealingScript", null, 0, 6);
        MetaData metaData2 = new MetaData();
        metaData2.add("TypeInfo", "AddEffectScript", null, 0, 6);
        metaData2.add("Effect", "Poison", null, 1, 6);
        metaData2.add("TargetProperty", "Target", null, 1, 6);
        metaData2.add("Chance", new Integer(100), null, 2, 7);
        MetaData metaData3 = new MetaData();
        metaData3.add("TypeInfo", "TemporaryEffect", null, 0, 6);
        metaData3.add("Time", new Integer(2000), null, 2, 6);
        metaData3.add("Modifier", Modifier.bonus("dummy", -1), null, 1, 6);
        metaData3.add("Stat", "MoveSpeed", null, 1, 6);
        metaData3.add("Bonus", new Integer(2000), null, 1, 6);
        metaData3.add("Multiplier", new Integer(100), null, 1, 7);
        metaData3.add("TargetProperty", "Target", null, 1, 6);
        metaData3.add("Chance", new Integer(100), null, 2, 7);
        MetaData metaData4 = new MetaData(libMetaData.get(ITEM));
        metaData4.add("IsPotion", new Integer(1), null, 0, 6);
        metaData4.add("IsDrinkable", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData4.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData4.add("Image", new Integer(240), null, 1, 6);
        metaData4.add("HPS", new Integer(3), null, 1, 6);
        metaData4.add("ItemWeight", new Integer(500), null, 1, 6);
        metaData4.add("Frequency", new Integer(60), null, 1, 6);
        metaData4.add("OnDrunk", new MetaData(), new MetaData[]{metaData, metaData2, metaData3}, 5, 7);
        metaData4.add("HealingPower", new Integer(8), null, 1, 7);
        libMetaData.add(POTION, metaData4);
        metaData4 = new MetaData(libMetaData.get(MISSILE));
        metaData4.add("IsThrowingWeapon", new Integer(1), null, 0, 6);
        metaData4.add("MissileType", "thrown", null, 1, 6);
        metaData4.add("LevelMin", new Integer(4), null, 2, 6);
        metaData4.add("MissileRecovery", new Integer(80), null, 2, 6);
        metaData4.add("Image", new Integer(100), null, 2, 6);
        metaData4.add("HPS", new Integer(15), null, 2, 6);
        metaData4.add("ItemWeight", new Integer(1000), null, 2, 6);
        metaData4.add("RSKMul", new Integer(50), null, 2, 6);
        metaData4.add("RSTMul", new Integer(100), null, 2, 6);
        metaData4.add("Frequency", new Integer(100), null, 2, 6);
        libMetaData.add(THROWING_WEAPON, metaData4);
        return libMetaData;
    }

    private static LibMetaData createWandMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsWand", new Integer(1), null, 0, 6);
        metaData.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Image", new Integer(288), null, 2, 6);
        metaData.add("HPS", new Integer(10), null, 2, 6);
        metaData.add("ItemWeight", new Integer(800), null, 2, 6);
        metaData.add("Frequency", new Integer(60), null, 2, 6);
        metaData.add("Charges", new Integer(1), null, 2, 6);
        metaData.add("Image", new Integer(288), null, 2, 6);
        metaData.add("UName", "wand name", null, 1, 6);
        metaData.add("Name", "wand of wand name", null, 1, 6);
        metaData.add("NamePlural", "wands of wand name", null, 1, 6);
        metaData.add("WandSpell", "spell name", null, 1, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        libMetaData.add(WAND, metaData);
        return libMetaData;
    }

    private static LibMetaData createRingMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData();
        metaData.add("TypeInfo", "SimpleModifier", null, 0, 6);
        metaData.add("Stat", new String(), null, 1, 6);
        metaData.add("Bonus", new Integer(0), null, 1, 6);
        metaData.add("Multiplier", new Integer(0), null, 1, 7);
        MetaData metaData2 = new MetaData(libMetaData.get(ITEM));
        metaData2.add("IsRing", new Integer(1), null, 0, 6);
        metaData2.add("WieldType", new Integer(5), new Integer[]{new Integer(5), new Integer(4)}, 5, 6);
        metaData2.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData2.add("Image", new Integer(200), null, 2, 6);
        metaData2.add("HPS", new Integer(36), null, 2, 6);
        metaData2.add("ItemWeight", new Integer(100), null, 2, 6);
        metaData2.add("LevelMin", new Integer(1), null, 2, 6);
        metaData2.add("Frequency", new Integer(30), null, 2, 6);
        metaData2.add("WieldedModifiers", metaData, null, 0, 7);
        libMetaData.add(RING, metaData2);
        return libMetaData;
    }

    private static LibMetaData createCoinMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsMoney", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(140), null, 2, 6);
        metaData.add("HPS", new Integer(6), null, 2, 6);
        metaData.add("ItemWeight", new Integer(20), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("Value", new Integer(1), null, 2, 6);
        metaData.add("Z", new Integer(18), null, 0, 6);
        metaData.add("Frequency", new Integer(100), null, 2, 6);
        libMetaData.add(COIN, metaData);
        return libMetaData;
    }

    private static LibMetaData createArmourMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsArmour", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(340), null, 2, 6);
        metaData.add("WieldType", new Integer(9), null, 0, 6);
        metaData.add("HPS", new Integer(70), null, 2, 6);
        metaData.add("ItemWeight", new Integer(20000), null, 2, 6);
        metaData.add("Frequency", new Integer(50), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        libMetaData.add(ARMOUR, metaData);
        metaData = new MetaData(libMetaData.get(ARMOUR));
        metaData.add("IsHelmet", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(323), null, 2, 6);
        metaData.add("WieldType", new Integer(11), null, 0, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("HPS", new Integer(40), null, 2, 6);
        metaData.add("ItemWeight", new Integer(5000), null, 2, 6);
        libMetaData.add(HELMET, metaData);
        MetaData metaData2 = new MetaData();
        metaData2.add("TypeInfo", "SimpleModifier", null, 0, 6);
        metaData2.add("Stat", new String(), null, 1, 6);
        metaData2.add("Bonus", new Integer(0), null, 1, 6);
        metaData2.add("Multiplier", new Integer(0), null, 1, 7);
        metaData = new MetaData(libMetaData.get(ARMOUR));
        metaData.add("IsFootwear", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(360), null, 2, 6);
        metaData.add("NameType", new Integer(2), null, 0, 6);
        metaData.add("WieldType", new Integer(8), null, 0, 6);
        metaData.add("HPS", new Integer(24), null, 2, 6);
        metaData.add("LevelMin", new Integer(5), null, 2, 6);
        metaData.add("ItemWeight", new Integer(2800), null, 2, 6);
        metaData.add("UName", BOOTS, null, 1, 6);
        metaData.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 2, 7);
        metaData.add("WieldedModifiers", metaData2, null, 0, 7);
        libMetaData.add(BOOTS, metaData);
        return libMetaData;
    }

    private static LibMetaData createWeaponMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsWeapon", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(2), null, 2, 6);
        metaData.add("WieldType", new Integer(1), new Integer[]{new Integer(1), new Integer(3)}, 5, 6);
        metaData.add("HPS", new Integer(40), null, 2, 6);
        metaData.add("ItemWeight", new Integer(6000), null, 2, 6);
        metaData.add("Frequency", new Integer(50), null, 2, 6);
        metaData.add("AttackCost", new Integer(100), null, 2, 6);
        metaData.add("ASKMul", new Integer(80), null, 2, 6);
        metaData.add("ASKBonus", new Integer(0), null, 2, 6);
        metaData.add("ASTMul", new Integer(80), null, 2, 6);
        metaData.add("ASTBonus", new Integer(0), null, 2, 6);
        metaData.add("DSKMul", new Integer(40), null, 2, 6);
        metaData.add("DSKBonus", new Integer(0), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        libMetaData.add(WEAPON, metaData);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsSword", new Integer(1), null, 0, 6);
        metaData.add("Name", "material + name", null, 1, 6);
        metaData.add("Material", "material", null, 1, 6);
        metaData.add("UName", "uname + name", null, 1, 6);
        libMetaData.add(SWORD, metaData);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsHammer", new Integer(1), null, 0, 6);
        metaData.add("Name", "material + name", null, 1, 6);
        metaData.add("Material", "material", null, 1, 6);
        metaData.add("UName", "uname + name", null, 1, 6);
        libMetaData.add(HAMMER, metaData);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsAxe", new Integer(1), null, 0, 6);
        metaData.add("Name", "material + name", null, 1, 6);
        metaData.add("Material", "material", null, 1, 6);
        metaData.add("UName", "uname + name", null, 1, 6);
        libMetaData.add(AXE, metaData);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsPolearm", new Integer(1), null, 0, 6);
        metaData.add("Name", "material + name", null, 1, 6);
        metaData.add("Material", "material", null, 1, 6);
        metaData.add("UName", "uname + name", null, 1, 6);
        libMetaData.add(POLEARM, metaData);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsMace", new Integer(1), null, 0, 6);
        metaData.add("Name", "material + name", null, 1, 6);
        metaData.add("Material", "material", null, 1, 6);
        metaData.add("UName", "uname + name", null, 1, 6);
        libMetaData.add(MACE, metaData);
        MetaData metaData2 = new MetaData();
        metaData2.add("TypeInfo", "AddEffectScript", null, 0, 6);
        metaData2.add("TargetProperty", new String(), null, 1, 6);
        metaData2.add("TargetName", new String(), null, 1, 6);
        metaData2.add("Chance", new Integer(1), null, 2, 7);
        metaData = new MetaData(libMetaData.get(WEAPON));
        metaData.add("IsUnarmedWeapon", new Integer(1), null, 0, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("OnWeaponDamage", metaData2, null, 1, 6);
        libMetaData.add(UNARMED_WEAPON, metaData);
        return libMetaData;
    }

    private static LibMetaData createSecretMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsSecret", new Integer(1), null, 0, 6);
        metaData.add("IsInvisible", new Integer(1), null, 2, 6);
        metaData.add("ImageSource", "Effects", null, 1, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("Image", new Integer(5), null, 2, 6);
        libMetaData.add(SECRET, metaData);
        metaData = new MetaData(libMetaData.get(SECRET));
        metaData.add("IsSecretDoor", new Integer(1), null, 0, 6);
        libMetaData.add(SECRET_DOOR, metaData);
        metaData = new MetaData(libMetaData.get(SECRET));
        metaData.add("IsSecretPassage", new Integer(1), null, 0, 6);
        libMetaData.add(SECRET_PASSAGE, metaData);
        metaData = new MetaData(libMetaData.get(SECRET));
        metaData.add("IsHiddenItem", new Integer(1), null, 0, 6);
        metaData.add("HiddenThing", "thing name", null, 1, 6);
        libMetaData.add(SECRET_ITEM, metaData);
        return libMetaData;
    }

    private static LibMetaData createSpellBookMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(ITEM));
        metaData.add("IsSpellBook", new Integer(1), null, 0, 6);
        metaData.add("IsReadable", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsMagicItem", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Image", new Integer(285), null, 2, 6);
        metaData.add("HPS", new Integer(12), null, 2, 6);
        metaData.add("ItemWeight", new Integer(3000), null, 2, 6);
        metaData.add("Frequency", new Integer(50), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("LevelMax", new Integer(30), null, 2, 6);
        metaData.add("Name", "spellbook of spell name", null, 1, 6);
        metaData.add("NamePlural", "spellbooks of spell names", null, 1, 6);
        metaData.add("UName", "title", null, 1, 6);
        metaData.add("BookSpell", "spell name", null, 1, 6);
        libMetaData.add(SPELLBOOK, metaData);
        return libMetaData;
    }

    private static LibMetaData createChestMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData();
        metaData.add("TypeInfo", "ChestCreate", null, 0, 6);
        MetaData metaData2 = new MetaData();
        metaData2.add("TypeInfo", "ChestOpen", null, 0, 6);
        MetaData metaData3 = new MetaData();
        metaData3.add("TypeInfo", "ChestClosed", null, 0, 7);
        MetaData metaData4 = new MetaData(libMetaData.get(ITEM));
        metaData4.add("IsChest", new Integer(1), null, 0, 6);
        metaData4.add("IsOpenable", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData4.add("ImageSource", "Scenery", null, 1, 6);
        metaData4.add("Image", new Integer(121), null, 2, 6);
        metaData4.add("ItemWeight", new Integer(10000), null, 2, 6);
        metaData4.add("LevelMin", new Integer(1), null, 2, 6);
        metaData4.add("Z", new Integer(18), null, 0, 6);
        metaData4.add("ImageOpen", new Integer(2), null, 2, 6);
        libMetaData.add(CHEST, metaData4);
        return libMetaData;
    }

    private static LibMetaData createDecorationMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsDecoration", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Scenery", null, 1, 6);
        metaData.add("IsTransparent", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Z", new Integer(5), null, 0, 6);
        libMetaData.add(DECORATION, metaData);
        return libMetaData;
    }

    private static LibMetaData createSceneryMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(THING));
        metaData.add("IsScenery", new Integer(1), null, 0, 6);
        metaData.add("ImageSource", "Scenery", null, 1, 6);
        metaData.add("IsBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsOwned", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Z", new Integer(19), null, 0, 6);
        metaData.add("HPS", new Integer(10), null, 2, 6);
        libMetaData.add(SCENERY, metaData);
        metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsDoor", new Integer(1), null, 0, 6);
        metaData.add("IsOpenable", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("Image", new Integer(144), null, 2, 6);
        metaData.add("ImageOpen", new Integer(1), null, 2, 6);
        metaData.add("Z", new Integer(21), null, 0, 6);
        metaData.add("IsOpen", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsViewBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("HPS", new Integer(30), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        libMetaData.add(DOOR, metaData);
        metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsFurniture", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(200), null, 2, 6);
        metaData.add("LevelMin", new Integer(7), null, 2, 6);
        libMetaData.add(FURNITURE, metaData);
        metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsSign", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(64), null, 2, 6);
        metaData.add("HPS", new Integer(20), null, 2, 6);
        metaData.add("IsBlocking", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        libMetaData.add(SIGN, metaData);
        metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsPlant", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(81), null, 2, 6);
        metaData.add("IsViewBlocking", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsBlocking", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("LevelMin", new Integer(4), null, 2, 6);
        libMetaData.add(PLANT, metaData);
        metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsTree", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(83), null, 2, 6);
        metaData.add("HPS", new Integer(100), null, 2, 6);
        metaData.add("IsViewBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsBlocking", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        libMetaData.add(TREE, metaData);
        return libMetaData;
    }

    private static LibMetaData createPortalMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(SCENERY));
        metaData.add("IsPortal", new Integer(1), null, 0, 6);
        metaData.add("IsBlocking", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("ImageSource", "Scenery", null, 1, 6);
        metaData.add("LevelMin", new Integer(1), null, 7, 6);
        libMetaData.add(PORTAL, metaData);
        metaData = new MetaData(libMetaData.get(PORTAL));
        metaData.add("IsInvisible", new Integer(1), null, 0, 6);
        libMetaData.add(INVISIBLE_PORTAL, metaData);
        metaData = new MetaData(libMetaData.get(PORTAL));
        metaData.add("IsStairs", new Integer(1), null, 0, 6);
        metaData.add("IsBlocking", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsInvisible", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        libMetaData.add(STAIRS, metaData);
        return libMetaData;
    }

    private static LibMetaData createTrapMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(SECRET));
        metaData.add("IsTrap", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(47), null, 2, 6);
        metaData.add("IsWarning", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 2, 6);
        metaData.add("IsActivated", new Integer(1), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("Z", new Integer(0), null, 0, 6);
        libMetaData.add(TRAP, metaData);
        return libMetaData;
    }

    private static LibMetaData createMonsterMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData(libMetaData.get(BEING));
        metaData.add("IsMonster", new Integer(1), null, 0, 6);
        metaData.add("IsMobile", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("IsHostile", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("LevelMax", new Integer(100), null, 2, 6);
        metaData.add("ImageSource", "Creatures", null, 1, 6);
        metaData.add("Image", new Integer(340), null, 2, 6);
        metaData.add("IsActive", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("MoveSpeed", new Integer(100), null, 2, 6);
        metaData.add("AttackSpeed", new Integer(100), null, 2, 6);
        metaData.add("SK", new Integer(9), null, 2, 6);
        metaData.add("ST", new Integer(8), null, 2, 6);
        metaData.add("AG", new Integer(9), null, 2, 6);
        metaData.add("TG", new Integer(8), null, 2, 6);
        metaData.add("IN", new Integer(7), null, 2, 6);
        metaData.add("WP", new Integer(8), null, 2, 6);
        metaData.add("CH", new Integer(6), null, 2, 6);
        metaData.add("CR", new Integer(7), null, 2, 6);
        libMetaData.add(MONSTER, metaData);
        metaData = new MetaData(libMetaData.get(MONSTER));
        metaData.add("IsHumanoid", new Integer(1), null, 0, 6);
        metaData.add("IsIntelligent", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("LevelMin", new Integer(5), null, 2, 6);
        metaData.add("LevelMax", new Integer(100), null, 2, 6);
        metaData.add("Image", new Integer(260), null, 2, 6);
        libMetaData.add(HUMANOID, metaData);
        metaData = new MetaData(libMetaData.get(HUMANOID));
        metaData.add("IsBandit", new Integer(1), null, 0, 6);
        metaData.add("LevelMin", new Integer(7), null, 2, 6);
        metaData.add("LevelMax", new Integer(14), null, 2, 6);
        metaData.add("Image", new Integer(80), null, 2, 6);
        libMetaData.add(BANDIT, metaData);
        metaData = new MetaData(libMetaData.get(HUMANOID));
        metaData.add("IsGoblinoid", new Integer(1), null, 0, 6);
        metaData.add("Image", new Integer(240), null, 2, 6);
        libMetaData.add(GOBLINOID, metaData);
        metaData = new MetaData(libMetaData.get(GOBLINOID));
        metaData.add("IsGoblin", new Integer(1), null, 0, 6);
        metaData.add("DeathDecoration", "slime pool", null, 1, 6);
        metaData.add("LevelMin", new Integer(6), null, 2, 6);
        metaData.add("LevelMax", new Integer(15), null, 2, 6);
        metaData.add("Image", new Integer(244), null, 2, 6);
        libMetaData.add(GOBLIN, metaData);
        metaData = new MetaData(libMetaData.get(GOBLIN));
        metaData.add("IsOrc", new Integer(1), null, 0, 6);
        metaData.add("LevelMin", new Integer(8), null, 2, 6);
        metaData.add("LevelMax", new Integer(17), null, 1, 6);
        metaData.add("Image", new Integer(242), null, 2, 6);
        libMetaData.add(ORC, metaData);
        metaData = new MetaData(libMetaData.get(MONSTER));
        metaData.add("IsInsect", new Integer(1), null, 0, 6);
        metaData.add("DeathDecoration", "slime pool", null, 1, 6);
        metaData.add("Frequency", new Integer(40), null, 2, 6);
        metaData.add("LevelMin", new Integer(3), null, 2, 6);
        metaData.add("LevelMax", new Integer(15), null, 2, 6);
        libMetaData.add(INSECT, metaData);
        metaData = new MetaData(libMetaData.get(MONSTER));
        metaData.add("IsSnake", new Integer(1), null, 0, 6);
        metaData.add("Frequency", new Integer(25), null, 2, 6);
        metaData.add("MoveSpeed", new Integer(70), null, 2, 6);
        metaData.add("Image", new Integer(286), null, 2, 6);
        metaData.add("LevelMin", new Integer(2), null, 2, 6);
        metaData.add("LevelMax", new Integer(8), null, 2, 6);
        libMetaData.add(SNAKE, metaData);
        metaData = new MetaData(libMetaData.get(MONSTER));
        metaData.add("IsCritter", new Integer(1), null, 0, 6);
        metaData.add("Frequency", new Integer(100), null, 2, 6);
        metaData.add("LevelMin", new Integer(1), null, 2, 6);
        metaData.add("LevelMax", new Integer(20), null, 2, 6);
        libMetaData.add(CRITTER, metaData);
        return libMetaData;
    }

    private static LibMetaData createPersonMetaData(LibMetaData libMetaData) {
        MetaData metaData = new MetaData();
        metaData.add("TypeInfo", "Personality", null, 0, 6);
        metaData.add("Type", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData.add("SubType", new Integer(0), new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8)}, 5, 6);
        metaData.add("State", new Integer(0), null, 2, 7);
        MetaData metaData2 = new MetaData(libMetaData.get(MONSTER));
        metaData2.add("IsPerson", new Integer(1), null, 0, 6);
        metaData2.add("IsHostile", new Integer(0), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData2.add("IsIntelligent", new Integer(1), new Integer[]{new Integer(0), new Integer(1)}, 5, 6);
        metaData2.add("Personality", metaData, null, 1, 6);
        libMetaData.add(PERSON, metaData2);
        return libMetaData;
    }

    protected static TreeMap createPropertyDescriptions() {
        if (DESCRIPTIONS == null) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("SK", "Skill");
            treeMap.put("ST", "Strength");
            treeMap.put("AG", "Agility");
            treeMap.put("TG", "Toughness");
            treeMap.put("IN", "Intelligence");
            treeMap.put("WP", "Willpower");
            treeMap.put("CH", "Charisma");
            treeMap.put("CR", "Craft");
            treeMap.put("HPS", "Hit points");
            treeMap.put("HPSMAX", "Maximum hit points");
            treeMap.put("MPS", "Magic points");
            treeMap.put("MPSMAX", "Maximum magic points");
            treeMap.put("APS", "Action points (100 \u2013 1 turn at normal speed)");
            treeMap.put("IsDecoration", "");
            treeMap.put("NoStack", "Don\u2019t allow multiple adds to same square");
            treeMap.put("IsBlocking", "Prevents free movement into same square");
            treeMap.put("IsViewBlocking", "");
            treeMap.put("IsInvisible", "");
            treeMap.put("Level", "level of object");
            treeMap.put("Frequency", "How common the thing is");
            treeMap.put("LevelMin", "Minimum level for generation (required!)");
            treeMap.put("LevelMax", "Maximum level for generation");
            treeMap.put("IsActive", "Gets game updates");
            treeMap.put("IsMobile", "Moves around, has DirectionX and DirectionY set on motion, can fight");
            treeMap.put("DirectionX", "Horizontal direction of last move");
            treeMap.put("DirectionY", "Vertical direction of last move");
            treeMap.put("IsDoor", "");
            treeMap.put("IsSecretDoor", "");
            treeMap.put("IsOpen", "");
            treeMap.put("IsOpenable", "Can be opened e.g. door, chest");
            treeMap.put("IsLocked", "");
            treeMap.put("LockDifficulty", "");
            treeMap.put("IsPortal", "");
            treeMap.put("PortalTargetMap", "Opposite portal object");
            treeMap.put("PortalTargetX", "");
            treeMap.put("PortalTargetY", "");
            treeMap.put("DestinationLevel", "Specific level for target dungeon");
            treeMap.put("DestinationLevelIncrement", "Level increment over current portal level");
            treeMap.put("WorldMap", "Hero only \u2013 top level world map");
            treeMap.put("IsPenetrable", "Is possible to move through (with some resistance), requires IsBlocking");
            treeMap.put("IsPushable", "");
            treeMap.put("IsWarning", "Warning for monsters");
            treeMap.put("IsUsable", "");
            treeMap.put("IsSecret", "Responds to 'search'");
            treeMap.put("IsSecretPassage", "");
            treeMap.put("IsHiddenItem", "");
            treeMap.put("HiddenThing", "Actual hidden thing");
            treeMap.put("HiddenItem", "Name of hidden item to create (null is random)");
            treeMap.put("IsItem", "Indicates whether the object is a pick-uppable item");
            treeMap.put("IsArtifact", "");
            treeMap.put("IsRusty", "");
            treeMap.put("IsIdentified", "");
            treeMap.put("Damage", "");
            treeMap.put("ItemWeight", "Weight per unit");
            treeMap.put("Number", "");
            treeMap.put("Value", "Value per unit");
            treeMap.put("Image", "Number of image in bitmap image (20 per row)");
            treeMap.put("ImageSource", "Name of bitmap image");
            treeMap.put("IsWieldable", "");
            treeMap.put("WieldType", "");
            treeMap.put("IsDrinkable", "");
            treeMap.put("IsReadable", "");
            treeMap.put("IsRangedWeapon", "");
            treeMap.put("IsMagicItem", "");
            treeMap.put("IsFootwear", "");
            treeMap.put("ARM", "Basic armour");
            treeMap.put("ARM:[damtype]", "Armour value vs. particular damage type");
            treeMap.put("RES:[damtype]", "Damage resistance");
            treeMap.put("IsArt", "");
            treeMap.put("IsSpell", "");
            treeMap.put("Level", "Achieved skill level");
            treeMap.put("SpellCost", "Cost in Mps");
            treeMap.put("SpellTarget", "Int type \u2013 self, target, item etc.");
            treeMap.put("SpellUsage", "Int type \u2013 offensive, defensive etc.");
            treeMap.put("SpellCastTime", "");
            treeMap.put("SpellRadius", "");
            treeMap.put("BoltImage", "");
            treeMap.put("IsSkill", "");
            treeMap.put("SkillCost", "Cost to increase skill by one level");
            treeMap.put("IsScroll", "");
            treeMap.put("ScrollSpell", "Spell name");
            treeMap.put("ScrollPower", "Scroll cast power (IN)");
            treeMap.put("IsFood", "");
            treeMap.put("IsEdible", "");
            treeMap.put("Hunger", "Hunger level (in ticks), increases over time");
            treeMap.put("HungerThreshold", "");
            treeMap.put("Nutrition", "Food value provided if eaten");
            treeMap.put("IsInsect", "");
            treeMap.put("IsGoblinoid", "");
            treeMap.put("IsGoblin", "");
            treeMap.put("IsOrc", "");
            treeMap.put("IsSpider", "");
            treeMap.put("IsSnake", "");
            treeMap.put("IsGenerator", "Marks a generator, also needs IsActive set");
            treeMap.put("GenerationRate", "Rate (per million ticks = per 10,000 turns)");
            treeMap.put("GenerationType", "Type of creature to generate");
            treeMap.put("DecayRate", "Rate (per million ticks = per 10,000 turns)");
            treeMap.put("DecayType", "Type of object to generate on decay");
            treeMap.put("DecayMessage", "");
            treeMap.put("AreaDamage", "Damage per turn (100 ticks)");
            treeMap.put("AreaDamageType", "");
            treeMap.put("AreaDamageMessage", "Message to hero");
            treeMap.put("LifeTime", "Lifetime in ticks");
            treeMap.put("AIMode", "Guard, Wander, Attack, Follow");
            treeMap.put("IsHostile", "Is hostile to player");
            treeMap.put("IsInhabitant", "Is a local inhabitant (NPC)");
            treeMap.put("IsInsane", "Attacks anything and everything");
            treeMap.put("GroupNumber", "Typical group size = d(gn)");
            treeMap.put("Leader", "Reference to leader");
            treeMap.put("GuardX1", "");
            treeMap.put("GuardY1", "");
            treeMap.put("GuardX2", "");
            treeMap.put("GuardY2", "");
            treeMap.put("IsEffect", "");
            treeMap.put("IsPoison", "");
            treeMap.put("Damage", "Average damage in HPS");
            treeMap.put("Strength", "Number of hits per million ticks = per 10,000 turns");
            treeMap.put("DamageType", "Damage type e.g. 'poison'");
            treeMap.put("DamageMessage", "Message to display when damage occurs");
            treeMap.put("IsRangedWeapon", "");
            treeMap.put("IsMissile", "");
            treeMap.put("IsThrowingWeapon", "");
            treeMap.put("MissileType", "Name of bolt type e.g. 'arrow'");
            treeMap.put("RangedWeaponType", "Needs to match MissileType of appropriate missiles");
            treeMap.put("FireCost", "APS cost to fire");
            treeMap.put("RSKMul", "");
            treeMap.put("RSKBonus", "");
            treeMap.put("RSTMul", "");
            treeMap.put("RSTBonus", "");
            treeMap.put("ThrowRange", "");
            treeMap.put("Range", "");
            treeMap.put("MissileRecovery", "Percentage chance of missile surviving");
            treeMap.put("Name", "");
            treeMap.put("Description", "Description to display");
            treeMap.put("IsHostile", "Are local inhabitants hostile?");
            treeMap.put("Target", "Target of event");
            treeMap.put("Time", "Length of time over which event occurs");
            treeMap.put("OnCreate", "Called when object created");
            treeMap.put("OnAction", "Called when time progresses on map");
            treeMap.put("OnWeaponAttack", "Called when a weapon attacks a target");
            treeMap.put("OnWeaponHit", "Called when a weapon hits a target");
            treeMap.put("OnDeath", "Called when a thing is killed");
            treeMap.put("Stat", "Name of stat being modified");
            treeMap.put("Source", "Thing causing the modification");
            treeMap.put("Priority", "Order of stat modifier application, High numbers have priority, and are called first to return the stat value");
            treeMap.put("IsFurniture", "");
            treeMap.put("IsSign", "");
            treeMap.put("IsTree", "");
            treeMap.put("IsPlant", "");
            treeMap.put("IsCritter", "");
            treeMap.put("IsBandit", "");
            treeMap.put("IsPerson", "");
            treeMap.put("IsUnarmedWeapon", "");
            treeMap.put("IsStairs", "");
            treeMap.put("IsScenery", "");
            treeMap.put("IsBeing", "");
            treeMap.put("IsThing", "");
            treeMap.put("IsTemporaryEffect", "");
            treeMap.put("IsFire", "");
            treeMap.put("Z", "Z ordering");
            DESCRIPTIONS = treeMap;
        }
        return DESCRIPTIONS;
    }
}

