/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mikera.tyrant.AI;
import mikera.tyrant.Armour;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Combat;
import mikera.tyrant.Damage;
import mikera.tyrant.Describer;
import mikera.tyrant.Description;
import mikera.tyrant.Event;
import mikera.tyrant.EventHandler;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Missile;
import mikera.tyrant.Modifier;
import mikera.tyrant.Movement;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Talkable;
import mikera.tyrant.Text;
import mikera.tyrant.ThingOwner;

public final class Thing
extends BaseObject
implements Description,
ThingOwner {
    private static final long serialVersionUID = 2056412474365358346L;
    public Thing next;
    public ThingOwner place;
    public int x;
    public int y;
    private Thing[] inv;
    private int invcount;
    private HashMap modifiers = null;
    public static final int Z_ELSEWHERE = -10;
    public static final int Z_FLOOR = 0;
    public static final int Z_ONFLOOR = 5;
    public static final int Z_ITEM = 20;
    public static final int Z_MOBILE = 40;
    public static final int Z_OVERHEAD = 60;
    public static final int Z_SYSTEM = 80;
    private static final Thing[] noThings = new Thing[0];
    private static final Modifier[] emptyModifiers = new Modifier[0];

    public Thing() {
    }

    public Thing(String string) {
        super(string);
    }

    public Thing(BaseObject baseObject) {
        super(baseObject);
    }

    public Thing(HashMap hashMap, BaseObject baseObject) {
        super(hashMap, baseObject);
    }

    public Thing(Thing thing) {
        super(thing);
    }

    public String toString() {
        return this.getString("Name");
    }

    public int invCount() {
        return this.invcount;
    }

    public ThingOwner owner() {
        return this.place;
    }

    public int getInventoryWeight() {
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            n += this.inv[i].getWeight();
        }
        return n;
    }

    public Thing[] getItems() {
        this.sortItems();
        if (this.invcount == 0) {
            return new Thing[0];
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!thing.getFlag("IsItem")) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public int countItems(String string) {
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            if (!string.equals(this.inv[i].name())) continue;
            n += this.inv[i].getStat("Number");
        }
        return n;
    }

    public int countIdentifiedItems(String string) {
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!string.equals(this.inv[i].name()) || !Item.isIdentified(thing)) continue;
            n += this.inv[i].getStat("Number");
        }
        return n;
    }

    public int removeItems(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!string.equals(thing.name())) continue;
            int n3 = thing.getStat("Number");
            if (n3 >= n) {
                n2 += n;
                thing.remove(n);
                break;
            }
            thing.remove();
            n -= n3;
            n2 += n3;
            --i;
        }
        return n2;
    }

    public Thing getContents(String string) {
        for (int i = 0; i < this.invcount; ++i) {
            if (!this.inv[i].name().equals(string)) continue;
            return this.inv[i];
        }
        return null;
    }

    public Thing getWeapon(int n) {
        for (int i = 0; i < this.invcount; ++i) {
            if (this.inv[i].y != n) continue;
            return this.inv[i];
        }
        return null;
    }

    public Thing[] getUsableContents() {
        if (this.invcount == 0) {
            return null;
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!thing.getFlag("IsUsable") && !thing.handles("OnUse")) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public Thing[] getFlaggedContents(String string) {
        if (this.invcount == 0) {
            return new Thing[0];
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (thing.getStat(string) <= 0) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public Thing[] getFlaggedItems(String string) {
        int n;
        if (this.invcount == 0) {
            return null;
        }
        int n2 = 0;
        Thing thing = null;
        for (n = 0; n < this.invcount; ++n) {
            thing = this.inv[n];
            if (!thing.getFlag(string)) continue;
            ++n2;
        }
        if (n2 > 0) {
            n = 0;
            Thing[] thingArray = new Thing[n2];
            for (int i = 0; i < this.invcount; ++i) {
                thing = this.inv[i];
                if (!thing.getFlag(string)) continue;
                thingArray[n] = thing;
                ++n;
            }
            return thingArray;
        }
        return null;
    }

    public Thing[] getContents(String string, Object object) {
        if (this.invcount == 0) {
            return null;
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!object.equals(thing.get(string))) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public Thing[] getWieldableContents() {
        if (this.invcount == 0) {
            return null;
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!thing.getFlag("WieldType")) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public void inventoryAction(Event event) {
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            thing.action(event);
        }
    }

    public Thing getThing(int n) {
        return n >= 0 & n < this.invcount ? this.inv[n] : null;
    }

    public int getUsage(int n) {
        return n >= 0 & n < this.invcount ? this.inv[n].y : -1;
    }

    public void ensureSize(int n) {
        if (this.inv != null && n <= this.inv.length) {
            return;
        }
        int n2 = n + 5;
        Thing[] thingArray = new Thing[n2];
        if (this.inv != null) {
            System.arraycopy(this.inv, 0, thingArray, 0, this.invcount);
        }
        this.inv = thingArray;
    }

    public void removeThing(Thing thing) {
        int n = thing.x;
        if (this.inv == null) {
            throw new Error("Empty Inventory bug!");
        }
        if (thing.place != this) {
            throw new Error("Thing in wrong place!");
        }
        if (this.inv[n] != thing) {
            throw new Error("Thing in wrong position!");
        }
        if (n < this.invcount - 1) {
            System.arraycopy(this.inv, n + 1, this.inv, n, this.invcount - n - 1);
        }
        this.setUsage(thing, 0);
        thing.removeModifiers("CarriedModifiers", this);
        this.inv[this.invcount - 1] = null;
        thing.place = null;
        thing.next = null;
        --this.invcount;
        for (int i = 0; i < this.invcount; ++i) {
            this.inv[i].x = i;
        }
    }

    public void swapItems(int n, int n2) {
        if (n >= this.invcount || n2 >= this.invcount || n < 0 || n2 < 0) {
            return;
        }
        Thing thing = this.inv[n];
        this.inv[n] = this.inv[n2];
        this.inv[n2] = thing;
        this.inv[n].x = n;
        this.inv[n2].x = n2;
    }

    public void sortItems() {
        if (this.inv == null) {
            return;
        }
        Arrays.sort(this.inv, new Comparator(){

            public int compare(Object object, Object object2) {
                Thing thing = (Thing)object;
                Thing thing2 = (Thing)object2;
                if (thing2 == null) {
                    return -1;
                }
                if (thing == null) {
                    return 1;
                }
                return thing2.y - thing.y;
            }
        });
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            this.inv[i].x = i;
        }
    }

    public Thing addThingWithStacking(Thing thing) {
        if (thing.getFlag("IsItem")) {
            for (int i = 0; i < this.invcount; ++i) {
                Thing thing2 = this.inv[i];
                if (thing2.y > 0 && thing2.y != 21 || !thing.stackWith(thing2)) continue;
                return thing2;
            }
        }
        if (thing.place != this) {
            return this.addThing(thing);
        }
        return thing;
    }

    public Thing separate(int n) {
        int n2 = this.getStat("Number");
        if (n >= n2) {
            return this;
        }
        if (n <= 0) {
            return null;
        }
        this.incStat("Number", -n);
        Thing thing = (Thing)this.clone();
        thing.set("Number", n);
        if (this.place instanceof Thing) {
            thing = ((Thing)this.place).addThing(thing);
        } else if (this.place instanceof Map) {
            thing = ((Map)this.place).addThing(thing, this.x, this.y);
        }
        return thing;
    }

    public Thing restack() {
        if (this.place instanceof Thing) {
            Thing thing = (Thing)this.place;
            return thing.addThingWithStacking(this);
        }
        return this;
    }

    public Thing addThing(Thing thing) {
        if (thing == null) {
            return null;
        }
        thing.remove();
        if (thing.getFlag("NoStack")) {
            String string = thing.getString("CancelEffect");
            for (int i = 0; i < this.invcount; ++i) {
                String string2 = this.inv[i].name();
                if (thing.name().equals(string2)) {
                    return null;
                }
                if (!string2.equals(string)) continue;
                this.inv[i--].remove();
            }
        }
        this.ensureSize(this.invcount + 1);
        this.inv[this.invcount] = thing;
        thing.place = this;
        thing.next = null;
        thing.x = this.invcount++;
        this.setUsage(thing, 0);
        thing.applyModifiers("CarriedModifiers", this);
        return thing;
    }

    public boolean clearUsage(int n) {
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            int n2 = thing.y;
            if (n2 != n || !thing.getFlag("IsItem")) continue;
            if (!thing.getFlag("IsCursed")) {
                this.message("You remove your " + thing.getName(Game.hero()));
                this.setUsage(thing, 0);
                thing.restack();
                continue;
            }
            this.message("You are unable to remove your " + thing.getName(Game.hero()) + "!");
            return false;
        }
        return true;
    }

    public boolean isMobile() {
        return this.getFlag("IsMobile");
    }

    public boolean isRunning() {
        return this.getFlag("IsRunMode");
    }

    public boolean isBlocking() {
        return this.getFlag("IsBlocking");
    }

    public Thing holder() {
        return this.place instanceof Thing ? (Thing)this.place : null;
    }

    public boolean handle(Event event) {
        EventHandler eventHandler = this.getHandler(event.handlerName());
        return eventHandler != null && eventHandler.handle(this, event);
    }

    public boolean handles(String string) {
        Game.assertTrue(string.startsWith("On"));
        return this.containsKey(string);
    }

    public void action(Event event) {
        this.inventoryAction(event);
        Game.actor = this;
        if (this.handle(event)) {
            return;
        }
    }

    public void multiplyStat(String string, double d) {
        this.set(string, RPG.round((double)this.getBaseStat(string) * d));
    }

    public boolean isIdentified() {
        return Item.isIdentified(this);
    }

    public int getWeight() {
        return this.getStat("ItemWeight") * this.getStat("Number");
    }

    public int getNumber() {
        return this.getBaseStat("Number");
    }

    public int getImage() {
        return this.getStat("Image");
    }

    public int getZ() {
        return this.getStat("Z");
    }

    public AI getAI() {
        return (AI)this.get("AI");
    }

    public void setAI(AI aI) {
        AI aI2 = this.getAI();
        if (aI2 != null) {
            // empty if block
        }
        this.set("AI", aI);
    }

    public Talkable getPersonality() {
        return (Talkable)this.get("Personality");
    }

    public void setPersonality(Script script) {
        this.set("OnChat", script);
    }

    public void addAttribute(Thing thing) {
        this.addThing(thing);
        if (thing.place == this) {
            String string;
            if (this.isHero() && (string = thing.getString("AttributeAddMessage")) != null) {
                this.message(string);
            }
            this.setUsage(thing, 100);
        }
    }

    public ThingOwner getPlace() {
        return this.place;
    }

    public Thing getParent() {
        if (this.place instanceof Thing) {
            return (Thing)this.place;
        }
        return null;
    }

    public String getName(int n, int n2) {
        return Describer.describe(Game.hero(), this, n2, n);
    }

    public String getPronoun(int n, int n2) {
        return Describer.getPronoun(n, n2, this.getNameType(), this.getGender());
    }

    public int getNameType() {
        return this.getStat("NameType");
    }

    public int getGender() {
        return this.getStat("Gender");
    }

    public String getDescriptionText() {
        String string = (String)this.get("Description");
        return string != null ? string : Text.capitalise(this.getName(Game.hero()) + ".");
    }

    public Description getDescription() {
        return this;
    }

    public final boolean isHero() {
        return this == Game.hero();
    }

    public String is() {
        return this.isHero() || this.getNumber() > 1 ? "are" : "is";
    }

    public String verb(String string) {
        return this.isHero() || this.getNumber() > 1 ? string : string + "s";
    }

    public String getName(Thing thing, int n) {
        return Describer.describe(thing, this, 0, n);
    }

    public String name() {
        return this.getString("Name");
    }

    public void message(String string) {
        if (this.isHero()) {
            Game.message(string);
        }
    }

    public String getName() {
        return this.getName(Game.hero());
    }

    public String getAName() {
        return this.getAName(Game.hero());
    }

    public String getTheName() {
        return this.getTheName(Game.hero());
    }

    public String getYourName() {
        return this.getYourName(Game.hero());
    }

    public String getName(Thing thing) {
        return Describer.describe(thing, this, 0);
    }

    public String getAName(Thing thing) {
        return Describer.describe(thing, this, 2);
    }

    public String getTheName(Thing thing) {
        return Describer.describe(thing, this, 1);
    }

    public String getYourName(Thing thing) {
        return Describer.describe(thing, this, 3);
    }

    public String getFullName(Thing thing) {
        return Describer.describe(thing, this);
    }

    public String getAdjectives() {
        String string = this.getString("Adjective");
        String string2 = string;
        string2 = string2 == null ? "" : string2 + " ";
        if (this.getFlag("IsItem")) {
            if (this.getFlag("IsStatusKnown")) {
                if (this.getFlag("IsCursed")) {
                    string2 = string2 + "cursed ";
                } else if (this.getFlag("IsBlessed")) {
                    string2 = string2 + "blessed ";
                }
            }
            if (string == null && this.getFlag("IsRunic")) {
                string2 = string2 + "runic ";
            }
        }
        return string2.equals("") ? null : string2;
    }

    public String getSingularName() {
        String string;
        if (!Item.isIdentified(this) && (string = this.getString("UName")) != null) {
            return string;
        }
        return this.getString("Name");
    }

    public String getPluralName() {
        String string;
        if (!Item.isIdentified(this)) {
            string = (String)this.get("UNamePlural");
            if (string != null) {
                return string;
            }
            string = this.getString("UName");
            if (string != null) {
                return string + "s";
            }
        }
        return (string = this.getString("NamePlural")) != null ? string : this.getString("Name") + "s";
    }

    public int getQuality() {
        return this.getStat("Quality");
    }

    public final Map getMap() {
        return this.place == null ? null : this.place.getMap();
    }

    public Thing[] inv() {
        return this.getInventory();
    }

    public boolean hasInventory() {
        return this.inv != null;
    }

    public final int getMapX() {
        if (this.place instanceof Map) {
            return this.x;
        }
        return this.place == null ? -1 : ((Thing)this.place).getMapX();
    }

    public boolean canSee(Map map, int n, int n2) {
        int n3 = Being.calcViewRange(this);
        if (n3 <= 0) {
            return false;
        }
        if (n3 * n3 < (this.x - n) * (this.x - n) + (this.y - n2) * (this.y - n2)) {
            return false;
        }
        if (map == null || map != this.place) {
            return false;
        }
        return map.isLOS(this.x, this.y, n, n2);
    }

    public boolean canSee(Thing thing) {
        if (thing.place != this.place) {
            return false;
        }
        if (thing.isHero()) {
            return ((Map)this.place).isHeroLOS(this.x, this.y);
        }
        if (this.isHero()) {
            return ((Map)this.place).isVisible(thing.x, thing.y);
        }
        return this.canSee(this.getMap(), thing.x, thing.y);
    }

    public void calculateVision() {
        if (Game.instance().lineOfSightDisabled()) {
            return;
        }
        int n = Being.calcViewRange(this);
        Map map = this.getMap();
        if (map != null) {
            map.calcVisible(this, n);
        }
    }

    public final int getMapY() {
        if (this.place instanceof Map) {
            return this.y;
        }
        return this.place == null ? -1 : ((Thing)this.place).getMapY();
    }

    public void remove() {
        if (this.place != null) {
            this.place.removeThing(this);
        }
    }

    public Thing remove(int n) {
        if (n < 1) {
            throw new Error("Thing.remove(): can't remove " + n + " objects");
        }
        int n2 = this.getNumber();
        if (n2 <= 0) {
            throw new Error("Thing.remove(): stack contains " + n2 + " objects");
        }
        if (n == n2) {
            this.remove();
            return this;
        }
        if (n < n2) {
            Thing thing = (Thing)this.clone();
            this.set("Number", n2 - n);
            thing.set("Number", n);
            return thing;
        }
        throw new Error("Thing: tring to remove more than entire stack!");
    }

    public void replace(String string) {
        this.replace(Lib.create(string));
    }

    public void die() {
        Combat.die(this);
    }

    public void moveTo(Map map, int n, int n2) {
        Movement.moveTo(this, map, n, n2);
    }

    public boolean displace() {
        int n;
        if (!(this.place instanceof Map)) {
            return false;
        }
        boolean bl = this.isBlocking();
        Map map = (Map)this.place;
        int n2 = this.x + 2 * RPG.r(2) - 1;
        int n3 = this.y + 2 * RPG.r(2) - 1;
        if (RPG.d(2) == 1) {
            if (RPG.d(2) == 1) {
                n2 = this.x;
            } else {
                n3 = this.y;
            }
        }
        if (!(map.isTileBlocked(n2, n3) || bl && map.isBlocked(n2, n3))) {
            this.moveTo(map, n2, n3);
            return true;
        }
        n2 = 0;
        for (n3 = this.x - 1; n3 <= this.x + 1; ++n3) {
            for (n = this.y - 1; n <= this.y + 1; ++n) {
                if (n3 == this.x && n == this.y || map.isTileBlocked(n3, n) || bl && map.isBlocked(n3, n)) continue;
                ++n2;
            }
        }
        if (n2 == 0) {
            return false;
        }
        n2 = RPG.d(n2);
        for (n3 = this.x - 1; n3 <= this.x + 1; ++n3) {
            for (n = this.y - 1; n <= this.y + 1; ++n) {
                if (n3 == this.x && n == this.y || map.isTileBlocked(n3, n) || this.isBlocking() && map.isBlocked(n3, n) || --n2 > 0) continue;
                this.moveTo(map, n3, n);
                return true;
            }
        }
        return false;
    }

    public boolean isWithin(ThingOwner thingOwner) {
        Thing thing = this;
        while (thing != null) {
            if (thing.place == thingOwner) {
                return true;
            }
            if (!(thing.place instanceof Thing)) {
                return false;
            }
            thing = (Thing)thing.place;
        }
        return false;
    }

    public boolean isTransparent() {
        return !this.getFlag("IsViewBlocking");
    }

    public boolean isDamaged() {
        return this.getFlag("Damage");
    }

    public void visibleMessage(String string) {
        if (this.isVisible(Game.hero()) && !this.isInvisible()) {
            Game.message(string);
        }
    }

    public boolean isVisible(Thing thing) {
        if (this.place instanceof Map) {
            return thing.canSee(this);
        }
        return thing.isHero() && this.rootThing() == thing;
    }

    public Thing rootThing() {
        return this.place instanceof Thing ? ((Thing)this.place).rootThing() : this;
    }

    public boolean isInvisible() {
        return this.getFlag("IsInvisible");
    }

    public Object clone() {
        Thing thing = new Thing(super.getLocal(), super.getInherited());
        thing.place = null;
        thing.next = null;
        if (this.inv != null) {
            thing.inv = (Thing[])this.inv.clone();
            for (int i = 0; i < this.invcount; ++i) {
                thing.inv[i] = (Thing)this.inv[i].clone();
                thing.inv[i].place = thing;
            }
        }
        return thing;
    }

    public boolean canStackWith(Thing thing) {
        if (this == thing) {
            return false;
        }
        if (!thing.getFlag("IsItem")) {
            return false;
        }
        if (thing == this) {
            throw new Error("Can't do canStackWith(self)!!");
        }
        if (!this.equalsIgnoreNumber(thing)) {
            return false;
        }
        return this.sameContents(thing);
    }

    public boolean sameContents(Thing thing) {
        if (this.invcount == 0 && thing.invcount == 0) {
            return true;
        }
        if (this.invcount != thing.invcount) {
            return false;
        }
        int n = this.invcount;
        for (int i = 0; i < n; ++i) {
            if (this.inv[i].name().equals(thing.inv[i].name())) continue;
            return false;
        }
        return true;
    }

    public boolean stackWith(Thing thing) {
        if (!this.canStackWith(thing)) {
            return false;
        }
        thing.incStat("Number", this.getStat("Number"));
        this.remove();
        return true;
    }

    public int damage(int n, String string) {
        return Damage.inflict(this, n, string);
    }

    public int getArmour(String string) {
        return Armour.calcArmour(this, string);
    }

    public int getResistance(String string) {
        return this.getStat("RES:" + string);
    }

    public int getLevel() {
        return this.getStat("Level");
    }

    public boolean hasItem(String string) {
        for (int i = 0; i < this.invcount; ++i) {
            if (!this.inv[i].name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Thing getItem(String string) {
        for (int i = 0; i < this.invcount; ++i) {
            if (!this.inv[i].name().equals(string)) continue;
            return this.inv[i];
        }
        return null;
    }

    public boolean isWielded(Thing thing) {
        boolean bl = false;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing2 = this.inv[i];
            if (!thing2.getFlag("IsItem") || thing2.y <= 0 || thing2 != thing) continue;
            return true;
        }
        return bl;
    }

    public Thing[] getWielded() {
        if (this.invcount == 0) {
            return new Thing[0];
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (thing.y <= 0) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public Thing[] getWieldedItems() {
        if (this.invcount == 0) {
            return new Thing[0];
        }
        Thing[] thingArray = new Thing[this.invcount];
        int n = 0;
        for (int i = 0; i < this.invcount; ++i) {
            Thing thing = this.inv[i];
            if (!thing.getFlag("IsItem") || thing.y <= 0) continue;
            thingArray[n] = thing;
            ++n;
        }
        Thing[] thingArray2 = new Thing[n];
        if (n > 0) {
            System.arraycopy(thingArray, 0, thingArray2, 0, n);
        }
        return thingArray2;
    }

    public Thing getWielded(int n) {
        Thing thing = this.getWeapon(n);
        if (thing == null) {
            if (n == 1) {
                thing = this.getWeapon(3);
            }
            if (n == 9 || n == 10) {
                thing = this.getWeapon(13);
            }
        }
        return thing;
    }

    public Thing[] getInventory() {
        return this.inv == null ? noThings : this.inv;
    }

    public void throwThing(Thing thing, int n, int n2) {
        Map map = this.getMap();
        if (map == null) {
            return;
        }
        Point point = map.tracePath(this.x, this.y, n, n2);
        if (point.x == this.x && point.y == this.y) {
            this.dropThing(thing);
            return;
        }
        Missile.throwAt(thing, this, map, point.x, point.y);
    }

    public void dropThing(Thing thing) {
        thing.remove();
        if (this.place instanceof Map) {
            ((Map)this.place).addThing(thing, this.x, this.y);
        }
    }

    public boolean wield(Thing thing) {
        return this.wield(thing, thing.getStat("WieldType"));
    }

    public boolean wield(Thing thing, int n) {
        if (thing.y == n) {
            return true;
        }
        if (!this.clearUsage(n)) {
            return false;
        }
        if (n == 3 && !this.clearUsage(1) | !this.clearUsage(2)) {
            return false;
        }
        if (n == 1 && !this.clearUsage(3)) {
            return false;
        }
        if (n == 2 && !this.clearUsage(3)) {
            return false;
        }
        if (n == 13 && !this.clearUsage(9) | !this.clearUsage(10)) {
            return false;
        }
        if (n == 9 && !this.clearUsage(13)) {
            return false;
        }
        if (n == 10 && !this.clearUsage(13)) {
            return false;
        }
        int n2 = thing.getNumber();
        if (n2 > 1 && n != 21) {
            Thing thing2 = thing.separate(n2 - 1);
            this.addThing(thing2);
        }
        this.setUsage(thing, n);
        if (thing.getFlag("IsArtifact")) {
            Item.identify(thing);
        }
        return true;
    }

    public void setUsage(Thing thing, int n) {
        if (thing.place != this) {
            throw new Error(thing.getName(Game.hero()) + " not in inventory ");
        }
        if (thing.y == n) {
            return;
        }
        thing.removeModifiers("WieldedModifiers", this);
        thing.removeModifiers("EffectModifiers", this);
        thing.y = n;
        if (n > 0 && n != 100) {
            thing.applyModifiers("WieldedModifiers", this);
        }
        if (n == 100) {
            thing.applyModifiers("EffectModifiers", this);
        }
    }

    private Modifier[] getModifiers(String string) {
        Modifier[] modifierArray = (Modifier[])this.get(string);
        return modifierArray == null ? emptyModifiers : modifierArray;
    }

    public void applyModifiers(String string, Thing thing) {
        Modifier[] modifierArray = this.getModifiers(string);
        for (int i = 0; i < modifierArray.length; ++i) {
            thing.applyModifier(Modifier.create(modifierArray[i], this, string));
        }
    }

    public void removeModifiers(String string, Thing thing) {
        Modifier[] modifierArray = this.getModifiers(string);
        for (int i = 0; i < modifierArray.length; ++i) {
            String string2 = modifierArray[i].getStat();
            thing.removeModifiersWithSource(this, string, string2);
        }
    }

    private void removeModifiersWithSource(Thing thing, String string, String string2) {
        ArrayList arrayList = this.getStatModifiers(string2);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Modifier modifier = (Modifier)arrayList.get(i);
                if (modifier.getSource() != thing || !modifier.getReason().equals(string)) continue;
                arrayList.remove(i);
            }
        }
    }

    public boolean isHostile(Thing thing) {
        return AI.isHostile(this, thing);
    }

    public Thing cloneType() {
        return Lib.create(this.getString("Name"));
    }

    public int notify(int n, int n2, Object object) {
        return AI.notify(this, n, n2, object);
    }

    public void give(Thing thing, Thing thing2) {
        if (this.handles("OnGift")) {
            Event event = new Event("Gift");
            event.set("Gift", thing2);
            event.set("Giver", thing);
            this.handle(event);
        } else {
            thing.message(this.getTheName() + " does not seem interested");
        }
    }

    public boolean isDead() {
        return this.getStat("HPS") <= 0;
    }

    private HashMap getModifierList() {
        return this.modifiers;
    }

    private void setModifierList(HashMap hashMap) {
        this.modifiers = hashMap;
    }

    private ArrayList getStatModifiers(String string) {
        HashMap hashMap = this.getModifierList();
        if (hashMap == null) {
            return null;
        }
        return (ArrayList)hashMap.get(string);
    }

    private void setStatModifiers(String string, ArrayList arrayList) {
        HashMap<String, ArrayList> hashMap = this.getModifierList();
        if (hashMap == null) {
            hashMap = new HashMap<String, ArrayList>();
            this.setModifierList(hashMap);
        }
        hashMap.put(string, arrayList);
    }

    public void add(String string, Modifier modifier) {
        super.add(string, modifier);
        if (string.equals("CarriedModifiers") && this.place instanceof Thing) {
            this.getParent().applyModifier(Modifier.create(modifier, this, string));
        }
    }

    private void applyModifier(Modifier modifier) {
        String string = modifier.getStat();
        ArrayList<Modifier> arrayList = this.getStatModifiers(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Modifier>();
            this.setStatModifiers(string, arrayList);
        }
        arrayList.add(modifier);
        Collections.sort(arrayList, Modifier.sorter);
    }

    public Object getModified(String string, int n) {
        ArrayList arrayList = this.getStatModifiers(string);
        if (arrayList != null && n < arrayList.size()) {
            Modifier modifier = (Modifier)arrayList.get(n);
            return modifier.calculate(this, string, n + 1);
        }
        return super.get(string);
    }

    public int getStat(String string) {
        Integer n = (Integer)this.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public Object get(String string) {
        if (this.modifiers != null) {
            return this.getModified(string, 0);
        }
        return super.get(string);
    }

    public String report() {
        String string = super.report();
        if (this.modifiers != null) {
            string = string + "\n";
            string = string + "Modified Values:\n";
            Iterator iterator = this.modifiers.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string = string + string2 + " = " + this.get(string2) + "\n";
            }
        }
        return string;
    }

    public List orthogonalExits(int n, int n2) {
        Map map = this.getMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (n == 1 || n == -1) {
            if (!map.isBlocked(this.x, this.y - 1) || this.isDoorVisible(this.x, this.y - 1)) {
                arrayList.add(new Point(this.x, this.y - 1));
            }
            if (!map.isBlocked(this.x, this.y + 1) || this.isDoorVisible(this.x, this.y + 1)) {
                arrayList.add(new Point(this.x, this.y + 1));
            }
        } else if (n2 == 1 || n2 == -1) {
            if (!map.isBlocked(this.x - 1, this.y) || this.isDoorVisible(this.x - 1, this.y)) {
                arrayList.add(new Point(this.x - 1, this.y));
            }
            if (!map.isBlocked(this.x + 1, this.y) || this.isDoorVisible(this.x + 1, this.y)) {
                arrayList.add(new Point(this.x + 1, this.y));
            }
        }
        return arrayList;
    }

    public boolean isDoorVisible(int n, int n2) {
        Thing[] thingArray = this.getMap().getThings(n, n2);
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing = thingArray[i];
            if (thing.getFlag("IsSecretDoor") || thing.getFlag("IsSecretPassage") || !thing.getFlag("IsDoor")) continue;
            return true;
        }
        return false;
    }

    public List moreExits(int n, int n2) {
        Map map = this.getMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        List list = this.orthogonalExits(n, n2);
        if (n == 1 || n == -1) {
            if (!map.isBlocked(this.x + n, this.y - 1) || this.isDoorVisible(this.x + n, this.y - 1)) {
                list.add(new Point(this.x + n, this.y - 1));
            }
            if (!map.isBlocked(this.x + n, this.y) || this.isDoorVisible(this.x + n, this.y)) {
                list.add(new Point(this.x + n, this.y));
            }
            if (!map.isBlocked(this.x + n, this.y + 1) || this.isDoorVisible(this.x + n, this.y + 1)) {
                list.add(new Point(this.x + n, this.y + 1));
            }
        } else if (n2 == 1 || n2 == -1) {
            if (!map.isBlocked(this.x + n, this.y - 1) || this.isDoorVisible(this.x + n, this.y - 1)) {
                list.add(new Point(this.x + n, this.y - 1));
            }
            if (!map.isBlocked(this.x + n, this.y) || this.isDoorVisible(this.x + n, this.y)) {
                list.add(new Point(this.x + n, this.y));
            }
            if (!map.isBlocked(this.x + n, this.y + 1) || this.isDoorVisible(this.x + n, this.y + 1)) {
                list.add(new Point(this.x + n, this.y + 1));
            }
        }
        return list;
    }

    public boolean areSeveralDirectionsNotVisited() {
        int n;
        int n2;
        Map map = this.getMap();
        int[] nArray = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
        int[] nArray2 = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (map.isTileBlocked(this.x + nArray[n2], this.y + nArray2[n2]) || (n = map.getPath(this.x + nArray[n2], this.y + nArray2[n2])) != 0) continue;
            arrayList.add(new Point(nArray[n2], nArray2[n2]));
        }
        if (arrayList.size() < 2) {
            return false;
        }
        n2 = -2;
        n = -2;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Point point = (Point)iterator.next();
            if (n2 == -2) {
                n2 = point.x;
            }
            if (n == -2) {
                n = point.y;
            }
            boolean bl2 = point.x != 0 && point.x == n2;
            boolean bl3 = bl = point.y != 0 && point.y == n;
            if (bl2 || bl) continue;
            return true;
        }
        return false;
    }

    private List allExits(boolean bl) {
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        Map map = this.getMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.x == 0) {
            if (this.y == 0) {
                nArray = new int[]{1, 1, 0};
                nArray2 = new int[]{0, 1, 1};
            } else if (this.y == map.getHeight() - 1) {
                nArray = new int[]{0, 1, 1};
                nArray2 = new int[]{-1, -1, 0};
            } else {
                nArray = new int[]{0, 1, 1, 1, 0};
                nArray2 = new int[]{-1, -1, 0, 1, 1};
            }
        } else if (this.y == 0) {
            if (this.x == map.getWidth() - 1) {
                nArray = new int[]{-1, -1, 0};
                nArray2 = new int[]{0, 1, 1};
            } else {
                nArray = new int[]{-1, -1, 0, 1, 1};
                nArray2 = new int[]{0, 1, 1, 1, 0};
            }
        } else if (this.x == map.getWidth() - 1) {
            if (this.y == map.getHeight() - 1) {
                nArray = new int[]{-1, -1, 0};
                nArray2 = new int[]{0, -1, -1};
            } else {
                nArray = new int[]{0, -1, -1, -1, 0};
                nArray2 = new int[]{-1, -1, 0, 1, 1};
            }
        } else if (this.y == map.getHeight() - 1) {
            nArray = new int[]{-1, -1, 0, 1, 1};
            nArray2 = new int[]{0, -1, -1, -1, 0};
        } else {
            nArray = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
            nArray2 = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < nArray.length; ++i) {
            if (map.isBlocked(this.x + nArray[i], this.y + nArray2[i])) continue;
            int n = this.x + nArray[i];
            int n2 = this.y + nArray2[i];
            if (!bl && map.getPath(n, n2) == 1 || !Movement.canMove(this, map, n, n2)) continue;
            arrayList.add(new Point(this.x + nArray[i], this.y + nArray2[i]));
        }
        return arrayList;
    }

    public boolean inARoom() {
        Map map = this.getMap();
        if (map == null) {
            return false;
        }
        return this.allExits(true).size() >= 3;
    }

    public void isRunning(boolean bl) {
        this.set("IsRunMode", bl);
        if (bl) {
            this.incStat("RunCount", 1);
        } else {
            this.set("RunCount", 0);
            this.set("RunDirectionX", Integer.MIN_VALUE);
            this.set("RunDirectionY", Integer.MIN_VALUE);
        }
    }

    public String inHandMessage() {
        Thing thing = this.getWielded(3);
        if (thing != null) {
            return thing.getName() + " in both hands";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Thing thing2 = this.getWielded(1);
        Thing thing3 = this.getWielded(2);
        stringBuffer.append(thing2 == null ? "" : " " + thing2.getName() + " in right hand");
        if (thing3 != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(thing3.getName());
            stringBuffer.append(" in left hand");
        }
        if (thing2 == null && thing3 == null) {
            return "nothing in hand";
        }
        return stringBuffer.toString().trim();
    }
}

