/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Being;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Movement;
import mikera.tyrant.Personality;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Monster {
    public static final String TAKE_THE_MONEY_AND_RUN = "TakeTheMoneyAndRun";
    public static final String TAKE_THE_MAGIC_AND_RUN = "TakeTheMagicAndRun";

    static void init() {
        Monster.initBase();
        Monster.initGoblinoids();
        Monster.initCritters();
        Monster.initDogs();
        Monster.initFrogs();
        Monster.initSpiders();
        Monster.initRalkans();
        Monster.initSlimes();
        Monster.initCats();
        Monster.initBears();
        Monster.initPlants();
        Monster.initNamedFoes();
        Monster.initEyes();
        Monster.initSnakes();
        Monster.initDragons();
        Monster.initWorms();
        Monster.initBirds();
        Monster.initInsects();
        Monster.initCentipedes();
        Monster.initBandits();
        Monster.initChaosForces();
        Monster.initUndead();
        Monster.initDemons();
        Monster.initImps();
        Monster.initBigHumanoids();
        Monster.initBigNasties();
        Monster.initElementals();
        Monster.initKobolds();
        Monster.initUrchins();
        Monster.initVoidlings();
    }

    public static Script breathAttack(String string, String string2, int n, int n2, int n3) {
        BreathAttackScript breathAttackScript = new BreathAttackScript();
        breathAttackScript.set("BreathType", string);
        breathAttackScript.set("BreathDescription", string2);
        breathAttackScript.set("Rate", n);
        breathAttackScript.set("Power", n2);
        breathAttackScript.set("BoltImage", n3);
        return breathAttackScript;
    }

    static void stats(Thing thing, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        thing.set("SK", RPG.ln(n, 0.05));
        thing.set("ST", RPG.ln(n2, 0.05));
        thing.set("AG", RPG.ln(n3, 0.05));
        thing.set("TG", RPG.ln(n4, 0.05));
        thing.set("IN", RPG.ln(n5, 0.05));
        thing.set("WP", RPG.ln(n6, 0.05));
        thing.set("CH", RPG.ln(n7, 0.05));
        thing.set("CR", RPG.ln(n8, 0.05));
    }

    static void strengthen(Thing thing, double d) {
        for (int i = 0; i < RPG.stats.length; ++i) {
            String string = RPG.stats[i];
            int n = thing.getBaseStat(string);
            thing.set(string, (int)((double)n * d));
        }
        thing.multiplyStat("ARM", d);
    }

    static void initBase() {
        Thing thing = Lib.extendCopy("base monster", "base being");
        thing.set("Frequency", 50);
        thing.set("IsMonster", 1);
        thing.set("IsHostile", 1);
        thing.set("IsLiving", 1);
        thing.set("LevelMin", 1);
        thing.set("LevelMax", 100);
        thing.set("ViewRange", 6);
        thing.set("XPValue", 4);
        thing.set("Alignment", "E+");
        thing.set("ASCII", "m");
        Lib.add(thing);
        thing = Lib.extend("base humanoid", "base monster");
        thing.set("IsHumanoid", 1);
        thing.set("IsIntelligent", 1);
        thing.set("LevelMin", 5);
        thing.set("LevelMax", 100);
        thing.set("Alignment", "E");
        thing.set("Image", 260);
        Lib.add(thing);
    }

    static void initUrchins() {
        Thing thing = Lib.extend("wood urchin", "base humanoid");
        Monster.stats(thing, 6, 4, 9, 3, 5, 4, 4, 3);
        thing.set("LevelMin", 2);
        thing.set("Image", 341);
        thing.set("DefaultThings", "[IsMushroom]");
        thing.set("Unarmed Combat", 1);
        thing.set("OnHit", new SpecialHit("steal", 30));
        thing.set("ASCII", "u");
        Lib.add(thing);
        thing = Lib.extend("leprechaun", "base humanoid");
        Monster.stats(thing, 26, 4, 29, 5, 5, 14, 4, 3);
        thing.set("LevelMin", 7);
        thing.set("Image", 349);
        thing.set("DefaultThings", "15* gold coin,50%[IsFood]");
        thing.set("Unarmed Combat", 1);
        thing.incStat("Magic Resistance", 3);
        thing.set("OnHit", new SpecialHit(TAKE_THE_MONEY_AND_RUN, 100));
        thing.set("ASCII", "L");
        Lib.add(thing);
        thing = Lib.extend("nymph", "base humanoid");
        Monster.stats(thing, 16, 14, 19, 13, 9, 14, 4, 13);
        thing.set("LevelMin", 11);
        thing.set("Image", 352);
        thing.set("ARM", 20);
        thing.set("AttackSpeed", 150);
        thing.set("MoveSpeed", 150);
        thing.set("DefaultThings", "25%[IsRunestone],10%[IsRing],20%[IsSpellBook],5%[IsWand],25%[IsScroll]");
        thing.set("Unarmed Combat", 2);
        thing.incStat("Magic Resistance", 4);
        thing.set("OnHit", new SpecialHit(TAKE_THE_MAGIC_AND_RUN, 100));
        thing.set("ASCII", "n");
        Lib.add(thing);
        thing = Lib.extend("pink urchin", "base humanoid");
        Monster.stats(thing, 26, 4, 29, 5, 5, 14, 4, 3);
        thing.set("LevelMin", 9);
        thing.set("Image", 340);
        thing.set("DefaultThings", "[IsFood]");
        thing.set("Unarmed Combat", 1);
        thing.set("OnHit", new SpecialHit("steal", 50));
        thing.set("ASCII", "u");
        Lib.add(thing);
        thing = Lib.extend("rock urchin", "base humanoid");
        Monster.stats(thing, 16, 14, 19, 13, 9, 14, 4, 13);
        thing.set("LevelMin", 14);
        thing.set("Image", 345);
        thing.set("ARM", 20);
        thing.set("AttackSpeed", 150);
        thing.set("MoveSpeed", 150);
        thing.set("DefaultThings", "[IsRunestone]");
        thing.set("Unarmed Combat", 1);
        thing.set("OnHit", new SpecialHit("steal", 100));
        thing.set("ASCII", "u");
        Lib.add(thing);
    }

    static void initKobolds() {
        Thing thing = Lib.extend("base kobold", "base humanoid");
        thing.set("IsKobold", 1);
        Monster.stats(thing, 6, 4, 9, 3, 5, 4, 4, 3);
        thing.set("LevelMin", 2);
        thing.set("Image", 342);
        thing.set("DefaultThings", "25%[IsWeapon],20%[IsFood]");
        thing.set("ASCII", "k");
        Lib.add(thing);
        thing = Lib.extend("kobold", "base kobold");
        Monster.stats(thing, 6, 4, 9, 3, 5, 4, 4, 3);
        thing.set("LevelMin", 2);
        thing.set("LevelMax", 10);
        thing.set("Image", 342);
        thing.set("DefaultThings", "15%[IsWeapon],10%[IsFood]");
        Lib.add(thing);
        thing = Lib.extend("kobold warrior", "kobold");
        Monster.stats(thing, 6, 4, 9, 3, 5, 4, 4, 3);
        thing.set("LevelMin", 4);
        thing.set("LevelMax", 12);
        thing.set("Image", 348);
        thing.set("Unarmed Combat", 1);
        thing.set("ARM", 2);
        thing.set("DefaultThings", "40%[IsWeapon],10%[IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("kobold chieftain", "kobold warrior");
        Monster.strengthen(thing, 2.0);
        thing.set("LevelMin", 8);
        thing.set("Image", 348);
        thing.set("Attack", 1);
        thing.set("Defence", 1);
        thing.set("Unarmed Combat", 2);
        thing.set("DefaultThings", "[IsWeapon],40%[IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("kobold spellcaster", "kobold");
        Monster.stats(thing, 10, 4, 19, 13, 15, 14, 8, 13);
        thing.set("LevelMin", 10);
        thing.set("Image", 348);
        thing.set("Attack", 1);
        thing.set("Defence", 2);
        thing.set("Unarmed Combat", 1);
        thing.set("Spellcasting", 2);
        thing.set("DefaultThings", "[IsStaff],[IsSpell],[IsSpell]");
        Lib.add(thing);
    }

    static void initBigHumanoids() {
        Thing thing = Lib.extend("base big humanoid", "base humanoid");
        Lib.add(thing);
        thing = Lib.extend("hill giant", "base big humanoid");
        Monster.stats(thing, 16, 46, 19, 88, 2, 68, 6, 7);
        thing.set("Unarmed Combat", 1);
        thing.set("Defence", 2);
        thing.set("Image", 260);
        thing.set("LevelMin", 19);
        thing.set("DefaultThings", "30% [IsClub], [IsFood]");
        Lib.add(thing);
        thing = Lib.extend("ogre", "base big humanoid");
        Monster.stats(thing, 17, 36, 19, 38, 5, 48, 6, 7);
        thing.set("Unarmed Combat", 1);
        thing.set("Defence", 1);
        thing.set("Image", 264);
        thing.set("LevelMin", 16);
        thing.set("DefaultThings", "50% [IsWeapon], 40% [IsFood],30% [IsCoin]");
        Lib.add(thing);
    }

    static void initBandits() {
        Thing thing = Lib.extend("base bandit", "base humanoid");
        Monster.stats(thing, 10, 8, 9, 9, 7, 8, 6, 7);
        thing.set("IsBandit", 1);
        thing.set("LevelMin", 5);
        thing.set("Image", 84);
        thing.set("Unarmed Combat", 1);
        thing.set("DefaultThings", "5% [IsFood],5%[IsWeapon],5% 1 gold coin, 50% [IsCoin], 40% 20 copper coin");
        thing.set("ASCII", "h");
        Lib.add(thing);
        thing = Lib.extend("bandit", "base bandit");
        Lib.add(thing);
        thing = Lib.extend("bandit archer", "base bandit");
        thing.set("DefaultThings", "[IsBow],10 [IsArrow],5% 1 gold coin, 50% 3 silver coin, 40% 20 copper coin");
        Lib.add(thing);
        thing = Lib.extend("cutpurse", "base bandit");
        thing.set("OnHit", new SpecialHit("steal", 30));
        thing.set("Image", 102);
        Lib.add(thing);
        thing = Lib.extend("thug", "base bandit");
        thing.set("Image", 82);
        thing.set("Defence", 1);
        Lib.add(thing);
        thing = Lib.extend("mutant", "base bandit");
        Monster.stats(thing, 6, 6, 9, 8, 7, 8, 6, 7);
        thing.set("Image", 261);
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("mercenary", "base bandit");
        Monster.stats(thing, 15, 18, 12, 18, 7, 13, 5, 9);
        thing.set("Image", 85);
        thing.set("LevelMin", 11);
        thing.set("Defence", 2);
        thing.set("Attack", 1);
        thing.set("DefaultThings", "50%[IsWeapon],10%[IsArmour],5%[IsItem],10 gold coin");
        Lib.add(thing);
        thing = Lib.extend("swordsman", "base bandit");
        Monster.stats(thing, 22, 14, 17, 12, 7, 13, 5, 9);
        thing.set("Image", 80);
        thing.set("LevelMin", 13);
        thing.set("Athletics", 2);
        thing.set("Ferocity", 3);
        thing.set("Defence", 4);
        thing.set("Attack", 4);
        thing.set("Luck", 20);
        thing.set("DefaultThings", "100%[IsSword],20%[IsArmour],16 gold coin");
        Lib.add(thing);
        thing = Lib.extend("pirate", "swordsman");
        thing.incStat("ARM", 4);
        thing.set("Image", 21);
        thing.set("AttackSpeed", 130);
        thing.set("LevelMin", 15);
        Lib.add(thing);
        thing = Lib.extend("pirate leader", "pirate");
        Monster.strengthen(thing, 2.0);
        thing.set("Image", 21);
        thing.set("AttackSpeed", 160);
        thing.set("LevelMin", 18);
        Lib.add(thing);
        thing = Lib.extend("pirate captain", "pirate");
        Monster.strengthen(thing, 3.0);
        thing.set("Image", 21);
        thing.set("AttackSpeed", 200);
        thing.set("LevelMin", 18);
        Lib.add(thing);
        thing = Lib.extend("mercenary captain", "mercenary");
        Monster.stats(thing, 25, 23, 22, 28, 17, 23, 15, 19);
        thing.set("Image", 86);
        thing.set("LevelMin", 14);
        thing.set("Defence", 3);
        thing.set("Attack", 2);
        thing.set("DefaultThings", "100%[IsWeapon],100%[IsArmour],5%[IsItem],10 sovereign");
        Lib.add(thing);
        thing = Lib.extend("mercenary commander", "mercenary captain");
        Monster.stats(thing, 45, 43, 42, 48, 37, 33, 35, 39);
        thing.set("Image", 87);
        thing.set("LevelMin", 20);
        thing.set("Defence", 4);
        thing.set("Attack", 4);
        thing.set("MoveSpeed", 150);
        thing.set("AttackSpeed", 200);
        thing.set("DefaultThings", "100%[IsWeapon],100%[IsArmour],100%[IsShield],[IsItem]");
        Lib.add(thing);
        thing = Lib.extend("warlock", "base bandit");
        Monster.stats(thing, 15, 18, 12, 18, 7, 13, 5, 9);
        thing.set("Image", 121);
        thing.set("LevelMin", 13);
        thing.set("Frequency", 20);
        thing.set("Spellcasting", 2);
        thing.set("DefaultThings", "50%[IsStaff],10%[IsSpellBook],10%[IsWand],100%[IsSpell],100%[IsSpell]");
        Lib.add(thing);
    }

    static void initChaosForces() {
        Thing thing = Lib.extend("base chaotic human", "base humanoid");
        Monster.stats(thing, 10, 8, 9, 9, 7, 8, 6, 7);
        thing.set("IsChaotic", 1);
        thing.set("LevelMin", 10);
        thing.set("Image", 51);
        thing.set("ASCII", "h");
        Lib.add(thing);
        thing = Lib.extend("chaos cultist", "base chaotic human");
        Monster.stats(thing, 10, 12, 9, 14, 7, 18, 7, 9);
        thing.set("Unarmed Combat", 1);
        thing.set("Attack", 1);
        thing.set("Defence", 1);
        thing.set("Image", 51);
        thing.set("LevelMin", 15);
        thing.set("DefaultThings", "[IsWeapon],30% [IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("chaos warrior", "base chaotic human");
        Monster.stats(thing, 20, 22, 19, 34, 17, 48, 17, 19);
        thing.set("ARM", 25);
        thing.set("Unarmed Combat", 3);
        thing.set("Attack", 3);
        thing.set("Defence", 2);
        thing.set("Image", 52);
        thing.set("LevelMin", 18);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("chaos knight", "chaos warrior");
        thing.set("Image", 52);
        thing.set("LevelMin", 24);
        Monster.strengthen(thing, 3.0);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour],[IsItem]");
        Lib.add(thing);
        thing = Lib.extend("chaos champion", "chaos warrior");
        thing.set("Image", 53);
        thing.set("LevelMin", 29);
        Monster.strengthen(thing, 10.0);
        Lib.add(thing);
        thing = Lib.extend("chaos hero", "chaos warrior");
        thing.set("Image", 53);
        thing.set("LevelMin", 34);
        Monster.strengthen(thing, 20.0);
        Lib.add(thing);
    }

    static void initVoidlings() {
        Thing thing = Lib.extend("base voidling", "base monster");
        thing.set("IsLiving", 0);
        thing.set("IsFlying", 1);
        thing.set("IsVoidling", 1);
        thing.set("ARM", 100);
        thing.set("RES:fire", 100);
        thing.set("RES:ice", 100);
        thing.set("RES:acid", 100);
        thing.set("RES:disintegrate", 1000);
        thing.set("RES:shock", 100);
        thing.set("Image", 406);
        thing.set("IsViewBlocking", 1);
        thing.set("ASCII", "V");
        Lib.add(thing);
        thing = Lib.extend("voidling", "base voidling");
        thing.set("LevelMin", 38);
        Monster.stats(thing, 300, 300, 500, 200, 300, 500, 0, 300);
        thing.set("MoveSpeed", 300);
        thing.set("AttackSpeed", 300);
        thing.set("UnarmedWeapon", Lib.create("disintegrate attack"));
        thing.set("DeathDecoration", "Void");
        Lib.add(thing);
        thing = Lib.extend("greater voidling", "voidling");
        thing.set("LevelMin", 40);
        Monster.strengthen(thing, 2.0);
        Lib.add(thing);
        thing = Lib.extend("master voidling", "voidling");
        thing.set("LevelMin", 42);
        Monster.stats(thing, 300, 300, 500, 200, 300, 500, 0, 300);
        Monster.strengthen(thing, 3.0);
        thing.addHandler("OnAction", Scripts.generator("voidling", 100));
        Lib.add(thing);
    }

    static void initBigNasties() {
        Thing thing = Lib.extend("base big monster", "base monster");
        thing.set("ASCII", "M");
        thing.set("IsBeast", 1);
        Lib.add(thing);
        thing = Lib.extend("horrendous gobbler", "base big monster");
        Monster.stats(thing, 130, 160, 70, 200, 5, 240, 3, 10);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        thing.set("MoveSpeed", 200);
        thing.set("AttackSpeed", 300);
        thing.set("DeathDecoration", "blood pool,bone");
        thing.addHandler("OnAction", Scripts.generator("fly swarm", 100));
        thing.addHandler("OnAction", Monster.breathAttack("poison", "poisonous fumes", 2, 60, 41));
        thing.set("RES:poison", 1000);
        thing.set("ARM", 160);
        thing.set("FearFactor", 6);
        thing.set("LevelMin", 28);
        thing.set("Image", 424);
        Lib.add(thing);
        thing = Lib.extend("purple horror", "base big monster");
        Monster.stats(thing, 40, 60, 50, 50, 15, 50, 3, 10);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.set("MoveSpeed", 100);
        thing.set("AttackSpeed", 100);
        thing.set("DeathDecoration", "blood pool,bone");
        thing.addHandler("OnAction", Scripts.generator("purple horror", 30));
        thing.set("RES:poison", 100);
        thing.set("ARM", 30);
        thing.set("FearFactor", 4);
        thing.set("LevelMin", 22);
        thing.set("Image", 423);
        Lib.add(thing);
        thing = Lib.extend("gryphon", "base big monster");
        Monster.stats(thing, 120, 60, 150, 70, 15, 90, 10, 5);
        thing.set("UnarmedWeapon", Lib.create("claw attack"));
        thing.set("MoveSpeed", 300);
        thing.set("AttackSpeed", 300);
        thing.set("DeathDecoration", "blood pool,bone");
        thing.set("ARM", 20);
        thing.set("FearFactor", 2);
        thing.set("LevelMin", 23);
        thing.set("Image", 361);
        Lib.add(thing);
        thing = Lib.extend("crocodile", "base big monster");
        Monster.stats(thing, 40, 90, 20, 90, 2, 30, 1, 3);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        thing.set("MoveSpeed", 80);
        thing.set("AttackSpeed", 100);
        thing.set("DeathDecoration", "blood pool,bone");
        thing.set("ARM", 10);
        thing.set("LevelMin", 18);
        thing.set("Image", 367);
        Lib.add(thing);
        thing = Lib.extend("hydra", "base big monster");
        Monster.stats(thing, 70, 90, 40, 130, 12, 70, 1, 33);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        thing.set("MoveSpeed", 90);
        thing.set("AttackSpeed", 400);
        thing.set("DeathDecoration", "blood pool,bone");
        thing.set("ARM", 60);
        thing.set("LevelMin", 24);
        thing.set("Image", 362);
        Lib.add(thing);
    }

    static void initEyes() {
        Thing thing = Lib.extend("base eye", "base monster");
        thing.set("IsEye", 1);
        thing.set("IsLiving", 1);
        thing.set("IsFlying", 1);
        thing.set("MoveSpeed", 70);
        thing.set("Frequency", 30);
        thing.set("RES:piercing", -13);
        thing.incStat("Magic Resistance", 3);
        thing.set("ASCII", "e");
        thing.set("UnarmedWeapon", Lib.create("drain attack"));
        Lib.add(thing);
        thing = Lib.extend("floating eye", "base eye");
        Monster.stats(thing, 10, 20, 15, 20, 40, 40, 2, 10);
        thing.set("Image", 373);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("magic eye", "base eye");
        Monster.stats(thing, 12, 20, 15, 20, 40, 40, 2, 10);
        thing.set("Image", 373);
        thing.set("LevelMin", 15);
        thing.set("Spellcasting", 3);
        thing.set("Focus", 1);
        thing.set("DefaultThings", "[IsSpell],[IsSpell],[IsSpell],[IsSpell]");
        Lib.add(thing);
        thing = Lib.extend("malevolent eye", "base eye");
        Monster.stats(thing, 22, 33, 25, 30, 50, 60, 6, 20);
        thing.set("ARM", 20);
        thing.set("Image", 372);
        thing.set("LevelMin", 20);
        thing.set("AttackSpeed", 150);
        thing.set("Defence", 1);
        thing.set("Spellcasting", 3);
        thing.set("Focus", 2);
        thing.set("DefaultThings", "[IsSpell],[IsSpell],[IsSpell],[IsSpell]");
        Lib.add(thing);
        thing = Lib.extend("beholder", "base eye");
        Monster.stats(thing, 32, 53, 35, 70, 80, 160, 16, 30);
        thing.set("ARM", 50);
        thing.set("Image", 368);
        thing.set("LevelMin", 25);
        thing.set("AttackSpeed", 150);
        thing.set("Defence", 1);
        thing.set("Spellcasting", 4);
        thing.set("Focus", 4);
        thing.set("DefaultThings", "[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell]");
        Lib.add(thing);
    }

    static void initElementals() {
        Thing thing = Lib.extend("base elemental", "base monster");
        thing.set("IsElemental", 1);
        thing.set("IsLiving", 0);
        thing.set("Frequency", 20);
        thing.set("Spellcasting", 1);
        thing.set("ASCII", "E");
        Lib.add(thing);
        thing = Lib.extend("ice elemental", "base elemental");
        Monster.stats(thing, 40, 60, 50, 60, 15, 50, 4, 15);
        thing.set("UnarmedWeapon", Lib.create("ice attack"));
        thing.set("MoveSpeed", 150);
        thing.set("AttackSpeed", 150);
        thing.set("DeathDecoration", "water pool");
        thing.set("RES:ice", 100);
        thing.set("RES:fire", -15);
        thing.set("ARM", 20);
        thing.set("LevelMin", 24);
        thing.set("Image", 425);
        thing.set("DefaultThings", "Ice Blast");
        Lib.add(thing);
        thing = Lib.extend("fire elemental", "base elemental");
        Monster.stats(thing, 60, 60, 60, 60, 15, 60, 3, 10);
        thing.set("UnarmedWeapon", Lib.create("fire attack"));
        thing.set("MoveSpeed", 150);
        thing.set("AttackSpeed", 150);
        thing.set("DeathDecoration", "medium fire");
        thing.set("RES:impact", 100);
        thing.set("RES:piercing", 100);
        thing.set("RES:ice", -15);
        thing.set("RES:fire", 100);
        thing.set("ARM", 20);
        thing.set("LevelMin", 22);
        thing.set("Image", 407);
        thing.set("DefaultThings", "Blaze");
        Lib.add(thing);
        thing = Lib.extend("earth elemental", "base elemental");
        Monster.stats(thing, 50, 70, 20, 100, 15, 60, 3, 10);
        thing.set("UnarmedWeapon", Lib.create("bash attack"));
        thing.set("MoveSpeed", 100);
        thing.set("AttackSpeed", 100);
        thing.set("DeathDecoration", "rock");
        thing.set("ARM", 60);
        thing.set("LevelMin", 21);
        thing.set("Image", 405);
        thing.set("DefaultThings", "Blast");
        Lib.add(thing);
        thing = Lib.extend("air elemental", "base elemental");
        Monster.stats(thing, 60, 60, 130, 40, 25, 70, 3, 10);
        thing.set("MoveSpeed", 300);
        thing.set("AttackSpeed", 200);
        thing.set("ARM", 10);
        thing.set("RES:impact", 100);
        thing.set("RES:piercing", 100);
        thing.set("RES:shock", 100);
        thing.set("LevelMin", 23);
        thing.set("Image", 385);
        thing.set("IsFlying", 1);
        thing.set("DefaultThings", "Thunderbolt");
        Lib.add(thing);
    }

    static void initUndead() {
        Thing thing = Lib.extend("base undead", "base monster");
        thing.set("IsUndead", 1);
        thing.set("IsLiving", 0);
        thing.set("Image", 302);
        thing.set("DeathDecoration", null);
        thing.set("Unarmed Combat", 1);
        thing.set("ASCII", "z");
        Lib.add(thing);
        Monster.initGhosts();
        Monster.initZombies();
        Monster.initSkeletons();
    }

    static void initSkeletons() {
        Thing thing = Lib.extend("base skeleton", "base undead");
        thing.set("Image", 305);
        thing.set("RES:piercing", 10);
        thing.set("RES:fire", -5);
        thing.set("ARM", 2);
        thing.set("FearFactor", 1);
        thing.set("IsRegenerating", 0);
        thing.set("DeathDecoration", "50% bone");
        thing.set("MoveSpeed", 100);
        thing.set("IsSkeleton", 1);
        thing.set("ASCII", "S");
        Lib.add(thing);
        thing = Lib.extend("lesser skeleton", "base skeleton");
        Monster.stats(thing, 6, 8, 3, 8, 0, 9, 0, 2);
        thing.set("LevelMin", 8);
        Lib.add(thing);
        thing = Lib.extend("skeleton", "base skeleton");
        Monster.stats(thing, 10, 12, 8, 12, 0, 13, 0, 5);
        thing.set("LevelMin", 11);
        thing.set("DefaultThings", "30% [IsWeapon]");
        Lib.add(thing);
        thing = Lib.extend("haunted skeleton", "base skeleton");
        Monster.stats(thing, 12, 12, 6, 10, 0, 13, 0, 5);
        thing.set("LevelMin", 12);
        thing.set("DeathDecoration", "haunted skull");
        Lib.add(thing);
        thing = Lib.extend("large skeleton", "skeleton");
        Monster.stats(thing, 14, 18, 7, 18, 0, 19, 0, 7);
        thing.set("ARM", 3);
        thing.set("LevelMin", 14);
        Lib.add(thing);
        thing = Lib.extend("fearsome skeleton", "skeleton");
        Monster.stats(thing, 16, 18, 10, 18, 0, 23, 0, 7);
        thing.set("FearFactor", 2);
        thing.set("ARM", 3);
        thing.set("LevelMin", 15);
        Lib.add(thing);
        thing = Lib.extend("skeleton warrior", "skeleton");
        Monster.stats(thing, 18, 18, 16, 18, 0, 19, 0, 17);
        thing.set("Image", 306);
        thing.set("FearFactor", 2);
        thing.set("ARM", 6);
        thing.set("LevelMin", 16);
        thing.set("DefaultThings", "[IsWeapon],50% [IsArmour],30% [IsRangedWeapon]");
        Lib.add(thing);
        thing = Lib.extend("skeleton hero", "skeleton");
        Monster.stats(thing, 78, 58, 56, 78, 0, 99, 0, 27);
        thing.set("Image", 306);
        thing.set("FearFactor", 3);
        thing.set("ARM", 13);
        thing.set("LevelMin", 24);
        thing.set("MoveSpeed", 150);
        thing.set("AttackSpeed", 200);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour],[IsThrowingWeapon],[IsItem]");
        Lib.add(thing);
        thing = Lib.extend("skeleton lord", "skeleton");
        Monster.stats(thing, 138, 88, 76, 178, 0, 199, 0, 50);
        thing.set("Image", 306);
        thing.set("FearFactor", 4);
        thing.set("ARM", 20);
        thing.set("LevelMin", 29);
        thing.set("MoveSpeed", 200);
        thing.set("AttackSpeed", 250);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour],[IsThrowingWeapon],[IsItem]");
        Lib.add(thing);
        thing = Lib.extend("skeletal dragon", "skeleton");
        Monster.stats(thing, 78, 98, 76, 178, 0, 199, 0, 57);
        thing.set("Image", 643);
        thing.set("FearFactor", 4);
        thing.set("ARM", 100);
        thing.set("LevelMin", 28);
        thing.set("MoveSpeed", 250);
        thing.set("AttackSpeed", 300);
        thing.set("IsFlying", 1);
        thing.set("DeathDecoration", "70% haunted dragon skull");
        Lib.add(thing);
    }

    static void initImps() {
        Thing thing = Lib.extend("base imp", "base demon");
        thing.set("IsImp", 1);
        thing.set("ARM", 2);
        Lib.add(thing);
        thing = Lib.extend("blue imp", "base imp");
        Monster.stats(thing, 6, 10, 5, 3, 6, 4, 7, 2);
        thing.set("Image", 347);
        thing.set("LevelMin", 7);
        thing.set("DeathDecoration", "Frost Bolt");
        Lib.add(thing);
        thing = Lib.extend("frost imp", "base imp");
        Monster.stats(thing, 4, 4, 5, 3, 5, 5, 7, 2);
        thing.set("Image", 347);
        thing.set("LevelMin", 8);
        thing.set("Spellcasting", 1);
        thing.set("DefaultThings", "Frost Bolt");
        thing.set("ARM", 3);
        thing.set("DeathDecoration", "Frost Bolt");
        Lib.add(thing);
        thing = Lib.extend("fire imp", "base imp");
        Monster.stats(thing, 7, 7, 3, 3, 7, 8, 7, 2);
        thing.set("Image", 220);
        thing.set("IsFlying", 1);
        thing.set("LevelMin", 9);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", -30);
        thing.set("Spellcasting", 1);
        thing.set("DefaultThings", "Flame");
        thing.set("ARM", 4);
        thing.set("DeathDecoration", "Flame");
        Lib.add(thing);
        thing = Lib.extend("greater blue imp", "blue imp");
        Monster.stats(thing, 16, 16, 15, 16, 6, 14, 7, 2);
        thing.set("Image", 347);
        thing.set("LevelMin", 11);
        thing.set("DeathDecoration", "Frost Bolt,[IsRunestone]");
        Lib.add(thing);
        thing = Lib.extend("greater fire imp", "fire imp");
        Monster.stats(thing, 17, 17, 13, 13, 17, 18, 17, 12);
        thing.set("Image", 220);
        thing.set("IsFlying", 1);
        thing.set("LevelMin", 12);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", -30);
        thing.set("Spellcasting", 2);
        thing.set("Focus", 2);
        thing.set("DefaultThings", "Flame, Fireball");
        thing.set("ARM", 8);
        thing.set("DeathDecoration", "Fireball,[IsRunestone]");
        Lib.add(thing);
    }

    static void initDemons() {
        Thing thing = Lib.extend("base demon", "base monster");
        thing.set("IsLiving", 0);
        thing.set("IsDemonic", 1);
        thing.set("RES:fire", 10);
        thing.set("RES:acid", 10);
        thing.set("ASCII", "D");
        thing.multiplyStat("RegenerationRate", 3.0);
        thing.set("UnarmedWeapon", Lib.create("claw attack"));
        Lib.add(thing);
        thing = Lib.extend("lesser demon", "base demon");
        Monster.stats(thing, 20, 20, 20, 20, 20, 20, 20, 20);
        thing.set("Unarmed Combat", 2);
        thing.set("Defence", 2);
        thing.set("Attack", 2);
        thing.set("Image", 420);
        thing.set("LevelMin", 14);
        Lib.add(thing);
        thing = Lib.extend("dark angel", "lesser demon");
        Monster.stats(thing, 30, 20, 40, 20, 40, 30, 60, 20);
        thing.set("Image", 400);
        thing.set("IsFlying", 1);
        thing.set("LevelMin", 16);
        thing.set("ARM", 10);
        Lib.add(thing);
        thing = Lib.extend("pit beast", "lesser demon");
        Monster.stats(thing, 40, 40, 50, 40, 10, 60, 10, 20);
        thing.set("Image", 420);
        thing.set("LevelMin", 21);
        thing.set("ARM", 18);
        thing.set("AttackSpeed", 200);
        Lib.add(thing);
        thing = Lib.extend("bile demon", "lesser demon");
        Monster.stats(thing, 40, 40, 30, 70, 50, 60, 1, 40);
        thing.set("Image", 545);
        thing.set("LevelMin", 24);
        thing.set("ARM", 60);
        thing.set("AttackSpeed", 150);
        thing.set("Spellcasting", 2);
        thing.set("Focus", 1);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        thing.set("DefaultThings", "Aruk's Poison Cloud,[IsSpell]");
        Lib.add(thing);
        thing = Lib.extend("wasp demon", "lesser demon");
        Monster.stats(thing, 60, 40, 70, 40, 10, 70, 5, 30);
        thing.set("Image", 548);
        thing.set("LevelMin", 25);
        thing.set("ARM", 20);
        thing.set("MoveSpeed", 200);
        thing.set("AttackSpeed", 200);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        Lib.add(thing);
        thing = Lib.extend("soul eater", "lesser demon");
        Monster.stats(thing, 70, 80, 80, 140, 160, 190, 100, 140);
        thing.set("Image", 543);
        thing.set("LevelMin", 27);
        thing.set("ARM", 60);
        thing.set("AttackSpeed", 150);
        thing.set("MoveSpeed", 70);
        thing.set("Spellcasting", 2);
        thing.set("Focus", 3);
        thing.set("Luck", 60);
        thing.set("UnarmedWeapon", Lib.create("drain attack"));
        thing.set("DefaultThings", "Thunderbolt,Blaze,[IsSpell],[IsSpell]");
        Lib.add(thing);
        thing = Lib.extend("greater demon", "lesser demon");
        Monster.stats(thing, 150, 100, 100, 150, 100, 200, 50, 100);
        thing.set("ARM", 70);
        thing.set("AttackSpeed", 200);
        thing.set("MoveSpeed", 200);
        thing.set("IsFlying", 1);
        thing.set("Spellcasting", 2);
        thing.set("Image", 541);
        thing.set("Luck", 130);
        thing.set("LevelMin", 30);
        Lib.add(thing);
        thing = Lib.extend("bilious demon", "greater demon");
        Monster.stats(thing, 150, 100, 100, 150, 100, 200, 50, 100);
        thing.set("ARM", 40);
        thing.set("AttackSpeed", 150);
        thing.set("MoveSpeed", 150);
        thing.set("IsFlying", 0);
        thing.set("Spellcasting", 4);
        thing.set("Image", 542);
        thing.set("Luck", 140);
        thing.set("DefaultThings", "Thunderbolt,Blaze,[IsSpell],[IsSpell]");
        thing.set("LevelMin", 36);
        Lib.add(thing);
        thing = Lib.extend("greater fire demon", "greater demon");
        Monster.stats(thing, 150, 150, 150, 200, 100, 250, 50, 50);
        thing.set("ARM", 100);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", -20);
        thing.set("RES:water", -20);
        thing.set("Image", 544);
        thing.set("LevelMin", 33);
        thing.addHandler("OnAction", Monster.breathAttack("fire", "blazing flames", 3, 40, 1));
        Lib.add(thing);
        thing = Lib.extend("greater frost demon", "greater demon");
        Monster.stats(thing, 160, 120, 150, 150, 150, 250, 50, 50);
        thing.set("ARM", 60);
        thing.set("RES:fire", -10);
        thing.set("RES:ice", 1000);
        thing.set("RES:water", 20);
        thing.set("Image", 546);
        thing.set("LevelMin", 34);
        thing.set("UnarmedWeapon", Lib.create("ice attack"));
        thing.addHandler("OnAction", Monster.breathAttack("ice", "a blast of ice", 3, 40, 101));
        Lib.add(thing);
        thing = Lib.extend("baal-rukh", "greater demon");
        Monster.stats(thing, 400, 500, 500, 400, 200, 600, 100, 200);
        thing.set("Image", 540);
        thing.set("ARM", 200);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", -20);
        thing.set("RES:water", -20);
        thing.set("AttackSpeed", 300);
        thing.set("MoveSpeed", 400);
        thing.set("IsFlying", 1);
        thing.set("Spellcasting", 5);
        thing.set("UnarmedWeapon", Lib.create("claw attack"));
        thing.set("DefaultThings", "[IsSword],Firepath,Blaze,[IsSpell]");
        thing.set("Luck", 130);
        thing.set("LevelMin", 39);
        Lib.add(thing);
    }

    static void initZombies() {
        Thing thing = Lib.extend("base zombie", "base undead");
        thing.set("Image", 300);
        thing.set("RES:piercing", 7);
        thing.set("RES:fire", -10);
        thing.set("ARM", 1);
        thing.set("FearFactor", 1);
        thing.set("IsRegenerating", 0);
        thing.set("DeathDecoration", "bone");
        thing.set("MoveSpeed", 65);
        thing.set("ASCII", "z");
        Lib.add(thing);
        thing = Lib.extend("lesser zombie", "base zombie");
        Monster.stats(thing, 3, 7, 4, 3, 0, 5, 0, 0);
        thing.set("LevelMin", 5);
        Lib.add(thing);
        thing = Lib.extend("zombie", "base zombie");
        Monster.stats(thing, 9, 17, 6, 7, 0, 14, 0, 0);
        thing.set("LevelMin", 8);
        Lib.add(thing);
        thing = Lib.extend("fearsome zombie", "base zombie");
        Monster.stats(thing, 9, 20, 6, 16, 0, 14, 0, 0);
        thing.set("LevelMin", 9);
        thing.set("FearFactor", 2);
        thing.set("AttackSpeed", 150);
        Lib.add(thing);
        thing = Lib.extend("large zombie", "base zombie");
        Monster.stats(thing, 12, 26, 8, 36, 0, 20, 0, 0);
        thing.set("LevelMin", 10);
        thing.set("Image", 301);
        Lib.add(thing);
        thing = Lib.extend("horrendous zombie", "base zombie");
        Monster.stats(thing, 12, 20, 6, 20, 0, 20, 0, 0);
        thing.set("LevelMin", 11);
        thing.set("FearFactor", 3);
        thing.set("Image", 301);
        Lib.add(thing);
    }

    static void initGhosts() {
        Thing thing = Lib.extend("base ghost", "base undead");
        thing.set("IsUndead", 1);
        thing.set("IsEthereal", 1);
        thing.set("IsFlying", 1);
        thing.set("IsInhabitant", 1);
        thing.set("IsBlocking", 1);
        thing.set("IsGhost", 1);
        thing.set("FearFactor", 2);
        thing.set("Image", 310);
        thing.set("RES:ice", 20);
        thing.set("RES:acid", 20);
        thing.set("MoveSpeed", 80);
        thing.set("UnarmedWeapon", Lib.create("chill attack"));
        thing.set("ASCII", "G");
        Lib.add(thing);
        thing = Lib.extend("ghost", "base ghost");
        Monster.stats(thing, 30, 30, 40, 10, 20, 20, 0, 0);
        thing.set("Image", 310);
        thing.set("LevelMin", 17);
        thing.set("OnTouch", Scripts.damage("chill", 3, "chilled by the touch of the ghost", 50));
        Lib.add(thing);
        thing = Lib.extend("holy ghost", "ghost");
        Monster.stats(thing, 40, 30, 40, 30, 20, 20, 0, 0);
        thing.set("Image", 310);
        thing.set("LevelMin", 22);
        thing.addHandler("OnAction", Scripts.generator("ghost", 20));
        Lib.add(thing);
        thing = Lib.extend("spectre", "base ghost");
        Monster.stats(thing, 80, 80, 60, 50, 60, 120, 0, 0);
        thing.set("Image", 315);
        thing.set("LevelMin", 24);
        thing.set("AttackSpeed", 150);
        thing.set("FearFactor", 5);
        thing.set("IsViewBlocking", 1);
        thing.addHandler("OnAction", Scripts.generator("spectre", 40));
        thing.set("OnTouch", Scripts.damage("chill", 10, "chilled by the touch of the spectre", 50));
        Lib.add(thing);
        thing = Lib.extend("demon spectre", "spectre");
        Monster.stats(thing, 100, 100, 80, 90, 60, 150, 0, 0);
        thing.set("Image", 315);
        thing.set("LevelMin", 30);
        thing.set("AttackSpeed", 200);
        thing.set("FearFactor", 6);
        thing.addHandler("OnAction", Scripts.generator("spectre", 100));
        Lib.add(thing);
        thing = Lib.extend("spectre lord", "demon spectre");
        Monster.stats(thing, 130, 160, 80, 170, 90, 200, 0, 0);
        thing.set("Image", 315);
        thing.set("LevelMin", 34);
        thing.set("AttackSpeed", 300);
        thing.set("FearFactor", 7);
        Lib.add(thing);
    }

    static void initGoblinoids() {
        Thing thing = Lib.extend("base goblinoid", "base humanoid");
        thing.set("IsGoblinoid", 1);
        thing.set("Image", 240);
        thing.set("ARM", 1);
        thing.set("Unarmed Combat", 1);
        thing.set("OnChat", new Personality(1, 6));
        Lib.add(thing);
        thing = Lib.extend("goblin", "base goblinoid");
        Monster.stats(thing, 10, 8, 12, 7, 6, 5, 5, 5);
        thing.set("DeathDecoration", "slime pool, 20% gold coin");
        thing.set("LevelMin", 4);
        thing.set("LevelMax", 15);
        thing.set("Image", 244);
        thing.set("IsGoblin", 1);
        thing.set("DefaultThings", "30%[IsWeapon],15%[IsFood]");
        Lib.add(thing);
        thing = Lib.extend("weedy goblin", "base goblinoid");
        Monster.stats(thing, 5, 3, 12, 3, 5, 2, 5, 5);
        thing.set("DeathDecoration", "slime pool");
        thing.set("LevelMin", 2);
        thing.set("LevelMax", 8);
        thing.set("Image", 244);
        thing.set("DefaultThings", "10%[IsWeapon]");
        Lib.add(thing);
        thing = Lib.extend("small goblin", "base goblinoid");
        Monster.stats(thing, 6, 6, 10, 4, 5, 2, 5, 5);
        thing.set("DeathDecoration", "slime pool");
        thing.set("LevelMin", 3);
        thing.set("LevelMax", 12);
        thing.set("Image", 244);
        thing.set("DefaultThings", "20%[IsWeapon]");
        Lib.add(thing);
        thing = Lib.extend("goblin rockthrower", "base goblinoid");
        Monster.stats(thing, 6, 6, 10, 4, 5, 2, 5, 5);
        thing.set("DeathDecoration", "slime pool");
        thing.set("LevelMin", 4);
        thing.set("Image", 244);
        thing.set("RetreatChance", 50);
        thing.set("Throwing", RPG.d(2));
        thing.set("DefaultThings", "10 [IsRock]");
        Lib.add(thing);
        thing = Lib.extend("goblin slinger", "goblin");
        Monster.stats(thing, 10, 10, 6, 10, 4, 5, 4, 5);
        thing.set("Image", 244);
        thing.set("LevelMin", 5);
        thing.set("RetreatChance", 40);
        thing.set("Archery", RPG.d(2));
        thing.set("DefaultThings", "[IsSling], 20 stone");
        Lib.add(thing);
        thing = Lib.extend("goblin archer", "goblin");
        Monster.stats(thing, 10, 10, 6, 13, 4, 9, 4, 7);
        thing.set("Image", 248);
        thing.set("LevelMin", 7);
        thing.set("RetreatChance", 60);
        thing.set("Archery", RPG.d(2));
        thing.set("DefaultThings", "100%[IsBow], 100% 6 [IsArrow],60% 6 goblin arrow");
        Lib.add(thing);
        thing = Lib.extend("big goblin", "goblin");
        Monster.stats(thing, 10, 10, 6, 13, 4, 9, 4, 7);
        thing.set("LevelMin", 6);
        thing.set("Image", 241);
        thing.set("Unarmed Combat", 2);
        thing.set("ARM", 3);
        Lib.add(thing);
        thing = Lib.extend("goblin warrior", "big goblin");
        Monster.stats(thing, 13, 10, 11, 9, 6, 8, 5, 6);
        thing.set("Image", 240);
        thing.set("DefaultThings", "30% [IsArmour], 30%[IsWeapon]");
        thing.set("LevelMin", 8);
        thing.set("ARM", 6);
        Lib.add(thing);
        thing = Lib.extend("goblin leader", "goblin warrior");
        Monster.stats(thing, 23, 12, 19, 17, 6, 8, 5, 6);
        thing.set("Image", 243);
        thing.set("DefaultThings", "50% [IsArmour], [IsWeapon]");
        thing.set("LevelMin", 10);
        thing.set("Defence", 2);
        thing.incStat("SkillPoints", 2);
        thing.set("ARM", 10);
        Lib.add(thing);
        thing = Lib.extend("goblin champion", "goblin leader");
        Monster.stats(thing, 33, 22, 39, 27, 16, 18, 11, 16);
        thing.set("Attack", 1);
        thing.set("ARM", 15);
        thing.set("LevelMin", 14);
        thing.incStat("Luck", 20);
        Lib.add(thing);
        thing = Lib.extend("goblin chieftain", "goblin champion");
        Monster.stats(thing, 35, 32, 39, 47, 16, 28, 11, 16);
        thing.set("Attack", 1);
        thing.set("Defence", 1);
        thing.set("ARM", 18);
        thing.set("LevelMin", 17);
        thing.incStat("Luck", 30);
        Lib.add(thing);
        thing = Lib.extend("goblin hero", "goblin chieftain");
        Monster.stats(thing, 53, 32, 69, 47, 36, 48, 21, 36);
        thing.set("MoveSpeed", 160);
        thing.set("AttackSpeed", 160);
        thing.set("Attack", 2);
        thing.incStat("SkillPoints", 4);
        thing.set("DefaultThings", "[IsArmour], [IsWeapon], 20% [IsThrowingWeapon], 20% [IsRangedWeapon]");
        thing.set("ARM", 20);
        thing.set("LevelMin", 20);
        thing.incStat("Luck", 40);
        Lib.add(thing);
        thing = Lib.extend("goblin war-boss", "goblin hero");
        Monster.strengthen(thing, 2.0);
        thing.set("LevelMin", 26);
        thing.set("IsDisplaceable", 0);
        Lib.add(thing);
        thing = Lib.extend("flying goblin", "goblin");
        Monster.stats(thing, 18, 10, 16, 19, 26, 28, 15, 16);
        thing.set("Image", 247);
        thing.set("MoveSpeed", 350);
        thing.set("AttackSpeed", 200);
        thing.set("IsFlying", 1);
        thing.set("DefaultThings", "50% [IsArmour], 100%[IsWeapon]");
        thing.set("Frequency", 10);
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("goblin shaman", "goblin");
        Monster.stats(thing, 16, 10, 16, 13, 26, 28, 15, 16);
        thing.set("UnarmedWeapon", Lib.create("curse attack"));
        thing.set("Spellcasting", 3);
        thing.set("Defence", 2);
        thing.set("Focus", 2);
        thing.set("DefaultThings", "[IsStaff],50% Fireball,50% Poison Cloud,50% Flame,[IsSpell],50% [IsArmour],[IsScroll]");
        thing.set("Image", 245);
        thing.set("LevelMin", 17);
        thing.set("ARM", 15);
        thing.incStat("Luck", 50);
        Lib.add(thing);
        thing = Lib.extend("orc", "big goblin");
        Monster.stats(thing, 8, 10, 7, 11, 4, 9, 3, 3);
        thing.set("ARM", 4);
        thing.set("LevelMin", 8);
        thing.set("Attack", 1);
        thing.set("Image", 242);
        thing.set("IsOrc", 1);
        thing.set("OnChat", new Personality(1, 7));
        Lib.add(thing);
        thing = Lib.extend("big orc", "orc");
        Monster.stats(thing, 7, 14, 7, 16, 4, 9, 3, 3);
        thing.set("ARM", 6);
        thing.set("LevelMin", 10);
        thing.set("Unarmed Combat", 2);
        thing.set("Attack", 1);
        thing.set("Defence", 2);
        thing.set("Image", 242);
        Lib.add(thing);
        thing = Lib.extend("orc warrior", "orc");
        Monster.stats(thing, 13, 18, 9, 18, 5, 18, 5, 6);
        thing.set("ARM", 10);
        thing.set("Attack", 2);
        thing.set("Defence", 1);
        thing.set("Image", 246);
        thing.set("DefaultThings", "50% [IsArmour], 100%[IsWeapon]");
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("orc champion", "orc");
        Monster.strengthen(thing, 2.5);
        thing.set("Unarmed Combat", 3);
        thing.set("Attack", 2);
        thing.set("Defence", 3);
        thing.set("AttackSpeed", 160);
        thing.set("Image", 246);
        thing.set("DefaultThings", "[IsArmour],[IsWeapon]");
        thing.set("LevelMin", 16);
        thing.incStat("Luck", 20);
        Lib.add(thing);
        thing = Lib.extend("orc hero", "orc");
        Monster.strengthen(thing, 6.0);
        thing.set("Unarmed Combat", 4);
        thing.set("Attack", 4);
        thing.set("Defence", 5);
        thing.set("AttackSpeed", 200);
        thing.set("MoveSpeed", 130);
        thing.set("Image", 246);
        thing.incStat("SkillPoints", 4);
        thing.set("DefaultThings", "[IsArmour],[IsWeapon], 50% [IsThrowingWeapon]");
        thing.set("LevelMin", 22);
        thing.incStat("Luck", 40);
        Lib.add(thing);
        thing = Lib.extend("orc warlord", "orc hero");
        Monster.strengthen(thing, 2.0);
        thing.set("Unarmed Combat", 6);
        thing.set("Attack", 6);
        thing.set("Defence", 8);
        thing.set("AttackSpeed", 300);
        thing.set("MoveSpeed", 150);
        thing.set("Image", 246);
        thing.set("DefaultThings", "[IsArmour],[IsArmour],[IsWeapon],[IsThrowingWeapon],[IsItem]");
        thing.set("LevelMin", 28);
        thing.incStat("Luck", 60);
        Lib.add(thing);
    }

    static void initInsects() {
        Thing thing = Lib.extend("base insect", "base monster");
        thing.set("DeathDecoration", "slime pool");
        thing.set("IsInsect", 1);
        thing.set("IsBeast", 1);
        thing.set("IsBlocking", 1);
        thing.set("Frequency", 40);
        thing.set("RES:poison", 10);
        thing.set("LevelMin", 3);
        thing.incStat("Dodge", 1);
        Lib.add(thing);
        thing = Lib.extend("insect", "base insect");
        Monster.stats(thing, 2, 2, 3, 1, 1, 1, 1, 1);
        thing.set("Image", 161);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("small yellow bug", "insect");
        Monster.stats(thing, 3, 3, 1, 2, 1, 1, 1, 2);
        thing.set("Image", 162);
        thing.set("LevelMin", 1);
        thing.set("DeathDecoration", "20% squished bug");
        Lib.add(thing);
        thing = Lib.extend("cockroach", "insect");
        Monster.stats(thing, 2, 2, 5, 2, 1, 2, 0, 1);
        thing.set("Image", 161);
        thing.set("LevelMin", 2);
        thing.set("DeathDecoration", "30% squished roach");
        Lib.add(thing);
        thing = Lib.extend("beetle", "insect");
        Monster.stats(thing, 5, 3, 5, 4, 2, 3, 1, 2);
        thing.set("Image", 169);
        thing.set("LevelMin", 3);
        thing.set("DeathDecoration", "30% dead beetle");
        Lib.add(thing);
        thing = Lib.extend("bug", "insect");
        Monster.stats(thing, 8, 8, 8, 8, 2, 9, 1, 2);
        thing.set("Image", 161);
        thing.set("ARM", 3);
        thing.set("LevelMin", 4);
        thing.set("DeathDecoration", "30% dead bug");
        Lib.add(thing);
        thing = Lib.extend("yellow bug", "insect");
        Monster.stats(thing, 9, 8, 8, 8, 2, 9, 1, 2);
        thing.set("Image", 162);
        thing.set("ARM", 4);
        thing.set("LevelMin", 5);
        thing.set("DeathDecoration", "40% dead bug");
        Lib.add(thing);
        thing = Lib.extend("big bug", "bug");
        Monster.stats(thing, 14, 12, 6, 13, 3, 19, 1, 3);
        thing.set("Image", 181);
        thing.set("ARM", 3);
        thing.set("LevelMin", 6);
        thing.set("DeathDecoration", "40% dead bug");
        Lib.add(thing);
        thing = Lib.extend("giant cockroach", "insect");
        Monster.stats(thing, 13, 10, 18, 13, 2, 5, 0, 2);
        thing.set("Image", 161);
        thing.set("Defence", 1);
        thing.set("ARM", 5);
        thing.set("LevelMin", 7);
        thing.set("DeathDecoration", "40% dead roach");
        Lib.add(thing);
        thing = Lib.extend("ice bug", "bug");
        Monster.stats(thing, 14, 13, 6, 12, 3, 19, 1, 3);
        thing.set("Image", 181);
        thing.set("LevelMin", 8);
        thing.set("ARM", 2);
        thing.set("UnarmedWeapon", Lib.create("ice attack"));
        Lib.add(thing);
        thing = Lib.extend("chaos beetle", "insect");
        Monster.stats(thing, 13, 16, 18, 18, 2, 15, 0, 2);
        thing.set("Image", 191);
        thing.set("Defence", 2);
        thing.set("Attack", 2);
        thing.set("ARM", 18);
        thing.set("LevelMin", 12);
        thing.set("DeathDecoration", "40% dead beetle");
        Lib.add(thing);
        thing = Lib.extend("scorpion", "insect");
        Monster.stats(thing, 40, 18, 20, 10, 2, 29, 1, 6);
        thing.set("Image", 168);
        thing.set("LevelMin", 10);
        thing.set("ARM", 2);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.set("DeathDecoration", "slime pool, scorpion tail, 20% dead scorpion");
        Lib.add(thing);
        thing = Lib.extend("base swarm", "base insect");
        Monster.stats(thing, 1, 1, 1, 1, 1, 1, 1, 1);
        thing.set("Image", 281);
        thing.set("IsFlying", 1);
        thing.set("LevelMin", 1);
        thing.set("ARM", 0);
        thing.set("IsConfused", 1);
        thing.incStat("Dodge", 1);
        Lib.add(thing);
        thing = Lib.extend("fly swarm", "base swarm");
        Monster.stats(thing, 6, 4, 7, 3, 1, 3, 1, 1);
        thing.set("Image", 280);
        thing.set("LevelMin", 3);
        thing.set("DeathDecoration", "20* dead fly");
        Lib.add(thing);
        thing = Lib.extend("bee swarm", "base swarm");
        Monster.stats(thing, 12, 6, 13, 5, 1, 3, 1, 1);
        thing.set("Image", 281);
        thing.set("LevelMin", 5);
        thing.set("DeathDecoration", "30* dead bee");
        Lib.add(thing);
        thing = Lib.extend("wasp swarm", "base swarm");
        Monster.stats(thing, 20, 8, 16, 10, 1, 3, 1, 1);
        thing.set("Image", 282);
        thing.set("ARM", 1);
        thing.set("LevelMin", 7);
        thing.set("DeathDecoration", "10* dead wasp");
        Lib.add(thing);
        thing = Lib.extend("hornet swarm", "base swarm");
        Monster.stats(thing, 28, 18, 26, 20, 1, 3, 1, 1);
        thing.set("Image", 282);
        thing.set("ARM", 3);
        thing.set("LevelMin", 11);
        thing.set("DeathDecoration", "15* dead hornet");
        Lib.add(thing);
        thing = Lib.extend("fire wasp swarm", "base swarm");
        Monster.stats(thing, 25, 8, 16, 15, 1, 3, 1, 1);
        thing.set("Image", 289);
        thing.set("LevelMin", 9);
        thing.set("ARM", 2);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.set("DeathDecoration", "20* dead fire wasp");
        Lib.add(thing);
    }

    static void initBears() {
        Thing thing = Lib.extend("base bear", "base monster");
        thing.set("IsBear", 1);
        thing.set("IsBeast", 1);
        thing.set("MoveSpeed", 100);
        thing.set("AttackSpeed", 150);
        thing.set("Frequency", 10);
        thing.set("Image", 201);
        thing.set("ARM", 8);
        thing.set("DeathDecoration", "blood pool, 30% bear paw");
        thing.set("UnarmedWeapon", Lib.create("claw attack"));
        Lib.add(thing);
        thing = Lib.extend("brown bear", "base bear");
        Monster.stats(thing, 20, 25, 16, 35, 3, 15, 4, 3);
        thing.set("LevelMin", 12);
        thing.set("Image", 201);
        Lib.add(thing);
        thing = Lib.extend("grizzly bear", "base bear");
        Monster.stats(thing, 25, 35, 19, 45, 3, 25, 4, 3);
        thing.set("LevelMin", 15);
        thing.set("Image", 201);
        Lib.add(thing);
        thing = Lib.extend("black bear", "base bear");
        Monster.stats(thing, 30, 50, 25, 65, 3, 35, 4, 3);
        thing.set("LevelMin", 16);
        thing.set("Image", 203);
        Lib.add(thing);
        thing = Lib.extend("polar bear", "base bear");
        Monster.stats(thing, 35, 55, 29, 75, 3, 45, 4, 3);
        thing.set("LevelMin", 18);
        thing.set("Image", 202);
        Lib.add(thing);
        thing = Lib.extend("ice bear", "base bear");
        Monster.stats(thing, 35, 55, 29, 75, 3, 55, 4, 3);
        thing.set("LevelMin", 20);
        thing.set("Image", 202);
        thing.set("UnarmedWeapon", Lib.create("ice attack"));
        Lib.add(thing);
    }

    static void initCats() {
        Thing thing = Lib.extend("base feline", "base monster");
        thing.set("IsFeline", 1);
        thing.set("MoveSpeed", 120);
        thing.set("Frequency", 10);
        thing.set("Image", 213);
        thing.set("DeathDecoration", "blood pool, 30% cat whisker");
        thing.set("ASCII", "f");
        thing.set("IsBeast", 1);
        Lib.add(thing);
        thing = Lib.extend("black cat", "base feline");
        Monster.stats(thing, 10, 3, 16, 5, 3, 5, 4, 2);
        thing.set("LevelMin", 3);
        thing.set("Image", 213);
        Lib.add(thing);
        thing = Lib.extend("wildcat", "black cat");
        Monster.stats(thing, 20, 13, 26, 20, 3, 13, 3, 3);
        thing.set("LevelMin", 8);
        thing.set("Image", 211);
        Lib.add(thing);
        thing = Lib.extend("cheetah", "wildcat");
        Monster.stats(thing, 30, 23, 36, 20, 3, 13, 3, 3);
        thing.set("LevelMin", 11);
        thing.set("MoveSpeed", 200);
        thing.set("AttackSpeed", 200);
        thing.set("Image", 211);
        Lib.add(thing);
        thing = Lib.extend("cave lion", "wildcat");
        Monster.stats(thing, 40, 40, 36, 40, 4, 23, 9, 2);
        thing.set("LevelMin", 14);
        thing.set("UnarmedWeapon", Lib.create("razor claw attack"));
        thing.set("Image", 212);
        Lib.add(thing);
        thing = Lib.extend("witch's cat", "black cat");
        Monster.stats(thing, 28, 13, 36, 15, 10, 19, 13, 7);
        thing.set("LevelMin", 17);
        thing.set("UnarmedWeapon", Lib.create("hex attack"));
        thing.set("FatePoints", 9);
        thing.set("Luck", 100);
        thing.set("Image", 213);
        Lib.add(thing);
    }

    static void initPlants() {
        Thing thing = Lib.extend("base plant monster", "base monster");
        thing.set("IsPlantMonster", 1);
        thing.set("Image", 320);
        thing.set("MoveSpeed", 30);
        thing.set("RES:fire", -15);
        thing.set("RES:impact", 12);
        thing.set("RES:piercing", 12);
        thing.set("RES:poison", 1000);
        thing.set("ASCII", "t");
        Lib.add(thing);
        thing = Lib.extend("triffid", "base plant monster");
        thing.set("Image", 320);
        Monster.stats(thing, 10, 10, 10, 15, 0, 10, 0, 3);
        thing.set("UnarmedWeapon", Lib.create("blind attack"));
        thing.set("ARM", 3);
        thing.set("LevelMin", 10);
        thing.set("DeathDecoration", "slime pool");
        Lib.add(thing);
        thing = Lib.extend("seed triffid", "triffid");
        thing.set("Image", 322);
        Monster.stats(thing, 20, 10, 20, 30, 0, 30, 0, 6);
        thing.set("UnarmedWeapon", Lib.create("blind attack"));
        thing.addHandler("OnAction", Scripts.generator("triffid", 100));
        thing.set("LevelMin", 14);
        Lib.add(thing);
        thing = Lib.extend("tree monster", "base plant monster");
        Monster.stats(thing, 20, 40, 10, 80, 4, 40, 0, 2);
        thing.set("ARM", 20);
        thing.set("IsIntelligent", 1);
        thing.set("Image", 321);
        thing.set("LevelMin", 10);
        thing.set("DeathDecoration", "wooden log");
        thing.set("ASCII", "T");
        Lib.add(thing);
        thing = Lib.extend("tree hurler", "tree monster");
        Monster.stats(thing, 30, 50, 10, 80, 4, 40, 0, 2);
        thing.set("ARM", 30);
        thing.set("Image", 321);
        thing.set("LevelMin", 13);
        thing.set("DefaultThings", "10 rock");
        thing.set("Throwing", 3);
        thing.set("DeathDecoration", "wooden log");
        Lib.add(thing);
        thing = Lib.extend("greater tree monster", "tree monster");
        Monster.stats(thing, 40, 60, 12, 180, 19, 70, 6, 7);
        thing.set("ARM", 50);
        thing.set("Image", 321);
        thing.set("LevelMin", 18);
        thing.set("DeathDecoration", "wooden log");
        Lib.add(thing);
        thing = Lib.extend("shrooma", "base plant monster");
        Monster.stats(thing, 40, 60, 20, 100, 39, 70, 6, 27);
        thing.set("ARM", 80);
        thing.set("Image", 325);
        thing.set("MoveSpeed", 60);
        thing.incStat("Spellcasting", 1);
        thing.set("DefaultThings", "Aruk's Poison Cloud");
        thing.set("LevelMin", 22);
        thing.set("DeathDecoration", "Poison Cloud,[IsMushroom]");
        Lib.add(thing);
        thing = Lib.extend("vileweed", "base plant monster");
        Monster.stats(thing, 80, 100, 0, 120, 1, 50, 0, 3);
        thing.set("ARM", 120);
        thing.set("Image", 323);
        thing.set("MoveSpeed", 10);
        thing.set("AttackSpeed", 100);
        thing.set("LevelMin", 24);
        thing.set("DeathDecoration", "Poison Cloud,slime pool");
        thing.set("UnarmedWeapon", Lib.create("poison whip attack"));
        Lib.add(thing);
    }

    static void initBirds() {
        Thing thing = Lib.extend("base bird", "base monster");
        thing.set("IsBird", 1);
        thing.set("IsBeast", 1);
        thing.set("Frequency", 45);
        thing.set("IsFlying", 1);
        thing.set("MoveSpeed", 200);
        thing.set("Image", 291);
        thing.set("RES:shock", 20);
        thing.set("RES:fire", -5);
        Lib.add(thing);
        thing = Lib.extend("kestrel", "base bird");
        thing.set("LevelMin", 3);
        thing.set("DeathDecoration", "blood pool,40% kestrel feather");
        Monster.stats(thing, 7, 4, 18, 3, 1, 3, 5, 2);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Lib.add(thing);
        thing = Lib.extend("hawk", "base bird");
        thing.set("LevelMin", 7);
        thing.set("DeathDecoration", "blood pool,40% hawk feather");
        Monster.stats(thing, 16, 10, 28, 13, 2, 6, 7, 3);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Lib.add(thing);
        thing = Lib.extend("eagle", "hawk");
        thing.set("LevelMin", 11);
        thing.set("ARM", 3);
        thing.set("DeathDecoration", "blood pool,40% hawk feather");
        Monster.stats(thing, 26, 15, 38, 18, 6, 16, 27, 3);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Lib.add(thing);
    }

    static void initDragons() {
        Thing thing = Lib.extend("base dragon", "base monster");
        thing.set("IsBeast", 1);
        thing.set("IsDragon", 1);
        thing.set("IsReptile", 1);
        thing.set("IsViewBlocking", 1);
        thing.set("Frequency", 20);
        Monster.stats(thing, 120, 140, 100, 200, 250, 190, 200, 240);
        thing.set("ARM", 300);
        thing.set("AttackSpeed", 200);
        thing.set("RES:poison", 20);
        thing.set("RES:fire", 10);
        thing.set("MoveSpeed", 200);
        thing.set("Luck", 70);
        thing.set("IsFlying", 1);
        thing.set("Unarmed Combat", 3);
        thing.set("Attack", 3);
        thing.set("Defence", 4);
        thing.set("Bravery", 2);
        thing.set("Spellcasting", 2);
        thing.set("Focus", 3);
        thing.set("UnarmedWeapon", Lib.create("razor claw attack"));
        thing.set("LevelMin", 30);
        thing.set("Image", 645);
        Lib.add(thing);
        thing = Lib.extend("swamp dragon", "base dragon");
        Monster.strengthen(thing, 0.8);
        thing.set("RES:poison", 1000);
        thing.set("LevelMin", 29);
        thing.set("Image", 645);
        thing.addHandler("OnAction", Monster.breathAttack("poison", "noxious fumes", 2, 40, 41));
        Lib.add(thing);
        thing = Lib.extend("green dragon", "base dragon");
        Monster.strengthen(thing, 1.0);
        thing.set("LevelMin", 30);
        thing.set("Image", 647);
        thing.addHandler("OnAction", Monster.breathAttack("poison", "poisonous fumes", 2, 60, 41));
        thing.addHandler("OnAction", Monster.breathAttack("fire", "blazing flames", 2, 60, 1));
        Lib.add(thing);
        thing = Lib.extend("blue dragon", "base dragon");
        thing.set("RES:shock", 1000);
        thing.set("LevelMin", 31);
        thing.set("Image", 644);
        thing.addHandler("OnAction", Monster.breathAttack("ice", "crackling lightning", 3, 60, 61));
        Lib.add(thing);
        thing = Lib.extend("frost dragon", "base dragon");
        thing.set("RES:ice", 1000);
        thing.set("RES:fire", -15);
        thing.set("LevelMin", 32);
        thing.addHandler("OnAction", Monster.breathAttack("ice", "a blast of ice", 5, 60, 101));
        thing.set("Image", 640);
        Lib.add(thing);
        thing = Lib.extend("red dragon", "base dragon");
        Monster.strengthen(thing, 1.5);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", -15);
        thing.set("LevelMin", 34);
        thing.set("Image", 641);
        thing.addHandler("OnAction", Monster.breathAttack("fire", "hellish flames", 6, 100, 1));
        Lib.add(thing);
        thing = Lib.extend("black dragon", "base dragon");
        Monster.strengthen(thing, 1.5);
        thing.set("RES:ice", 1000);
        thing.set("RES:fire", -15);
        thing.set("LevelMin", 36);
        thing.set("Image", 642);
        thing.set("Luck", 100);
        thing.set("Spellcasting", 6);
        thing.set("Focus", 5);
        thing.addHandler("OnAction", Monster.breathAttack("fire", "hellish flames", 4, 60, 1));
        thing.set("DefaultThings", "[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell],[IsSpell]");
        Lib.add(thing);
    }

    static void initCentipedes() {
        Thing thing = Lib.extend("base centipede", "base monster");
        thing.set("IsCentipede", 1);
        thing.set("IsInsect", 1);
        thing.set("IsBeast", 1);
        thing.set("Frequency", 40);
        Monster.stats(thing, 7, 5, 5, 7, 2, 6, 1, 1);
        thing.set("MoveSpeed", 100);
        thing.set("Image", 560);
        thing.set("ARM", 2);
        thing.set("RES:poison", 20);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Lib.add(thing);
        thing = Lib.extend("centipede", "base centipede");
        thing.set("LevelMin", 2);
        Lib.add(thing);
        thing = Lib.extend("giant centipede", "base centipede");
        Monster.strengthen(thing, 1.5);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("monster centipede", "base centipede");
        Monster.strengthen(thing, 2.0);
        thing.set("Image", 565);
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("demon centipede", "base centipede");
        Monster.strengthen(thing, 3.0);
        thing.set("Image", 563);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("magipede", "base centipede");
        Monster.strengthen(thing, 3.0);
        Monster.stats(thing, 10, 8, 15, 17, 25, 28, 4, 12);
        thing.set("Image", 561);
        thing.set("Spellcasting", 2);
        thing.set("DefaultThings", "[IsSpell],[IsSpell],[IsSpell]");
        thing.set("LevelMin", 13);
        Lib.add(thing);
    }

    static void initWorms() {
        Thing thing = Lib.extend("base worm", "base monster");
        thing.set("IsWorm", 1);
        thing.set("IsBeast", 1);
        thing.set("Frequency", 25);
        Monster.stats(thing, 6, 4, 8, 4, 2, 4, 2, 2);
        thing.set("MoveSpeed", 90);
        thing.set("Image", 624);
        thing.set("RES:fire", -20);
        thing.set("RES:poison", 20);
        Lib.add(thing);
        thing = Lib.extend("giant worm", "base worm");
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Monster.stats(thing, 8, 7, 3, 15, 1, 12, 1, 1);
        thing.set("LevelMin", 4);
        thing.set("Image", 624);
        Lib.add(thing);
        thing = Lib.extend("vileworm", "base worm");
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        Monster.stats(thing, 18, 17, 13, 35, 1, 22, 1, 1);
        thing.set("LevelMin", 11);
        thing.set("Image", 621);
        Lib.add(thing);
        thing = Lib.extend("fire worm", "base worm");
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Monster.stats(thing, 18, 27, 13, 35, 1, 22, 1, 1);
        thing.set("LevelMin", 13);
        thing.set("RES:fire", 1000);
        thing.set("RES:ice", 20);
        thing.set("MoveSpeed", 100);
        thing.set("Image", 620);
        Lib.add(thing);
        thing = Lib.extend("chaos worm", "base worm");
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Monster.stats(thing, 28, 27, 23, 45, 1, 32, 1, 1);
        thing.set("IsChaotic", 1);
        thing.set("LevelMin", 15);
        thing.set("MoveSpeed", 100);
        thing.set("Image", 625);
        Lib.add(thing);
        thing = Lib.extend("corpse worm", "base worm");
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Monster.stats(thing, 38, 37, 33, 55, 1, 42, 1, 1);
        thing.set("LevelMin", 17);
        thing.set("MoveSpeed", 100);
        thing.set("AttackSpeed", 150);
        thing.set("Image", 623);
        Lib.add(thing);
    }

    static void initSnakes() {
        Thing thing = Lib.extend("base snake", "base monster");
        thing.set("IsSnake", 1);
        thing.set("IsBeast", 1);
        thing.set("IsReptile", 1);
        thing.set("Frequency", 25);
        Monster.stats(thing, 6, 4, 8, 4, 2, 4, 2, 2);
        thing.set("MoveSpeed", 70);
        thing.set("Image", 567);
        thing.set("RES:ice", -5);
        thing.set("RES:poison", 20);
        thing.set("Swimming", 1);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.set("ASCII", "s");
        Lib.add(thing);
        thing = Lib.extend("grass snake", "base snake");
        thing.set("UnarmedWeapon", Lib.create("unarmed attack"));
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("small snake", "grass snake");
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        thing.set("LevelMin", 2);
        Lib.add(thing);
        thing = Lib.extend("snake", "base snake");
        thing.set("LevelMin", 3);
        thing.set("DeathDecoration", "blood pool,40% snake skin");
        Lib.add(thing);
        thing = Lib.extend("python", "base snake");
        Monster.stats(thing, 26, 17, 22, 16, 3, 17, 2, 5);
        thing.set("Image", 566);
        thing.set("LevelMin", 9);
        thing.set("DeathDecoration", "blood pool,40% snake skin");
        Lib.add(thing);
        thing = Lib.extend("red snake", "base snake");
        thing.set("Image", 570);
        Monster.stats(thing, 16, 7, 12, 6, 3, 7, 2, 3);
        thing.set("LevelMin", 6);
        thing.set("RES:ice", -10);
        thing.set("ARM", 2);
        thing.set("DeathDecoration", "blood pool,40% red snake skin");
        Lib.add(thing);
        thing = Lib.extend("fire snake", "red snake");
        Monster.stats(thing, 22, 14, 18, 9, 8, 12, 7, 5);
        thing.set("RES:ice", 10);
        thing.set("LevelMin", 8);
        Lib.add(thing);
        thing = Lib.extend("demon snake", "fire snake");
        Monster.stats(thing, 26, 19, 28, 29, 18, 23, 16, 12);
        thing.addHandler("OnAction", Scripts.generator("fire snake", 200));
        thing.set("MoveSpeed", 60);
        thing.set("AttackSpeed", 60);
        thing.set("LevelMin", 13);
        thing.set("LevelMax", 20);
        thing.set("FearFactor", 2);
        thing.set("ARM", 6);
        thing.set("Image", 568);
        Lib.add(thing);
    }

    static void initSpiders() {
        Thing thing = Lib.extend("base spider", "base monster");
        thing.set("IsSpider", 1);
        thing.set("IsBeast", 1);
        thing.set("Frequency", 50);
        Monster.stats(thing, 5, 5, 6, 8, 3, 9, 1, 3);
        thing.set("MoveSpeed", 100);
        thing.set("Image", 164);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        thing.set("LevelMin", 1);
        thing.set("RES:fire", -10);
        thing.set("ARM", 1);
        thing.set("ASCII", "s");
        Lib.add(thing);
        thing = Lib.extend("small spider", "base spider");
        thing.set("Image", 164);
        Monster.stats(thing, 5, 3, 5, 2, 3, 9, 1, 3);
        thing.set("LevelMin", 1);
        thing.set("ARM", 1);
        thing.set("DeathDecoration", "20% squished spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("spider", "base spider");
        thing.set("Image", 164);
        Monster.stats(thing, 7, 5, 8, 6, 3, 12, 1, 3);
        thing.set("LevelMin", 4);
        thing.set("DeathDecoration", "20% dead spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("wolf spider", "base spider");
        thing.set("Image", 184);
        Monster.stats(thing, 9, 6, 9, 9, 3, 15, 1, 4);
        thing.set("MoveSpeed", 120);
        thing.set("AttackSpeed", 120);
        thing.set("ARM", 3);
        thing.set("LevelMin", 6);
        thing.set("DeathDecoration", "30% dead wolf spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("large spider", "base spider");
        thing.set("Image", 184);
        Monster.stats(thing, 12, 10, 10, 18, 3, 20, 2, 5);
        thing.set("LevelMin", 7);
        thing.set("ARM", 5);
        thing.addHandler("OnAction", Scripts.generator("spider web", 20));
        thing.set("DeathDecoration", "40% dead spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("red spider", "base spider");
        Monster.stats(thing, 13, 7, 12, 15, 4, 18, 2, 6);
        thing.set("Image", 165);
        thing.set("ARM", 6);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.set("LevelMin", 8);
        thing.set("DeathDecoration", "30% dead red spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("black widow", "base spider");
        Monster.stats(thing, 33, 12, 22, 15, 4, 28, 4, 8);
        thing.set("Image", 583);
        thing.set("ARM", 7);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        thing.set("LevelMin", 13);
        thing.set("DeathDecoration", "40% dead black widow, blood pool");
        Lib.add(thing);
        thing = Lib.extend("baby giant spider", "base spider");
        Monster.stats(thing, 12, 10, 10, 10, 3, 20, 2, 5);
        thing.set("Image", 167);
        thing.set("ARM", 8);
        thing.set("DecayRate", 10);
        thing.set("DecayType", "giant spider");
        thing.addHandler("OnAction", Scripts.decay());
        thing.set("LevelMin", 13);
        thing.set("DeathDecoration", "30% dead spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("giant spider", "base spider");
        Monster.stats(thing, 23, 19, 18, 25, 6, 28, 4, 10);
        thing.set("Image", 187);
        thing.set("ARM", 18);
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        thing.addHandler("OnAction", Scripts.generator("giant spider web", 20));
        thing.set("LevelMin", 14);
        thing.set("DeathDecoration", "40% dead spider, blood pool");
        Lib.add(thing);
        thing = Lib.extend("tarantula", "base spider");
        Monster.stats(thing, 33, 29, 28, 35, 6, 48, 6, 12);
        thing.set("Image", 585);
        thing.set("ARM", 18);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        thing.set("LevelMin", 21);
        thing.set("DeathDecoration", "20% dead tarantula, blood pool");
        Lib.add(thing);
        thing = Lib.extend("giant tarantula", "tarantula");
        Monster.stats(thing, 33, 39, 28, 55, 6, 68, 6, 15);
        thing.set("Image", 585);
        thing.set("ARM", 30);
        thing.set("UnarmedWeapon", Lib.create("strong poison attack"));
        thing.set("LevelMin", 24);
        thing.set("DeathDecoration", "50% dead tarantula, blood pool");
        Lib.add(thing);
    }

    public static void initRalkans() {
        Thing thing = Lib.extend("base ralkan", "base monster");
        thing.set("IsSpider", 1);
        thing.set("Frequency", 50);
        Monster.stats(thing, 25, 25, 12, 48, 5, 29, 3, 3);
        thing.set("MoveSpeed", 80);
        thing.set("Image", 186);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        thing.set("LevelMin", 15);
        thing.set("ARM", 40);
        thing.set("ASCII", "R");
        Lib.add(thing);
        thing = Lib.extend("baby ralkan", "base ralkan");
        thing.set("Image", 166);
        thing.set("ARM", 30);
        thing.set("DecayRate", 3);
        thing.set("DecayType", "ralkan");
        thing.addHandler("OnAction", Scripts.decay());
        thing.set("LevelMin", 15);
        Lib.add(thing);
        thing = Lib.extend("ralkan", "base ralkan");
        Monster.strengthen(thing, 2.0);
        thing.set("Image", 186);
        thing.set("ARM", 90);
        thing.addHandler("OnAction", Scripts.generator("baby ralkan", 5));
        thing.set("LevelMin", 18);
        Lib.add(thing);
    }

    static void initCritters() {
        Thing thing = Lib.extend("base critter", "base monster");
        thing.set("IsCritter", 1);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 1);
        thing.set("IsBeast", 1);
        thing.set("UnarmedWeapon", Lib.create("bite attack"));
        Lib.add(thing);
        thing = Lib.extend("rat", "base critter");
        thing.set("Image", 283);
        thing.set("IsRat", 1);
        thing.set("LevelMin", 2);
        Monster.stats(thing, 3, 2, 3, 2, 1, 2, 1, 1);
        thing.set("DeathDecoration", "blood pool,20% rat tail");
        thing.set("ASCII", "r");
        Lib.add(thing);
        thing = Lib.extend("field mouse", "rat");
        thing.set("Image", 283);
        thing.set("LevelMin", 1);
        thing.set("LevelMax", 3);
        Monster.stats(thing, 3, 1, 4, 1, 1, 1, 1, 1);
        thing.set("DeathDecoration", "blood pool,20% mouse tail");
        Lib.add(thing);
        thing = Lib.extend("small rat", "rat");
        thing.set("Image", 283);
        thing.set("LevelMin", 1);
        thing.set("LevelMax", 3);
        Monster.stats(thing, 4, 1, 3, 1, 1, 1, 1, 1);
        Lib.add(thing);
        thing = Lib.extend("big rat", "rat");
        thing.set("LevelMin", 3);
        Monster.stats(thing, 4, 4, 5, 4, 1, 3, 1, 1);
        Lib.add(thing);
        thing = Lib.extend("sewer rat", "rat");
        thing.set("LevelMin", 4);
        thing.set("LevelMax", 12);
        thing.set("Image", 296);
        thing.set("IsGenerator", 1);
        thing.addHandler("OnAction", Scripts.generator("sewer rat", 10));
        Monster.stats(thing, 5, 3, 6, 3, 3, 6, 1, 5);
        Lib.add(thing);
        thing = Lib.extend("giant rat", "rat");
        Monster.stats(thing, 6, 7, 6, 8, 2, 8, 2, 2);
        thing.set("LevelMin", 5);
        thing.set("LevelMax", 10);
        thing.set("Image", 284);
        Lib.add(thing);
        thing = Lib.extend("chaos rat", "rat");
        thing.set("LevelMin", 8);
        thing.set("Image", 295);
        thing.set("IsGenerator", 1);
        thing.set("IsChaotic", 1);
        thing.addHandler("OnAction", Scripts.generator("chaos rat", 30));
        thing.set("UnarmedWeapon", Lib.create("poison attack"));
        Monster.stats(thing, 10, 8, 16, 8, 5, 8, 2, 7);
        Lib.add(thing);
    }

    static void initDogs() {
        Thing thing = Lib.extend("dog", "base critter");
        thing.set("Image", 287);
        thing.set("LevelMin", 3);
        thing.set("MoveSpeed", 130);
        thing.set("Swimming", 1);
        thing.set("Unarmed Combat", 1);
        Monster.stats(thing, 7, 6, 5, 5, 1, 3, 1, 1);
        thing.set("ASCII", "d");
        Lib.add(thing);
        thing = Lib.extend("big dog", "base critter");
        thing.set("Image", 287);
        thing.set("LevelMin", 6);
        thing.set("MoveSpeed", 120);
        Monster.stats(thing, 7, 9, 4, 9, 2, 5, 2, 2);
        Lib.add(thing);
        thing = Lib.extend("hound", "base critter");
        thing.set("Image", 287);
        thing.set("LevelMin", 9);
        thing.set("MoveSpeed", 150);
        thing.set("AttackSpeed", 150);
        Monster.stats(thing, 17, 12, 14, 19, 2, 5, 2, 2);
        Lib.add(thing);
    }

    static void initFrogs() {
        Thing thing = Lib.extend("base frog", "base critter");
        thing.set("IsFrog", 1);
        thing.set("IsBeast", 1);
        thing.set("Image", 521);
        thing.set("Swimming", 3);
        thing.multiplyStat("Frequency", 0.3);
        thing.set("MoveSpeed", 100);
        Monster.stats(thing, 3, 4, 7, 4, 4, 7, 1, 1);
        thing.set("LevelMin", 2);
        thing.set("RES:fire", -15);
        thing.set("RES:poison", 20);
        thing.set("RES:acid", 100);
        thing.set("UnarmedWeapon", Lib.create("acid attack"));
        thing.set("ASCII", "f");
        thing.set("DeathDecoration", "blood pool,30% frog leg");
        Lib.add(thing);
        thing = Lib.extend("giant frog", "base frog");
        thing.set("Image", 521);
        Monster.stats(thing, 10, 6, 16, 9, 4, 25, 2, 2);
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("giant toad", "base frog");
        thing.set("Image", 520);
        Monster.stats(thing, 26, 18, 24, 29, 4, 45, 2, 2);
        thing.set("ARM", 10);
        thing.set("Defence", 1);
        thing.set("LevelMin", 16);
        thing.set("DeathDecoration", "blood pool,30% toad leg");
        Lib.add(thing);
        thing = Lib.extend("horntoad", "giant toad");
        thing.set("Image", 522);
        Monster.stats(thing, 46, 35, 50, 69, 34, 85, 6, 27);
        thing.set("Attack", 1);
        thing.set("Defence", 2);
        thing.set("ARM", 25);
        thing.set("LevelMin", 19);
        Lib.add(thing);
    }

    static void initSlimes() {
        Thing thing = Lib.extend("base slime", "base monster");
        thing.set("IsIntelligent", 0);
        thing.set("IsLiving", 0);
        thing.set("IsSlime", 1);
        thing.set("Image", 380);
        Lib.add(thing);
        thing = Lib.extend("yellow slime", "base slime");
        Monster.stats(thing, 10, 10, 10, 10, 1, 5, 0, 0);
        thing.set("LevelMin", 4);
        thing.set("Image", 383);
        Lib.add(thing);
        thing = Lib.extend("grey slime", "base slime");
        Monster.stats(thing, 15, 15, 10, 30, 1, 15, 0, 0);
        thing.set("LevelMin", 7);
        thing.set("Image", 381);
        ItemDamageHit itemDamageHit = new ItemDamageHit("wielded", "acid", 50, 10);
        thing.set("OnHit", itemDamageHit);
        Lib.add(thing);
        thing = Lib.extend("purple slime", "base slime");
        Monster.stats(thing, 10, 10, 10, 20, 1, 10, 0, 0);
        thing.set("LevelMin", 8);
        thing.set("Image", 380);
        thing.set("OnTouch", Scripts.damage("acid", 2, "hit by the noxious acid of the purple slime", 25));
        Lib.add(thing);
        thing = Lib.extend("red slime", "base slime");
        Monster.stats(thing, 20, 20, 20, 40, 1, 25, 0, 0);
        thing.set("LevelMin", 9);
        thing.set("Image", 382);
        itemDamageHit = new ItemDamageHit("wielded", "fire", 40, 5);
        thing.set("OnHit", itemDamageHit);
        thing.set("UnarmedWeapon", Lib.create("curse attack"));
        thing.set("DeathDecoration", "Fireball");
        Lib.add(thing);
    }

    private static void initNamedFoes() {
        Thing thing = Lib.extend("Borrok", "goblin shaman");
        Monster.strengthen(thing, 1.3);
        Lib.add(thing);
    }

    public static class SpecialHit
    extends Script {
        private static final long serialVersionUID = 3762814904666633524L;

        public SpecialHit(String string, int n) {
            this.set("SpecialHitChance", n);
            this.set("SpecialHitType", string);
        }

        public boolean stealSomething(Thing thing, Thing thing2, String string) {
            Thing[] thingArray = null;
            thingArray = string == null ? thing.getItems() : thing.getFlaggedContents(string);
            if (thingArray.length == 0) {
                return false;
            }
            Thing thing3 = thingArray[RPG.r(thingArray.length)];
            if (thing3.y > 0) {
                return false;
            }
            if (thing3.getFlag("IsTheftProof")) {
                return false;
            }
            thing.message(thing2.getTheName() + " steals your " + thing3.getName(Game.hero()) + "!");
            thing2.addThingWithStacking(thing3);
            Being.utiliseItems(thing2);
            return true;
        }

        public boolean stealSomething(Thing thing, Thing thing2, String string, int n) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (!this.stealSomething(thing, thing2, string)) continue;
                bl = true;
            }
            return bl;
        }

        public boolean handle(Thing thing, Event event) {
            int n = this.getStat("SpecialHitChance");
            if (RPG.d(100) > n) {
                return false;
            }
            String string = this.getString("SpecialHitType");
            Thing thing2 = event.getThing("Target");
            if (!RPG.test(thing.getStat("SK"), thing2.getStat("SK"), thing, thing2)) {
                return false;
            }
            if (string.equals("steal")) {
                return this.stealSomething(thing2, thing, null);
            }
            if (string.equals("StealMoney")) {
                return this.stealSomething(thing2, thing, "IsMoney");
            }
            if (string.equals(Monster.TAKE_THE_MONEY_AND_RUN)) {
                if (this.stealSomething(thing2, thing, "IsMoney")) {
                    String string2 = thing.getTheName() + " vanishes in a puff of smoke!";
                    if (this.teleportAway(thing)) {
                        thing2.message(string2);
                        return true;
                    }
                }
            } else if (string.equals(Monster.TAKE_THE_MAGIC_AND_RUN) && this.stealSomething(thing2, thing, "IsMagicItem", 3)) {
                String string3 = thing.getTheName() + " vanishes in a cloud of perfume!";
                if (this.teleportAway(thing)) {
                    Game.message(string3);
                    return true;
                }
            }
            return false;
        }

        public boolean teleportAway(Thing thing) {
            Map map = thing.getMap();
            if (map == null) {
                return false;
            }
            Point point = map.findFreeSquare();
            if (point == null) {
                return false;
            }
            Movement.teleport(thing, map, point.x, point.y);
            return true;
        }
    }

    public static class ItemDamageHit
    extends Script {
        private static final long serialVersionUID = 3761124920951715636L;

        public ItemDamageHit(String string, String string2, int n, int n2) {
            this.set("SpecialHitTarget", string);
            this.set("SpecialHitChance", n);
            this.set("SpecialHitDamageType", string2);
            this.set("SpecialHitPower", n2);
        }

        public boolean handle(Thing thing, Event event) {
            Thing[] thingArray;
            int n = this.getStat("SpecialHitChance");
            if (RPG.d(100) > n) {
                return false;
            }
            String string = this.getString("SpecialHitTarget");
            Thing thing2 = event.getThing("Target");
            Thing thing3 = null;
            if (string.equals("item")) {
                Thing[] thingArray2 = thing2.getItems();
                if (thingArray2.length > 0) {
                    thing3 = thingArray2[RPG.r(thingArray2.length)];
                }
            } else if (string.equals("wielded")) {
                Thing[] thingArray3 = thing2.getWieldedItems();
                if (thingArray3.length > 0) {
                    thing3 = thingArray3[RPG.r(thingArray3.length)];
                }
            } else if (string.startsWith("[") && (thingArray = thing2.getFlaggedContents(string.substring(1, string.length() - 2))).length > 0) {
                thing3 = thingArray[RPG.r(thingArray.length)];
            }
            if (thing3 != null) {
                Damage.inflict(thing3, this.getStat("SpecialHitPower"), this.getString("SpecialHitDamageType"));
                return true;
            }
            return false;
        }
    }

    public static class BreathAttackScript
    extends Script {
        private static final long serialVersionUID = 3257006536114256182L;

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            int n2 = this.getStat("Rate");
            if (RPG.test(n2, n)) {
                Thing thing2 = AI.findFoe(thing);
                if (thing2 == null) {
                    return false;
                }
                String string = this.getString("BreathType");
                String string2 = this.getString("BreathDescription");
                Game.instance().doBreath(thing.x, thing.y, thing2.x, thing2.y, this.getStat("BoltImage"), 10.0);
                thing.visibleMessage(thing.getTheName() + " " + thing.verb("breathe") + " " + string2 + " at " + thing2.getTheName());
                thing2.damage(this.getStat("Power"), string);
            }
            return false;
        }
    }
}

