/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import mikera.tyrant.Game;
import mikera.tyrant.QuestApp;
import mikera.tyrant.Screen;

public class ListScreen
extends Screen {
    private static final long serialVersionUID = 3257003267744478006L;
    String title = "List";
    String[] strings = null;
    static int page = 0;
    Object result;
    private static int pagesize = 26;
    private static int lineheight = 20;
    public String bottomString = "ESC = Cancel";

    public Object getObject() {
        boolean bl = false;
        while (!bl) {
            int n;
            KeyEvent keyEvent = Game.getInput();
            if (keyEvent == null) continue;
            if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) {
                return null;
            }
            int n2 = Character.toLowerCase(keyEvent.getKeyChar());
            if (keyEvent.getKeyCode() == 38) {
                n2 = 45;
            }
            if (keyEvent.getKeyCode() == 40) {
                n2 = 43;
            }
            if ((n2 == 112 || n2 == 45) && page > 0) {
                --page;
                this.repaint();
            }
            if ((n2 == 110 || n2 == 43 || n2 == 32) && (page + 1) * pagesize < this.strings.length) {
                ++page;
                this.repaint();
            }
            if ((n = n2 - 97) < 0 || n >= pagesize || (n += page * pagesize) < 0 || n >= this.strings.length) continue;
            return this.strings[n];
        }
        return null;
    }

    public void activate() {
    }

    private static String[] getStringArray(Collection collection) {
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public ListScreen(String string, Collection collection) {
        this(string, ListScreen.getStringArray(collection));
    }

    public ListScreen(String string, String[] stringArray) {
        super(Game.getQuestapp());
        this.setLayout(new GridLayout(15, 1));
        this.setFont(QuestApp.mainfont);
        this.addKeyListener(this.questapp.keyadapter);
        this.strings = stringArray;
        if (this.strings == null) {
            this.strings = new String[0];
        }
        this.title = string;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (page * pagesize > this.strings.length) {
            page = 0;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        graphics.drawString(this.title, 20, 1 * lineheight);
        for (int i = 0; i < Math.min(this.strings.length - page * pagesize, pagesize); ++i) {
            String string = this.strings[i + page * pagesize];
            String string2 = "[" + (char)(97 + i) + "] " + string;
            graphics.drawString(string2, 50, lineheight * (i + 2));
        }
        String string = this.bottomString + " ";
        if (page > 0) {
            string = string + " Up = Previous ";
        }
        if ((page + 1) * pagesize < this.strings.length) {
            string = string + " Down = Next ";
        }
        graphics.drawString(string, 20, dimension.height - 20);
    }
}

