/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import java.util.HashMap;
import mikera.tyrant.AI;
import mikera.tyrant.Being;
import mikera.tyrant.Game;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;

public class LevelMap
implements Serializable {
    private static final long serialVersionUID = 3545517309273125684L;
    private int[] pixels = null;
    private int[] currentMemory = null;
    private Map lastMap = null;
    private HashMap mapMemory = new HashMap();

    public static LevelMap instance() {
        LevelMap levelMap = (LevelMap)Game.instance().get("MapMemory");
        if (levelMap == null) {
            levelMap = new LevelMap();
            Game.instance().set("MapMemory", levelMap);
        }
        return levelMap;
    }

    private HashMap getMapMemory() {
        return this.mapMemory;
    }

    private int[] getMapMemory(Map map) {
        HashMap hashMap = this.getMapMemory();
        int[] nArray = (int[])hashMap.get(map);
        if (nArray == null && map == this.lastMap) {
            nArray = this.currentMemory;
        }
        if (nArray == null) {
            nArray = new int[map.width * map.height];
            if (!map.getFlag("ForgetMap")) {
                hashMap.put(map, nArray);
            }
        }
        this.currentMemory = nArray;
        this.lastMap = map;
        return nArray;
    }

    public static void reveal(Map map) {
        int n = map.width;
        int n2 = map.height;
        int[] nArray = LevelMap.instance().getMapMemory(map);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                LevelMap.setMapColor(map, nArray, j, i);
            }
        }
    }

    public static void forget(Map map, int n) {
        if (map == null) {
            return;
        }
        int[] nArray = LevelMap.instance().getMapMemory(map);
        for (int i = 0; i < nArray.length; ++i) {
            if (RPG.r(100) >= n) continue;
            nArray[i] = 0;
        }
    }

    public int[] getMapView(Map map) {
        int n;
        int n2;
        int n3 = map.width;
        int n4 = map.height;
        int[] nArray = this.getMapMemory(map);
        Thing thing = Game.hero();
        int n5 = Being.calcViewRange(thing);
        for (n2 = RPG.max(0, thing.y - n5); n2 < RPG.min(thing.y + n5 + 1, n4); ++n2) {
            for (n = RPG.max(0, thing.x - n5); n < RPG.min(thing.x + n5 + 1, n3); ++n) {
                if (!map.isVisibleChecked(n + n2 * n3)) continue;
                LevelMap.setMapColor(map, nArray, n, n2);
            }
        }
        if (this.pixels == null || this.pixels.length != nArray.length) {
            this.pixels = new int[nArray.length];
        }
        System.arraycopy(nArray, 0, this.pixels, 0, nArray.length);
        for (n2 = RPG.max(0, thing.y - n5); n2 < RPG.min(thing.y + n5 + 1, n4); ++n2) {
            for (n = RPG.max(0, thing.x - n5); n < RPG.min(thing.x + n5 + 1, n3); ++n) {
                LevelMap.updateMapColor(map, this.pixels, n, n2);
            }
        }
        return this.pixels;
    }

    private static void updateMapColor(Map map, int[] nArray, int n, int n2) {
        int n3 = n + map.width * n2;
        if (map.isVisibleChecked(n3)) {
            int n4 = nArray[n3];
            n4 += 0x101010;
            Thing thing = map.getObjectsChecked(n3);
            while (thing != null) {
                if (thing.getFlag("IsMobile")) {
                    if (thing.isHero()) {
                        int n5;
                        nArray[n3] = n5 = 0xFF8000;
                        return;
                    }
                    n4 = AI.isHostile(Game.hero(), thing) ? 0xD00000 : 53280;
                }
                thing = thing.next;
            }
            nArray[n3] = n4;
        }
    }

    private static void setMapColor(Map map, int[] nArray, int n, int n2) {
        int n3 = map.getTile(n, n2);
        int n4 = Tile.getMapColour(n3);
        Thing thing = map.getObjects(n, n2);
        while (thing != null) {
            int n5 = thing.getStat("MapColour");
            if (n5 > 0) {
                n4 = n5;
            }
            thing = thing.next;
        }
        nArray[n + map.width * n2] = n4;
    }
}

