/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import mikera.tyrant.Being;
import mikera.tyrant.Coin;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Gods;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Quest;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Score;
import mikera.tyrant.Script;
import mikera.tyrant.Secret;
import mikera.tyrant.Spell;
import mikera.tyrant.SpellBook;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;
import mikera.tyrant.Wish;

public class Hero {
    private static final int baseLevelCost = 40;
    private static final double experienceDecay = 0.98;
    private static final double experienceLevelCost = Math.sqrt(2.0);
    private static final double experienceLevelMultiplier = experienceLevelCost * 0.97;
    private static String[] hungerDecayStats = new String[]{"SK", "ST", "AG", "TG", "IN", "WP", "CH", "CR"};
    private static final String[] races = new String[]{"human", "hobbit", "dwarf", "high elf", "wood elf", "dark elf", "gnome", "half orc", "half troll", "hawken", "argonian", "pensadorian"};
    private static String[] months = new String[]{null, "Windalmar", "Ferrentir", "Antalyir", "Foolsdawn", "Whispertide", "Evermoor", "Brightsun", "Kingsmoon", "Harvestmoon", "Eberfest", "Witherfrost", "Hogmandark"};

    public static Thing createBaseHero(String string) {
        Thing thing = Lib.extend("you", string);
        thing.set("IsHero", 1);
        thing.set("Gods", Lib.instance().getObject("Gods"));
        thing.set("IsGiftReceiver", 0);
        thing.set("Image", 7);
        thing.set("Z", 45);
        thing.set("RechargeRate", 60);
        thing.set("RegenerationRate", 20);
        thing.set("HungerThreshold", 300000);
        thing.set("NameType", 1);
        thing.set("OnAction", new HeroAction());
        thing.set("Seed", RPG.r(1000000000));
        thing.set("ASCII", "@");
        thing.set("IsDisplaceable", 0);
        thing.incStat("FatePoints", 1);
        thing.set("Level", 1);
        thing.incStat("SkillPoints", 1);
        Map map = new Map(1, 1);
        map.addThing(thing, 0, 0);
        return thing;
    }

    public static void addDebugModifications(Thing thing) {
        thing.set("IsImmortal", 1);
        thing.set("IsDebugMode", 1);
        if ("QuickTester".equals(thing.getString("HeroName"))) {
            thing.addThing(Spell.create("Annihilation"));
            thing.addThing(Spell.create("Blaze"));
            thing.addThing(Spell.create("Ultimate Destruction"));
            Wish.makeWish("skills", 100);
        }
    }

    public static void setHeroName(Thing thing, String string) {
        thing.set("HeroName", string);
    }

    public static Thing createHero(String string, String string2, String string3) {
        Thing thing = Hero.createBaseHero(string2);
        Game.instance().initialize(thing);
        if (string == null || string.equals("")) {
            string = "Tester";
        }
        Hero.setHeroName(thing, string);
        if (Game.isDebug()) {
            Hero.addDebugModifications(thing);
        }
        Hero.applyRace(thing, string2);
        Hero.applyProfession(thing, string3);
        Hero.applyBonusItems(thing);
        thing.set("HPSMAX", thing.getBaseStat("TG") + RPG.d(6));
        thing.set("MPSMAX", thing.getBaseStat("WP") + RPG.d(6));
        thing.set("HPS", thing.getStat("HPSMAX"));
        thing.set("MPS", thing.getStat("MPSMAX"));
        Being.utiliseItems(thing);
        Wish.makeWish("id", 100);
        thing.set("Score", 0);
        ArrayList arrayList = Gods.getPossibleGods(thing);
        int n = arrayList.size();
        if (n > 0) {
            thing.set("Religion", arrayList.get(RPG.r(n)));
        } else {
            Game.warn("No religion available for " + string2 + " " + string3);
        }
        Hero.createHeroHistory(thing);
        thing.flattenProperties();
        return thing;
    }

    public static void improveSlightly(Thing thing) {
        thing.incStat("MoveSpeed", 100);
        thing.incStat("AttackSpeed", 100);
        thing.incStat("ARM", 10);
        thing.incStat("RegenerationRate", 50);
        thing.incStat("RechargeRate", 50);
    }

    public static int getHunger(Thing thing) {
        int n = thing.getStat("Hunger");
        return n >= thing.getStat("HungerThreshold") ? 1 : 0;
    }

    public static void addQuest(Quest quest) {
        Quest.getQuests().add(quest);
    }

    public static Map worldMap() {
        return (Map)Game.hero().get("WorldMap");
    }

    private static void applyBonusItems(Thing thing) {
        Object object;
        if (thing.getFlag("Prayer")) {
            object = Lib.create("potion of holy water");
            object.set("Number", thing.getStat("Prayer"));
            thing.addThingWithStacking((Thing)object);
        }
        if (thing.getFlag("Trading")) {
            object = Lib.create("sovereign");
            object.set("Number", thing.getStat("Trading"));
            thing.addThingWithStacking((Thing)object);
        }
        if (thing.getFlag("Weapon Lore")) {
            object = Lib.createType("IsWeapon", RPG.d(2, 6));
            thing.addThingWithStacking((Thing)object);
        }
        if (thing.getFlag("Cooking")) {
            object = Lib.createType("IsFood", 25);
            object.set("Number", thing.getStat("Cooking"));
            thing.addThingWithStacking((Thing)object);
        }
        if (thing.getFlag("Archery")) {
            object = Lib.createType("IsRangedWeapon", RPG.d(thing.getStat("Archery"), 6));
            Thing thing2 = RangedWeapon.createAmmo((Thing)object, RPG.d(thing.getStat("Archery"), 6));
            thing.addThing((Thing)object);
            thing.addThing(thing2);
        }
        if (((Thing[])(object = thing.getFlaggedContents("IsWeapon"))).length == 0) {
            thing.addThing(Lib.createType("IsWeapon", 1));
        }
    }

    private static void applyProfession(Thing thing, String string) {
        thing.set("Profession", string);
        if (string.equals("fighter")) {
            thing.set("Image", 7);
            thing.incStat("SK", RPG.r(5));
            thing.incStat("ST", RPG.r(5));
            thing.incStat("AG", RPG.r(4));
            thing.incStat("TG", RPG.r(6));
            thing.incStat("IN", RPG.r(0));
            thing.incStat("WP", RPG.r(0));
            thing.incStat("CH", RPG.r(0));
            thing.incStat("CR", RPG.r(0));
            thing.incStat("Attack", 1);
            thing.incStat("Defence", 1);
            thing.incStat("Unarmed Combat", RPG.d(2));
            thing.incStat("Weapon Lore", RPG.d(2));
        } else if (string.equals("wizard")) {
            thing.set("Image", 6);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(0) - 1);
            thing.incStat("IN", RPG.r(7));
            thing.incStat("WP", RPG.r(5));
            thing.incStat("CH", RPG.r(2));
            thing.incStat("CR", RPG.r(4));
            thing.incStat("Item Lore", RPG.r(2));
            thing.incStat("Literacy", RPG.d(3));
            thing.incStat("True Magic", RPG.d(2));
            thing.incStat("Spellcasting", RPG.d(2));
            thing.incStat("Focus", RPG.d(2));
            thing.addThing(Spell.randomOffensiveSpell("True Magic", 3));
            thing.incStat("Luck", -5);
            thing.addThing(SpellBook.create("True Magic", RPG.d(6)));
            thing.addThing(Lib.create("[IsScroll]"));
        } else if (string.equals("shaman")) {
            int n;
            thing.set("Image", 6);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(4));
            thing.incStat("WP", RPG.r(4));
            thing.incStat("CH", RPG.r(5));
            thing.incStat("CR", RPG.r(6));
            thing.incStat("Item Lore", RPG.r(2));
            thing.incStat("Literacy", RPG.r(2));
            thing.incStat("Black Magic", RPG.d(3));
            thing.incStat("Spellcasting", RPG.d(2));
            thing.incStat("Herb Lore", RPG.d(2));
            thing.addThing(Spell.randomSpell("Black Magic", 3));
            thing.incStat("Luck", 15);
            for (n = 0; n < 10; ++n) {
                thing.addThingWithStacking(Lib.createType("IsHerb", RPG.d(10)));
            }
            for (n = 0; n < 6; ++n) {
                thing.addThingWithStacking(Lib.createType("IsMonsterPart", RPG.d(10)));
            }
        } else if (string.equals("witch")) {
            thing.set("Image", 32);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(5));
            thing.incStat("WP", RPG.r(4));
            thing.incStat("CH", RPG.r(4));
            thing.incStat("CR", RPG.r(6));
            thing.incStat("Literacy", 1);
            thing.incStat("Black Magic", 1);
            thing.incStat("Spellcasting", 1);
            thing.incStat("Herb Lore", RPG.r(3));
            thing.incStat("Cooking", RPG.r(3));
            for (int i = 0; i < 10; ++i) {
                thing.addThingWithStacking(Lib.createType("IsHerb", RPG.d(10)));
            }
            thing.addThing(Spell.randomSpell("Black Magic", 3));
            thing.incStat("Luck", 10);
            thing.addThing(Lib.create("[IsScroll]"));
            thing.addThing(SpellBook.create("Black Magic", RPG.d(8)));
        } else if (string.equals("war-mage")) {
            thing.set("Image", 6);
            thing.incStat("SK", RPG.r(2));
            thing.incStat("ST", RPG.r(2));
            thing.incStat("AG", RPG.r(2));
            thing.incStat("TG", RPG.r(2));
            thing.incStat("IN", RPG.r(2));
            thing.incStat("WP", RPG.r(4));
            thing.incStat("CH", RPG.r(2));
            thing.incStat("CR", RPG.r(4));
            thing.incStat("Literacy", 1);
            thing.incStat("True Magic", RPG.r(3));
            thing.incStat("Healing", RPG.d(2));
            thing.incStat("Spellcasting", RPG.d(2));
            thing.addThing(Spell.randomSpell("True Magic", 3));
            thing.incStat("Luck", 0);
        } else if (string.equals("runecaster")) {
            Thing thing2;
            int n;
            thing.set("Image", 6);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(6));
            thing.incStat("WP", RPG.r(5));
            thing.incStat("CH", RPG.r(4));
            thing.incStat("CR", RPG.r(8));
            thing.incStat("Alchemy", RPG.r(3));
            thing.incStat("Herb Lore", RPG.r(2));
            thing.incStat("Item Lore", RPG.d(2));
            thing.incStat("Literacy", RPG.d(4));
            thing.incStat("Rune Lore", RPG.d(2));
            thing.incStat("Luck", -10);
            Thing thing3 = Lib.create("scroll of Teleport Self");
            Item.identify(thing3);
            thing.addThing(thing3);
            thing3 = Lib.createType("IsWeaponRunestone", RPG.d(17));
            Item.identify(thing3);
            thing.addThing(thing3);
            for (n = RPG.d(6); n > 0; --n) {
                thing2 = Lib.createType("IsRunestone", RPG.d(10));
                Item.identify(thing2);
                thing.addThing(thing2);
            }
            for (n = RPG.r(3); n > 0; --n) {
                thing2 = Lib.createType("IsRuneRecipeScroll", RPG.d(10));
                Item.identify(thing2);
                thing.addThing(thing2);
            }
        } else if (string.equals("priest")) {
            thing.set("Image", 11);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(3));
            thing.incStat("IN", RPG.r(4));
            thing.incStat("WP", RPG.r(8));
            thing.incStat("CH", RPG.r(5));
            thing.incStat("CR", RPG.r(0));
            thing.incStat("Prayer", RPG.d(2));
            thing.incStat("Literacy", RPG.d(2));
            thing.incStat("Holy Magic", RPG.d(2));
            thing.incStat("Healing", RPG.r(3));
            thing.incStat("Meditation", RPG.r(2));
            thing.incStat("Focus", RPG.r(2));
            thing.incStat("Luck", 5);
            thing.addThing(Spell.randomSpell("Holy Magic", 5));
            Thing thing4 = Lib.create("potion of healing");
            Item.identify(thing4);
            thing.addThing(thing4);
        } else if (string.equals("healer")) {
            thing.set("Image", 11);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(3));
            thing.incStat("IN", RPG.r(4));
            thing.incStat("WP", RPG.r(4));
            thing.incStat("CH", RPG.r(5));
            thing.incStat("CR", RPG.r(4));
            thing.incStat("Item Lore", RPG.d(2));
            thing.incStat("Literacy", RPG.d(2));
            thing.incStat("Healing", RPG.d(3));
            thing.incStat("Herb Lore", RPG.d(2));
            thing.incStat("Meditation", RPG.r(2));
            thing.incStat("Focus", RPG.r(2));
            thing.incStat("Luck", 15);
            Thing thing5 = Lib.create("potion of healing");
            Item.identify(thing5);
            thing.addThing(thing5);
            thing.addThing(Lib.create("potion of healing"));
            thing.addThing(Lib.create("potion of healing"));
            thing.addThing(Lib.createType("IsHerb", RPG.d(10)));
            thing.addThing(Lib.createType("IsHerb", RPG.d(10)));
            thing.addThing(Lib.createType("IsHerb", RPG.d(10)));
            thing.addThing(Lib.createType("IsHerb", RPG.d(10)));
            thing.addThing(Lib.createType("IsHerb", RPG.d(10)));
        } else if (string.equals("bard")) {
            thing.set("Image", 7);
            thing.incStat("SK", RPG.r(3));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(3));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(3));
            thing.incStat("WP", RPG.r(3));
            thing.incStat("CH", RPG.r(6));
            thing.incStat("CR", RPG.r(6));
            thing.incStat("Music", RPG.po(0.5));
            thing.incStat("Perception", 1);
            thing.incStat("Sleight Of Hand", RPG.po(0.5));
            thing.incStat("Storytelling", RPG.po(0.5));
            thing.incStat("Seduction", RPG.po(1.2));
            thing.incStat("Literacy", RPG.po(0.8));
            thing.incStat("Luck", 20);
            Thing thing6 = Lib.createType("IsRing", 5);
            Item.identify(thing6);
            thing.addThing(thing6);
        } else if (string.equals("paladin")) {
            thing.set("Image", 7);
            thing.incStat("SK", RPG.r(4));
            thing.incStat("ST", RPG.r(4));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(4));
            thing.incStat("IN", RPG.r(4));
            thing.incStat("WP", RPG.r(4));
            thing.incStat("CH", RPG.r(0));
            thing.incStat("CR", RPG.r(0));
            thing.incStat("Prayer", RPG.d(2));
            thing.incStat("Attack", RPG.r(2));
            thing.incStat("Defence", RPG.r(2));
            thing.incStat("Bravery", RPG.d(3));
            thing.addThing(Weapon.createWeapon(RPG.d(4)));
            Thing thing7 = Lib.createType("IsWand", RPG.d(4));
            Item.identify(thing7);
            thing.addThing(thing7);
        } else if (string.equals("barbarian")) {
            thing.set("Image", 3);
            thing.incStat("SK", RPG.r(3));
            thing.incStat("ST", RPG.r(3));
            thing.incStat("AG", RPG.r(5));
            thing.incStat("TG", RPG.r(5));
            thing.incStat("IN", RPG.r(0));
            thing.incStat("WP", RPG.r(0));
            thing.incStat("CH", RPG.r(0));
            thing.incStat("CR", RPG.r(0));
            thing.incStat("AttackSpeed", 10);
            thing.incStat("Attack", RPG.r(2));
            thing.incStat("Ferocity", 1);
            thing.incStat("Athletics", 1);
            thing.incStat("Alertness", RPG.r(3));
            thing.incStat("Survival", RPG.d(2));
            thing.incStat("Pickpocket", RPG.r(2));
            thing.incStat("Unarmed Combat", 1);
            thing.incStat("Tracking", RPG.r(2));
            Thing thing8 = Lib.create("potion of speed");
            Item.identify(thing8);
            thing.addThing(thing8);
        } else if (string.equals("thief")) {
            thing.set("Image", 10);
            thing.incStat("SK", RPG.r(5));
            thing.incStat("ST", RPG.r(0));
            thing.incStat("AG", RPG.r(6));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(0));
            thing.incStat("WP", RPG.r(0));
            thing.incStat("CH", RPG.r(4));
            thing.incStat("CR", RPG.r(3));
            thing.incStat("AttackSpeed", 120);
            thing.incStat("Alertness", RPG.d(3));
            thing.incStat("Pickpocket", RPG.r(3));
            thing.incStat("Lockpicking", RPG.r(3));
            thing.incStat("Disarm Traps", RPG.r(2));
            Thing thing9 = Lib.create("wand of Teleport Self");
            Item.identify(thing9);
            thing.addThing(thing9);
        } else if (string.equals("ranger")) {
            thing.set("Image", 10);
            thing.incStat("SK", RPG.r(8));
            thing.incStat("ST", RPG.r(3));
            thing.incStat("AG", RPG.r(6));
            thing.incStat("TG", RPG.r(0));
            thing.incStat("IN", RPG.r(0));
            thing.incStat("WP", RPG.r(0));
            thing.incStat("CH", RPG.r(4));
            thing.incStat("CR", RPG.r(0));
            thing.incStat("Archery", RPG.r(3));
            thing.incStat("Throwing", RPG.r(3));
            thing.incStat("Survival", RPG.d(1));
            thing.incStat("Swimming", RPG.r(2));
            thing.incStat("Riding", RPG.r(2));
            thing.incStat("Tracking", RPG.d(3));
            Thing thing10 = Lib.create("healing potion");
            thing.addThing(thing10);
        } else if (string.equals("farmer")) {
            thing.set("Image", 10);
            thing.incStat("SK", RPG.r(0));
            thing.incStat("ST", RPG.r(4));
            thing.incStat("AG", RPG.r(0));
            thing.incStat("TG", RPG.r(4));
            thing.incStat("IN", RPG.r(0));
            thing.incStat("WP", RPG.r(6));
            thing.incStat("CH", RPG.r(4));
            thing.incStat("CR", RPG.r(6));
            thing.incStat("Throwing", RPG.r(3));
            thing.incStat("Survival", RPG.r(3));
            thing.incStat("Swimming", RPG.r(2));
            thing.incStat("Cooking", RPG.r(3));
            thing.incStat("Herb Lore", RPG.d(2));
            Thing thing11 = Lib.create("potion of healing");
            Item.identify(thing11);
            thing.addThing(thing11);
        } else {
            throw new Error("Profession [" + string + "] not recognised");
        }
    }

    private static void applyRace(Thing thing, String string) {
        if (string.equals("human")) {
            Coin.addMoney(thing, 10 * RPG.d(4, 10));
            thing.addThing(Lib.create("[IsDagger]"));
            thing.addThing(Lib.create("[IsFood]"));
        } else if (string.equals("dwarf")) {
            Coin.addMoney(thing, 10 * RPG.d(5, 10));
            thing.addThing(Lib.create("iron hand axe"));
            thing.addThing(Lib.create("loaf of dwarf bread"));
        } else if (string.equals("hobbit")) {
            Coin.addMoney(thing, RPG.d(6, 10));
            thing.addThing(Lib.create("stone knife"));
            thing.addThing(Lib.create("[IsFood]"));
            thing.addThing(Lib.create("[IsFood]"));
            thing.addThing(Lib.create("[IsFood]"));
            thing.addThing(Lib.create("[IsEquipment]"));
            thing.addThing(Lib.create("sling"));
            thing.addThing(Lib.create("10 pebble"));
        } else if (string.equals("high elf")) {
            Coin.addMoney(thing, 10 * RPG.d(6, 10));
            thing.addThing(Lib.create("ornate mithril ring"));
            thing.addThing(Lib.create("elven steel dagger"));
        } else if (string.equals("wood elf")) {
            thing.addThing(Lib.create("short bow"));
            thing.addThing(Lib.create("lesser elven arrow"));
        } else if (string.equals("dark elf")) {
            thing.addThing(Lib.create("iron dagger"));
            thing.addThing(Lib.create("[IsPotion]"));
        } else if (string.equals("gnome")) {
            Thing thing2 = Lib.createType("IsMagicItem", 5);
            Item.identify(thing2);
            thing.addThing(thing2);
            Coin.addMoney(thing, 100 * RPG.d(10, 10));
        } else if (string.equals("half orc")) {
            thing.addThing(Lib.createType("IsWeapon", RPG.d(3)));
            thing.addThing(Lib.create("[IsMeat]"));
            Coin.addMoney(thing, RPG.d(4, 10));
        } else if (string.equals("half troll")) {
            thing.incStat("SkillPoints", -1);
            thing.addThing(Lib.createType("IsClub", RPG.d(6)));
            thing.addThing(Lib.create("[IsMeat]"));
            thing.addThing(Lib.create("[IsMeat]"));
            thing.addThing(Lib.create("meat ration"));
        } else if (string.equals("argonian")) {
            thing.addThing(Lib.create("[IsTrident]"));
            thing.addThing(Lib.create("[IsMeat]"));
            thing.addThing(Lib.create("[IsFish]"));
        } else if (string.equals("hawken")) {
            thing.addThing(Lib.create("[IsDagger]"));
            thing.addThing(Lib.create("[IsMeat]"));
            Coin.addMoney(thing, RPG.d(4, 10));
        } else if (string.equals("pensadorian")) {
            thing.addThing(Lib.create("[IsDagger]"));
            thing.addThing(Lib.create("[IsFruit]"));
            Coin.addMoney(thing, RPG.d(4, 10));
        } else {
            throw new Error("Race [" + string + "] not recognised");
        }
    }

    public static void gainExperience(int n) {
        Thing thing = Game.hero();
        int n2 = thing.getBaseStat("Experience") + n;
        int n3 = thing.getBaseStat("Level");
        int n4 = Hero.calcXPRequirement(n3 + 1);
        while (n2 >= n4) {
            if (n3 < 50) {
                Being.gainLevel(thing);
                n2 -= n4;
                n4 = Hero.calcXPRequirement(++n3 + 1);
                continue;
            }
            n2 = n4 - 1;
        }
        thing.set("Experience", n2);
    }

    public static int calcXPRequirement(int n) {
        double d = 40.0;
        return (int)(d *= Math.pow(experienceLevelCost, n - 2));
    }

    public static String reportKillData() {
        HashMap hashMap = Hero.getKillHashMap();
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You have killed the following creatures:\n");
        stringBuffer.append("\n");
        boolean bl = true;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (bl && !Character.isUpperCase(string.charAt(0))) {
                bl = false;
                stringBuffer.append("\n");
            }
            Integer n = (Integer)hashMap.get(string);
            String string2 = Text.centrePad(string, n.toString(), 60);
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer.toString();
    }

    public static int getKillCount(Thing thing) {
        HashMap hashMap = Hero.getKillHashMap();
        Integer n = (Integer)hashMap.get(thing.name());
        if (n == null) {
            return 0;
        }
        return n;
    }

    private static HashMap getKillHashMap() {
        Thing thing = Game.hero();
        HashMap hashMap = (HashMap)thing.get("Kills");
        if (hashMap == null) {
            hashMap = new HashMap();
            thing.set("Kills", hashMap);
        }
        return hashMap;
    }

    public static int incKillCount(Thing thing) {
        String string;
        HashMap hashMap = Hero.getKillHashMap();
        Integer n = (Integer)hashMap.get(string = thing.name());
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n + 1;
        hashMap.put(string, new Integer(n2));
        return n2;
    }

    public static int gainKillExperience(Thing thing, Thing thing2) {
        int n = thing.getLevel();
        int n2 = thing2.getLevel();
        int n3 = 0;
        if (thing.isHero() && (n3 = Hero.incKillCount(thing2)) == 1) {
            Score.scoreFirstKill(thing2);
        }
        int n4 = thing2.getStat("XPValue");
        double d = n4;
        d *= Math.pow(0.98, n3);
        d *= Math.pow(experienceLevelMultiplier, n2 - 1);
        if (n > n2) {
            d /= (double)(n - n2);
        }
        int n5 = (int)d;
        Hero.gainExperience(n5);
        return n5;
    }

    public static String[] heroRaces() {
        return races;
    }

    public static String[] heroRaceDescriptions() {
        String[] stringArray = Hero.heroRaces();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = Lib.create(stringArray[i]).getString("RaceDescription");
            if (string == null) {
                string = "No description for " + stringArray[i] + " yet...";
            }
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    public static String[] heroProfessionDescriptions(String string) {
        String[] stringArray = Hero.heroProfessions(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fighter", "Fighters are trained in all aspects of combat. Whether they work in the service of a powerful lord or travel alone as adventurers, they are formidable in battle and can expect to earn a good living from their valuable skills in turbulent times such as these. Fighters often join brotherhoods and guilds where they are form string bonds of loyalty and friendship.");
        hashMap.put("wizard", "By the mastery of arcane forces, wizards are able to summon supernatural powers to their aid by casting spells. The secrets of their craft are closely guarded, and only a few wizards are ever able to master the most powerful spells. Many aspire to the ultimate honour of joining the Council of The Archmagi, and the ultimate prize of immortality.");
        hashMap.put("priest", "Priests dedicate their lives to the service of their God. They seek to build temples, help the needy and convert followers to the glory of God, and are always ready to take up arms to strike down blasphemers and heretics. As priests gain power, they are often granted divine aid to aid them in their quests. To serve their God is the only reward they need.");
        hashMap.put("thief", "Thieves are cunning and ruthless, willing to break a few rules to get what they want. Their skills are highly prized among adventurers, since not everything can be achieved by brute force alone. Their ability to enter guarded areas and obtain items unnoticed can be highly lucrative. Of course, theives would do well to conceal their profession in the company of civilized folk.");
        hashMap.put("ranger", "Roaming the wilderness, rangers are happiest when they are in the great outdoors. Some serve armies and settlements as scouts, archers and skirmishers where their speed and mobility can give a crucial tactical adventage. Alternatively, many simply enjoy their freedom and live by hunting and trading in the wilds.");
        hashMap.put("paladin", "Called to the service of their God, paladins are holy warriors tasked with a divine mission to destroy the forces of heretics and all other foes of their God. Like priests, they are able to pray for divine aid and are often answered. Driven by their dedication and promise of infinte rewards in paradise, they are suprememly brave and will willingly fight fiercely against impossible odds.");
        hashMap.put("barbarian", "Raised far from civilization in tribes on the edge of the unknown, barbarians have long gravitated towards the riches of civilization, tempted by plunder and a thirst to gain immortal power and glory. Tough and agile, barbarians are more at home in the wilds than in towns, but their skills as adventurers are second to none.");
        hashMap.put("witch", "Granted mysterious powers by the passing down of dark secrets through many generations, witches are able to practice Black Magic. Their spells and curses are cast with the aid of gathered ingredients and mystic rites, and can have devastating effects. Nevertheless, witches know the danger of dabbling too much and prefer to conceal their powers.");
        hashMap.put("war-mage", "Some rare and talented individuals show an aptitude for both fighting and magic. This elite few are perhaps the most deadly foes to face, able to respond with both force and magic. Keen to exploit their talents, many become well-paid mercenaries, working for the highest bidder until they are able to build an army of their own.");
        hashMap.put("shaman", "Trained from an early age in Black Magic by the elders of their tribes, shamen are marked out as spiritual leaders and holy warriors. As a last rite of passage, they must leave their tribe and travel alone as adventurers until their skills are perfected and they have cheated death a thousand times. Only the wisest and most skilled return, and they are deemed truly worthy of rule.");
        hashMap.put("runecaster", "Since ancient times, runes have been revered for their mysterious powers. Runecasters have learnt to control them. But even they have little understanding of the mysteries behind the runes, on which subject even the Gods have remained strangely silent. Obsessed by their craft, Runecasters seek the perfection of their skills and the answer to the Ultimate Question.");
        hashMap.put("healer", "Their remarkeble gift enables Healers to cure the sick and wounded. Beloved and revered by common folk for the selfless help that they give, healers can live well from the gratitude of those whose loved ones they save. They are also welcomed by armies and bands of adventurers who desperately need their skills after every battle. Even so, healers are motivated first and foremost by compassion.");
        hashMap.put("bard", "Bards have always travelled and revelled in the company of those they meet upon the way. They are natural entertainers and the best of them can be showered in gold for displaying their talents. They often join bands of adventurers, enjoying the thrills of adventure, and more importantly, gaining new and fantastic tales to tell when next they find a hospiable inn to entertain.");
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = (String)hashMap.get(stringArray[i]);
            if (string2 == null) {
                string2 = "No description for " + stringArray[i] + " yet...";
            }
            stringArray2[i] = string2;
        }
        return stringArray2;
    }

    public static String[] heroProfessions(String string) {
        String[] stringArray = new String[1000];
        int n = 0;
        stringArray[n++] = "fighter";
        stringArray[n++] = "wizard";
        stringArray[n++] = "priest";
        if (string.equals("hobbit")) {
            stringArray[n++] = "thief";
            stringArray[n++] = "farmer";
            stringArray[n++] = "ranger";
            stringArray[n++] = "healer";
        }
        if (string.equals("human")) {
            stringArray[n++] = "bard";
            stringArray[n++] = "thief";
            stringArray[n++] = "paladin";
            stringArray[n++] = "runecaster";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "ranger";
            stringArray[n++] = "witch";
        }
        if (string.equals("dwarf")) {
            stringArray[n++] = "thief";
            stringArray[n++] = "runecaster";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "ranger";
        }
        if (string.equals("gnome")) {
            stringArray[n++] = "thief";
            stringArray[n++] = "runecaster";
            stringArray[n++] = "bard";
            stringArray[n++] = "healer";
        }
        if (string.equals("high elf")) {
            stringArray[n++] = "paladin";
            stringArray[n++] = "runecaster";
            stringArray[n++] = "ranger";
            stringArray[n++] = "healer";
        }
        if (string.equals("wood elf")) {
            stringArray[n++] = "bard";
            stringArray[n++] = "ranger";
            stringArray[n++] = "war-mage";
            stringArray[n++] = "witch";
            stringArray[n++] = "healer";
        }
        if (string.equals("dark elf")) {
            stringArray[n++] = "paladin";
            stringArray[n++] = "bard";
            stringArray[n++] = "thief";
            stringArray[n++] = "runecaster";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "ranger";
            stringArray[n++] = "witch";
        }
        if (string.equals("half orc")) {
            stringArray[n++] = "shaman";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "ranger";
            stringArray[n++] = "war-mage";
        }
        if (string.equals("half troll")) {
            stringArray[n++] = "shaman";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "war-mage";
        }
        if (string.equals("argonian")) {
            stringArray[n++] = "runecaster";
            stringArray[n++] = "thief";
            stringArray[n++] = "witch";
        }
        if (string.equals("hawken")) {
            stringArray[n++] = "ranger";
            stringArray[n++] = "barbarian";
            stringArray[n++] = "war-mage";
            stringArray[n++] = "bard";
        }
        if (string.equals("pensadorian")) {
            stringArray[n++] = "runecaster";
            stringArray[n++] = "shaman";
            stringArray[n++] = "thief";
            stringArray[n++] = "witch";
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static void createHeroHistory(Thing thing) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(5);
        int n2 = calendar.get(2) + 1;
        String string = n + "/" + n2;
        String string2 = Text.ordinal(n);
        String string3 = months[n2];
        String string4 = thing.getString("Race");
        stringBuffer.append("You are born " + (Text.isVowel(string4.charAt(0)) ? "an" : "a") + " " + string4 + " on the " + string2 + " of " + string3 + ". ");
        if (string.equals("14/2")) {
            stringBuffer.append("Everyone agreed you were a charming baby. ");
            thing.incStat("CH", RPG.d(6));
            thing.incStat("Seduction", 1);
        }
        if (string.equals("1/1")) {
            stringBuffer.append("A bright star shone in the sky when you were born. ");
            thing.incStat("WP", RPG.d(6));
        }
        stringBuffer.append("\n\n");
        switch (RPG.d(7)) {
            case 1: {
                stringBuffer.append("You had an unhappy childhood, finding it hard to relate to your peers.");
                thing.incStat("WP", RPG.d(3));
                thing.incStat("CH", -1);
                break;
            }
            case 2: {
                stringBuffer.append("You had a happy childhood, with supportive parents who taught you well.");
                thing.incStat("IN", RPG.d(3));
                thing.incStat("CH", -1);
                break;
            }
            case 3: {
                stringBuffer.append("You were always getting into trouble as a child, but somehow everything seemed to work out for you. Wise elders were convinced that fortune favoured you. ");
                thing.incStat("Luck", 5);
                break;
            }
            case 4: {
                stringBuffer.append("You enjoyed playing outdoors as a child, and excelled in particular at sports. Your peers developed a healthy respect for your talents.");
                thing.incStat("Athletics", 1);
                thing.incStat("CH", RPG.d(4));
                thing.incStat("IN", -2);
                break;
            }
            case 5: {
                stringBuffer.append("You were badly behaved as a child. You bullied smaller children relentlessly. You came to lead an impressive gang, though they followed you more out of fear than respect.");
                thing.incStat("CH", -1);
                thing.incStat("IN", -3);
                thing.incStat("ST", 2);
                break;
            }
            default: {
                stringBuffer.append("You had an uneventful childhood, and yearned for adventure.");
            }
        }
        stringBuffer.append("\n\n");
        String string5 = thing.getString("Religion");
        stringBuffer.append("You were brough up to worship " + string5 + ". ");
        switch (RPG.d(5)) {
            case 1: {
                stringBuffer.append("You avoided religious ceremonies, as you disliked your priest intensely. You even came to feel that he had laid a curse upon you. ");
                thing.incStat("Luck", -4);
                break;
            }
            case 2: {
                stringBuffer.append("You were extremely devout. It caused you great anguish because you never felt that " + string5 + " was truly close to you. ");
                thing.incStat("WP", 1);
                thing.incStat("CH", -1);
                break;
            }
            case 3: {
                stringBuffer.append("You were extremely devout, and your priest praised you for having earnt the blessing of " + string5 + ". ");
                thing.incStat("Luck", 4);
                thing.incStat("FatePoints", 1);
                break;
            }
            default: {
                stringBuffer.append("You were not particularly devout, but still felt that " + string5 + " would protect you. ");
            }
        }
        stringBuffer.append(Gods.get(string5).getString("UpbringingText") + " ");
        stringBuffer.append("\n\n");
        switch (RPG.d(5)) {
            case 1: {
                stringBuffer.append("As you grew up, you felt that you were destined for greatness. Everyone else thought that you were merely arrogant. ");
                thing.incStat("SkillPoints", 1);
                thing.incStat("CH", -3);
                break;
            }
            case 2: {
                stringBuffer.append("As you grew up, you found yourself with the remarkable ability to learn creative skills. You had a tendency to dedicate too much time to creative pursuits at the expense of other activities. ");
                thing.incStat(RPG.pick(new String[]{"Smithing", "Painting", "Music", "Cooking"}), 1);
                thing.incStat("ST", -1);
                thing.incStat("IN", -1);
            }
            case 3: {
                stringBuffer.append("Later in your youth, you fell hopelessly in love. Sadly, this was not returned. Heartbroken, you spent countless days wandering alone trying to fathom the meaning of life. ");
                thing.incStat("CH", -1);
                thing.incStat("ST", -1);
                thing.incStat("IN", 2);
                thing.incStat("Perception", 1);
                break;
            }
            default: {
                stringBuffer.append("You grew up without any particularly great events shaping your life. But you still knew that one day you would set out to achieve greatness. ");
            }
        }
        stringBuffer.append("\n\n");
        String string6 = thing.getString("Profession");
        stringBuffer.append("Determined to make something of your life, you began your " + string6 + " training as soon as you were old enough. ");
        switch (RPG.d(5)) {
            default: 
        }
        stringBuffer.append("You showed a good aptitude for your chosen career, and before too long your tutor proclaimed you as a fully trained " + string6 + ".");
        stringBuffer.append("\n\n");
        String[] stringArray = Being.statNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (thing.getStat(stringArray[i]) > 0) continue;
            thing.set(stringArray[i], 1);
        }
        thing.set("HeroHistory", stringBuffer.toString());
    }

    public static void action(Thing thing, int n) {
        int n2;
        int n3 = thing.getStat("Hunger");
        int n4 = thing.getStat("HungerThreshold");
        n3 = RPG.min(n4 * 3, n3 + n * 6 / (6 + thing.getStat("Survival")));
        thing.set("Hunger", n3);
        int n5 = n3 / n4;
        switch (n5) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                for (n2 = RPG.po(n, 10000); n2 > 0; --n2) {
                    Game.message("You feel weak with hunger!");
                    String string = RPG.pick(hungerDecayStats);
                    int n6 = thing.getBaseStat(string);
                    if (thing.getFlag("IsImmortal")) continue;
                    thing.set(string, RPG.max(n6 - 1, 1));
                }
                break;
            }
            case 3: {
                n2 = RPG.po((double)n / 1000.0);
                if (n2 > 0) {
                    Game.message("You are dying of hunger!!");
                }
                if (!thing.getFlag("IsImmortal")) {
                    thing.incStat("HPSMAX", -n2);
                }
                if (thing.getFlag("IsImmortal")) break;
                thing.incStat("HPS", -n2 * 2);
            }
        }
        for (n2 = RPG.po(n * thing.getStat("Alertness") * thing.getStat("CR"), 10000); n2 > 0; --n2) {
            Secret.search();
        }
    }

    public static String hungerString(Thing thing) {
        int n;
        int n2 = thing.getStat("HungerThreshold");
        int n3 = n = n2 > 0 ? thing.getStat("Hunger") * 100 / n2 : 0;
        if (n < -50) {
            return "bloated";
        }
        if (n < 0) {
            return "satiated";
        }
        if (n < 20) {
            return "well fed";
        }
        if (n < 70) {
            return "contented";
        }
        if (n < 100) {
            return "peckish";
        }
        if (n < 150) {
            return "hungry";
        }
        if (n < 200) {
            return "very hungry";
        }
        if (n < 250) {
            return "ravenous";
        }
        if (n < 300) {
            return "starving";
        }
        return "starving!";
    }

    public static class HeroAction
    extends Script {
        private static final long serialVersionUID = 3257571689436033328L;

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            Hero.action(thing, n);
            Being.recover(thing, n);
            return false;
        }
    }
}

