/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Coin;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

class DeepForest {
    DeepForest() {
    }

    public static Map create(int n, int n2) {
        Map map = new Map(n, n2);
        DeepForest.makeDeepForest(map);
        return map;
    }

    public static void makeWoodTemple(Map map) {
        int n;
        int n2;
        int n3;
        int n4 = map.width;
        int n5 = map.height;
        map.setTheme("deepforest");
        map.set("WanderingRate", 0);
        map.set("IsHostile", 0);
        map.set("Level", 9);
        map.set("Description", "Wood Temple");
        map.fillArea(0, 0, n4 - 1, n5 - 1, map.wall());
        map.fillArea(1, 1, n4 - 2, n5 - 1, 0);
        map.setEntrance(Portal.create());
        map.addThing(map.getEntrance(), n4 / 2, 0);
        map.setTile(n4 / 2, 0, map.floor());
        DeepForest.makePath(map, n4 / 2, 1, n4 / 2, n5 / 2);
        DeepForest.makePath(map, 1, 20, n4 - 2, 20);
        map.fillOval(10, n5 / 2, n4 - 10, n5 - 5, map.floor());
        for (n3 = 0; n3 < 20; ++n3) {
            Point point = map.findFreeSquare();
            n2 = RPG.r(n4 - 2) + 1;
            int n6 = RPG.r(n5 - 2) + 1;
            if (RPG.d(3) == 1) {
                DeepForest.makeClearing(map, n2, n6, false);
            }
            DeepForest.makePath(map, point.x, point.y, n2, n6);
            map.setTile(n2, n6, map.floor());
            if (RPG.d(6) != 1) continue;
            map.addThing(Lib.createItem(RPG.d(10)), n2, n6);
        }
        n3 = 20;
        map.fillArea(0, n3 - RPG.r(2), 0, n3 + RPG.d(2), 25);
        for (n = 1; n < n4 - 1; ++n) {
            if ((n3 = n3 + RPG.r(3) - 1) < 4) {
                ++n3;
            }
            if (n3 > n5 / 2) {
                --n3;
            }
            map.fillArea(n, n3 - RPG.d(3), n, n3 + RPG.d(3), 32);
            map.fillArea(n, n3 - RPG.r(2), n, n3 + RPG.d(2), 26);
        }
        map.fillArea(n4 - 1, n3 - RPG.r(2), n4 - 1, n3 + RPG.d(2), 25);
        DeepForest.makePath(map, n4 / 2, 1, n4 / 2, n5 - 2);
        n = n4 / 2;
        n2 = n5 * 3 / 4;
        DeepForest.makeTempleCircle(map, n, n2);
        DeepForest.makeTempleFeature(map, n - 20, n2);
        DeepForest.makeTempleFeature(map, n - 11, n2 + 5);
        DeepForest.makeTempleFeature(map, n - 11, n2 - 7);
        DeepForest.makeTempleFeature(map, n - 6, n2 - 13);
        DeepForest.makeTempleFeature(map, n + 2, n2 - 11);
        DeepForest.makeTempleFeature(map, n + 12, n2 - 10);
        DeepForest.makeTempleFeature(map, n + 16, n2 - 3);
        DeepForest.makeTempleFeature(map, n + 14, n2 + 5);
        map.replaceTiles(0, map.wall());
    }

    public static void makeTempleFeature(Map map, int n, int n2) {
        map.clearArea(n - 3, n2 - 3, n + 3, n2 + 3);
        switch (RPG.d(4)) {
            case 1: {
                map.fillArea(n - 1, n2 - 2, n + 1, n2 + 2, map.wall());
                map.fillArea(n - 2, n2 - 1, n + 2, n2 + 1, map.wall());
                map.fillArea(n - 2, n2 - 0, n + 2, n2 + 0, map.floor());
                map.fillArea(n - 1, n2 - 1, n + 1, n2 + 1, map.floor());
                map.fillArea(n - 0, n2 - 2, n + 0, n2 + 2, map.floor());
                Thing thing = Lib.create("wood temple guard");
                map.addThing(thing, n, n2);
                AI.setGuard(thing, map, n - 4, n2 - 4, n + 4, n2 + 4);
                break;
            }
            case 2: {
                map.fillArea(n - 1, n2 - 2, n + 1, n2 + 2, map.wall());
                map.fillArea(n - 2, n2 - 1, n + 2, n2 + 1, map.wall());
                Thing thing = Lib.create("wood temple archer");
                map.addThing(thing, n - 2, n2 - 2);
                AI.setGuard(thing, map, n - 4, n2 - 4, n + 4, n2 + 4);
                break;
            }
            default: {
                DeepForest.makeTreeHouse(map, n - 3, n2 - 2, n + 3, n2 + 2);
                map.setTile(n + RPG.r(3) - 1, n2 - 2, map.floor());
                Thing thing = Lib.create("woodsman");
                map.addThing(thing, n, n2);
                AI.setGuard(thing, map, n - 5, n2 - 5, n + 5, n2 + 5);
            }
        }
    }

    public static void makeTreeHouse(Map map, int n, int n2, int n3, int n4) {
        map.fillArea(n + 1, n2, n3 - 1, n4, map.wall());
        map.fillArea(n, n2 + 1, n3, n4 - 1, map.wall());
        map.fillArea(n + 2, n2 + 1, n3 - 2, n4 - 1, map.floor());
        map.fillArea(n + 1, n2 + 2, n3 - 1, n4 - 2, map.floor());
    }

    public static void makeTempleCircle(Map map, int n, int n2) {
        DeepForest.makeTreeBlock(map, n - 6, n2 - 2);
        DeepForest.makeTreeBlock(map, n - 5, n2 - 5);
        DeepForest.makeTreeBlock(map, n - 2, n2 - 6);
        DeepForest.makeTreeBlock(map, n + 1, n2 - 6);
        DeepForest.makeTreeBlock(map, n + 4, n2 - 5);
        DeepForest.makeTreeBlock(map, n + 5, n2 - 2);
        DeepForest.makeTreeBlock(map, n + 5, n2 + 1);
        DeepForest.makeTreeBlock(map, n + 4, n2 + 4);
        DeepForest.makeTreeBlock(map, n + 1, n2 + 5);
        DeepForest.makeTreeBlock(map, n - 2, n2 + 5);
        DeepForest.makeTreeBlock(map, n - 5, n2 + 4);
        DeepForest.makeTreeBlock(map, n - 6, n2 + 1);
        Thing thing = Lib.create("wood priestess");
        map.addThing(thing, n, n2);
        AI.setGuard(thing, map, n - 3, n2 - 3, n + 3, n2 + 3);
        thing = Lib.create("wood priest");
        map.addThing(thing, n, n2);
        AI.setGuard(thing, map, n - 7, n2 - 6, n - 1, n2 + 6);
        thing = Lib.create("wood priest");
        map.addThing(thing, n, n2);
        AI.setGuard(thing, map, n + 1, n2 - 6, n + 7, n2 + 6);
    }

    public static void makeTreeBlock(Map map, int n, int n2) {
        map.fillArea(n, n2, n + 1, n2 + 1, 16);
    }

    public static Map makeDarkForest(int n) {
        Map map = new Map(71, 71);
        int n2 = map.width;
        int n3 = map.height;
        map.setTheme("deepforest");
        map.set("Level", n);
        map.set("WanderingRate", 300);
        map.set("Description", "Dark Forest");
        map.set("EnterMessageFirst", "You hear many eerie howls - it seems you are not alone in this dark forest!");
        map.fillArea(0, 0, n2 - 1, n3 - 1, map.floor());
        for (int i = 0; i < n2; ++i) {
            block5: for (int j = 0; j < n3; ++j) {
                switch (RPG.d(10)) {
                    case 1: {
                        map.setTile(i, j, map.wall());
                        continue block5;
                    }
                    case 2: {
                        map.addThing("thorny bush", i, j);
                        continue block5;
                    }
                }
            }
        }
        map.setEntrance(Lib.create("invisible portal"));
        map.addThing(map.getEntrance(), 0, 0, n2 - 1, 0);
        map.addThing(Lib.create("wood temple"), 0, n3 / 2, n2 - 1, n3 - 1);
        return map;
    }

    public static void makeDeepForest(Map map) {
        Point point;
        int n;
        int n2 = map.width;
        int n3 = map.height;
        map.setTheme("deepforest");
        map.set("Description", "Deep Forest");
        map.set("Level", 4);
        map.set("EnterMessageFirst", "The forest here is dark and dangerous");
        map.fillArea(0, 0, n2 - 1, n3 - 1, map.wall());
        map.fillArea(1, 0, n2 - 2, n3 - 2, 0);
        map.setEntrance(Portal.create());
        map.setTile(n2 / 2, n3 - 1, map.floor());
        map.addThing(map.getEntrance(), n2 / 2, n3 - 1);
        map.setEntrance(Portal.create());
        map.addThing(map.getEntrance(), n2 / 2, n3 - 1);
        Point point2 = new Point(n2 / 2, 3 * n3 / 4);
        DeepForest.makePath(map, n2 / 2, n3 - 4, point2.x, point2.y);
        map.fillArea(n2 / 2 - 1, n3 - 8, n2 / 2 + 1, n3 - 1, map.floor());
        map.addThing(Coin.createMoney(600), point2.x, point2.y);
        DeepForest.makeClearing(map, n2 - point2.x, n3 - point2.y, true);
        DeepForest.makeHut(map, n2 - point2.x - 5, n3 - point2.y - 4, n2 - point2.x + 5, n3 - point2.y + 4);
        Point point3 = new Point(RPG.r(n2 - 2) + 1, RPG.r(map.height - 2) + 1);
        DeepForest.makePath(map, point2.x, point2.y, point3.x, point3.y);
        DeepForest.makePath(map, point3.x, point3.y, n2 - point2.x, n3 - point2.y);
        for (n = 0; n < 10; ++n) {
            point = map.findFreeSquare();
            int n4 = RPG.r(n2 - 2) + 1;
            int n5 = RPG.r(n3 - 2) + 1;
            DeepForest.makeClearing(map, n4, n5, true);
            DeepForest.makePath(map, point.x, point.y, n4, n5);
        }
        map.replaceTiles(0, map.wall());
        DeepForest.decorateForest(map, 0, 0, n2 - 1, n3 - 1);
        for (n = 0; n < 8; ++n) {
            DeepForest.addBeasties(map, RPG.r(n2), RPG.r(n3));
            point = map.findFreeSquare();
            DeepForest.addBaddie(map, point.x, point.y);
        }
    }

    private static void makePath(Map map, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n <= 0 || n3 >= map.width - 1 || n2 <= 0 || n4 >= map.height - 1) {
            Game.warn("DeepForest.makePath() bounds error");
        }
        while (n != n3 || n2 != n4) {
            if (map.getTile(n, n2) == 0) {
                map.setTile(n, n2, map.floor());
            }
            if (RPG.d(4) == 1) {
                n5 = RPG.sign(n3 - n);
                n6 = RPG.sign(n4 - n2);
            } else {
                n5 = RPG.r(3) - 1;
                n6 = RPG.r(3) - 1;
            }
            if (n5 != 0 && n6 != 0) {
                switch (RPG.d(2)) {
                    case 1: {
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        n6 = 0;
                    }
                }
            }
            n += n5;
            n2 += n6;
            n = RPG.middle(1, n, map.width - 2);
            n2 = RPG.middle(1, n2, map.height - 2);
        }
    }

    private static void makeClearing(Map map, int n, int n2, boolean bl) {
        int n3;
        int n4 = RPG.d(8);
        int n5 = RPG.d(8);
        int n6 = n - n4;
        int n7 = n2 - n5;
        int n8 = n + n4;
        int n9 = n2 + n5;
        int n10 = (n6 + n8) / 2;
        int n11 = (n7 + n9) / 2;
        for (n3 = n6; n3 <= n6 + n4 * 2; ++n3) {
            for (int i = n7; i < n7 + n5 * 2; ++i) {
                if ((n3 - n10) * (n3 - n10) * 100 / (n4 * n4) + (i - n11) * (i - n11) * 100 / (n5 * n5) >= 100 || map.getTile(n3, i) != 0) continue;
                map.setTile(n3, i, map.floor());
            }
        }
        if (bl && n4 >= 4 && n5 >= 4 && RPG.d(6) == 1 && n != map.getEntrance().x) {
            for (n3 = 0; n3 < RPG.d(10); ++n3) {
                int n12;
                float f = RPG.random() * 100.0f;
                int n13 = (int)(0.5 + (double)n10 + 3.0 * Math.sin(f));
                if (map.isBlocked(n13, n12 = (int)(0.5 + (double)n11 + 3.0 * Math.cos(f)))) continue;
                map.addThing(Lib.create("mushroom"), n13, n12);
            }
            for (n3 = 0; n3 <= RPG.d(2, 4); ++n3) {
                Thing thing = Lib.create("rabbit");
                thing.set("TargetX", n10);
                thing.set("TargetX", n11);
                map.addThing(thing, n10, n11);
            }
        }
    }

    public static void makeHut(Map map, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        map.fillArea(n, n2, n3, n4, map.floor());
        int n7 = n3 - n - 4;
        int n8 = n4 - n2 - 4;
        if (n8 < 3 || n7 < 3) {
            return;
        }
        map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 10);
        map.fillArea(n + 2, n2 + 2, n3 - 2, n4 - 2, 1);
        if (RPG.d(2) == 1) {
            n6 = RPG.rspread(n + 2, n3 - 2);
            n5 = RPG.d(2) == 1 ? n2 + 1 : n4 - 1;
        } else {
            n5 = RPG.rspread(n2 + 2, n4 - 2);
            n6 = RPG.d(2) == 1 ? n + 1 : n3 - 1;
        }
        map.setTile(n6, n5, map.floor());
        map.addThing(Lib.createType("IsDoor", map.getLevel()), n6, n5);
        Thing thing = Portal.create("old dungeon");
        map.addThing(thing, RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing("canoe", n, n2, n3, n4);
        map.addThing(Lib.create("goblin"), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing(Lib.create("goblin"), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing(Lib.createItem(0), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing(Lib.createItem(0), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing(Food.createFood(0), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
        map.addThing(Food.createFood(0), RPG.rspread(n + 2, n3 - 2), RPG.rspread(n2 + 2, n4 - 2));
    }

    public static void decorateForest(Map map, int n, int n2, int n3, int n4) {
        for (int i = n; i <= n3; ++i) {
            block6: for (int j = n2; j <= n4; ++j) {
                if (map.isBlocked(i, j) || map.getTile(i, j) != map.floor()) continue;
                switch (RPG.d(60)) {
                    case 1: 
                    case 2: {
                        map.addThing(Lib.create("bush"), i, j);
                        continue block6;
                    }
                    case 5: {
                        map.addThing(Lib.create("thorny bush"), i, j);
                        continue block6;
                    }
                    case 6: {
                        map.addThing(Lib.create("mushroom"), i, j);
                    }
                }
            }
        }
    }

    private static void addBeasties(Map map, int n, int n2) {
        Thing thing;
        switch (RPG.d(5)) {
            case 1: {
                thing = Lib.create("dog");
                break;
            }
            default: {
                thing = Lib.create("small spider");
            }
        }
        for (int i = 0; i < 4; ++i) {
            int n3;
            int n4 = n - 2 + RPG.r(5);
            if (!map.isClear(n4, n3 = n2 - 2 + RPG.r(5))) continue;
            map.addThing(thing, n4, n3);
            thing = thing.cloneType();
        }
    }

    private static void addBaddie(Map map, int n, int n2) {
        if (map.isClear(n, n2)) {
            Thing thing = Lib.create("mutant");
            thing.addThing(Lib.createItem(0));
            map.addThing(thing, n, n2);
        }
    }
}

