/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Coin {
    public static final String SOVEREIGN = "sovereign";
    public static final String GOLD = "gold";
    public static final String SILVER = "silver";
    public static final String COPPER = "copper";
    public static final int SOVEREIGN_AMOUNT = 1000;
    public static final int GOLD_AMOUNT = 100;
    public static final int SILVER_AMOUNT = 10;
    public static final int COPPER_AMOUNT = 1;

    public static int roundMoney(int n) {
        int n2 = 1;
        while (n > 100) {
            n = n / 10 + (RPG.r(10) < n % 10 ? 1 : 0);
            n2 *= 10;
        }
        return n * n2;
    }

    public static int roundDownMoney(int n) {
        int n2 = 1;
        while (n > 100) {
            n /= 10;
            n2 *= 10;
        }
        return n * n2;
    }

    public static String valueString(int n) {
        int n2;
        for (n2 = 0; n2 < 2 && n > 0 && n % 10 == 0; ++n2, n /= 10) {
        }
        if (n <= 0) {
            return "nothing";
        }
        switch (n2) {
            case 0: {
                return n + " copper";
            }
            case 1: {
                return n + " silver";
            }
            case 2: {
                return n + " gold";
            }
        }
        return "nothing";
    }

    public static Thing createRandomMoney(int n) {
        return Coin.createMoney(n);
    }

    public static Thing createMoney(int n) {
        int n2 = 0;
        if (n >= 1000) {
            ++n2;
        }
        if (n >= 100) {
            ++n2;
        }
        if (RPG.d(2) == 1 && n >= 10) {
            ++n2;
        }
        for (int i = 0; i < n2; ++i) {
            n /= 10;
        }
        if (n <= 0) {
            n = 1;
        }
        String string = "copper coin";
        switch (n2) {
            case 1: {
                string = "silver coin";
                break;
            }
            case 2: {
                string = "gold coin";
                break;
            }
            case 3: {
                string = SOVEREIGN;
            }
        }
        Thing thing = Lib.create(string);
        thing.set("Number", n);
        return thing;
    }

    protected static int valueOf(Thing thing) {
        return thing.getStat("Value") * thing.getNumber();
    }

    public static int getMoney(Thing thing) {
        Thing[] thingArray = thing.getFlaggedContents("IsMoney");
        int n = 0;
        for (int i = 0; i < thingArray.length; ++i) {
            n += Coin.valueOf(thingArray[i]);
        }
        return n;
    }

    public static void addMoney(Thing thing, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            Coin.removeMoney(thing, -n);
            return;
        }
        int n2 = 1;
        String string = COPPER;
        if (n > 1000) {
            n2 = 1000;
            string = SOVEREIGN;
        } else if (n > 100) {
            n2 = 100;
            string = GOLD;
        } else if (n > 10) {
            n2 = 10;
            string = SILVER;
        }
        Thing thing2 = Coin.createMoney(n / n2, string);
        int n3 = Coin.valueOf(thing2);
        thing.addThingWithStacking(thing2);
        Coin.addMoney(thing, n - n3);
    }

    private static Thing createMoney(int n, String string) {
        String string2 = string.equals(SOVEREIGN) ? "" : " coin";
        return Lib.create("" + n + " " + string + string2);
    }

    public static Thing createLevelMoney(int n) {
        int n2 = (int)((double)(10 * (n = RPG.d(n))) * Math.pow(1.1, n));
        if (n2 <= 0) {
            n2 = 1;
        }
        return Coin.createMoney(RPG.d(n2));
    }

    public static void removeMoney(Thing thing, int n) {
        if (n <= 0) {
            Coin.addMoney(thing, -n);
            return;
        }
        int n2 = Coin.getMoney(thing) - n;
        Thing[] thingArray = thing.getFlaggedContents("IsMoney");
        for (int i = 0; i < thingArray.length; ++i) {
            thingArray[i].remove();
        }
        if (n2 > 0) {
            Coin.addMoney(thing, n2);
        }
    }

    public static void init() {
        Thing thing = Lib.extend("base coin", "base item");
        thing.set("IsMoney", 1);
        thing.set("IsCoin", 1);
        thing.set("IsStatusKnown", 1);
        thing.set("Image", 140);
        thing.set("HPS", 6);
        thing.set("ItemWeight", 20);
        thing.set("LevelMin", 1);
        thing.set("RES:water", 100);
        thing.set("Z", 18);
        thing.set("Frequency", 100);
        thing.set("ASCII", "$");
        Lib.add(thing);
        thing = Lib.extend("copper coin", "base coin");
        thing.set("Value", 1);
        thing.set("Image", 144);
        thing.set("ItemWeight", 20);
        Lib.add(thing);
        thing = Lib.extend("silver coin", "base coin");
        thing.set("Value", 10);
        thing.set("Image", 143);
        thing.set("ItemWeight", 30);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("gold coin", "base coin");
        thing.set("Value", 100);
        thing.set("Image", 140);
        thing.set("ItemWeight", 50);
        thing.set("LevelMin", 5);
        Lib.add(thing);
        thing = Lib.extend(SOVEREIGN, "base coin");
        thing.set("Value", 1000);
        thing.set("Image", 140);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 8);
        Lib.add(thing);
    }
}

