/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Door;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Score;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;
import mikera.tyrant.Trap;

public class Chest {
    public static Thing create(int n) {
        Thing thing = Lib.createType("IsChest", n);
        return thing;
    }

    public static void init() {
        Thing thing = Lib.extend("base chest", "base scenery");
        thing.set("IsOpenable", 1);
        thing.set("IsChest", 1);
        thing.set("ImageSource", "Scenery");
        thing.set("Image", 121);
        thing.set("HPS", 30);
        thing.set("Frequency", 30);
        thing.set("ItemWeight", 10000);
        thing.set("LevelMin", 1);
        thing.set("Z", 15);
        thing.set("ImageOpen", 2);
        thing.addHandler("OnDamage", new ChestDamage());
        thing.set("DefaultThings", "80% [IsTrap]");
        thing.set("OnBump", new ChestBump());
        Lib.add(thing);
        thing = Lib.extend("chest", "base chest");
        thing.set("OnCreate", new ChestCreation());
        thing.set("OnOpen", new ChestOpen());
        thing.set("ScoreExplore", 10);
        Lib.add(thing);
    }

    public static class ChestBump
    extends Script {
        private static final long serialVersionUID = 4120851040649491762L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            if (thing2.isHero()) {
                Item.touch(thing2, thing);
                Game.message("You open " + thing.getTheName());
                Door.setOpen(thing, true);
            }
            return false;
        }
    }

    public static class ChestOpen
    extends Script {
        private static final long serialVersionUID = 4120851040649491762L;

        public boolean handle(Thing thing, Event event) {
            Thing[] thingArray = thing.getItems();
            Score.scoreExplore(thing);
            for (int i = 0; i < thingArray.length; ++i) {
                if (!thingArray[i].getFlag("IsItem")) continue;
                thing.getMap().addThing(thingArray[i], thing.x, thing.y);
            }
            return false;
        }
    }

    public static class ChestClosed
    extends Script {
        private static final long serialVersionUID = 3256718494266373688L;

        public boolean handle(Thing thing, Event event) {
            return false;
        }
    }

    public static class ChestCreation
    extends Script {
        private static final long serialVersionUID = 3256723974577598773L;

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Level");
            for (int i = RPG.min(1, RPG.d(2, 4) - 3); i > 0; --i) {
                thing.addThing(Lib.createItem(n + RPG.r(5)));
            }
            if (RPG.test(n, 10)) {
                thing.addThing(Trap.createTrap(n));
            }
            return false;
        }
    }

    public static class ChestDamage
    extends Script {
        private static final long serialVersionUID = 4121411791663740466L;

        public boolean handle(Thing thing, Event event) {
            Thing[] thingArray = thing.getFlaggedContents("IsTrap");
            Map map = thing.getMap();
            Thing thing2 = event.getThing("Actor");
            for (int i = 0; i < thingArray.length; ++i) {
                Point point = new Point(thing.x, thing.y);
                if (thing2 != null) {
                    int n = thing.x + RPG.sign(thing2.x - thing.x);
                    int n2 = thing.y + RPG.sign(thing2.y - thing.y);
                    point.x = n;
                    point.y = n2;
                }
                map.addThing(thingArray[i], point.x, point.y);
                Trap.trigger(thingArray[i]);
            }
            return false;
        }
    }
}

