/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import mikera.tyrant.util.MetaData;

public class MetaDataEntry {
    public static final int FIX_VALUE = 0;
    public static final int ANY_VALUE = 1;
    public static final int POSITIVE_VALUE = 2;
    public static final int NEGATIVE_VALUE = 3;
    public static final int INTERVAL = 4;
    public static final int CERTAIN_VALUES = 5;
    public static final int MANDATORY_PROPERTY = 6;
    public static final int OPTIONAL_PROPERTY = 7;
    private Object value;
    private ArrayList validValues;
    private int valueCondition;
    private int propertyCondition;

    protected MetaDataEntry(Object object, Object[] objectArray, int n, int n2) throws IllegalArgumentException {
        if (this.valueCondition == 4 && objectArray.length != 2) {
            throw new IllegalArgumentException("The INTERVAL condition needs two valid values: [minimum ; maximum]. " + objectArray.length + " values were found");
        }
        if (this.valueCondition == 5 && objectArray.length <= 1) {
            throw new IllegalArgumentException("The CERTAIN_VALUES condition needs more than one valid value. " + objectArray.length + " value(s) were found");
        }
        if (objectArray != null) {
            this.validValues = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                this.validValues.add(objectArray[i]);
            }
            if (!(objectArray instanceof MetaData[])) {
                Collections.sort(this.validValues);
            }
        }
        this.value = object;
        this.valueCondition = n;
        this.propertyCondition = n2;
    }

    protected boolean isMandatory() {
        return this.propertyCondition == 6;
    }

    protected Object getValue() {
        return this.value;
    }

    protected String getValueCondition() {
        switch (this.valueCondition) {
            case 0: {
                return "Fix";
            }
            case 1: {
                return "Any";
            }
            case 2: {
                return "Positive";
            }
            case 3: {
                return "Negative";
            }
            case 4: {
                return "Interval";
            }
            case 5: {
                return "Certain values";
            }
        }
        return null;
    }

    protected ArrayList getValidValues() {
        return this.validValues;
    }

    protected boolean describes(Object object) {
        boolean bl = false;
        try {
            if (this.value instanceof Integer && !(object instanceof Integer)) {
                object = new Integer((String)object);
            }
            if (this.value instanceof Double && !(object instanceof Double)) {
                object = new Double((String)object);
            }
            if (this.value instanceof MetaData) {
                object = (TreeMap)object;
            }
            System.out.println("    " + object + " matches the value type " + this.value.getClass().getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("    " + object + " is a " + object.getClass() + " and doesn't match the value type " + this.value.getClass() + ": " + exception.getMessage());
            return false;
        }
        switch (this.valueCondition) {
            case 0: {
                if (object instanceof TreeMap) {
                    bl = ((MetaData)this.value).describes((TreeMap)object, true);
                }
                bl = this.value.equals(object);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    boolean bl2 = bl = new Integer(0).compareTo((Integer)object) <= 0;
                }
                if (!(object instanceof Double)) break;
                bl = new Double(0.0).compareTo((Double)object) <= 0;
                break;
            }
            case 3: {
                if (object instanceof Integer) {
                    boolean bl3 = bl = new Integer(0).compareTo((Integer)object) > 0;
                }
                if (!(object instanceof Double)) break;
                bl = new Double(0.0).compareTo((Double)object) > 0;
                break;
            }
            case 4: {
                Iterator iterator = this.validValues.iterator();
                if (object instanceof Integer) {
                    boolean bl4 = bl = ((Integer)iterator.next()).compareTo((Integer)object) >= 0 && ((Integer)iterator.next()).compareTo((Integer)object) <= 0;
                }
                if (!(object instanceof Double)) break;
                bl = ((Double)iterator.next()).compareTo((Double)object) >= 0 && ((Double)iterator.next()).compareTo((Double)object) <= 0;
                break;
            }
            case 5: {
                if (object instanceof TreeMap) {
                    TreeMap treeMap = (TreeMap)object;
                    Iterator iterator = this.validValues.iterator();
                    while (iterator.hasNext()) {
                        if (!((MetaData)iterator.next()).describes(treeMap, true)) continue;
                        bl = true;
                    }
                    break;
                }
                bl = this.validValues.contains(object);
                break;
            }
        }
        return this.checkCondition(object, bl);
    }

    private boolean checkCondition(Object object, boolean bl) {
        if (bl) {
            System.out.println("    " + object + " matches the " + this.getValueCondition().toLowerCase() + " condition");
        } else {
            System.out.println("    " + object + " doesn't match the " + this.getValueCondition().toLowerCase() + " condition");
        }
        return bl;
    }
}

