/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.author;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Thing;
import mikera.tyrant.author.MapMaker;

public class ThingMaker {
    public static final String SPACES_3 = "   ";
    public static final String FLAG_ENDING = "@";
    private Thing lastThing;
    public boolean isDesigner = true;

    public void storeThings(Map map, StringBuffer stringBuffer) {
        stringBuffer.append(MapMaker.NL);
        stringBuffer.append("---Things---");
        stringBuffer.append(MapMaker.NL);
        for (int i = 0; i < map.getHeight(); ++i) {
            for (int j = 0; j < map.getWidth(); ++j) {
                Thing[] thingArray = map.getThings(j, i);
                if (thingArray.length == 0 || thingArray[0] == Game.hero()) continue;
                this.storeThing(stringBuffer, thingArray, j, i);
            }
        }
        stringBuffer.append("---Things---");
        stringBuffer.append(MapMaker.NL);
    }

    private void storeThing(StringBuffer stringBuffer, Thing[] thingArray, int n, int n2) {
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing = thingArray[i];
            if (thing == Game.hero()) continue;
            stringBuffer.append(n);
            stringBuffer.append("x");
            stringBuffer.append(n2);
            stringBuffer.append(" ");
            this.storeThingName(stringBuffer, thing);
        }
    }

    private void storeThingName(StringBuffer stringBuffer, Thing thing) {
        String string = thing.name();
        if (string.endsWith(FLAG_ENDING)) {
            stringBuffer.append("[");
            stringBuffer.append(string.substring(0, string.length() - 1));
            stringBuffer.append("]");
        } else {
            stringBuffer.append(thing.name());
        }
        stringBuffer.append(MapMaker.NL);
        this.storeThingsLocal(stringBuffer, thing);
    }

    private void storeThingsLocal(StringBuffer stringBuffer, Thing thing) {
        HashMap hashMap = thing.getLocal();
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        TreeMap treeMap = new TreeMap(hashMap);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (k.equals("Name")) continue;
            stringBuffer.append(SPACES_3);
            stringBuffer.append(k);
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(MapMaker.NL);
        }
    }

    public void addThingsToMap(Map map, String string) {
        int[] nArray = MapMaker.extract("---Things---", string, null);
        if (nArray != null) {
            String string2 = string.substring(nArray[0], nArray[1]).trim();
            this.createThings(map, string2);
        }
    }

    private void createThings(Map map, String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (Character.isSpaceChar(string2.charAt(0))) {
                    String[] stringArray = string2.trim().split("=");
                    object = stringArray[1].trim();
                    if (Character.isDigit(object.charAt(0))) {
                        object = Integer.valueOf((String)object);
                    }
                    this.lastThing.set(stringArray[0].trim(), object);
                    continue;
                }
                int n = (string2 = string2.trim()).indexOf(32);
                if (n == -1) {
                    return;
                }
                object = string2.substring(0, n).trim().split("x");
                int n2 = Integer.parseInt(object[0]);
                int n3 = Integer.parseInt(object[1]);
                String string3 = string2.substring(n + 1);
                this.lastThing = this.createDesignerThing(string3.trim());
                map.addThing(this.lastThing, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Thing createDesignerThing(String string) {
        if (this.isDesigner && string.charAt(0) == '[') {
            return Lib.create(string.substring(1, string.length() - 1) + FLAG_ENDING);
        }
        return Lib.create(string);
    }
}

