/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.author;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Text;
import mikera.tyrant.Tile;
import mikera.tyrant.author.ThingMaker;

public class MapMaker {
    private static int nextChar = 97;
    private java.util.Map tiles = new HashMap();
    public static String NL = System.getProperty("line.separator");
    private java.util.Map legend = new HashMap();
    private ThingMaker thingMaker = new ThingMaker();

    public String store(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        this.storeTiles(map, stringBuffer);
        this.storeLegend(stringBuffer);
        this.storeProperties(map, stringBuffer);
        this.thingMaker.storeThings(map, stringBuffer);
        return stringBuffer.toString();
    }

    private void storeLegend(StringBuffer stringBuffer) {
        stringBuffer.append(NL);
        stringBuffer.append("---Legend---");
        stringBuffer.append(NL);
        TreeMap treeMap = new TreeMap(this.legend);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(NL);
        }
        stringBuffer.append("---Legend---");
        stringBuffer.append(NL);
    }

    private void storeProperties(Map map, StringBuffer stringBuffer) {
        stringBuffer.append(NL);
        stringBuffer.append("---Properties---");
        stringBuffer.append(NL);
        java.util.Map map2 = map.getCollapsedMap();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(NL);
        }
        stringBuffer.append("---Properties---");
        stringBuffer.append(NL);
    }

    public void storeTiles(Map map, StringBuffer stringBuffer) {
        nextChar = 97;
        stringBuffer.append("---Tiles---");
        stringBuffer.append(NL);
        for (int i = 0; i < map.getHeight(); ++i) {
            for (int j = 0; j < map.getWidth(); ++j) {
                int n = map.getTile(j, i);
                Character c = this.charForTile(n);
                stringBuffer.append(c);
            }
            stringBuffer.append(NL);
        }
        stringBuffer.append("---Tiles---");
        stringBuffer.append(NL);
    }

    private Character charForTile(int n) {
        String string = Tile.tileNameFor(n);
        Character c = (Character)this.tiles.get(string);
        if (c == null) {
            c = new Character((char)nextChar++);
            this.tiles.put(string, c);
            this.legend.put(String.valueOf(c), string);
        }
        return c;
    }

    public java.util.Map getLegend() {
        return this.legend;
    }

    public Map create(String string, boolean bl) {
        int[] nArray = MapMaker.extract("---Legend---", string, null);
        if (nArray == null) {
            return null;
        }
        String string2 = string.substring(nArray[0], nArray[1]).trim();
        this.createLegend(string2);
        nArray = MapMaker.extract("---Tiles---", string, null);
        String string3 = null;
        if (nArray != null) {
            string3 = string.substring(nArray[0], nArray[1]).trim();
        }
        nArray = MapMaker.extract("---Properties---", string, null);
        String string4 = null;
        if (nArray != null) {
            string4 = string.substring(nArray[0], nArray[1]).trim();
        }
        Map map = this.createMap(string3);
        map.setProperties(this.createProperties(string4));
        this.thingMaker.isDesigner = bl;
        this.thingMaker.addThingsToMap(map, string);
        return map;
    }

    private Map createMap(String string) {
        int n;
        String[] stringArray = string.split("\n");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        n = stringArray[0].length();
        if (stringArray[n2 - 1].length() < n) {
            --n2;
        }
        Map map = new Map(n, n2);
        if (string == null) {
            throw new Error("Null tiles");
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            for (int j = 0; j < n; ++j) {
                String string3 = string2.substring(j, j + 1);
                String string4 = (String)this.legend.get(string3);
                BaseObject baseObject = Lib.get(string4);
                if (baseObject == null) {
                    throw new Error("Legend [" + string3 + "] not recognised");
                }
                int n3 = baseObject.getStat("TileValue");
                map.setTile(j, i, n3);
            }
        }
        return map;
    }

    private void createLegend(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                String[] stringArray = string2.split("=");
                String string3 = stringArray[0].trim();
                String string4 = stringArray[1].trim();
                this.legend.put(string3, string4);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private TreeMap createProperties(String string) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (string == null || string.length() == 0) {
            return treeMap;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                String[] stringArray = string2.split("=");
                String string3 = stringArray[0].trim();
                Object object = Text.parseObject(stringArray[1].trim());
                treeMap.put(string3, object);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return treeMap;
    }

    public static int[] extract(String string, String string2, int[] nArray) {
        int n = nArray == null ? 0 : nArray[1];
        int n2 = string2.indexOf(string, n);
        if (n2 == -1) {
            return null;
        }
        int n3 = string2.indexOf(string, n2 + string.length());
        if (n3 == -1) {
            return null;
        }
        return new int[]{n2 + string.length(), n3};
    }

    public Map promptAndLoad() {
        String string = "map.txt";
        FileDialog fileDialog = new FileDialog(new Frame(), "Load map", 0);
        fileDialog.setFile(string);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return null;
        }
        string = fileDialog.getDirectory() + fileDialog.getFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(NL);
            }
            Map map = this.create(stringBuffer.toString(), true);
            Game.message("Map loaded - " + string);
            return map;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Game.message("Error while loading map, check console");
            return null;
        }
    }
}

