/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.RuneTrap;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Trap {
    public static Thing create() {
        return Trap.createTrap(Lib.currentLevel());
    }

    public static Thing create(int n) {
        return Trap.createTrap(n);
    }

    public static Thing createTrap(int n) {
        return Lib.createType("IsTrap", n);
    }

    public static void setActivated(Thing thing, boolean bl) {
        thing.set("IsActivated", bl);
    }

    public static boolean isActivated(Thing thing) {
        return thing.getFlag("IsActivated");
    }

    public static void trigger(Thing thing) {
        if (thing.handles("OnEnterTrigger")) {
            Event event = new Event("EnterTrigger");
            Thing thing2 = thing.getMap().getMobile(thing.x, thing.y);
            event.set("Target", thing2);
            thing.visibleMessage(thing.getAName() + " is triggered!");
            if (thing2 != null && thing2.isHero()) {
                thing2.isRunning(false);
            }
            thing.handle(event);
        }
    }

    public static boolean applyDisarmTraps(Thing thing) {
        Game.message("Disarm trap in which direction?");
        Point point = Game.getDirection();
        Thing thing2 = thing.getMap().getFlaggedObject(thing.x + point.x, thing.y + point.y, "IsTrap");
        if (thing2 != null && thing2.isVisible(Game.hero())) {
            return Trap.tryDisarm(thing, thing2);
        }
        Game.message("No trap found.");
        return false;
    }

    public static boolean tryDisarm(Thing thing, Thing thing2) {
        thing.incStat("APS", -200);
        int n = thing.getStat("Disarm Traps") * thing.getStat("CR");
        int n2 = thing2.getStat("Level") * 5;
        int n3 = 0;
        if (RPG.test(n, n2)) {
            ++n3;
        }
        if (RPG.test(n, n2)) {
            ++n3;
        }
        switch (n3) {
            case 0: {
                Game.message("You trigger the trap by accident!");
                Trap.trigger(thing2);
                return true;
            }
            case 1: {
                Game.message("You fail to disarm the trap");
                thing.incStat("APS", -200);
                return true;
            }
            case 2: {
                Game.message("You disarm the trap successfully");
                Trap.disarm(thing2);
                return true;
            }
        }
        return true;
    }

    public static void disarm(Thing thing) {
        thing.die();
    }

    public static void init() {
        Thing thing = Lib.extend("base trap", "base secret");
        thing.set("IsTrap", 1);
        thing.set("ImageSource", "Scenery");
        thing.set("IsDestructible", 0);
        thing.set("Image", 47);
        thing.set("IsWarning", 1);
        thing.set("IsInvisible", Game.isDebug() ? 0 : 1);
        thing.set("Frequency", 50);
        thing.set("IsActivated", 1);
        thing.set("Uses", 1);
        thing.set("LevelMin", 1);
        thing.set("Z", 0);
        thing.set("ASCII", "^");
        Lib.add(thing);
        Trap.initSpecialTraps();
        Trap.initSpellTraps();
        RuneTrap.init();
    }

    public static void initSpellTrap(Thing thing) {
        if (thing.getStat("SpellUsage") == 1) {
            String string = thing.name();
            Thing thing2 = Lib.extend(string + " trap", "base trap");
            thing2.set("TrapSpell", string);
            thing2.set("Image", 47);
            thing2.set("Level", thing.getLevel());
            thing2.set("LevelMin", thing.getLevel());
            thing2.set("OnEnterTrigger", new SpellTrapTrigger());
            thing2.set("DeathDecoration", "10% wand of " + string);
            Lib.add(thing2);
        }
    }

    public static void initSpellTraps() {
        ArrayList arrayList = Spell.getSpellNames();
        for (int i = 0; i < arrayList.size(); ++i) {
            Thing thing = Spell.create((String)arrayList.get(i));
            Trap.initSpellTrap(thing);
        }
    }

    public static void initSpecialTraps() {
        Thing thing = Lib.extend("pit trap", "base trap");
        thing.set("OnEnterTrigger", new PitTrapTrigger());
        Lib.add(thing);
        thing = Lib.extend("ambush trap", "base trap");
        thing.set("OnEnterTrigger", new AmbushTrapTrigger());
        Lib.add(thing);
        thing = Lib.extend("rockfall trap", "base trap");
        thing.set("OnEnterTrigger", new RockfallTrapTrigger());
        Lib.add(thing);
        thing = Lib.extend("blindness trap", "base trap");
        AttributeTrapTrigger attributeTrapTrigger = new AttributeTrapTrigger();
        attributeTrapTrigger.set("Message", "You are blinded by a sudden flash!");
        attributeTrapTrigger.set("Effect", "curse of blindness");
        thing.set("OnEnterTrigger", attributeTrapTrigger);
        Lib.add(thing);
        thing = Lib.extend("poison trap", "base trap");
        attributeTrapTrigger = new AttributeTrapTrigger();
        attributeTrapTrigger.set("Message", "You are hit by a jet of poisonous gas!");
        attributeTrapTrigger.set("Effect", "poison");
        thing.set("OnEnterTrigger", attributeTrapTrigger);
        thing.set("DeathDecoration", "potion of poison");
        Lib.add(thing);
        thing = Lib.extend("curse trap", "base trap");
        attributeTrapTrigger = new AttributeTrapTrigger();
        attributeTrapTrigger.set("Message", "You feel like this is not going to be a good day...");
        attributeTrapTrigger.set("Effect", "curse");
        thing.set("OnEnterTrigger", attributeTrapTrigger);
        Lib.add(thing);
    }

    protected static class AttributeTrapTrigger
    extends Script {
        private static final long serialVersionUID = 3256721771276022839L;

        protected AttributeTrapTrigger() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            thing.remove();
            if (thing2 != null) {
                thing2.message(this.getString("Message"));
                thing2.addAttribute(Lib.create(this.getString("Effect")));
            }
            return false;
        }
    }

    protected static class RockfallTrapTrigger
    extends Script {
        private static final long serialVersionUID = 4121129234254214969L;

        protected RockfallTrapTrigger() {
        }

        public boolean handle(Thing thing, Event event) {
            Map map = thing.getMap();
            int n = thing.x;
            int n2 = thing.y;
            Thing thing2 = event.getThing("Target");
            thing.remove();
            Lib.create("pit");
            if (thing2 != null) {
                thing2.message("You are hit by falling rocks!");
                Damage.inflict(thing2, RPG.d(20), "impact");
            }
            map.addThing(Lib.create("rock"), n, n2);
            map.addThing(Lib.create("stone"), n, n2);
            return false;
        }
    }

    protected static class AmbushTrapTrigger
    extends Script {
        private static final long serialVersionUID = 3258135751886516790L;

        protected AmbushTrapTrigger() {
        }

        public boolean handle(Thing thing, Event event) {
            Map map = thing.getMap();
            int n = map.getLevel();
            Thing thing2 = Lib.createType("IsMonster", n);
            Thing thing3 = event.getThing("Target");
            boolean bl = false;
            for (int i = RPG.d(6); i > 0; --i) {
                bl |= map.addBlockingThing(Lib.create(thing2.name()), thing.x - 1, thing.y - 1, thing.x + 1, thing.y + 1);
            }
            if (thing3 != null) {
                if (bl) {
                    thing3.message("You have been ambushed!");
                } else {
                    thing3.message("You feel you are being watched");
                }
            }
            thing.remove();
            return false;
        }
    }

    protected static class PitTrapTrigger
    extends Script {
        private static final long serialVersionUID = 3257008748072613943L;

        protected PitTrapTrigger() {
        }

        public boolean handle(Thing thing, Event event) {
            Map map = thing.getMap();
            Thing thing2 = event.getThing("Target");
            Thing thing3 = Lib.create("pit");
            thing3.set("DestinationLevel", RPG.middle(1, map.getLevel() + RPG.d(3) - RPG.d(3), 50));
            thing.replace(thing3);
            thing3 = thing;
            if (thing2 != null) {
                Portal.travel(thing3, thing2);
                Map map2 = thing2.getMap();
                Point point = map2.findFreeSquare();
                if (point == null) {
                    throw new Error("Unable to find a free square in pit");
                }
                if (point != null && thing2 != null) {
                    thing2.message("You have fallen into a pit!");
                    thing2.moveTo(map2, point.x, point.y);
                }
                return true;
            }
            return false;
        }
    }

    protected static class SpellTrapTrigger
    extends Script {
        private static final long serialVersionUID = 4049353132389774130L;

        protected SpellTrapTrigger() {
        }

        public boolean handle(Thing thing, Event event) {
            Map map = thing.getMap();
            int n = thing.x;
            int n2 = thing.y;
            thing.remove();
            Thing thing2 = Game.actor;
            if (map != null) {
                Thing thing3 = Spell.create(thing.getString("TrapSpell"));
                Spell.castAtLocation(thing3, null, map, n, n2);
                Thing thing4 = (Thing)thing.get("Actor");
                if (thing4 != null) {
                    thing4.message("Your power is drained by the runes");
                    thing4.incStat("MPS", -thing3.getStat("SpellCost"));
                }
            }
            Game.actor = thing2;
            return false;
        }
    }
}

