/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import mikera.tyrant.Game;
import mikera.tyrant.Hero;
import mikera.tyrant.Item;
import mikera.tyrant.Map;
import mikera.tyrant.QuestApp;
import mikera.tyrant.StringList;
import mikera.tyrant.TPanel;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class StatusPanel
extends TPanel {
    private static final long serialVersionUID = 3905800885761095223L;
    public static final int boxborder = 1;
    public static final Color healthcolor = new Color(180, 80, 0);
    public static final Color powercolor = new Color(0, 128, 60);
    public static int charwidth = 0;
    public static int charheight = 0;
    public static int charmaxascent = 0;
    private static String[] stats1 = new String[]{"SK", "ST", "AG", "TG", "Level"};
    private static String[] stats2 = new String[]{"IN", "WP", "CH", "CR", "Luck"};

    public StatusPanel() {
        super(Game.getQuestapp());
        this.setBackground(QuestApp.PANELCOLOUR);
    }

    public Dimension getPreferredSize() {
        return new Dimension(208, 272);
    }

    public void paint(Graphics graphics) {
        int n;
        Object object;
        super.paint(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        charwidth = fontMetrics.charWidth(' ');
        charheight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        charmaxascent = fontMetrics.getMaxAscent();
        Thing thing = Game.hero();
        Map map = thing.getMap();
        Rectangle rectangle = this.getBounds();
        int n2 = rectangle.width;
        int n3 = thing.getStat("HPS");
        int n4 = thing.getStat("HPSMAX");
        float f = (float)n3 / (float)n4;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        StatusPanel.paintLabel(graphics, "Health: " + n3 + "/" + n4, 10, 18);
        StatusPanel.paintBar(graphics, 10 + 16 * charwidth, 10, n2 - 20 - 16 * charwidth, 16, healthcolor, Color.black, f);
        int n5 = thing.getStat("MPS");
        int n6 = thing.getStat("MPSMAX");
        float f2 = (float)n5 / (float)n6;
        StatusPanel.paintLabel(graphics, "Power:  " + n5 + "/" + n6, 10, 44);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        StatusPanel.paintBar(graphics, 10 + 16 * charwidth, 36, n2 - 20 - 16 * charwidth, 16, powercolor, Color.black, f2);
        int n7 = 52 + charheight;
        this.paintStats(graphics, 10, n7);
        StatusPanel.paintLabel(graphics, "Exp: " + thing.getStat("Experience") + " / " + Hero.calcXPRequirement(thing.getStat("Level") + 1), 10, n7 += 5 * charheight);
        StatusPanel.paintLabel(graphics, "Hunger: " + Text.capitalise(Hero.hungerString(thing)), 10, n7 += charheight);
        StatusPanel.paintLabel(graphics, map == null ? "Six Feet Under" : map.getDescription(), 10, n7 += charheight);
        n7 += charheight;
        if (map != null && Game.isDebug()) {
            object = map.name();
            StatusPanel.paintLabel(graphics, "[" + (String)object + "] lv=" + map.getLevel(), 10, n7);
            n7 += charheight;
        }
        object = thing.getFlaggedContents("IsEffect");
        StringList stringList = new StringList();
        for (int i = 0; i < ((Thing[])object).length; ++i) {
            stringList.add(Text.capitalise(object[i].getString("EffectName")));
        }
        Thing thing2 = thing.getWielded(1);
        Thing thing3 = thing.getWielded(2);
        if (thing2 != null && Item.isDamaged(thing2)) {
            stringList.add("Damaged weapon");
        }
        if (thing3 != null && Item.isDamaged(thing3)) {
            stringList.add("Damaged weapon");
        }
        if (thing2 != null && !thing2.getFlag("IsWeapon")) {
            thing2 = null;
        }
        if (thing3 != null && !thing3.getFlag("IsWeapon")) {
            thing3 = null;
        }
        if (thing2 == null && thing3 == null) {
            stringList.add("Unarmed");
        }
        Thing[] thingArray = thing.getFlaggedContents("IsBeing");
        int n8 = 0;
        int n9 = 0;
        for (n = 0; n < thingArray.length; ++n) {
            if (thingArray[n].isHostile(thing)) {
                ++n9;
                continue;
            }
            ++n8;
        }
        if (n8 > 0) {
            stringList.add(Integer.toString(n8) + (n8 > 1 ? " companions" : " companion"));
        }
        if (n9 > 0) {
            stringList.add(Integer.toString(n9) + (n9 > 1 ? " enemies in pursuit" : " enemy in pusuit"));
        }
        stringList = stringList.compress();
        stringList = stringList.compact(21, ", ");
        for (n = 0; n < stringList.getCount(); ++n) {
            StatusPanel.paintLabel(graphics, stringList.getString(n), 20, n7);
            n7 += charheight;
        }
    }

    public void paintStats(Graphics graphics, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < stats1.length; ++n3) {
            this.paintStat(graphics, stats1[n3], n, n2 + n3 * charheight);
        }
        for (n3 = 0; n3 < stats2.length; ++n3) {
            this.paintStat(graphics, stats2[n3], n + 100, n2 + n3 * charheight);
        }
    }

    public void paintStat(Graphics graphics, String string, int n, int n2) {
        StatusPanel.paintLabel(graphics, string + ": " + Game.hero().getStat(string), n, n2);
    }

    public static void paintBar(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        int n5 = n4 / 4;
        graphics.setColor(color);
        graphics.fillRect(n, n2, (int)((float)n3 * f), n4);
        graphics.setColor(color.brighter());
        graphics.fillRect(n, n2, (int)((float)n3 * f), n5);
        graphics.setColor(color.darker());
        graphics.fillRect(n, n2 + 3 * n5, (int)((float)n3 * f), n4 - 3 * n5);
        graphics.setColor(color2);
        graphics.fillRect(n + (int)((float)n3 * f), n2, (int)((float)n3 * (1.0f - f)), n4);
        StatusPanel.paintBox(graphics, n, n2, n3, n4, false);
    }

    public static int paintLabel(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        graphics.drawString(string, n, n2 + charmaxascent - charheight / 2);
        return charwidth * string.length();
    }

    public static void paintBox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(QuestApp.PANELHIGHLIGHT);
        } else {
            graphics.setColor(QuestApp.PANELSHADOW);
        }
        graphics.fillRect(n, n2, n3, 1);
        graphics.fillRect(n, n2, 1, n4);
        if (!bl) {
            graphics.setColor(QuestApp.PANELHIGHLIGHT);
        } else {
            graphics.setColor(QuestApp.PANELSHADOW);
        }
        graphics.fillRect(n + 1, n2 + n4 - 1, n3 - 1, 1);
        graphics.fillRect(n + n3 - 1, n2 + 1, 1, n4 - 1);
    }
}

