/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import mikera.tyrant.AI;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Movement;
import mikera.tyrant.Point;
import mikera.tyrant.Poison;
import mikera.tyrant.RPG;
import mikera.tyrant.Recipe;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;

public class Spell {
    public static final int TARGET_NONE = 0;
    public static final int TARGET_SELF = 1;
    public static final int TARGET_LOCATION = 2;
    public static final int TARGET_DIRECTION = 3;
    public static final int TARGET_ITEM = 4;
    public static final int SPELL_USELESS = 0;
    public static final int SPELL_OFFENCE = 1;
    public static final int SPELL_DEFENCE = 2;
    public static final int SPELL_TACTICAL = 3;
    public static final int SPELL_ENCHANT = 4;
    public static final int SPELL_SUMMON = 5;
    private static ArrayList spellNames;
    private static final String[] orders;
    private static final double spellPowerMultiplier = 1.1;

    public static boolean isOrder(String string) {
        for (int i = 0; i < orders.length; ++i) {
            if (!orders[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void learn(Thing thing, String string) {
        Thing thing2 = Lib.create(string);
        if (thing2 == null) {
            throw new Error("Spell doesn't exist: " + string);
        }
        Thing thing3 = thing.getContents(string);
        if (thing3 != null) {
            thing.message("You already know the " + thing2.getName(Game.hero()) + " spell");
            return;
        }
        Game.message("You mind is filled with mystic knowledge");
        thing.addThing(thing2);
        Game.message("You now know the " + thing2.getName(Game.hero()) + " spell");
    }

    public static Thing randomSpell(int n) {
        return Lib.createType("IsSpell", n);
    }

    public static Thing randomSpell(String string, int n) {
        for (int i = 0; i < 100; ++i) {
            Thing thing = Spell.randomSpell(n);
            if (!string.equals(thing.getString("Order"))) continue;
            return thing;
        }
        Game.warn("Unable to create level " + n + " spell for order [" + string + "]");
        return null;
    }

    public static Thing randomOffensiveSpell(String string, int n) {
        for (int i = 0; i < 10; ++i) {
            Thing thing = Spell.randomSpell(string, n);
            if (thing.getStat("SpellUsage") != 1) continue;
            return thing;
        }
        Game.warn("Unable to create level " + n + " offensive spell for order [" + string + "]");
        return Lib.create("Magic Missile");
    }

    public static int castTime(Thing thing) {
        double d = 200.0;
        return (int)(d /= 1.0 + 0.25 * (double)thing.getStat("Spellcasting"));
    }

    public static boolean castAI(Thing thing, Thing thing2) {
        int n;
        int n2;
        Thing thing3;
        if (!Spell.canCast(thing, thing2)) {
            return false;
        }
        Map map = thing.getMap();
        if (thing2.getStat("SpellUsage") == 1) {
            Thing thing4;
            if (map == null) {
                return false;
            }
            Thing thing5 = map.findNearestFoe(thing);
            if (thing5 != null && ((thing4 = map.findNearestFoe(thing5)) == null || RPG.distSquared(thing4.x, thing4.y, thing5.x, thing5.y) > thing2.getStat("Radius"))) {
                if (thing5.isVisible(Game.hero()) || thing.isVisible(Game.hero())) {
                    Game.message(thing.getTheName() + " casts " + thing2.name() + " at " + thing5.getTheName());
                }
                Spell.castAtLocation(thing2, thing, map, thing5.x, thing5.y);
                Spell.castCost(thing, thing2);
                return true;
            }
            return false;
        }
        if (thing2.getStat("SpellUsage") == 2 && thing.getStat("HPS") < thing.getStat("HPSMAX")) {
            thing.visibleMessage(thing.getTheName() + " casts " + thing2.name());
            Spell.castAtSelf(thing2, thing);
            Spell.castCost(thing, thing2);
            return true;
        }
        if (thing2.getStat("SpellUsage") == 5 && thing.isVisible(Game.hero()) && (thing3 = map.findNearestFoe(thing)) != null && !map.isBlocked(n2 = (thing.x + thing3.x) / 2, n = (thing.y + thing3.y) / 2)) {
            Game.message(thing.getTheName() + " shouts words of summoning!");
            Spell.castAtLocation(thing2, thing, map, n2, n);
            Spell.castCost(thing, thing2);
            return true;
        }
        return false;
    }

    public static void train(Thing thing, Thing thing2) {
        int n;
        int n2 = thing.getStat("Level");
        int n3 = thing2.getStat("SpellSkill");
        int n4 = thing2.getStat("SpellCost");
        if (RPG.d(n2) <= n3) {
            return;
        }
        int n5 = thing.getStat("IN") * thing.getStat("IN");
        if (RPG.test(n5, n = n3 * n3 * n4)) {
            thing2.incStat("SpellSkill", 1);
        }
    }

    public static void castAtSelf(Thing thing, Thing thing2) {
        if (thing2 == null) {
            return;
        }
        if (thing.getStat("SpellTarget") == 2) {
            Spell.castAtLocation(thing, thing2, thing2.getMap(), thing2.x, thing2.y);
            return;
        }
        Game.instance().doSpark(thing2.x, thing2.y, thing.getStat("BoltImage"));
        Spell.doEffect(thing2, thing, thing2);
    }

    public static void castAtLocation(Thing thing, Thing thing2, Map map, int n, int n2) {
        if (map == null || thing.getStat("SpellTarget") != 2) {
            return;
        }
        int n3 = thing.getStat("Radius");
        int n4 = thing.getStat("BoltImage");
        if (map.isVisible(n, n2)) {
            if (thing2 != null) {
                Game.instance().doSpellShot(thing2.x, thing2.y, n, n2, thing.getStat("BoltImage"), 100.0, n3);
            } else {
                Game.instance().doExplosion(n, n2, n4, n3);
            }
        }
        if (thing2 != null) {
            double d = (double)thing2.x + 0.5;
            double d2 = (double)thing2.y + 0.5;
            int n5 = thing2.x;
            int n6 = thing2.y;
            double d3 = Math.sqrt((n5 - n) * (n5 - n) + (n6 - n2) * (n6 - n2));
            while (n5 != n || n6 != n2) {
                while (n5 == (int)d && n6 == (int)d2) {
                    d += 0.5 * (double)(n - thing2.x) / d3;
                    d2 += 0.5 * (double)(n2 - thing2.y) / d3;
                }
                n5 = (int)d;
                n6 = (int)d2;
                if (!thing.handles("OnPathEffect")) continue;
                Event event = new Event("PathEffect");
                event.set("TargetMap", map);
                event.set("TargetX", n5);
                event.set("TargetY", n6);
                if (!thing.handle(event)) continue;
                return;
            }
        }
        if (n3 > 0) {
            Spell.affectArea(thing, thing2, map, n, n2, n3);
            return;
        }
        Spell.affectLocation(thing, thing2, map, n, n2);
    }

    public static void castAtObject(Thing thing, Thing thing2, Thing thing3) {
        if (thing.getStat("SpellTarget") == 2) {
            Spell.castAtLocation(thing, thing2, thing3.getMap(), thing3.getMapX(), thing3.getMapY());
            return;
        }
        Spell.doEffect(thing2, thing, thing3);
    }

    public static void castInDirection(Thing thing, Thing thing2, int n, int n2) {
        int n3 = thing2.x + n;
        int n4 = thing2.y + n2;
        int n5 = thing.getStat("BoltImage");
        Game.instance().doSpark(n3, n4, n5);
        Spell.affectLocation(thing, thing2, thing2.getMap(), n3, n4);
    }

    public static void affectArea(Thing thing, Thing thing2, Map map, int n, int n2, int n3) {
        int n4 = n3;
        for (int i = -n4; i <= n4; ++i) {
            for (int j = -n4; j <= n4; ++j) {
                if (n4 * n4 + 1 < i * i + j * j) continue;
                Spell.affectLocation(thing, thing2, map, n + i, n2 + j);
            }
        }
    }

    public static String getOrder(String string) {
        return (String)Lib.get(string).get("Order");
    }

    public static boolean canLearn(Thing thing, String string) {
        String string2 = Spell.getOrder(string);
        return thing.getStat(string2) > 0;
    }

    public static boolean canCast(Thing thing, Thing thing2) {
        if (thing2.place != thing) {
            Game.warn("Spell.canCast: spell not in inventory!");
            return false;
        }
        String string = thing2.getString("Order");
        if (string.equals("Black Magic")) {
            int n = thing2.getStat("SpellCost");
            if (thing.getStat("MPS") < n) {
                return false;
            }
            int n2 = Recipe.checkIngredients(thing, thing2.getString("Ingredients"));
            return n2 > 0;
        }
        int n = thing2.getStat("Charges");
        return n > 0;
    }

    public static void castCost(Thing thing, Thing thing2) {
        thing.incStat("APS", -Spell.castTime(thing));
        String string = thing2.getString("Order");
        if (string.equals("True Magic") || string.equals("Holy Magic")) {
            thing2.incStat("Charges", -1);
        } else {
            thing.incStat("MPS", -thing2.getStat("SpellCost"));
        }
        String string2 = thing2.getString("Ingredients");
        if (string2 != null && !Recipe.removeIngredients(thing, string2)) {
            Game.warn("Bug: Not enough ingredients to cast!");
        }
    }

    public static int maxCharges(Thing thing, Thing thing2) {
        int n = thing2.getStat("SpellCost");
        if (n == 0) {
            return 0;
        }
        int n2 = thing.getStat("WP");
        return 1 + (n2 - 1) / n;
    }

    public static String chargeString(Thing thing, Thing thing2) {
        String string = thing2.getString("Order");
        if (string.equals("Black Magic")) {
            String string2;
            String string3 = thing2.getString("Ingredients");
            int n = Recipe.checkIngredients(thing, string3);
            int n2 = thing2.getStat("SpellCost");
            String string4 = string2 = n2 > 0 ? "+ cost: " + n2 : "";
            if (n > 0) {
                return "[ units: " + n + " " + string2 + "]";
            }
            return "[ needs: " + string3 + " " + string2 + "]";
        }
        return "[ charges: " + thing2.getStat("Charges") + " / " + Spell.maxCharges(thing, thing2) + " ]";
    }

    public static String powerString(Thing thing, Thing thing2) {
        return "{ skill: " + Spell.calcMagicSkill(thing, thing2) + " }";
    }

    private static String rechargeSkill(Thing thing) {
        String string = thing.getString("Order");
        if (string.equals("Holy Magic")) {
            return "Prayer";
        }
        return "Focus";
    }

    private static int chargeRate(Thing thing, Thing thing2) {
        int n = thing.getStat("WP");
        n *= 1 + thing.getStat(Spell.rechargeSkill(thing2));
        n *= thing2.getStat("ChargeRate");
        if ((n /= thing2.getStat("SpellCost")) <= 0) {
            Game.warn("Spell.cargeRate(...)==0 for " + thing2.name());
        }
        return n;
    }

    public static void rechargeSpells(Thing thing, int n) {
        Thing[] thingArray = thing.getFlaggedContents("IsSpell");
        int n2 = thingArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            Thing thing2 = thingArray[i];
            int n4 = Spell.maxCharges(thing, thing2);
            int n5 = thing2.getStat("Charges");
            int n6 = n4 - n5;
            if (n4 <= 0 || n6 <= 0 || !RPG.test(n * (n3 = Spell.chargeRate(thing, thing2) / n2), 1000000)) continue;
            thing2.incStat("Charges", 1);
            if (thing2.getBaseStat("Charges") != 1) continue;
            thing.message("You have regained enough power to cast " + thing2.name() + " again");
        }
    }

    public static void affectLocation(Thing thing, Thing thing2, Map map, int n, int n2) {
        Thing[] thingArray;
        if (thing.handles("OnLocationEffect")) {
            thingArray = new Event("LocationEffect");
            thingArray.set("TargetMap", map);
            thingArray.set("TargetX", n);
            thingArray.set("TargetY", n2);
            if (thing.handle((Event)thingArray)) {
                return;
            }
        }
        thingArray = map.getThings(n, n2);
        for (int i = 0; i < thingArray.length; ++i) {
            Spell.doEffect(thing2, thing, thingArray[i]);
        }
    }

    public static int getPower(Thing thing) {
        Game.assertTrue(thing.getFlag("IsSpell"));
        return thing.getStat("Power");
    }

    public static String selectionString(Thing thing, Thing thing2, int n) {
        return Text.centrePad(thing2.getString("Name"), Spell.powerString(thing, thing2) + " " + Spell.chargeString(thing, thing2), n);
    }

    public static Thing create(String string) {
        Thing thing = Lib.create(string);
        return thing;
    }

    private static int calcAntiMagic(Thing thing) {
        double d = thing.getStat("AntiMagic");
        return (int)(d += (double)thing.getStat("WP") * (1.0 + 0.7 * (double)thing.getStat("Magic Resistance")));
    }

    private static int calcMagicSkill(Thing thing, Thing thing2) {
        if (thing == null) {
            return (int)(5.0 * Math.pow(1.1, thing2.getLevel()));
        }
        int n = thing.getStat(thing2.getString("Order"));
        int n2 = (int)((double)thing.getStat("IN") * (0.85 + 0.15 * (double)thing.getStat("Spellcasting")) * (0.85 + 0.15 * (double)n));
        return n2;
    }

    private static int calcMagicPower(Thing thing, Thing thing2) {
        int n;
        Game.assertTrue(thing2.getFlag("IsSpell"));
        double d = 0.0;
        if (thing != null) {
            d = Spell.calcMagicSkill(thing, thing2);
        }
        if (d < (double)(n = thing2.getStat("SkillMin"))) {
            d = n;
        }
        if ((d = d * (double)thing2.getStat("PowerMultiplier") / 100.0 + (double)thing2.getStat("PowerBonus")) < 0.0) {
            d = 0.0;
        }
        return (int)d;
    }

    private static Script createSummonEffect(String string, int n, int n2) {
        SummonEffect summonEffect = new SummonEffect();
        summonEffect.set("SummonType", string);
        summonEffect.set("SummonMin", n);
        summonEffect.set("SummonMax", n2);
        return summonEffect;
    }

    private static void doEffect(Thing thing, Thing thing2, Thing thing3) {
        int n = Spell.calcMagicSkill(thing, thing2);
        int n2 = Spell.calcAntiMagic(thing3);
        int n3 = Spell.calcMagicPower(thing, thing2);
        boolean bl = true;
        boolean bl2 = thing3.isVisible(Game.hero());
        if (n2 > 0 && thing2.getStat("SpellUsage") == 1) {
            Game.warn("Magic test: " + (n += n3 / 5) + " vs. " + n2);
            boolean bl3 = bl = (float)n >= (float)n2 * RPG.luckRandom(thing, thing3);
        }
        if (thing != null && thing3.getFlag("IsBeing") && thing2.getStat("SpellUsage") == 1) {
            AI.notifyAttack(thing3, thing);
        }
        String string = thing2.getString("HitName");
        if (bl) {
            if (string != null) {
                thing3.message("You are hit by the " + string);
            }
            Event event = new Event("Effect");
            event.set("Strength", n3);
            event.set("Caster", thing);
            event.set("Target", thing3);
            thing2.handle(event);
        } else if (bl2) {
            Game.message(thing3.getTheName() + " " + thing3.verb("resist") + " the " + string);
        }
    }

    public static void addSpell(Thing thing) {
        String string = thing.getString("Name");
        spellNames.add(string);
        Game.assertTrue(thing.getFlag("IsSpell"));
        int n = thing.getStat("Level");
        Game.assertTrue(n > 0);
        thing.set("LevelMin", n);
        int n2 = thing.getStat("SpellCost") * 3;
        thing.set("SkillMin", n2);
        thing.set("Image", thing.getStat("BoltImage"));
        thing.set("ImageSource", "Effects");
        Lib.add(thing);
    }

    public static void updateIngredients() {
        Iterator iterator = spellNames.iterator();
        while (iterator.hasNext()) {
            Spell.updateIngredients(Lib.getLibraryInstance((String)iterator.next()));
        }
    }

    public static void updateIngredients(Thing thing) {
        int n = thing.getStat("Level");
        String string = thing.getString("Order");
        if (string.equals("Black Magic")) {
            thing.set("SpellCost", 0);
            String string2 = thing.getString("Ingredients");
            int n2 = thing.getStat("RandomIngredientCount");
            if (string2 == null && n2 <= 0) {
                Game.warn("Black Magic spell " + thing.name() + " has no ingredient list!");
            }
            for (int i = 0; i < n2; ++i) {
                Thing thing2 = Lib.createType("IsBlackIngredient", n);
                string2 = string2 == null ? thing2.name() : string2 + "," + thing2.name();
            }
            thing.set("Ingredients", string2);
        }
    }

    public static void addItemSpell(Thing thing) {
        Spell.addSpell(thing);
    }

    public static void addOffensiveSpell(Thing thing) {
        if (thing.getString("HitName") == null) {
            thing.set("HitName", thing.name() + " spell");
        }
        thing.set("IsOffensiveSpell", 1);
        Spell.addSpell(thing);
    }

    public static void addDefensiveSpell(Thing thing) {
        thing.set("IsDefensiveSpell", 1);
        Spell.addSpell(thing);
    }

    public static void addUtilitySpell(Thing thing) {
        Spell.addSpell(thing);
    }

    public static void initSummonSpells() {
        Thing thing = Lib.extend("base summon spell", "base defensive spell");
        thing.set("IsSummonSpell", 1);
        Lib.add(thing);
        thing = Lib.extend("Summon Creature", "base summon spell");
        thing.set("OnEffect", Spell.createSummonEffect("[IsBeast]", 1, 1));
        thing.set("SpellTarget", 1);
        thing.set("Frequency", 50);
        thing.set("BoltImage", 120);
        thing.set("LevelMin", 1);
        thing.set("SpellCost", 10);
        Lib.add(thing);
        thing = Lib.extend("Summon Undead", "base summon spell");
        thing.set("OnEffect", Spell.createSummonEffect("[IsUndead]", 2, 6));
        thing.set("SpellTarget", 1);
        thing.set("SpellOrder", "Black Magic");
        thing.set("Frequency", 50);
        thing.set("BoltImage", 120);
        thing.set("LevelMin", 8);
        thing.set("SpellCost", 30);
        Lib.add(thing);
        thing = Lib.extend("Summon Demons", "base summon spell");
        thing.set("OnEffect", Spell.createSummonEffect("[IsDemonic]", 2, 6));
        thing.set("SpellTarget", 1);
        thing.set("SpellOrder", "True Magic");
        thing.set("Frequency", 50);
        thing.set("BoltImage", 120);
        thing.set("LevelMin", 12);
        thing.set("SpellCost", 50);
        Lib.add(thing);
    }

    public static void initDefensiveSpells() {
        Thing thing = Lib.extend("base defensive spell", "base spell");
        thing.set("SpellTarget", 1);
        thing.set("SpellUsage", 2);
        thing.set("BoltImage", 121);
        thing.set("Frequency", 50);
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Bless", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 11);
        thing.set("SpellCost", 10);
        thing.set("OnEffect", AddScript.create("blessing", 100));
        thing.set("Order", "Holy Magic");
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Lucky Charm", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 1);
        thing.set("SpellCost", 1);
        thing.set("Ingredients", "blue mushroom");
        thing.set("OnEffect", AddScript.create("blessing", 100));
        thing.set("Order", "Black Magic");
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Stone Skin", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("Frequency", 50);
        thing.set("BoltImage", 81);
        thing.set("LevelMin", 7);
        thing.set("SpellCost", 5);
        thing.set("OnEffect", AddScript.create("stone skin", 100));
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("God's Protection", "Stone Skin");
        thing.set("Order", "Holy Magic");
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Cloak Of Stone", "Stone Skin");
        thing.set("LevelMin", 6);
        thing.set("Order", "Black Magic");
        thing.set("Ingredients", "blue mushroom,rock");
        Lib.add(thing);
        thing = Lib.extend("Inspire Fear", "base defensive spell");
        thing.set("LevelMin", 8);
        thing.set("SpellTarget", 1);
        thing.set("Frequency", 50);
        thing.set("SpellCost", 8);
        thing.set("OnEffect", AddScript.create("fearsome", 100));
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Holy Awe", "Inspire Fear");
        thing.set("Order", "Holy Magic");
        thing.set("LevelMin", 6);
        thing.set("SpellCost", 6);
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Haste", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 13);
        thing.set("SpellPowerMultiplier", 20);
        thing.set("SpellPowerBonus", 3);
        thing.set("SpellCost", 5);
        thing.set("OnEffect", AddScript.create("haste", 100));
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("God's Speed", "Haste");
        thing.set("SpellTarget", 1);
        thing.set("Order", "Holy Magic");
        thing.set("SpellPowerMultiplier", 30);
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Haste Self", "base defensive spell");
        thing.set("SpellTarget", 1);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 11);
        thing.set("SpellPowerMultiplier", 20);
        thing.set("SpellPowerBonus", 3);
        thing.set("SpellCost", 5);
        thing.set("OnEffect", AddScript.create("haste", 100));
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Teleport Self", "base defensive spell");
        thing.set("Level", 18);
        thing.set("SpellCost", 40);
        thing.set("SpellDamageMultiplier", 0);
        thing.set("BoltImage", 2);
        thing.set("OnEffect", new TeleportEffect());
        thing.set("Order", "True Magic");
        Spell.addDefensiveSpell(thing);
    }

    public static void initUtilitySpells() {
        Thing thing = Lib.extend("base utility spell", "base spell");
        thing.multiplyStat("ChargeRate", 0.2);
        thing.set("SpellUsage", 3);
        thing.set("BoltImage", 121);
        Lib.add(thing);
        thing = Lib.extend("Magic Shovel", "base utility spell");
        thing.set("SpellTarget", 3);
        thing.set("LevelMin", 14);
        thing.set("Frequency", 30);
        thing.set("SpellCost", 40);
        thing.set("Order", "True Magic");
        thing.set("OnLocationEffect", new Script(){
            private static final long serialVersionUID = 3979270248400893753L;

            public boolean handle(Thing thing, Event event) {
                Map map = (Map)event.get("TargetMap");
                if (map == null) {
                    return false;
                }
                int n = event.getStat("TargetX");
                int n2 = event.getStat("TargetY");
                Tile.dig(map, n, n2);
                return false;
            }
        });
        Spell.addUtilitySpell(thing);
        thing = Lib.extend("Open Rock", "Magic Shovel");
        thing.set("LevelMin", 14);
        thing.set("Frequency", 30);
        thing.set("Order", "Holy Magic");
        Spell.addUtilitySpell(thing);
    }

    public static void initCureSpells() {
        Thing thing = Lib.extend("base cure spell", "base defensive spell");
        thing.multiplyStat("ChargeRate", 0.5);
        thing.set("BoltImage", 21);
        Lib.add(thing);
        thing = Lib.extend("Cure Poison", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("LevelMin", 8);
        thing.set("Frequency", 50);
        thing.set("SpellPowerMultiplier", 20);
        thing.set("SpellPowerBonus", 8);
        thing.set("Order", "Holy Magic");
        thing.set("OnEffect", new CureScript());
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Curing Light", "Cure Poison");
        thing.set("SpellTarget", 2);
        thing.set("LevelMin", 10);
        thing.set("Frequency", 50);
        thing.set("SpellCost", 15);
        thing.set("BoltImage", 21);
        thing.set("Order", "True Magic");
        thing.set("OnEffect", new CureScript());
        Spell.addDefensiveSpell(thing);
    }

    public static void initHealingSpells() {
        Thing thing = Lib.extend("Light Heal", "base defensive spell");
        thing.set("SpellTarget", 1);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 1);
        thing.set("PowerMultiplier", 10);
        thing.set("PowerBonus", 3);
        thing.set("SpellCost", 3);
        thing.set("OnEffect", new HealingScript());
        thing.set("Order", "Holy Magic");
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Heal", "base defensive spell");
        thing.set("SpellTarget", 2);
        thing.set("Frequency", 50);
        thing.set("LevelMin", 3);
        thing.set("PowerMultiplier", 20);
        thing.set("PowerBonus", 3);
        thing.set("SpellCost", 5);
        thing.set("OnEffect", new HealingScript());
        thing.set("Order", "Holy Magic");
        Spell.addDefensiveSpell(thing);
        thing = Lib.extend("Heal Light Wounds", "Light Heal");
        thing.set("LevelMin", 3);
        thing.set("PowerMultiplier", 10);
        thing.set("PowerBonus", 3);
        thing.set("SpellCost", 4);
        thing.set("Order", "True Magic");
        Lib.add(thing);
        thing = Lib.extend("Heal Wounds", "Heal Light Wounds");
        thing.set("LevelMin", 10);
        thing.set("PowerMultiplier", 20);
        thing.set("PowerBonus", 6);
        thing.set("SpellCost", 12);
        thing.set("Order", "True Magic");
        Lib.add(thing);
        thing = Lib.extend("Healing Charm", "Heal");
        thing.set("Order", "Black Magic");
        thing.set("RandomIngredientCount", 1);
        thing.set("LevelMin", 1);
        Spell.addDefensiveSpell(thing);
    }

    public static ArrayList getSpellNames() {
        return (ArrayList)spellNames.clone();
    }

    public static void initCurseSpells() {
        Thing thing = Lib.extend("base curse spell", "base spell");
        thing.set("SpellTarget", 2);
        thing.set("BoltImage", 141);
        thing.set("SpellUsage", 1);
        thing.set("Order", "Black Magic");
        thing.set("Frequency", 50);
        thing.set("SpellRange", 6);
        Lib.add(thing);
        thing = Lib.extend("Curse", "base curse spell");
        thing.set("Level", 8);
        thing.set("SpellCost", 6);
        thing.set("HitName", "malevolent magic");
        thing.set("Radius", 0);
        Thing thing2 = Lib.create("curse");
        Script script = Scripts.addEffect("Target", thing2);
        thing.set("OnEffect", script);
        thing.set("Order", "Holy Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Blind", "base curse spell");
        thing.set("Level", 10);
        thing.set("SpellCost", 15);
        thing.set("HitName", "malevolent magic");
        thing.set("Radius", 0);
        thing2 = Lib.create("curse of blindness");
        script = Scripts.addEffect("Target", thing2);
        thing.set("OnEffect", script);
        thing.set("Order", "Black Magic");
        thing.set("RandomIngredientCount", 2);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Slow", "base curse spell");
        thing.set("Level", 10);
        thing.set("SpellCost", 15);
        thing.set("HitName", "malevolent magic");
        thing.set("Radius", 0);
        thing.set("OnEffect", AddScript.create("slow", 100));
        thing.set("Order", "Black Magic");
        thing.set("RandomIngredientCount", 1);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Confuse", "base curse spell");
        thing.set("Level", 16);
        thing.set("SpellCost", 15);
        thing.set("HitName", "malevolent magic");
        thing.set("Radius", 0);
        thing2 = Lib.create("confusion");
        script = Scripts.addEffect("Target", thing2);
        thing.set("OnEffect", script);
        thing.set("Order", "Black Magic");
        thing.set("RandomIngredientCount", 3);
        Spell.addOffensiveSpell(thing);
    }

    public static void initItemSpells() {
        Thing thing = Lib.extend("base item spell", "base spell");
        thing.set("SpellTarget", 4);
        thing.set("SpellUsage", 0);
        thing.set("OnEffect", new OffensiveEffect());
        thing.set("Frequency", 50);
        Lib.add(thing);
        thing = Lib.extend("Repair", "base item spell");
        thing.set("Level", 10);
        thing.set("SpellCost", 20);
        thing.set("SpellPowerMultiplier", 20);
        thing.set("OnEffect", new Script(){
            private static final long serialVersionUID = 3256999964814293296L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                Thing thing3 = event.getThing("Caster");
                int n = event.getStat("Strength");
                int n2 = thing2.getStat("HPSMAX") - thing2.getStat("HPS");
                if (n2 > 0 && RPG.test(n, n2)) {
                    Item.repair(thing2, false);
                    thing3.message(thing2.getYourName() + " glows brightly as it is restored to excellent condition");
                } else {
                    thing3.message(thing2.getYourName() + " glows faintly for a second but nothing else happens");
                }
                return true;
            }
        });
        Spell.addItemSpell(thing);
        thing = Lib.extend("Identify", "base item spell");
        thing.set("Level", 11);
        thing.set("SpellCost", 50);
        thing.set("SpellPowerMultiplier", 20);
        thing.set("OnEffect", new Script(){
            private static final long serialVersionUID = 3257002176856339760L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                Thing thing3 = event.getThing("Caster");
                Item.identify(thing2);
                thing2.set("IsStatusKnown", 1);
                thing3.message("You identify " + thing2.getTheName());
                return true;
            }
        });
        Spell.addItemSpell(thing);
        thing = Lib.extend("Destroy Item", "base item spell");
        thing.set("Level", 15);
        thing.set("SpellCost", 100);
        thing.set("OnEffect", new Script(){
            private static final long serialVersionUID = 3906363839908755504L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                Damage.inflict(thing2, 5000, "normal");
                if (thing2.place == null) {
                    Game.message(thing2.getTheName() + " " + thing2.is() + " turned to dust");
                } else {
                    Game.message(thing2.getTheName() + " trembles violently");
                }
                return true;
            }
        });
        Spell.addItemSpell(thing);
    }

    public static void initOffensiveSpells() {
        Thing thing = Lib.extend("base offensive spell", "base spell");
        thing.set("SpellTarget", 2);
        thing.set("SpellUsage", 1);
        thing.set("BoltImage", 1);
        thing.set("PowerMultiplier", 20);
        thing.set("PowerBonus", 2);
        thing.set("SpellDamageType", "normal");
        thing.set("OnEffect", new OffensiveEffect());
        thing.set("Frequency", 50);
        thing.set("SpellRange", 6);
        Lib.add(thing);
        thing = Lib.extend("Spark", "base offensive spell");
        thing.set("Level", 1);
        thing.set("SpellCost", 1);
        thing.set("PowerMultiplier", 20);
        thing.set("PowerBonus", 4);
        thing.set("BoltImage", 61);
        thing.set("HitName", "spark");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Flame Bolt", "base offensive spell");
        thing.set("Level", 2);
        thing.set("SpellCost", 2);
        thing.set("PowerMultiplier", 20);
        thing.set("PowerBonus", 5);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 1);
        thing.set("HitName", "flame");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Frost Bolt", "base offensive spell");
        thing.set("Level", 4);
        thing.set("SpellCost", 4);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 5);
        thing.set("SpellDamageType", "ice");
        thing.set("BoltImage", 101);
        thing.set("HitName", "ice");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Force Bolt", "base offensive spell");
        thing.set("Level", 6);
        thing.set("SpellCost", 6);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 4);
        thing.set("SpellDamageType", "impact");
        thing.set("BoltImage", 81);
        thing.set("HitName", "force bolt");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Magic Missile", "base offensive spell");
        thing.set("Level", 3);
        thing.set("SpellCost", 3);
        thing.set("PowerMultiplier", 40);
        thing.set("PowerBonus", 5);
        thing.set("BoltImage", 2);
        thing.set("HitName", "impact");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Punishment", "Magic Missile");
        thing.set("Order", "Holy Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Flame", "base offensive spell");
        thing.set("Level", 5);
        thing.set("SpellCost", 6);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 6);
        thing.set("SpellDamageType", "fire");
        thing.set("Order", "Black Magic");
        thing.set("OnLocationEffect", new CreateEffect("small fire", 100, false));
        thing.set("BoltImage", 1);
        thing.set("RandomIngredientCount", 1);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Teleport Monster", "base offensive spell");
        thing.set("Level", 13);
        thing.set("SpellCost", 20);
        thing.set("PowerMultiplier", 60);
        thing.set("BoltImage", 2);
        thing.set("OnEffect", new TeleportEffect());
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Fireball", "base offensive spell");
        thing.set("Level", 9);
        thing.set("SpellCost", 6);
        thing.set("PowerMultiplier", 40);
        thing.set("PowerBonus", 10);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 3);
        thing.set("Radius", 1);
        thing.set("HitName", "flames");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Wrath Of Fire", "Fireball");
        thing.set("Order", "Holy Magic");
        thing.set("Level", 10);
        thing.set("SpellCost", 8);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Ball Of Fire", "base offensive spell");
        thing.set("Level", 9);
        thing.set("SpellCost", 5);
        thing.set("PowerMultiplier", 40);
        thing.set("PowerBonus", 15);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 3);
        thing.set("Radius", 1);
        thing.set("HitName", "flames");
        thing.set("Order", "Black Magic");
        thing.set("Ingredients", "snake skin");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Ice Blast", "base offensive spell");
        thing.set("Level", 13);
        thing.set("SpellCost", 10);
        thing.set("PowerMultiplier", 35);
        thing.set("PowerBonus", 15);
        thing.set("SpellDamageType", "ice");
        thing.set("BoltImage", 103);
        thing.set("Radius", 2);
        thing.set("HitName", "icy blast");
        thing.set("Order", "True Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Acid Ball", "base offensive spell");
        thing.set("Level", 11);
        thing.set("SpellCost", 6);
        thing.set("PowerMultiplier", 40);
        thing.set("PowerBonus", 10);
        thing.set("SpellDamageType", "acid");
        thing.set("BoltImage", 23);
        thing.set("Radius", 1);
        thing.set("HitName", "burning acid");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Firepath", "base offensive spell");
        thing.set("Level", 17);
        thing.set("SpellCost", 12);
        thing.set("PowerMultiplier", 50);
        thing.set("PowerBonus", 25);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 3);
        thing.set("Radius", 1);
        thing.set("HitName", "searing flames");
        thing.set("OnPathEffect", new CreateEffect("small fire", 90));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Blast", "base offensive spell");
        thing.set("Level", 22);
        thing.set("SpellCost", 10);
        thing.set("PowerMultiplier", 45);
        thing.set("PowerBonus", 30);
        thing.set("SpellDamageType", "impact");
        thing.set("BoltImage", 3);
        thing.set("Radius", 2);
        thing.set("HitName", "blast");
        thing.set("Order", "True Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Blaze", "base offensive spell");
        thing.set("Level", 24);
        thing.set("SpellCost", 20);
        thing.set("PowerMultiplier", 50);
        thing.set("PowerBonus", 30);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 3);
        thing.set("Radius", 2);
        thing.set("HitName", "searing flames");
        thing.set("OnLocationEffect", new CreateEffect("small fire", 50));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Firestorm", "base offensive spell");
        thing.set("Level", 26);
        thing.set("SpellCost", 26);
        thing.set("PowerMultiplier", 55);
        thing.set("PowerBonus", 40);
        thing.set("SpellDamageType", "fire");
        thing.set("BoltImage", 3);
        thing.set("Radius", 3);
        thing.set("HitName", "roaring flames");
        thing.set("OnLocationEffect", new CreateEffect("medium fire", 70, false));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Poison Cloud", "base offensive spell");
        thing.set("Level", 7);
        thing.set("SpellCost", 0);
        thing.set("PowerMultiplier", 25);
        thing.set("PowerBonus", 5);
        thing.set("SpellDamageType", "poison");
        thing.set("Ingredients", "red snake skin,rat tail");
        thing.set("Order", "Black Magic");
        thing.set("BoltImage", 42);
        thing.set("Radius", 1);
        thing.set("HitName", "poison spray");
        thing.set("OnLocationEffect", new CreateEffect("poison cloud"));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Flame Cloud", "base offensive spell");
        thing.set("Level", 12);
        thing.set("SpellCost", 0);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 10);
        thing.set("SpellDamageType", "fire");
        thing.set("Order", "True Magic");
        thing.set("BoltImage", 2);
        thing.set("Radius", 1);
        thing.set("HitName", "flaming blast");
        thing.set("OnLocationEffect", new CreateEffect("flame cloud"));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Acid Cloud", "base offensive spell");
        thing.set("Level", 16);
        thing.set("SpellCost", 0);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 10);
        thing.set("SpellDamageType", "acid");
        thing.set("Order", "True Magic");
        thing.set("BoltImage", 22);
        thing.set("Radius", 1);
        thing.set("HitName", "acidic blast");
        thing.set("OnLocationEffect", new CreateEffect("acid cloud"));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Aruk's Poison Cloud", "base offensive spell");
        thing.set("Level", 7);
        thing.set("SpellCost", 4);
        thing.set("PowerMultiplier", 30);
        thing.set("PowerBonus", 10);
        thing.set("SpellDamageType", "poison");
        thing.set("BoltImage", 42);
        thing.set("Radius", 1);
        thing.set("HitName", "poison spray");
        thing.set("OnLocationEffect", new CreateEffect("poison cloud"));
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Thunderbolt", "base offensive spell");
        thing.set("Level", 21);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 25);
        thing.set("PowerMultiplier", 70);
        thing.set("PowerBonus", 100);
        thing.set("SpellDamageType", "shock");
        thing.set("HitName", "thunder bolt");
        thing.set("BoltImage", 22);
        thing.set("Order", "True Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Ball Lightning", "base offensive spell");
        thing.set("Level", 28);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 50);
        thing.set("PowerMultiplier", 60);
        thing.set("PowerBonus", 80);
        thing.set("SpellDamageType", "shock");
        thing.set("HitName", "lightning");
        thing.set("Radius", 1);
        thing.set("BoltImage", 62);
        thing.set("Order", "True Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Sheet Lightning", "base offensive spell");
        thing.set("Level", 32);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 50);
        thing.set("PowerMultiplier", 70);
        thing.set("PowerBonus", 100);
        thing.set("SpellDamageType", "shock");
        thing.set("HitName", "lightning");
        thing.set("Radius", 2);
        thing.set("BoltImage", 63);
        thing.set("Order", "True Magic");
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Annihilation", "base offensive spell");
        thing.set("Level", 34);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 100);
        thing.set("PowerMultiplier", 100);
        thing.set("PowerBonus", 200);
        thing.set("SpellDamageType", "disintegrate");
        thing.set("HitName", "pure destructive energy");
        thing.set("BoltImage", 85);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Gargash Vapouriser", "base offensive spell");
        thing.set("Level", 42);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 200);
        thing.set("PowerMultiplier", 100);
        thing.set("PowerBonus", 200);
        thing.set("SpellDamageType", "disintegrate");
        thing.set("HitName", "pure destructive energy");
        thing.set("BoltImage", 44);
        thing.set("Radius", 1);
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Void", "base offensive spell");
        thing.set("Level", 50);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 100);
        thing.set("PowerMultiplier", 100);
        thing.set("PowerBonus", 200);
        thing.set("SpellDamageType", "disintegrate");
        thing.set("HitName", "pure destructive energy");
        thing.set("BoltImage", 85);
        thing.set("OnLocationEffect", new Script(){
            private static final long serialVersionUID = 3979270248400893753L;

            public boolean handle(Thing thing, Event event) {
                Map map = (Map)event.get("TargetMap");
                if (map == null) {
                    return false;
                }
                int n = event.getStat("TargetX");
                int n2 = event.getStat("TargetY");
                map.setTile(n, n2, 40);
                return false;
            }
        });
        Spell.addOffensiveSpell(thing);
        thing = Lib.extend("Ultimate Destruction", "base offensive spell");
        thing.set("Level", 50);
        thing.set("Frequency", 0);
        thing.set("SpellCost", 1000);
        thing.set("PowerMultiplier", 100);
        thing.set("PowerBonus", 2000);
        thing.set("SpellDamageType", "special");
        thing.set("HitName", "pure destructive energy");
        thing.set("BoltImage", 85);
        thing.set("Radius", 4);
        Spell.addOffensiveSpell(thing);
    }

    public static String spellReport() {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Thing> arrayList = new ArrayList<Thing>();
        for (n = 0; n < spellNames.size(); ++n) {
            object2 = (String)spellNames.get(n);
            object = Lib.create((String)object2);
            arrayList.add((Thing)object);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Thing thing = (Thing)object;
                Thing thing2 = (Thing)object2;
                int n = thing.getString("Order").compareTo(thing2.getString("Order"));
                if (n != 0) {
                    return n;
                }
                int n2 = -(thing.getLevel() - thing2.getLevel());
                if (n2 != 0) {
                    return n2;
                }
                return 0;
            }
        });
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = (Thing)arrayList.get(n);
            object = ((Thing)object2).name();
            stringBuffer.append(Text.rightPad((String)object + ": ", 25));
            stringBuffer.append(Text.rightPad(((BaseObject)object2).getString("Order"), 20));
            stringBuffer.append(Text.rightPad("Lv. " + ((Thing)object2).getLevel(), 10));
            stringBuffer.append(Text.rightPad(((BaseObject)object2).getString("Ingredients"), 40));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void init() {
        spellNames = new ArrayList();
        Thing thing = Lib.extend("base spell", "base thing");
        thing.set("IsArt", 1);
        thing.set("IsSpell", 1);
        thing.set("Frequency", 100);
        thing.set("LevelMin", 1);
        thing.set("SpellCost", 8);
        thing.set("PowerMultiplier", 100);
        thing.set("PowerBonus", 0);
        thing.set("SpellTarget", 2);
        thing.set("SpellUsage", 1);
        thing.set("Order", "True Magic");
        thing.set("BoltImage", 2);
        thing.set("Radius", 0);
        thing.set("ChargeRate", 100);
        thing.set("Charges", 1);
        Lib.add(thing);
        Spell.initOffensiveSpells();
        Spell.initDefensiveSpells();
        Spell.initSummonSpells();
        Spell.initCurseSpells();
        Spell.initItemSpells();
        Spell.initHealingSpells();
        Spell.initCureSpells();
        Spell.initUtilitySpells();
    }

    static {
        orders = new String[]{"True Magic", "Holy Magic", "Black Magic"};
    }

    private static class AddScript
    extends Script {
        private static final long serialVersionUID = 3762529005907293232L;

        private AddScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            int n = this.getStat("Chance");
            String string = this.getString("Thing");
            if (n == 0) {
                n = 100;
            }
            if (RPG.r(100) < n) {
                thing2.addThing(Lib.create(string));
            }
            return false;
        }

        public static Script create(String string, int n) {
            AddScript addScript = new AddScript();
            addScript.set("Thing", string);
            addScript.set("Chance", n);
            return addScript;
        }
    }

    public static class CureScript
    extends Script {
        private static final long serialVersionUID = 3978138846573377330L;

        public boolean handle(Thing thing, Event event) {
            int n;
            Thing thing2 = event.getThing("Target");
            int n2 = n = event.getStat("Strength");
            Poison.cure(thing2, n2);
            return false;
        }
    }

    public static class HealingScript
    extends Script {
        private static final long serialVersionUID = 3257009860535989298L;

        public boolean handle(Thing thing, Event event) {
            int n;
            Thing thing2 = event.getThing("Target");
            int n2 = n = event.getStat("Strength");
            Being.heal(thing2, n2);
            return false;
        }
    }

    private static class OffensiveEffect
    extends Script {
        private static final long serialVersionUID = -1441648028619126968L;

        private OffensiveEffect() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            int n = event.getStat("Strength");
            if (n > 0) {
                int n2 = n;
                boolean bl = thing2.isVisible(Game.hero());
                int n3 = Damage.inflict(thing2, n2, thing.getString("SpellDamageType"));
                if (n3 > 0 && thing2.isDead()) {
                    String string;
                    String string2 = string = thing2.getFlag("IsLiving") ? "killed" : "destroyed";
                    if (bl) {
                        Game.message(thing2.getTheName() + " is " + string + " by the " + thing.getString("HitName"));
                    }
                }
            }
            return false;
        }
    }

    private static class SummonEffect
    extends Script {
        private static final long serialVersionUID = 1L;

        private SummonEffect() {
        }

        public boolean handle(Thing thing, Event event) {
            int n = this.getStat("SummonMin");
            int n2 = this.getStat("SummonMax");
            int n3 = RPG.rspread(n, n2);
            String string = this.getString("SummonType");
            Thing thing2 = event.getThing("Target");
            Map map = thing2.getMap();
            int n4 = thing2.getMapX();
            int n5 = thing2.getMapY();
            for (int i = 0; i < n3; ++i) {
                Point point = map.findFreeSquare(n4 - 1, n5 - 1, n4 + 1, n5 + 1);
                if (point == null || !map.isVisible(point.x, point.y)) {
                    point = map.findFreeSquare(n4 - 2, n5 - 2, n4 + 2, n5 + 2);
                }
                if (point == null || !map.isVisible(point.x, point.y)) {
                    point = map.findFreeSquare(n4 - 3, n5 - 3, n4 + 3, n5 + 3);
                }
                if (point == null) continue;
                Thing thing3 = Lib.create(string, thing2.getLevel() - 2);
                if (thing3.getFlag("IsBeing")) {
                    AI.setFollower(thing3, thing2);
                }
                Game.instance().doSpark(point.x, point.y, thing.getStat("BoltImage"));
                map.addThing(thing3, point.x, point.y);
                thing3.set("APS", -200);
            }
            return false;
        }
    }

    private static class TeleportEffect
    extends Script {
        private static final long serialVersionUID = 4049358595655349555L;

        private TeleportEffect() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            Map map = thing2.getMap();
            if (map == null) {
                return false;
            }
            Point point = map.findFreeSquare();
            if (point == null) {
                return false;
            }
            if (thing2.isHero()) {
                thing2.message("You teleport");
            } else {
                thing2.visibleMessage(thing2.getTheName() + " teleports");
            }
            Movement.teleport(thing2, map, point.x, point.y);
            return false;
        }
    }

    private static class CreateEffect
    extends Script {
        private static final long serialVersionUID = 4051047475630388276L;

        public CreateEffect(String string, int n, boolean bl) {
            this(string, n);
            this.set("NeedSpace", bl);
        }

        public CreateEffect(String string, int n) {
            this(string);
            this.set("Chance", n);
        }

        public CreateEffect(String string) {
            this.set("Chance", 100);
            this.set("NeedSpace", 1);
            this.set("SummonType", string);
        }

        public boolean handle(Thing thing, Event event) {
            Map map = (Map)event.get("TargetMap");
            if (map == null) {
                return false;
            }
            int n = event.getStat("TargetX");
            int n2 = event.getStat("TargetY");
            int n3 = this.getStat("Chance");
            boolean bl = this.getFlag("NeedSpace");
            if (!(RPG.r(100) >= n3 || bl && map.isBlocked(n, n2))) {
                String string = this.getString("SummonType");
                Thing thing2 = Lib.create(string);
                map.addThing(thing2, n, n2);
            }
            return false;
        }
    }
}

