/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.HashMap;
import mikera.tyrant.AI;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Recipe;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Trap;

public class Skill {
    private static final String[] names = new String[]{"Riding", "Archery", "Athletics", "Throwing", "Tracking", "Climbing", "Dodge", "Swimming", "Survival", "Attack", "Defence", "Parry", "Ferocity", "Unarmed Combat", "Mighty Blows", "Bravery", "Weapon Lore", "Alertness", "Pickpocket", "Lockpicking", "Disarm Traps", "Prayer", "Holy Magic", "Meditation", "Healing", "Literacy", "Item Lore", "Alchemy", "Languages", "Rune Lore", "Herb Lore", "Black Magic", "True Magic", "Magic Resistance", "Spellcasting", "Music", "Perception", "Sleight Of Hand", "Storytelling", "Seduction", "Painting", "Smithing", "Stealth", "Mining", "Appraisal", "Woodwork", "Ropework", "Construction", "Trading", "Farming", "Cooking", "Focus"};
    public static final String RIDING = "Riding";
    public static final String ARCHERY = "Archery";
    public static final String ATHLETICS = "Athletics";
    public static final String THROWING = "Throwing";
    public static final String TRACKING = "Tracking";
    public static final String CLIMBING = "Climbing";
    public static final String DODGE = "Dodge";
    public static final String SWIMMING = "Swimming";
    public static final String SURVIVAL = "Survival";
    public static final String DEFENCE = "Defence";
    public static final String ATTACK = "Attack";
    public static final String PARRY = "Parry";
    public static final String FEROCITY = "Ferocity";
    public static final String UNARMED = "Unarmed Combat";
    public static final String MIGHTYBLOW = "Mighty Blows";
    public static final String BRAVERY = "Bravery";
    public static final String WEAPONLORE = "Weapon Lore";
    public static final String TACTICS = "Tactics";
    public static final String ALERTNESS = "Alertness";
    public static final String PICKPOCKET = "Pickpocket";
    public static final String PICKLOCK = "Lockpicking";
    public static final String DISARM = "Disarm Traps";
    public static final String STEALTH = "Stealth";
    public static final String PRAYER = "Prayer";
    public static final String HOLYMAGIC = "Holy Magic";
    public static final String MEDITATION = "Meditation";
    public static final String HEALING = "Healing";
    public static final String LITERACY = "Literacy";
    public static final String IDENTIFY = "Item Lore";
    public static final String ALCHEMY = "Alchemy";
    public static final String LANGUAGES = "Languages";
    public static final String RUNELORE = "Rune Lore";
    public static final String HERBLORE = "Herb Lore";
    public static final String STRATEGY = "Strategy";
    public static final String BLACKMAGIC = "Black Magic";
    public static final String TRUEMAGIC = "True Magic";
    public static final String MAGICRESISTANCE = "Magic Resistance";
    public static final String CASTING = "Spellcasting";
    public static final String FOCUS = "Focus";
    public static final String MUSIC = "Music";
    public static final String CON = "Deception";
    public static final String PERCEPTION = "Perception";
    public static final String SLEIGHT = "Sleight Of Hand";
    public static final String STORYTELLING = "Storytelling";
    public static final String SEDUCTION = "Seduction";
    public static final String PAINTING = "Painting";
    public static final String SMITHING = "Smithing";
    public static final String APPRAISAL = "Appraisal";
    public static final String WOODWORK = "Woodwork";
    public static final String ROPEWORK = "Ropework";
    public static final String CONSTRUCTION = "Construction";
    public static final String TRADING = "Trading";
    public static final String FARMING = "Farming";
    public static final String COOKING = "Cooking";
    public static final String MINING = "Mining";
    private static final HashMap descs = new HashMap();

    public static boolean isSkill(String string) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSkillIgnoreCase(String string) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static String ensureCase(String string) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(string)) continue;
            return names[i];
        }
        return string;
    }

    public static ArrayList getList(Thing thing) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String string = names[i];
            int n = thing.getStat(string);
            if (n <= 0) continue;
            if (n > 1) {
                string = string + " " + Text.roman(n);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] fullList() {
        return names;
    }

    public static ArrayList getUnmarkedList(Thing thing) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String string = names[i];
            int n = thing.getStat(string);
            if (n <= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] getTrainableSkills() {
        int n = names.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public static String trim(String string) {
        string = string.trim();
        while (!Skill.isSkill(string) && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void add(Thing thing, String string, int n) {
        if (!Skill.isSkill(string = Skill.trim(string))) {
            throw new Error("Not a skill: " + string);
        }
        thing.incStat(string, n);
    }

    public static boolean train(Thing thing, String string) {
        if (thing.getStat("SkillPoints") <= 0) {
            thing.message("You don't seem able to learn any more");
            return false;
        }
        thing.message("You train your " + string + " skill");
        Skill.add(thing, string, 1);
        thing.incStat("APS", -1000);
        thing.incStat("SkillPoints", -1);
        thing.incStat("SkillPointsSpent", 1);
        return true;
    }

    public static boolean apply(Thing thing, String string) {
        if ((string = Skill.trim(string)).equals(PICKPOCKET)) {
            return Skill.applyPickPocket(thing);
        }
        if (string.equals(DISARM)) {
            return Trap.applyDisarmTraps(thing);
        }
        if (Recipe.isRecipeSkill(string)) {
            return Recipe.apply(thing, string);
        }
        thing.message("The " + string + " skill is used automatically");
        if (descs.containsKey(string)) {
            thing.message((String)descs.get(string));
        }
        return false;
    }

    public static boolean applyPickPocket(Thing thing) {
        Game.message("Pickpocket: select direction");
        Point point = Game.getDirection();
        Map map = thing.getMap();
        int n = thing.getStat(PICKPOCKET);
        if (point != null) {
            Thing thing2 = map.getFlaggedObject(thing.x + point.x, thing.y + point.y, "IsMobile");
            if (thing2 == null) {
                Game.message("");
                return false;
            }
            int n2 = thing.getStat("SK") * n;
            if (RPG.test(n2, thing2.getStat("SK"), thing, thing2)) {
                Thing[] thingArray = thing2.getItems();
                if (thingArray.length > 0) {
                    Thing thing3 = thingArray[RPG.r(thingArray.length)];
                    if (thing3.y == 0 && !thing3.getFlag("IsTheftProof")) {
                        thing.addThingWithStacking(thing3);
                        Game.message("You steal " + thing3.getAName());
                        Item.steal(thing, thing3);
                    } else {
                        Game.message("You almost manage to steal " + thing3.getAName());
                    }
                } else {
                    Game.message("You find nothing worth stealing");
                }
            } else if (RPG.test(n2, thing2.getStat("IN"), thing, thing2)) {
                Game.message("You are unable to steal anything");
            } else {
                Game.message(thing2.getTheName() + " spots you!");
                AI.turnNasty(thing2);
            }
            return true;
        }
        return false;
    }

    public static void init() {
        descs.put(RIDING, "This skill allows you to ride horses and other riding animals");
        descs.put(ATTACK, "This skill improves your chance of hitting opponents and increases the amount of damage that you inflict in close combat");
        descs.put(DEFENCE, "This skill reduces your chance of being hit and damaged in close combat, particularly when using shields and armour");
        descs.put(UNARMED, "This skill improves your ability to fight in close combat without a weapon");
        descs.put(DODGE, "This skill improves your ability to dodge missile and avoid enemy attacks in hand to hand combat");
        descs.put(CASTING, "This skill enables you to cast magical spells with increased effectiveness");
        descs.put(SURVIVAL, "This skill enables you survive longer in the wild by finding food in unexpected places");
        descs.put(BRAVERY, "This skill enables you to resist the effects of fear and fight effectively when outnumbered");
        descs.put(IDENTIFY, "This skill enables you to identify items that you discover");
        descs.put(ALERTNESS, "This skill helps you to notice hidden items, traps and secret doors");
        descs.put(ARCHERY, "This skill improves your ability at firing ranged weapons such as bows");
        descs.put(THROWING, "This skill improves your ability with throwing weapons such as knives or darts");
        descs.put(TRACKING, "This skill improves your chances of hunting down prey in the wilderness");
        descs.put(FOCUS, "This skill improves your ability to recharge your mental energies");
    }
}

