/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Door;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Score;
import mikera.tyrant.Thing;

public class Secret {
    public static void searchAround() {
        Thing thing = Game.hero();
        Map map = thing.getMap();
        if (map == null) {
            Game.warn("Hero not on map in Secret.searchAround!");
            return;
        }
        if (thing.getFlag("IsBlind")) {
            Game.message("You fumble around ineffectively");
            return;
        }
        boolean bl = Secret.search();
        if (!bl) {
            Game.message("You search but find nothing of interest");
        }
    }

    public static boolean search() {
        Thing thing = Game.hero();
        boolean bl = false;
        Thing[] thingArray = thing.getMap().getThings(thing.x - 1, thing.y - 1, thing.x + 1, thing.y + 1);
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            bl |= Secret.search(thing2);
        }
        return bl;
    }

    public static boolean search(Thing thing) {
        Map map = thing.getMap();
        if (!thing.getFlag("IsSecret")) {
            return false;
        }
        if (thing.getFlag("IsSecretDoor")) {
            Game.message("You have found a secret door!");
            map.setTile(thing.x, thing.y, map.floor());
            String string = thing.getString("SecretDoorType");
            Thing thing2 = string == null ? Door.createDoor(map.getLevel()) : Lib.create(string);
            Score.scoreSecretDoor(map.getLevel());
            map.addThing(thing2, thing.x, thing.y);
            map.setVisible(thing.x, thing.y);
            thing.remove();
            return true;
        }
        if (thing.getFlag("IsTrap") && thing.getFlag("IsInvisible")) {
            Game.message("You have found a " + thing.name() + "!!");
            thing.set("IsDiscovered", 1);
            thing.set("IsInvisible", 0);
            return true;
        }
        if (thing.getFlag("IsSecretPassage")) {
            Game.message("You have found a hidden passage!");
            map.setTile(thing.x, thing.y, map.floor());
            thing.remove();
            return true;
        }
        if (thing.getFlag("IsHiddenItem")) {
            Thing thing3 = (Thing)thing.get("HiddenThing");
            if (thing3 == null) {
                String string = thing.getString("HiddenItem");
                thing3 = string == null ? Lib.createItem(map.getLevel()) : Lib.create(string);
            }
            Game.message("You have discovered " + thing3.getAName() + "!");
            map.addThing(thing3, thing.x, thing.y);
            thing.remove();
            return true;
        }
        return false;
    }

    public static Thing hide(Thing thing) {
        Thing thing2 = Lib.create("secret item");
        thing2.set("HiddenThing", thing);
        thing.remove();
        thing2.addThing(thing);
        return thing2;
    }

    public static void init() {
        Thing thing = Lib.extend("base secret", "base special");
        thing.set("IsPhysical", 0);
        thing.set("IsDestructible", 0);
        thing.set("Image", 5);
        thing.set("IsSecret", 1);
        thing.set("ASCII", "o");
        Lib.add(thing);
        thing = Lib.extend("secret door", "base secret");
        thing.set("IsSecretDoor", 1);
        Lib.add(thing);
        thing = Lib.extend("secret passage", "base secret");
        thing.set("IsSecretPassage", 1);
        Lib.add(thing);
        thing = Lib.extend("secret item", "base secret");
        thing.set("IsHiddenItem", 1);
        Lib.add(thing);
    }
}

