/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.LevelMap;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Scroll {
    private static final String[] titles = new String[]{"thgil eb ereht tel", "gniht yxes ouy", "ybab atsiv al atsah", "senob meht fo elip dlo gib", "ekul ecrof eht esu", "strohs ym tae", "eno ylno eb nac ereht", "evah reven nac i gnihtemos", "eloh a ekil daeh", "ereh morf bup eht ees nac i", "naeb a dna sbeeh owt hsart etihw", "siht tuoba gnileef egnarts a teg i", "gniht taht ezis eht ta kool", "elbmur ot ydaer teg stel", "kcab eb lli", "em ta gnikool uoy era", "su ot gnoleb era esab ruoy lla", "su ot gnoleb era srevres ruoy lla", "su ot gnoleb era slous ruoy lla", "su ot gnoleb era sllorcs ruoy lla", "su ot gnoleb si lirhtim ruoy lla", "dnuora uoy deciton evi", "nosredna leahcim yb tnaryt", "stunococ fo hcnub ylevol", "ereh saw rennureldnurt eztlawfpmad", "ereh saw toofgib daorb", "ereh saw rakabraz igons", "no og tsum wohs eht", "xinu ton sung", "xinu ton sung", "yug a tahw", "yawa og", "zelur tnaryt", "zelur xunil", "nedbeh nerrad ot xnaht", "nosredna ssur ot xnaht", "llem noj ot zteerg", "reywob luap ot zteerg", "yreffej nitram ot zteerg", "nwod gnillaf si egdirb nodnol", "ruof dna dnasuoht owt snehta dnalgne og", "drows ecin a tahw", "avaj rof nus sknaht", "egrofecruos ot sknaht", "egrofecruos yb detsoh", "seripmav tsniaga cilrag esu", "nos ym kcowrebbaj eht eraweb", "tnediserp rof sunil", "dnalrob ot xnaht", "nitram ot tcepser ffun", "ettolrahc dna sirhc gniddew yppah", "evol i eno eht ot detacided", "uoy htiw eb ecrof eht yam", "meht dnib to gnir eno", "lla meht elur to gnir eno", "dlrow eth fo yaw eht"};
    private static final String[] specialtitles = new String[]{"?toor tog", "eerf eb ot stnaw erawtfos", "ybab atsiv al atsah", "senob meht fo elip dlo gib", "nosredna ssur ot xnaht", "llem noj ot zteerg", "reywob luap ot zteerg", "yreffej nitram ot zteerg", "nwod gnillaf si egdirb nodnol", "ruof dna dnasuoht owt snehta dnalgne og", "drows ecin a tahw", "avaj rof nus sknaht", "egrofecruos ot sknaht", "egrofecruos yb detsoh", "seripmav tsniaga cilrag esu", "nos ym kcowrebbaj eht eraweb", "tnediserp rof sunil", "dnalrob ot xnaht", "nitram ot tcepser ffun", "ettolrahc dna sirhc gniddew yppah", "evol i eno eht ot detacided", "uoy htiw eb ecrof eht yam", "meht dnib to gnir eno", "lla meht elur to gnir eno", "dlrow eth fo yaw eht", "ssab eht pu pmup"};

    public static Thing createScroll(int n) {
        return Lib.createType("IsScroll", n);
    }

    public static void init() {
        Thing thing = Lib.extend("base scroll", "base item");
        thing.set("IsScroll", 1);
        thing.set("IsReadable", 1);
        thing.set("OnRead", new ReadScrollScript());
        thing.set("OnDeath", new DestroyScrollScript());
        thing.set("IsMagicItem", 1);
        thing.set("Image", 280);
        thing.set("HPS", 2);
        thing.set("RES:water", -10);
        thing.set("ValueBase", 450);
        thing.set("ItemWeight", 200);
        thing.set("Frequency", 60);
        thing.set("ASCII", "?");
        Lib.add(thing);
        Scroll.initNotes();
        Scroll.initSpellScrolls();
        Scroll.initSpecialScrolls();
    }

    private static void addScroll(Thing thing) {
        Lib.add(thing);
    }

    public static Thing note(String string, String string2) {
        Thing thing = Lib.create(string);
        thing.set("Text", string2);
        return thing;
    }

    private static void initNotes() {
        Thing thing = Lib.extend("base note", "base scroll");
        thing.set("IsMagicItem", 0);
        thing.set("IsNote", 1);
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3256722862197913397L;

            public boolean handle(Thing thing, Event event) {
                Game.warn("note read script:");
                if (event.getThing("Reader") != Game.hero()) {
                    return false;
                }
                String string = thing.getString("Text");
                Game.warn(string);
                Game.infoScreen(string);
                return false;
            }
        });
        thing.set("OnDeath", null);
        thing.set("ValueBase", 1);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 1);
        thing.set("Frequency", 0);
        Lib.add(thing);
        thing = Lib.extend("scribbled note", "base note");
        thing.set("Text", "This note is blank");
        Lib.add(thing);
        thing = Lib.extend("note", "base note");
        thing.set("Text", "Reminder: feed wood urchins");
        Lib.add(thing);
        thing = Lib.extend("pamphlet", "base note");
        thing.set("Text", "Visit Rusty's Potions for bargain prices!");
        Lib.add(thing);
    }

    private static void addSpecialScroll(Thing thing) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < specialtitles.length; ++i) {
            arrayList.add(specialtitles[i]);
        }
        String string = (String)arrayList.remove(RPG.r(arrayList.size()));
        thing.set("UName", "weird scroll titled \"" + string + "\"");
        thing.set("UNamePlural", "weird scrolls titled \"" + string + "\"");
        Scroll.addScroll(thing);
    }

    public static void initSpellScrolls() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < titles.length; ++i) {
            arrayList.add(titles[i]);
        }
        ArrayList arrayList2 = Spell.getSpellNames();
        int n = arrayList2.size();
        if (n > arrayList.size()) {
            Game.warn("Not enough scroll titles!!");
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList2.get(i);
            Thing thing = Spell.create(string);
            String string2 = (String)arrayList.remove(RPG.r(arrayList.size()));
            Thing thing2 = Lib.extend("xxx scroll", "base scroll");
            thing2.set("Name", "scroll of " + string);
            thing2.set("Image", 280 + RPG.r(4));
            thing2.set("NamePlural", "scrolls of " + string);
            thing2.set("UName", "scroll titled \"" + string2 + "\"");
            thing2.set("UNamePlural", "scrolls titled \"" + string2 + "\"");
            thing2.set("ScrollSpell", string);
            thing2.set("Frequency", RPG.d(2, 100) * thing.getStat("Frequency") / 100);
            if (string.equals("Identify")) {
                thing2.set("Frequency", 100);
                thing2.set("IsIdentifyScroll", 1);
            }
            thing2.set("ScrollPower", 10);
            thing2.set("LevelMin", RPG.max(1, thing.getLevel() - 10));
            Scroll.addScroll(thing2);
        }
    }

    public static void initSpecialScrolls() {
        Thing thing = Lib.extend("scroll of amnesia", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3761967168350336050L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                thing2.message("Your head spins... where are you?");
                LevelMap.forget(thing2.getMap(), 80);
                return true;
            }
        });
        thing.set("LevelMin", 1);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of mapping", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3760560888616269105L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Reader");
                thing2.message("You suddenly know this place like the back of your hand");
                LevelMap.reveal(thing2.getMap());
                thing.remove(1);
                return true;
            }
        });
        thing.set("LevelMin", 1);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of item destruction", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3763091964450451513L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Thing[] thingArray = thing2.getItems();
                if (thingArray.length == 0) {
                    Game.message("Your head hurts for a second");
                    return true;
                }
                Thing thing3 = thingArray[RPG.r(thingArray.length)];
                if (thing.getFlag("IsBlessed")) {
                    thing3 = Game.selectItem("Select an item to target: ", thingArray);
                }
                if (thing3 == null) {
                    return false;
                }
                if (!thing3.getFlag("IsArtifact")) {
                    thing3.die();
                } else {
                    thing2.message(thing3.getTheName() + " shudders for a second");
                }
                return true;
            }
        });
        thing.set("LevelMin", 1);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of great identification", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3834315042081354553L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Thing[] thingArray = thing2.getItems();
                for (int i = 0; i < thingArray.length; ++i) {
                    Item.identify(thingArray[i]);
                }
                Game.message("Your mind is filled with great knowledge about all your posessions");
                return true;
            }
        });
        thing.set("ValueBase", 5000);
        thing.set("LevelMin", 1);
        thing.set("IsIdentifyScroll", 1);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of item redistribution", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3257571710911001395L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Map map = thing2.getMap();
                Thing[] thingArray = thing2.getItems();
                boolean bl = false;
                for (int i = 0; i < thingArray.length; ++i) {
                    if (!thing.getFlag("IsCursed") && RPG.d(2) == 1 || !thing.getFlag("IsBlessed") && thingArray[i].getFlag("IsCursed")) continue;
                    map.addThing(thingArray[i]);
                    bl = true;
                }
                if (bl) {
                    Game.message("Some of your posessions have been teleported away");
                } else {
                    Game.message("You feel a strange force around you... but it passes");
                }
                return true;
            }
        });
        thing.set("LevelMin", 4);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of total identification", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3761409733168806195L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Thing[] thingArray = thing2.getItems();
                Game.message("Your mind is filled with great knowledge about all your posessions");
                for (int i = 0; i < thingArray.length; ++i) {
                    Item.identify(thingArray[i]);
                }
                return true;
            }
        });
        thing.set("LevelMin", 10);
        thing.set("IsIdentifyScroll", 1);
        thing.set("ValueBase", 5000);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of curse detection", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3257290244557582388L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Thing[] thingArray = thing2.getItems();
                boolean bl = false;
                for (int i = 0; i < thingArray.length; ++i) {
                    Thing thing3 = thingArray[i];
                    if (!thing3.getFlag("IsCursed")) continue;
                    thing3.set("IsStatusKnown", 1);
                    bl = true;
                }
                if (bl) {
                    Game.message("You shudder with an uneasy chill");
                } else {
                    Game.message("You feel a strong sense of relief");
                }
                return true;
            }
        });
        thing.set("LevelMin", 1);
        Scroll.addSpecialScroll(thing);
        thing = Lib.extend("scroll of item cursing", "base scroll");
        thing.set("OnRead", new Script(){
            private static final long serialVersionUID = 3016187993514949388L;

            public boolean handle(Thing thing, Event event) {
                thing.remove(1);
                Thing thing2 = event.getThing("Reader");
                Thing[] thingArray = thing2.getItems();
                boolean bl = false;
                for (int i = RPG.d(6); i > 0; --i) {
                    Thing thing3 = thingArray[RPG.r(thingArray.length)];
                    if (RPG.d(4) != 1 || thing3.getFlag("IsArtifact") || thing3.getFlag("IsCursed")) continue;
                    thing2.message(thing3.getYourName() + " turns black for a second");
                    thing3.set("IsCursed", 1);
                    thing3.set("IsBlessed", 0);
                    thing3.set("IsStatusKnown", 1);
                    bl = true;
                }
                if (bl) {
                    Game.message("You shudder with an uneasy chill");
                } else {
                    Game.message("You feel a strong sense of relief");
                }
                return true;
            }
        });
        thing.set("LevelMin", 1);
        Scroll.addSpecialScroll(thing);
    }

    private static class ReadScrollScript
    extends Script {
        private static final long serialVersionUID = -90663348604771008L;

        private ReadScrollScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Reader");
            if (!thing.getFlag("IsScroll")) {
                System.out.println("Not a scroll!");
                return false;
            }
            if (!thing2.isHero()) {
                return false;
            }
            Item.identify(thing);
            String string = thing.getString("ScrollSpell");
            if (string != null) {
                Thing thing3 = Spell.create(string);
                QuestApp.getInstance().getScreen().castSpell(thing2, thing3);
                thing.remove(1);
            }
            return true;
        }
    }

    private static class DestroyScrollScript
    extends Script {
        private static final long serialVersionUID = -8023348676467373601L;

        private DestroyScrollScript() {
        }

        public boolean handle(Thing thing, Event event) {
            String string = thing.getString("ScrollSpell");
            if (string == null) {
                return false;
            }
            Thing thing2 = Spell.create(string);
            Spell.castAtLocation(thing2, null, (Map)event.get("DeathMap"), event.getStat("DeathX"), event.getStat("DeathY"));
            return false;
        }
    }
}

