/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.ListScreen;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;

public class Recipe {
    private static ArrayList recs = new ArrayList();

    public static void init() {
        Thing thing = Lib.extend("base recipe", "base thing");
        thing.set("IsRecipe", 1);
        thing.set("NoStack", 1);
        Lib.add(thing);
        thing = Lib.extend("base recipe scroll", "base scroll");
        thing.set("IsRecipeScroll", 1);
        thing.set("OnRead", new ReadRecipeScrollScript());
        thing.set("ValueBase", 100);
        thing.set("Frequency", 20);
        Lib.add(thing);
        Recipe.initRecipes();
    }

    public static int checkIngredients(Thing thing, String string) {
        if (string == null) {
            return 999999;
        }
        try {
            String[] stringArray = string.split(",");
            int n = 999999;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string2 = stringArray[i].trim();
                int n3 = 1;
                if (Character.isDigit(string2.charAt(0))) {
                    n2 = string2.indexOf(" ");
                    n3 = Integer.parseInt(string2.substring(0, n2));
                    string2 = string2.substring(n2 + 1);
                }
                n2 = thing.countIdentifiedItems(string2);
                n = RPG.min(n, n2 / n3);
            }
            return n;
        }
        catch (Throwable throwable) {
            Game.warn("Problem checking ingredients [" + string + "]");
            return 0;
        }
    }

    public static boolean removeIngredients(Thing thing, String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i].trim();
            int n2 = 1;
            if (Character.isDigit(string2.charAt(0))) {
                n = string2.indexOf(" ");
                n2 = Integer.parseInt(string2.substring(0, n));
                string2 = string2.substring(n + 1);
            }
            if ((n = thing.removeItems(string2, n2)) == n2) continue;
            return false;
        }
        return true;
    }

    public static void register(String string, Thing thing, int n) {
        thing.set("RecipeOrder", string);
        thing.set("RecipeIngredientCount", n);
        recs.add(thing);
    }

    private static void addRecipe(Thing thing) {
        Lib.add(thing);
        String string = thing.getString("RecipeOrder");
        Thing thing2 = Lib.extend("instructions for a " + Recipe.recipeResult(thing).get("Name"), "base recipe scroll");
        thing2.set("NamePlural", thing2.get("Name"));
        thing2.set("UName", "instructions for a strange " + Recipe.recipeName(thing.getString("RecipeOrder")));
        thing2.set("UNamePlural", thing2.get("UName"));
        thing2.set("NameType", 2);
        thing2.set("RecipeName", thing.name());
        thing2.set("Level", thing.getStat("Level"));
        thing2.set("LevelMin", thing.getStat("Level"));
        thing2.set(Recipe.recipeScrollTag(string), 1);
        Lib.add(thing2);
    }

    public static boolean isRecipeSkill(String string) {
        return !Recipe.orderTag(string).equals("Any");
    }

    private static String orderTag(String string) {
        if (string.equals("Alchemy")) {
            return "Alchemy";
        }
        if (string.equals("Black Magic")) {
            return "Black";
        }
        if (string.equals("Rune Lore")) {
            return "Rune";
        }
        if (string.equals("Herb Lore")) {
            return "Herb";
        }
        return "Any";
    }

    private static String ingredientTag(String string) {
        String string2 = Recipe.orderTag(string);
        if (string2 != null) {
            return "Is" + string2 + "Ingredient";
        }
        return null;
    }

    private static String recipeTag(String string) {
        String string2 = Recipe.orderTag(string);
        if (string2 != null) {
            return "Is" + string2 + "Recipe";
        }
        return null;
    }

    private static String recipeScrollTag(String string) {
        String string2 = Recipe.orderTag(string);
        if (string2 != null) {
            return "Is" + string2 + "RecipeScroll";
        }
        return null;
    }

    private static String recipeName(String string) {
        if (string.equals("Alchemy")) {
            return "concoction";
        }
        if (string.equals("Black Magic")) {
            return "rite";
        }
        if (string.equals("Rune Lore")) {
            return "runescript";
        }
        return "recipe";
    }

    private static Thing chooseIngredient(String string, String string2, int n) {
        Thing thing = null;
        int n2 = 0;
        String string3 = Recipe.ingredientTag(string2);
        while (thing == null) {
            thing = Lib.createType(string3, n + RPG.d(10) - RPG.d(10));
            if (++n2 > 30) {
                Game.warn("Can't choose ingredient for " + string + " [" + string3 + "," + n + "]");
                return thing;
            }
            if (!thing.name().equals(string)) continue;
            thing = null;
        }
        return thing;
    }

    private static void initRecipes() {
        int n = recs.size();
        for (int i = 0; i < n; ++i) {
            Thing thing = (Thing)recs.get(i);
            String string = thing.getString("RecipeOrder");
            String string2 = thing.getString("RecipeIngredients");
            int n2 = thing.getStat("Level") + 3;
            String string3 = thing.name();
            String string4 = string3 + " " + Recipe.recipeName(string);
            Thing thing2 = Lib.extend(string4, "base recipe");
            thing2.set("RecipeName", string3);
            int n3 = thing.getStat("RecipeIngredientCount");
            if (n3 <= 0) {
                n3 = 2;
            }
            if (string2 == null || string2.equals("")) {
                string2 = "";
            } else if (n3 > 0) {
                string2 = string2 + ",";
            }
            for (int j = 0; j < n3; ++j) {
                string2 = string2 + Recipe.chooseIngredient(string3, string, n2).name() + ",";
            }
            if (n3 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            thing2.set("RecipeOrder", string);
            thing2.set("Level", n2);
            thing2.set("LevelMin", n2);
            thing2.set("Ingredients", string2);
            thing2.set(Recipe.recipeTag(string), 1);
            Recipe.addRecipe(thing2);
        }
        recs.clear();
    }

    public static boolean apply(Thing thing, String string) {
        String string2;
        String string3;
        Serializable serializable;
        Thing[] thingArray = thing.getFlaggedContents("IsRecipe");
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (int i = 0; i < thingArray.length; ++i) {
            serializable = thingArray[i];
            if (!((BaseObject)serializable).getString("RecipeOrder").equals(string)) continue;
            string3 = ((BaseObject)serializable).getString("Ingredients");
            int n = Recipe.checkIngredients(thing, string3);
            string2 = ((BaseObject)serializable).getString("RecipeName") + "  (" + string3 + "  stock: " + n + ")";
            arrayList.add(string2);
            hashMap.put(string2, serializable);
        }
        ListScreen listScreen = new ListScreen("Select your recipe:", arrayList);
        serializable = QuestApp.getInstance().getScreen();
        QuestApp.getInstance().switchScreen(listScreen);
        string3 = (String)listScreen.getObject();
        QuestApp.getInstance().switchScreen((Component)serializable);
        if (string3 != null) {
            Thing thing2 = (Thing)hashMap.get(string3);
            string2 = thing2.getString("Ingredients");
            int n = Recipe.checkIngredients(thing, string2);
            if (n <= 0) {
                Game.message("You do not have the necessary ingredients!");
                Game.message("You need " + string2);
                return false;
            }
            Recipe.removeIngredients(thing, string2);
            Thing thing3 = Recipe.recipeResult(thing2);
            Game.message("You make " + thing3.getAName());
            Item.identify(thing3);
            thing.addThing(thing3);
        }
        return false;
    }

    protected static Thing recipeResult(Thing thing) {
        String string = thing.getString("RecipeName");
        Thing thing2 = Lib.create(string);
        return thing2;
    }

    private static class ReadRecipeScrollScript
    extends Script {
        private static final long serialVersionUID = 3977020660478586934L;

        private ReadRecipeScrollScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Reader");
            String string = thing.getString("RecipeName");
            Thing thing3 = Lib.create(string);
            String string2 = thing3.getString("RecipeOrder");
            Item.identify(thing);
            if (thing2.getStat(string2) <= 0) {
                Game.message("You identify " + thing.getTheName());
                Game.message("You must acquire the " + string2 + " skill in order to learn this recipe");
                return true;
            }
            thing2.addThing(thing3);
            thing.remove(1);
            Thing thing4 = Recipe.recipeResult(thing3);
            Item.identify(thing4);
            Game.message("You now know how to make " + thing4.getAName());
            return true;
        }
    }
}

