/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import mikera.tyrant.Animal;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Outdoors {
    public static Map create(int n) {
        Map map = new Map(65, 65);
        map.setEntrance(Portal.create());
        map.addThing(map.getEntrance(), 32, 32);
        Outdoors.buildOutdoors(map, 0, 0, map.width - 1, map.height - 1, n);
        map.set("Description", "Somewhere in the Wild");
        map.set("WanderingRate", 100);
        map.set("IsHostile", 0);
        map.set("ForgetMap", 1);
        map.set("EnterMessage", "");
        map.set("Level", 1);
        return map;
    }

    public static void buildOutdoors(Map map, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 - n + 1;
        int n7 = n4 - n2 + 1;
        int n8 = n6 * n7;
        switch (n5) {
            case 19: {
                Serializable serializable;
                int n9;
                map.setTheme("plains");
                map.fillArea(n, n2, n3, n4, map.floor());
                for (n9 = 0; n9 < n8 / (20 + RPG.d(100)); ++n9) {
                    serializable = map.findFreeSquare();
                    map.addThing(Lib.create("bush"), ((Point)serializable).x, ((Point)serializable).y);
                }
                for (n9 = 0; n9 < n8 / 400; ++n9) {
                    map.addThing(Lib.create("stone"), n, n2, n3, n4);
                    map.addThing(Lib.create("tree stump"), n, n2, n3, n4);
                }
                Point point = map.findFreeSquare(n, n2, n3, n4);
                map.addThing(Lib.create("tree stump"), point.x, point.y);
                map.addThing(Lib.create("secret item"), point.x, point.y);
                if (RPG.d(6 + Game.hero().getStat("Herb Lore")) < 6) break;
                serializable = Lib.createType("IsHerb", RPG.d(10));
                int n10 = 7;
                int n11 = RPG.rspread(n, n3 - n10);
                int n12 = RPG.rspread(n2, n4 - n10);
                for (int i = n11; i < n11 + n10; ++i) {
                    for (int j = n12; j < n12 + n10; ++j) {
                        if (RPG.d(5) != 1 || map.getTile(i, j) != map.floor()) continue;
                        map.addThing(((Thing)serializable).cloneType(), i, j);
                    }
                }
                break;
            }
            case 21: {
                Point point;
                int n13;
                map.setTheme("plains");
                map.fillArea(n, n2, n3, n4, map.floor());
                for (n13 = 0; n13 < n8 / 10; ++n13) {
                    map.setTile(n + RPG.r(n6), n2 + RPG.r(n7), 21);
                }
                for (n13 = 0; n13 < n8 / 40; ++n13) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("pine tree"), point.x, point.y);
                }
                for (n13 = 0; n13 < n8 / 80; ++n13) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("tree stump"), point.x, point.y);
                }
                for (n13 = 0; n13 < n8 / 80; ++n13) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("pebble"), point.x, point.y);
                }
                for (n13 = 0; n13 < n8 / 80; ++n13) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("rock"), point.x, point.y);
                }
                if (RPG.d(10) != 1) break;
                map.addThing(Portal.create("dungeon"));
                break;
            }
            case 22: {
                map.setTheme("plains");
                map.fillArea(n, n2, n3, n4, map.floor());
                for (int i = 0; i < 10; ++i) {
                    int n14 = RPG.r(n6);
                    int n15 = RPG.r(n7);
                    map.spray(n14 - 6, n15 - 6, n14 + 6, n15 + 6, 22, 20);
                }
                break;
            }
            case 29: {
                int n16;
                map.setTheme("swamp");
                map.fillArea(n, n2, n3, n4, map.floor());
                for (n16 = n; n16 <= n3; n16 += 8) {
                    for (int i = n2; i <= n4; i += 8) {
                        int n17 = RPG.pick(new int[]{19, map.floor(), map.floor()});
                        map.setTile(n16, i, n17);
                    }
                }
                map.fractalize(n, n2, n3, n4, 8);
                for (n16 = 0; n16 < n8 / 40; ++n16) {
                    Point point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("thorny bush"), point.x, point.y);
                }
                break;
            }
            case 20: {
                Point point;
                int n18;
                map.setTheme("woods");
                map.fillArea(n, n2, n3, n4, map.floor());
                for (n18 = 0; n18 < n8 / 20; ++n18) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("tree"), point.x, point.y);
                }
                for (n18 = 0; n18 < n8 / 80; ++n18) {
                    point = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(Lib.create("tree stump"), point.x, point.y);
                }
                if (RPG.d(6 + Game.hero().getStat("Farming")) < 6) break;
                map.incStat("Level", RPG.r(6));
                String string = "mushroom";
                switch (RPG.d(6)) {
                    case 1: {
                        string = "plant";
                        break;
                    }
                    case 2: {
                        string = "[IsHerb]";
                        break;
                    }
                    case 3: {
                        string = "mushroom";
                        break;
                    }
                    case 4: {
                        string = "[IsMushroom]";
                    }
                }
                for (int i = 0; i < n8 / (1 + RPG.d(100)); ++i) {
                    Point point2 = map.findFreeSquare(n, n2, n3, n4);
                    map.addThing(string, point2.x, point2.y);
                    map.incStat("WanderingRate", 1);
                }
                map.addThing("tree monster", n, n2, n3, n4);
                break;
            }
            case 18: {
                map.fillArea(n, n2, n3, n4, n5);
                break;
            }
            default: {
                throw new Error("Outdoor type " + n5 + "not recognised");
            }
        }
        Point point = map.findFreeSquare(n, n2, n3, n4);
        Outdoors.addBeasties(map, point.x, point.y);
        int n19 = RPG.r(2 + Game.hero().getStat("Tracking") * 2);
        for (int i = 0; i < n19; ++i) {
            map.addThing(Animal.create(map.getLevel()));
        }
    }

    public static void addBeasties(Map map, int n, int n2) {
        Thing thing = Lib.createCreature(map.getLevel());
        for (int i = RPG.d(thing.getStat("GroupNumber")); i > 0; --i) {
            int n3;
            int n4 = n - 2 + RPG.r(5);
            if (!map.isClear(n4, n3 = n2 - 2 + RPG.r(5))) continue;
            map.addThing(thing.cloneType(), n4, n3);
        }
    }
}

