/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import mikera.tyrant.QuestApp;

public class ImageGadget
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected Image image;
    private boolean noImage = false;
    private int imageWidth = 0;
    protected Image backgroundImage;
    protected String resourceName;
    protected ActionListener actionListener;
    protected boolean loadLater;
    protected static Map images = new HashMap();
    protected boolean loadFailed;
    private String text;

    public ImageGadget() {
        this.addMouseListener(new ForwardingMouseListener());
    }

    public ImageGadget(String string) {
        this(string, null);
    }

    public ImageGadget(String string, String string2) {
        this();
        this.resourceName = string;
        this.text = string2;
    }

    public static ImageGadget noImage(String string) {
        ImageGadget imageGadget = new ImageGadget();
        imageGadget.text = string;
        imageGadget.noImage = true;
        return imageGadget;
    }

    public void addActionListener(ActionListener actionListener) {
        this.setActionListener(AWTEventMulticaster.add(actionListener, this.actionListener));
    }

    public static Map getImages() {
        return images;
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (this.text != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n = fontMetrics.stringWidth(this.text);
            n2 = fontMetrics.getHeight();
        }
        if (this.noImage) {
            return new Dimension(n, n2);
        }
        if (this.image == null && !this.loadLater) {
            this.lookupImage();
        }
        if (this.image == null) {
            return new Dimension(18 + n, 16);
        }
        return new Dimension(this.image.getWidth(null) + 2 + n, this.image.getHeight(null));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected static synchronized Image imageFor(ImageGadget imageGadget) throws AWTException {
        String string = imageGadget.resourceName;
        if (string == null) {
            return null;
        }
        Image image = (Image)ImageGadget.getImages().get(string);
        if (image == null) {
            imageGadget.loadImage();
            ImageGadget.getImages().put(string, imageGadget.image);
            image = imageGadget.image;
        }
        return image;
    }

    protected void loadImage() throws AWTException {
        Image image = null;
        InputStream inputStream = this.getClass().getResourceAsStream(this.resourceName);
        if (inputStream == null) {
            this.loadFailed = true;
            throw new AWTException("Image resource " + this.resourceName + " not found.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 1024;
        byte[] byArray = new byte[n];
        if (inputStream == null) {
            return;
        }
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, n)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
            image = Toolkit.getDefaultToolkit().createImage(byArray);
        }
        catch (IOException iOException) {
            System.out.println("Error reading image data");
            iOException.printStackTrace();
        }
        this.setImage(image);
        if (this.loadLater) {
            return;
        }
        this.waitForImage();
    }

    protected void lookupImage() {
        try {
            if (this.loadFailed) {
                return;
            }
            Image image = ImageGadget.imageFor(this);
            this.setImage(image);
        }
        catch (AWTException aWTException) {
            this.loadFailed = true;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (!this.noImage && this.resourceName == null || this.loadFailed) {
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, n, n2);
            graphics.drawLine(n, 0, 0, n2);
            if (this.text != null) {
                graphics.drawString(this.text, 18, n2 / 2);
            }
            return;
        }
        if (!this.noImage && this.image == null) {
            this.lookupImage();
        }
        if (this.backgroundImage != null) {
            this.paintBackground(graphics, n, n2);
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, (n2 - this.image.getHeight(null)) / 2, this);
        }
        if (this.text != null) {
            graphics.setColor(QuestApp.INFOTEXTCOLOUR);
            int n3 = (this.getSize().height + graphics.getFontMetrics().getAscent()) / 2;
            graphics.drawString(this.text, this.image == null ? 0 : this.imageWidth + 2, n3 - 2);
        }
    }

    private void paintBackground(Graphics graphics, int n, int n2) {
        int n3 = this.backgroundImage.getWidth(null);
        for (int i = 0; i < n; i += n3) {
            for (int j = 0; j < n2; j += n2) {
                graphics.drawImage(this.backgroundImage, i, j, null);
            }
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.setActionListener(AWTEventMulticaster.remove(actionListener, this.actionListener));
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setImage(Image image) {
        this.image = image;
        this.imageWidth = image.getWidth(null);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setNoImage(boolean bl) {
        this.noImage = bl;
    }

    public static void setImages(Hashtable hashtable) {
        images = hashtable;
    }

    public void waitForImage() {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 1456);
        try {
            mediaTracker.waitForID(1456);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error reading image data");
            interruptedException.printStackTrace();
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    private final class ForwardingMouseListener
    implements MouseListener {
        private ForwardingMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
            if (ImageGadget.this.actionListener == null) {
                return;
            }
            ImageGadget.this.actionListener.actionPerformed(new ActionEvent(this, -100, null));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

