/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mikera.tyrant.AI;
import mikera.tyrant.Action;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.CharacterScreen;
import mikera.tyrant.Combat;
import mikera.tyrant.Damage;
import mikera.tyrant.Door;
import mikera.tyrant.Dungeon;
import mikera.tyrant.Event;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.GameHandler;
import mikera.tyrant.IActionHandler;
import mikera.tyrant.InfoScreen;
import mikera.tyrant.InventoryScreen;
import mikera.tyrant.Item;
import mikera.tyrant.LevelMapPanel;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.MapPanel;
import mikera.tyrant.MessagePanel;
import mikera.tyrant.Movement;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.Potion;
import mikera.tyrant.Quest;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Screen;
import mikera.tyrant.Secret;
import mikera.tyrant.Skill;
import mikera.tyrant.Spell;
import mikera.tyrant.StatusPanel;
import mikera.tyrant.Text;
import mikera.tyrant.TextZone;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;
import mikera.tyrant.Time;
import mikera.tyrant.Wish;
import mikera.tyrant.author.MapMaker;

public class GameScreen
extends Screen {
    private static final long serialVersionUID = 3907207143852421428L;
    private MapPanel mappanel;
    public MessagePanel messagepanel;
    public StatusPanel statuspanel;
    protected GameHandler gameHandler = new GameHandler();
    public Map map;
    private InventoryScreen inventoryScreen;
    private List actionHandlers;
    private LevelMapPanel levelMap = null;
    private String lastSkill = null;
    private static Thing lastSpell = null;

    public void addActionHandler(IActionHandler iActionHandler) {
        if (this.actionHandlers == null) {
            this.actionHandlers = new LinkedList();
        }
        this.actionHandlers.add(iActionHandler);
    }

    public void setGameHandler(GameHandler gameHandler) {
        this.gameHandler = gameHandler;
    }

    public GameHandler getGameHandler() {
        return this.gameHandler;
    }

    public void mainLoop() {
        this.map = Game.hero().getMap();
        this.endTurn();
        Game.over = false;
        KeyEvent keyEvent = null;
        Action action = null;
        while (!Game.over) {
            try {
                Thing thing = Game.hero();
                if (!Game.instance().lineOfSightDisabled()) {
                    this.getMappanel().viewPosition(this.map, thing.x, thing.y);
                }
                if (!this.tryTick(thing, action = this.convertEventToAction(keyEvent = this.getUserInput(keyEvent)), keyEvent.isShiftDown())) continue;
                this.ensureHerosNotDead();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.questapp.gameOver();
    }

    public boolean tryTick(Thing thing, Action action, boolean bl) {
        if (action == null) {
            return false;
        }
        this.performAction(thing, action, bl);
        this.endTurn();
        return true;
    }

    private void ensureHerosNotDead() {
        this.questapp.switchScreen(this);
        if (Game.hero().place == null || Game.hero().getStat("HPS") <= 0) {
            Game.message("You have died.....");
            Game.over = true;
        }
    }

    public Action convertEventToAction(KeyEvent keyEvent) {
        if (this.rejectEvent(keyEvent)) {
            return null;
        }
        return this.gameHandler.actionFor(keyEvent);
    }

    private KeyEvent getUserInput(KeyEvent keyEvent) {
        Game.instance().clearMessageList();
        if (Game.hero().isRunning()) {
            return keyEvent;
        }
        return Game.getInput();
    }

    public GameScreen(QuestApp questApp) {
        super(questApp);
        if (questApp == null) {
            return;
        }
        questApp.setScreen(this);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.messagepanel = new MessagePanel(questApp);
        this.add((Component)this.messagepanel, "South");
        this.mappanel = new MapPanel(this);
        this.add((Component)this.mappanel, "Center");
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.add("East", panel);
        this.statuspanel = new StatusPanel();
        panel.add("Center", this.statuspanel);
        this.levelMap = new LevelMapPanel();
        panel.add((Component)this.levelMap, "South");
        this.setFont(QuestApp.mainfont);
    }

    public void performAction(Thing thing, Action action, boolean bl) {
        Object object;
        Game.actor = thing;
        Game.message("");
        if (this.actionHandlers != null) {
            object = this.actionHandlers.iterator();
            while (object.hasNext()) {
                IActionHandler iActionHandler = (IActionHandler)object.next();
                if (!iActionHandler.handleAction(thing, action, bl)) continue;
                return;
            }
        }
        if (action == Action.WAIT) {
            this.doWait(thing);
        } else if (action.isMovementKey()) {
            this.gameHandler.doDirection(thing, action, bl);
        } else if (action == Action.EXIT) {
            this.doExit(thing);
        } else if (action == Action.HELP) {
            this.doHelp();
        } else if (action == Action.SHOW_QUESTS) {
            this.doShowQuests();
        } else if (action == Action.INVENTORY) {
            this.doInventory(thing);
        } else if (action == Action.MESSAGES) {
            this.doMessages();
        } else if (action == Action.VIEW_STATS) {
            this.doViewStats(thing);
        } else if (action == Action.ZOOM_OUT) {
            this.doZoom(25);
        } else if (action == Action.ZOOM_IN) {
            this.doZoom(-25);
        } else if (action == Action.SAVE_GAME) {
            if (Game.save() < 0) {
                Game.message("Save game failed.");
            }
        } else {
            if (action == Action.LOAD_GAME) {
                Game.restore();
                return;
            }
            if (action == Action.DEBUG) {
                this.doDebugKeys(thing);
            } else {
                if (thing.getMap().getFlag("IsWorldMap")) {
                    thing.message("You must enter an area by pressing \"x\" first");
                    return;
                }
                if (action == Action.APPLY_SKILL) {
                    this.doApplySkill(thing);
                } else if (action == Action.CHAT) {
                    this.doChat(thing);
                } else if (action == Action.DROP) {
                    this.doDrop(thing, false);
                } else if (action == Action.DROP_EXTENDED) {
                    this.doDrop(thing, true);
                } else if (action == Action.EAT) {
                    this.doEat(thing);
                } else if (action == Action.FIRE) {
                    this.doFire(thing);
                } else if (action == Action.GIVE) {
                    this.doGive(thing);
                } else if (action == Action.JUMP) {
                    this.doJump(thing);
                } else if (action == Action.KICK) {
                    this.doKick(thing);
                } else if (action == Action.LOOK) {
                    this.doLook();
                } else if (action == Action.OPEN) {
                    this.doOpen(thing);
                } else if (action == Action.PICKUP) {
                    this.doPickup(thing, false);
                } else if (action == Action.PICKUP_EXTENDED) {
                    this.doPickup(thing, true);
                } else if (action == Action.QUAFF) {
                    this.doQuaff(thing);
                } else if (action == Action.READ) {
                    this.doRead(thing);
                } else if (action == Action.SEARCH) {
                    this.doSearch(thing);
                } else if (action == Action.THROW) {
                    this.doThrow(thing);
                } else if (action == Action.USE) {
                    this.doUse(thing);
                } else if (action == Action.WIELD) {
                    this.doWield(thing);
                } else if (action == Action.PRAY || action == Action.PRAY2) {
                    this.doPray(thing, action);
                } else if (action == Action.ZAP) {
                    this.doZap(thing, true);
                } else if (action == Action.ZAP_AGAIN) {
                    this.doZap(thing, false);
                } else if (Game.isDebug() && action == Action.SELECT_TILE && (object = Game.selectItem("Select a tile:", Tile.tiles)) != null) {
                    this.getMappanel().currentTile = ((Thing)object).getStat("TileValue");
                }
            }
        }
    }

    private boolean rejectEvent(KeyEvent keyEvent) {
        return (keyEvent.getModifiers() | 0x200) > 0 && keyEvent.getKeyCode() == 18;
    }

    public InventoryScreen getInventoryScreen() {
        if (this.inventoryScreen == null) {
            this.inventoryScreen = new InventoryScreen();
        }
        return this.inventoryScreen;
    }

    public Point getSpellTargetLocation(Thing thing, Thing thing2) {
        Thing thing3;
        Map map = thing.getMap();
        Thing thing4 = thing3 = thing2.getStat("SpellUsage") == 1 ? map.findNearestFoe(thing) : null;
        if (thing3 != null && !map.isVisible(thing3.x, thing3.y)) {
            thing3 = null;
        }
        if (thing3 == null) {
            if (thing2.getStat("SpellUsage") == 1) {
                Point point = new Point(thing.x + thing.getStat("DirectionX"), thing.y + thing.getStat("DirectionY"));
                return this.getTargetLocation(map, point);
            }
            return this.getTargetLocation(thing);
        }
        return this.getTargetLocation(thing3);
    }

    public Point getTargetLocation() {
        return this.getTargetLocation(Game.hero());
    }

    public Point getTargetLocation(Thing thing) {
        if (thing == null) {
            thing = Game.hero();
        }
        return this.getTargetLocation(thing.getMap(), new Point(thing.x, thing.y));
    }

    public Point getTargetLocation(Map map, Point point) {
        if (point == null) {
            return this.getTargetLocation();
        }
        this.getMappanel().setCursor(point.x, point.y);
        this.getMappanel().viewPosition(map, point.x, point.y);
        this.doLookPoint(new Point(this.getMappanel().curx, this.getMappanel().cury));
        List list = this.map.findStuff(Game.hero(), 3);
        int n = 0;
        this.statuspanel.repaint();
        while (true) {
            KeyEvent keyEvent;
            if ((keyEvent = Game.getInput()) == null) {
                continue;
            }
            int n2 = Character.toLowerCase(keyEvent.getKeyChar());
            int n3 = keyEvent.getKeyCode();
            switch (n3) {
                case 38: {
                    n2 = 56;
                    break;
                }
                case 40: {
                    n2 = 50;
                    break;
                }
                case 37: {
                    n2 = 52;
                    break;
                }
                case 39: {
                    n2 = 54;
                    break;
                }
                case 36: {
                    n2 = 55;
                    break;
                }
                case 35: {
                    n2 = 49;
                    break;
                }
                case 33: {
                    n2 = 57;
                    break;
                }
                case 34: {
                    n2 = 51;
                    break;
                }
                case 27: {
                    n2 = 113;
                }
            }
            int n4 = 0;
            int n5 = 0;
            switch (n2) {
                case 42: 
                case 108: 
                case 120: {
                    if (n >= list.size()) {
                        n = 0;
                    }
                    Point point2 = (Point)list.get(n);
                    ++n;
                    if (point2 == null) {
                        point2 = point;
                    }
                    n4 = point2.x - this.getMappanel().curx;
                    n5 = point2.y - this.getMappanel().cury;
                    break;
                }
                case 56: {
                    n4 = 0;
                    n5 = -1;
                    break;
                }
                case 50: {
                    n4 = 0;
                    n5 = 1;
                    break;
                }
                case 52: {
                    n4 = -1;
                    n5 = 0;
                    break;
                }
                case 54: {
                    n4 = 1;
                    n5 = 0;
                    break;
                }
                case 55: {
                    n4 = -1;
                    n5 = -1;
                    break;
                }
                case 57: {
                    n4 = 1;
                    n5 = -1;
                    break;
                }
                case 49: {
                    n4 = -1;
                    n5 = 1;
                    break;
                }
                case 51: {
                    n4 = 1;
                    n5 = 1;
                    break;
                }
                case 113: {
                    this.getMappanel().clearCursor();
                    return null;
                }
                default: {
                    this.getMappanel().clearCursor();
                    return new Point(this.getMappanel().curx, this.getMappanel().cury);
                }
            }
            this.getMappanel().setCursor(this.getMappanel().curx + n4, this.getMappanel().cury + n5);
            this.getMappanel().viewPosition(map, this.getMappanel().curx, this.getMappanel().cury);
            this.doLookPoint(new Point(this.getMappanel().curx, this.getMappanel().cury));
        }
    }

    public void castSpell(Thing thing, Thing thing2) {
        if (thing2 == null) {
            return;
        }
        Map map = thing.getMap();
        switch (thing2.getStat("SpellTarget")) {
            case 1: {
                Spell.castAtSelf(thing2, thing);
                break;
            }
            case 3: {
                Game.message("Select Direction:");
                Point point = Game.getDirection();
                if (point == null) break;
                Spell.castInDirection(thing2, thing, point.x, point.y);
                break;
            }
            case 2: {
                Thing thing3;
                Thing thing4 = thing3 = thing2.getStat("SpellUsage") == 1 ? map.findNearestFoe(thing) : null;
                if (thing3 != null && !map.isVisible(thing3.x, thing3.y)) {
                    thing3 = null;
                }
                Point point = this.getSpellTargetLocation(thing, thing2);
                Game.message("");
                if (point == null) break;
                if (point.x == thing.x && point.y == thing.y && thing2.getStat("SpellUsage") == 1) {
                    Game.message("Are you sure you want to target yourself? (y/n)");
                    char c = Game.getOption("yn");
                    if (c == 'n') break;
                }
                if (map.isVisible(point.x, point.y)) {
                    Spell.castAtLocation(thing2, thing, map, point.x, point.y);
                    break;
                }
                Game.message("You cannot see to focus your power");
                break;
            }
            case 4: {
                Thing thing5 = Game.selectItem("Select an item:", thing.getItems());
                this.questapp.switchScreen(this);
                if (thing5 == null) break;
                Spell.castAtObject(thing2, thing, thing5);
            }
        }
    }

    public void endTurn() {
        Game.actor = null;
        Thing thing = Game.hero();
        while (thing.getStat("APS") < 0) {
            int n = -thing.getStat("APS");
            int n2 = n * 100 / thing.getStat("Speed");
            Time.advance(n2);
            thing.incStat("APS", n);
        }
        Being.calcEncumberance(thing);
        thing.set("IsFrozen", 0);
        if (thing.getMap() != this.map) {
            this.map = thing.getMap();
            if (this.map == null) {
                return;
            }
            Game.enterMap(this.map, thing.x, thing.y);
        }
        this.gameHandler.calculateVision(thing);
        if (this.levelMap != null) {
            this.levelMap.repaint();
            this.statuspanel.repaint();
        }
    }

    public static char getKey(KeyEvent keyEvent) {
        char c = Character.toLowerCase(keyEvent.getKeyChar());
        if (keyEvent.getKeyCode() == 38) {
            c = '8';
        }
        if (keyEvent.getKeyCode() == 40) {
            c = '2';
        }
        if (keyEvent.getKeyCode() == 37) {
            c = '4';
        }
        if (keyEvent.getKeyCode() == 39) {
            c = '6';
        }
        if (keyEvent.getKeyCode() == 36) {
            c = '7';
        }
        if (keyEvent.getKeyCode() == 35) {
            c = '1';
        }
        if (keyEvent.getKeyCode() == 33) {
            c = '9';
        }
        if (keyEvent.getKeyCode() == 34) {
            c = '3';
        }
        if (keyEvent.getKeyCode() == 27) {
            c = 'Q';
        }
        if (keyEvent.getKeyCode() == 10) {
            c = 'Q';
        }
        if (keyEvent.getKeyCode() == 112) {
            c = '?';
        }
        if (keyEvent.getKeyCode() == 113) {
            c = '(';
        }
        if (keyEvent.getKeyCode() == 114) {
            c = ')';
        }
        if (keyEvent.getKeyCode() == 115) {
            c = '*';
        }
        if (keyEvent.getKeyCode() == 116) {
            c = ':';
        }
        if (keyEvent.getKeyCode() == 9) {
            c = '\t';
        }
        return c;
    }

    public void doZoom(int n) {
        this.getMappanel().zoomfactor += n;
        if (this.getMappanel().zoomfactor < 25) {
            this.getMappanel().zoomfactor = 25;
        }
        if (this.getMappanel().zoomfactor > 800) {
            this.getMappanel().zoomfactor = 800;
        }
        Game.warn("Zooming.... (" + this.getMappanel().zoomfactor + "%)");
        this.getMappanel().repaint();
    }

    private void doDebugKeys(Thing thing) {
        Thing[] thingArray;
        int n;
        Object object;
        BaseObject baseObject;
        if (!Game.isDebug()) {
            return;
        }
        String string = Game.getLine("What is your bidding? ");
        if (string.equals("") || string.equals("ESC")) {
            Game.message("");
            return;
        }
        char c = string.charAt(0);
        string = string.substring(1);
        if (c == 'a') {
            try {
                int n2 = Integer.parseInt(string);
                this.map.addThing(Lib.createArtifact(n2), thing.x - 1, thing.y - 1, thing.x + 1, thing.y + 1);
            }
            catch (Exception exception) {
                return;
            }
        }
        if (c == 'c') {
            Point point = this.getTargetLocation();
            baseObject = this.map.getFlaggedObject(point.x, point.y, "IsMobile");
            if (baseObject != null) {
                Game.instance().setHero((Thing)baseObject);
            }
        }
        if (c == 'd') {
            String string2 = Game.getLine("Enter dungeon DNA: ");
            baseObject = new Map(50, 50);
            ((Map)baseObject).setTheme(Dungeon.selectTheme(thing.getLevel()));
            baseObject.set("DungeonDNA", string2);
            Dungeon.makeDungeon((Map)baseObject, thing.getLevel());
            ((Map)baseObject).addThing(thing);
            Wish.makeWish("map", 100);
        }
        if (c == 'l') {
            Game.message("Magic Look: select location");
            Point point = this.getTargetLocation();
            if (point != null) {
                baseObject = this.map.getObjects(point.x, point.y);
                while (baseObject != null) {
                    this.doMagicLook((Thing)baseObject);
                    baseObject = ((Thing)baseObject).next;
                }
                this.questapp.switchScreen(this);
            }
        }
        if (c == 'x') {
            Game.message("Load map: ");
            MapMaker mapMaker = new MapMaker();
            baseObject = mapMaker.promptAndLoad();
            if (baseObject == null) {
                return;
            }
            object = Portal.create("stairs up");
            baseObject.set("Description", "bob");
            if (baseObject.containsKey("EntranceX")) {
                n = baseObject.getStat("EntranceX");
                int n3 = baseObject.getStat("EntranceY");
                ((Map)baseObject).addThing((Thing)object, n, n3);
                ((Map)baseObject).setEntrance((Thing)object);
            }
            ((Map)baseObject).addThing(thing);
        }
        if (c == 'p' && (thingArray = this.map.getObjects(0, 0, this.map.width - 1, this.map.height - 1, "IsPortal")).length > 0) {
            int n4 = RPG.r(thingArray.length);
            this.map.addThing(thing, thingArray[n4].x, thingArray[n4].y);
        }
        if (c == 'q') {
            Game.message("Are you sure you want to quit this game (y/n)");
            if (Game.getOption("yn") == 'y') {
                thing.set("HPS", -10);
            }
        }
        if (c == 't') {
            String string3 = Game.getLine("Enter tile number: ");
            this.getMappanel().currentTile = Tile.tiles[Integer.parseInt(string3)].getStat("TileValue");
        }
        if (c == 'g') {
            String string4 = Game.getLine("Enter target map: ");
            String[] stringArray = string4.split(":");
            object = stringArray[0];
            n = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 1;
            Thing thing2 = Portal.create("stairs down");
            thing2.set("ComplexName", object);
            thing2.set("DestinationLevel", n);
            this.map.addThing(thing2, thing.x, thing.y);
            Portal.travel(thing2, thing);
        }
        if (c == 's') {
            Game.saveMap(this.map);
        }
        if (c == 'm') {
            Game.showData(Spell.spellReport());
        }
        if (c == 'z') {
            BaseObject.GET_SET_DEBUG = !BaseObject.GET_SET_DEBUG;
            Game.message("BaseObject.GET_SET_DEBUG = " + BaseObject.GET_SET_DEBUG);
        }
        if (c == 'y') {
            HashMap hashMap = BaseObject.getCounter;
            Thing thing3 = new Thing(new BaseObject(hashMap));
            Game.showData(thing3.reportByValue());
        }
    }

    public void doWait(Thing thing) {
        thing.incStat("APS", -50);
    }

    public void doApplySkill(Thing thing) {
        String[] stringArray;
        String string;
        ArrayList arrayList = Skill.getList(thing);
        if (this.lastSkill != null) {
            arrayList.remove(this.lastSkill);
            arrayList.add(0, this.lastSkill);
        }
        if ((string = Game.selectString("Your skills", stringArray = arrayList.toArray(new String[arrayList.size()]))) != null) {
            this.lastSkill = string;
            if ((string = Skill.trim(string)).equals("Throwing")) {
                this.doThrow(thing);
            } else if (string.equals("Archery")) {
                this.doFire(thing);
            } else if (string.equals("Spellcasting")) {
                this.doZap(thing, true);
            } else {
                Skill.apply(thing, string);
            }
        }
    }

    public void doChat(Thing thing) {
        Serializable serializable;
        Thing thing2 = null;
        if (this.map.countNearby("IsIntelligent", thing.x, thing.y, 1) > 2) {
            Game.message("Chat: select direction");
            serializable = Game.getDirection();
            thing2 = this.map.getFlaggedObject(thing.x + ((Point)serializable).x, thing.y + ((Point)serializable).y, "IsIntelligent");
        } else {
            try {
                thing2 = this.map.getNearby("IsIntelligent", thing.x, thing.y, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (thing2 == null) {
            return;
        }
        if (AI.isHostile(thing2, thing)) {
            Game.message(thing2.getTheName() + " is attacking you!");
            return;
        }
        if (thing2.handles("OnChat")) {
            serializable = new Event("Chat");
            ((BaseObject)serializable).set("Target", thing);
            thing2.handle((Event)serializable);
        } else if (thing2.equals(Game.hero())) {
            Game.message("You mumble to yourself");
        } else if (thing2.getFlag("IsIntelligent")) {
            Game.message("You chat with " + thing2.getTheName() + " for some time");
        } else {
            Game.message("You can't talk to " + thing2.getTheName());
        }
        thing.incStat("APS", -200);
    }

    public void doDrop(Thing thing, boolean bl) {
        if (bl) {
            Thing thing2 = Game.selectItem("Select item to drop:", thing.getItems());
            while (thing2 != null) {
                Being.tryDrop(thing, thing2);
                Thing[] thingArray = thing.getItems();
                if (thingArray.length != 0) {
                    thing2 = Game.selectItem("Select item to drop:", thingArray, true);
                    continue;
                }
                break;
            }
        } else {
            Thing thing3 = Game.selectItem("Select item to drop:", thing.getItems());
            if (thing3 != null) {
                Being.tryDrop(thing, thing3);
            }
        }
    }

    public void doEat(Thing thing) {
        Thing thing2 = Game.selectItem("Select item to eat:", thing.getFlaggedContents("IsEdible"));
        this.questapp.switchScreen(this);
        if (thing2 != null) {
            Food.eat(thing, thing2);
        }
    }

    public void doFire(Thing thing) {
        Thing[] thingArray;
        Thing thing2 = thing.getWielded(20);
        Thing thing3 = thing.getWielded(21);
        if (thing2 == null && thing3 != null && thing3.getFlag("IsThrowingWeapon")) {
            this.doThrow(thing, thing3);
            return;
        }
        if (thing2 == null && (thingArray = thing.getFlaggedContents("IsRangedWeapon")).length > 0) {
            thing2 = Game.selectItem("Select a ranged weapon:", thingArray);
        }
        if (thing2 != null) {
            RangedWeapon.useRangedWeapon(thing2, thing);
        } else if (thing3 != null) {
            this.doThrow(thing, thing3);
        } else {
            Game.message("You must first find an appropriate missile weapon");
        }
    }

    public void doGive(Thing thing) {
        Serializable serializable;
        Thing thing2 = null;
        if (this.map.countNearby("IsGiftReceiver", thing.x, thing.y, 1) > 1) {
            Game.message("Give: select direction");
            serializable = Game.getDirection();
            thing2 = this.map.getFlaggedObject(thing.x + ((Point)serializable).x, thing.y + ((Point)serializable).y, "IsGiftReceiver");
        } else {
            thing2 = this.map.getNearby("IsGiftReceiver", thing.x, thing.y, 1);
        }
        if (thing2 != null && !thing.isHostile(thing2)) {
            serializable = Game.selectItem("Select item to give:", thing.getItems());
            if (serializable != null) {
                int n;
                if (((Thing)serializable).y > 0 && !thing.clearUsage(((Thing)serializable).y)) {
                    return;
                }
                int n2 = ((Thing)serializable).getStat("Number");
                if (n2 > 1 && (n = Game.getNumber("Give how many (Enter=All)? ", n2)) > 0) {
                    serializable = ((Thing)serializable).separate(n);
                }
                thing2.give(thing, (Thing)serializable);
                if (((Thing)serializable).place == thing) {
                    ((Thing)serializable).restack();
                }
                thing.incStat("APS", -100);
            }
        } else {
            Game.message("There is nobody to receive your gift");
        }
    }

    private void doInventory(Thing thing) {
        Thing thing2 = Game.selectItem("Your inventory:  (choose a letter to inspect an item)", thing.getItems());
        if (thing2 != null) {
            Game.infoScreen(Item.inspect(thing2));
        }
    }

    private void doJump(Thing thing) {
        Game.message("Jump: select location");
        Point point = this.getTargetLocation();
        if (point != null) {
            Movement.jump(thing, point.x, point.y);
        }
    }

    private void doKick(Thing thing) {
        Game.message("Kick: select direction");
        Point point = Game.getDirection();
        if (point != null && (point.x != 0 || point.y != 0)) {
            this.messagepanel.clear();
            Combat.kick(thing, point.x, point.y);
        } else {
            Game.message("");
        }
    }

    private void doLook() {
        Game.message("Look: select location");
        Point point = this.getTargetLocation();
        this.doLookPoint(point);
    }

    private void doLookPoint(Point point) {
        if (point != null) {
            this.messagepanel.clear();
            Game.message(Game.isDebug() ? "You see: " + (this.map.getTile(point.x, point.y) & 0xFFFF) : "You see:");
            if (this.map.isVisible(point.x, point.y)) {
                Thing thing = this.map.getObjects(point.x, point.y);
                while (thing != null && thing.isVisible(Game.hero())) {
                    String string = "";
                    string = string + thing.getDescription().getDescriptionText();
                    if (thing.getFlag("IsBeing")) {
                        string = string + " (" + Text.capitalise(Damage.describeState(thing)) + " damage)";
                    }
                    if (thing.isHostile(Game.hero())) {
                        string = string + " (Hostile) ";
                    }
                    Game.message(string);
                    thing = thing.next;
                }
            }
        }
    }

    private void doMagicLook(Thing thing) {
        char c = Game.showData(thing.report());
        if (c == 'e') {
            this.doEdit(thing);
        }
    }

    private void doEdit(Thing thing) {
        String string = Game.getLine("Edit property for " + thing.getName(Game.hero()) + ":");
        if (string.equals("") || string.equals("ESC")) {
            Game.message("");
            return;
        }
        String[] stringArray = string.split("=");
        try {
            int n = Integer.parseInt(stringArray[1]);
            thing.set(stringArray[0], n);
        }
        catch (Exception exception) {
            thing.set(stringArray[0], stringArray[1]);
        }
    }

    private void doMessages() {
        String[] stringArray = Text.separateString(Game.instance().messageList(), '\n');
        String string = "";
        int n = TextZone.linelength == 0 ? 80 : TextZone.linelength;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = Text.wrapString(stringArray[i], n);
            for (int j = 0; j < stringArray2.length; ++j) {
                string = string.concat(stringArray2[j]).concat("\n");
            }
        }
        Game.scrollTextScreen(string, true);
    }

    private void doOpen(Thing thing) {
        Game.message("Select direction");
        Point point = Game.getDirection();
        if (point != null && (point.x != 0 || point.y != 0)) {
            this.messagepanel.clear();
            Thing thing2 = this.map.getFlaggedObject(thing.x + point.x, thing.y + point.y, "IsOpenable");
            if (thing2 != null) {
                Door.useDoor(thing, thing2);
                thing.incStat("APS", -Being.actionCost(thing));
            }
        }
    }

    private void doPickup(Thing thing, boolean bl) {
        if (thing.getInventoryWeight() >= Being.maxCarryingWeight(thing)) {
            Game.message("You cannot carry any more!");
            return;
        }
        Thing[] thingArray = this.map.getObjects(thing.x, thing.y, thing.x, thing.y, "IsItem");
        boolean bl2 = false;
        if (bl && thingArray.length > 1) {
            Thing thing2;
            while (thingArray.length > 0 && (thing2 = Game.selectItem("Select items to pick up:", thingArray)) != null) {
                Being.tryPickup(thing, thing2);
                thingArray = this.map.getObjects(thing.x, thing.y, thing.x, thing.y, "IsItem");
            }
        } else {
            for (int i = 0; i < thingArray.length; ++i) {
                Thing thing3 = thingArray[i];
                if (!bl2 && thingArray.length > 1) {
                    char c;
                    if (i == thingArray.length - 1) {
                        Game.message("Pick up " + thingArray[i].getTheName() + "? (Y/N)");
                        c = Game.getOption("yn,p");
                    } else {
                        Game.message("Pick up " + thingArray[i].getTheName() + "? (Y/N/All)");
                        c = Game.getOption("yn,pa");
                    }
                    if (c == 'n') continue;
                    if (c == 'q') {
                        Game.message("");
                        break;
                    }
                    if (c == 'a') {
                        bl2 = true;
                    }
                }
                Being.tryPickup(thing, thing3);
            }
        }
    }

    private void doQuaff(Thing thing) {
        Thing thing2 = Game.selectItem("Select item to quaff:", thing.getFlaggedContents("IsDrinkable"));
        this.questapp.switchScreen(this);
        if (thing2 != null) {
            Potion.drink(thing, thing2);
        }
    }

    private void doRead(Thing thing) {
        int n = thing.getStat("Literacy");
        if (n > 0) {
            Thing thing2 = Game.selectItem("Select item to read:", thing.getFlaggedContents("IsReadable"));
            this.questapp.switchScreen(this);
            if (thing2 != null) {
                thing.incStat("APS", -600 / n);
                thing2 = thing2.separate(1);
                thing.message("You read " + thing2.getTheName());
                if (thing2.handles("OnRead")) {
                    Event event = new Event("Read");
                    event.set("Reader", thing);
                    event.set("Target", thing);
                    thing2.handle(event);
                }
                if (thing2.place == thing) {
                    thing2.restack();
                }
            }
        } else {
            thing.message("You can't read!");
        }
    }

    private void doSearch(Thing thing) {
        Game.message("Searching...");
        thing.incStat("APS", -200);
        Secret.searchAround();
    }

    private void doThrow(Thing thing) {
        Thing thing2 = Game.selectItem("Throw Item:", thing.getItems());
        this.questapp.switchScreen(this);
        this.doThrow(thing, thing2);
    }

    private void doThrow(Thing thing, Thing thing2) {
        if (thing2 != null) {
            Point point;
            int n = thing2.y;
            thing2 = thing2.separate(1);
            if (thing2.y > 0 && !thing.clearUsage(thing2.y)) {
                return;
            }
            Thing thing3 = this.map.findNearestFoe(thing);
            if (thing3 != null && !this.map.isVisible(thing3.x, thing3.y)) {
                thing3 = null;
            }
            if ((point = this.getTargetLocation(thing3)) != null) {
                thing2 = thing2.remove(1);
                thing.throwThing(thing2, point.x, point.y);
            }
            if (thing2.place == thing) {
                thing2 = thing2.restack();
                thing.setUsage(thing2, n);
            }
        }
    }

    private void doUse(Thing thing) {
        Thing thing2 = Game.selectItem("Use Item:", thing.getUsableContents());
        this.questapp.switchScreen(this);
        if (thing2 != null) {
            thing2 = thing2.separate(1);
            Item.use(thing, thing2);
            thing2.restack();
        }
    }

    private void doViewStats(Thing thing) {
        CharacterScreen characterScreen = new CharacterScreen(thing);
        this.questapp.switchScreen(characterScreen);
        Game.getInput();
        this.questapp.switchScreen(this);
    }

    private void doWield(Thing thing) {
        Thing thing2 = Game.selectItem("Wield/wear which item?", thing.getWieldableContents());
        if (thing2 != null) {
            Thing thing3 = thing2;
            boolean bl = false;
            int n = thing3.getStat("WieldType");
            if (thing3.y == n) {
                if (thing.clearUsage(n)) {
                    Game.message("You are no longer using " + thing3.getTheName());
                }
                return;
            }
            if (n == 5 || n == 4) {
                Game.message("Which finger? (r/l)");
                char c = Game.getOption("lr");
                if (c == 'r') {
                    if (thing.wield(thing3, 4)) {
                        Game.message("You put " + thing3.getTheName() + " on your right finger");
                        bl = true;
                    }
                } else if (c == 'l') {
                    if (thing.wield(thing3, 5)) {
                        Game.message("You put " + thing3.getTheName() + " on your left finger");
                        bl = true;
                    }
                } else {
                    this.messagepanel.clear();
                }
            } else if (n == 1 || n == 2) {
                Game.message("Which hand? (r/l) [" + thing.inHandMessage() + "]");
                char c = Game.getOption("lr");
                if (c == 'r') {
                    if (thing.wield(thing3, 1)) {
                        Game.message("You wield " + thing3.getTheName() + " in your right hand");
                        bl = true;
                    }
                } else if (c == 'l') {
                    if (thing.wield(thing3, 2)) {
                        Game.message("You wield " + thing3.getTheName() + " in your left hand");
                        bl = true;
                    }
                } else {
                    this.messagepanel.clear();
                }
            } else if (n == 3) {
                if (thing.wield(thing3, 3)) {
                    Game.message("You wield " + thing3.getTheName() + " in both hands");
                    bl = true;
                }
            } else if (n == 20) {
                if (thing.wield(thing3, n)) {
                    Game.message("You wield " + thing3.getTheName() + " as your ranged weapon");
                    bl = true;
                }
            } else if (n == 21) {
                if (thing.wield(thing3, n)) {
                    Game.message("You prepare to fire " + thing3.getTheName());
                    bl = true;
                }
            } else if (thing.wield(thing3, n)) {
                Game.message("You are now wearing " + thing3.getTheName());
                bl = true;
            }
            if (bl && thing3.getFlag("IsCursed")) {
                thing.message(thing3.getTheName() + " glows black for a second");
                thing3.set("IsStatusKnown", 1);
            }
            thing.incStat("APS", -Being.actionCost(thing));
        }
    }

    private void doExit(Thing thing) {
        thing.incStat("APS", -100);
        this.map.exitMap(thing.x, thing.y);
    }

    private void doPray(Thing thing, Action action) {
        int n = thing.getLevel() + thing.getStat("Prayer");
        if (Game.isDebug() && action == Action.PRAY2) {
            Wish.doWish();
        } else {
            if (action == Action.PRAY2) {
                return;
            }
            if (thing.getStat("Prayer") > 0) {
                if (thing.getBaseStat("FatePoints") > 0) {
                    if (Wish.doPray(n)) {
                        thing.incStat("FatePoints", -1);
                        Game.message("Praise be to " + thing.getString("Religion") + "!");
                        if (thing.getBaseStat("FatePoints") == 0) {
                            Game.message("The ground rumbles");
                        }
                    }
                } else {
                    Game.message(thing.getString("Religion") + " is unimpressed with your whining");
                    thing.addAttribute(Lib.create("hex"));
                }
            } else if (thing.getBaseStat("FatePoints") > 0) {
                thing.incStat("FatePoints", -1);
                if (thing.getStat("HPS") < thing.getStat("HPSMAX")) {
                    Wish.makeWish("healing", n);
                } else {
                    switch (RPG.d(8)) {
                        case 1: {
                            Wish.makeWish("identification", n);
                            break;
                        }
                        case 2: {
                            Wish.makeWish("cash", n);
                            break;
                        }
                        case 3: {
                            Wish.makeWish("experience", n);
                            break;
                        }
                        case 4: {
                            Wish.makeWish("[IsMagicItem]", n);
                            break;
                        }
                        case 5: {
                            if (thing.getStat("SkillPoints") >= 1) {
                                String[] stringArray = Skill.fullList();
                                Wish.makeWish(stringArray[RPG.r(stringArray.length)], 100);
                                break;
                            }
                            Wish.makeWish("identification", n);
                            break;
                        }
                        case 6: {
                            Wish.makeWish("blessing", n);
                            break;
                        }
                        case 7: {
                            Wish.makeWish("potion of holy water", 100);
                            break;
                        }
                        default: {
                            Wish.makeWish("[IsMagicItem]", n);
                            break;
                        }
                    }
                }
            } else {
                Game.message(thing.getString("Religion") + " does not seem interested in helping you");
            }
        }
    }

    private void doZap(Thing thing, boolean bl) {
        if (thing.getStat("Spellcasting") <= 0 && thing.getStat("Holy Magic") <= 0) {
            thing.message("You are unable to cast magic spells");
            return;
        }
        Thing thing2 = lastSpell;
        if (bl || thing2 == null) {
            thing2 = Game.selectItem("Select spell to cast:", thing.getFlaggedContents("IsSpell"));
        }
        if (thing2 != null) {
            if (Spell.canCast(thing, thing2) || Game.isDebug()) {
                Spell.castCost(thing, thing2);
                thing.message("You cast " + thing2.getName(Game.hero()));
                this.castSpell(thing, thing2);
                Spell.train(thing, thing2);
            } else {
                Game.message("You have insufficient power to cast " + thing2.getName(Game.hero()));
            }
            lastSpell = thing2;
        }
    }

    private void doShowQuests() {
        ArrayList arrayList = Quest.getQuests();
        String string = "Your quests:\n\n";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + Quest.getQuestText((Thing)arrayList.get(i)) + "\n";
        }
        string = string + "[Press space to continue]";
        Game.infoScreen(string);
    }

    private void doHelp() {
        this.questapp.switchScreen(new InfoScreen(Game.getQuestapp(), "Key Commands:\n  a = apply skill                       ? = help\n  c = chat to somebody                  = = load game\n  d = drop item                         - = save game\n  e = eat item                          @ = view quests\n  f = fire ranged weapon                ( = zoom map in\n  g = give item                         ) = zoom map out\n  i = inspect inventory\n  j = jump\n  k = kick something\n  l = look\n  m = message log\n  o = open / close door\n  p = pick up item\n  , = pick up item (extended)\n  q = quaff potion\n  r = read book or scroll\n  s = search area\n  t = throw / shoot missile\n  u = use item\n  v = view hero statistics\n  w = wield weapon / wear armour\n  x = exit area / climb staircase\n  _ = pray for divine aid\n  z = cast spell\n\n"));
        Game.getInput();
        this.questapp.switchScreen(this);
    }

    public void setMappanel(MapPanel mapPanel) {
        this.mappanel = mapPanel;
    }

    public MapPanel getMappanel() {
        return this.mappanel;
    }

    public LevelMapPanel getLevelMap() {
        return this.levelMap;
    }
}

