/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Armour;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Movement;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Damage {
    private static final double resistMultiplier = Math.pow(0.5, 0.1);

    private static int calculate(Thing thing, double d, String string) {
        if (d <= 0.0) {
            return 0;
        }
        double d2 = Armour.calcArmour(thing, string);
        d = d * d / (d2 + d);
        int n = thing.getResistance(string);
        if (n != 0) {
            d *= Math.pow(resistMultiplier, n);
        }
        if (string.equals("poison") && !thing.getFlag("IsLiving")) {
            d = 0.0;
        }
        if (string.equals("chill") && !thing.getFlag("IsLiving")) {
            d = 0.0;
        }
        int n2 = RPG.round(d);
        if (thing.getFlag("IsItem")) {
            int n3 = thing.getStat("HPSMAX");
            int n4 = thing.getStat("DamageLevels");
            if (n4 > 0) {
                if (n2 < n3 / (1 + n4)) {
                    n2 = RPG.r(n3 / (1 + n4)) < n2 ? n3 / (1 + n4) : 0;
                }
            } else {
                n2 = RPG.r(n3) < n2 ? n3 : 0;
            }
        }
        return n2;
    }

    public static int inflict(Thing thing, int n, String string) {
        int n2;
        BaseObject baseObject;
        if (!thing.getFlag("IsDestructible")) {
            return 0;
        }
        if (thing.isDead()) {
            return 0;
        }
        if (Game.actor != null && thing.getFlag("IsBeing") && !thing.isHostile(Game.actor)) {
            thing.notify(1, thing.getStat("Side"), Game.actor);
        }
        int n3 = Damage.calculate(thing, n, string);
        if (string.equals("impact")) {
            if (RPG.d(10) == 1 && thing.getFlag("IsLiving") && RPG.test(n3, thing.getStat("TG"))) {
                thing.addAttribute(Lib.create("confusion"));
            }
            if ((baseObject = Game.actor) != null && (thing.getFlag("IsItem") || thing.getFlag("IsBeing") && RPG.test(n3, thing.getStat("TG") + 10, (Thing)baseObject, thing))) {
                n2 = 1;
                if (thing.getFlag("IsShopOwned")) {
                    n2 = 0;
                }
                if (n2 != 0 && Movement.push(thing, RPG.sign(thing.x - ((Thing)baseObject).x), RPG.sign(thing.y - ((Thing)baseObject).y))) {
                    thing.message("You are knocked back by the force of the impact");
                }
            }
        }
        if (n3 <= 0) {
            return 0;
        }
        if (thing.isHero()) {
            thing.isRunning(false);
        }
        if (thing.handles("OnDamage")) {
            baseObject = new Event("Damage");
            baseObject.set("Damage", n3);
            baseObject.set("DamageType", string);
            baseObject.set("Actor", Game.actor);
            if (thing.handle((Event)baseObject)) {
                return baseObject.getStat("Damage");
            }
            n3 = baseObject.getStat("Damage");
        }
        if (n3 <= 0) {
            return 0;
        }
        if (string.equals("drain") || string.equals("shock")) {
            thing.incStat("MPS", -n3);
            if (thing.getStat("MPS") < 0) {
                thing.incStat("HPS", thing.getStat("MPS"));
                thing.set("MPS", 0);
            }
        } else if (thing.getStat("Number") > 1 && n3 >= thing.getStat("HPS")) {
            int n4 = thing.getNumber();
            n2 = RPG.round((double)n / (double)n3);
            if (n2 >= n4) {
                thing.incStat("HPS", -n3);
            } else {
                if ((thing = thing.separate(n2)) == null) {
                    return 0;
                }
                thing.incStat("HPS", -n3);
            }
        } else {
            thing.incStat("HPS", -n3);
        }
        if (!thing.getFlag("IsFrozen") && string.equals("ice") && RPG.test(n3, thing.getStat("TG"))) {
            thing.message("You are briefly frozen!");
            thing.set("IsFrozen", 1);
            thing.incStat("APS", -200);
        }
        if (thing.getStat("HPS") <= 0) {
            int n5 = thing.getStat("FatePoints");
            if (n5 > 0) {
                thing.set("FatePoints", n5 - 1);
                thing.set("HPS", 1);
                thing.message(n5 == 1 ? "You feel your luck is running out..." : "That was too close for comfort...");
            } else {
                thing.set("KillingDamageType", string);
                thing.die();
            }
        }
        Damage.itemDamage(thing, n, string);
        int n6 = 0;
        if (string.equals("water")) {
            n6 = 0;
        }
        if (string.equals("poison")) {
            n6 = 40;
        }
        if (string.equals("ice") || string.equals("chill") || string.equals("acid")) {
            n6 = 20;
        }
        if (string.equals("shock")) {
            n6 = 61;
        }
        if (string.equals("drain") || string.equals("disintegrate")) {
            n6 = 80;
        }
        if (n3 * 5 > thing.getStat("HPSMAX")) {
            ++n6;
        }
        if (Game.visuals) {
            Game.instance().doDamageMark(thing.x, thing.y, n6);
        }
        return n3;
    }

    private static void bagProtection(Thing thing, Thing[] thingArray, int n, String string) {
        for (int i = 0; i < RPG.WT_BAGS.length; ++i) {
            Thing thing2 = thing.getWielded(RPG.WT_BAGS[i]);
            if (thing2 == null) continue;
            Damage.inflict(thing2, n, string);
            if (thing2.isDead()) continue;
            for (int j = 0; j < thingArray.length; ++j) {
                if (thingArray[j] == null || thingArray[j] != thing2 && (thing.isWielded(thingArray[j]) || !thingArray[j].getFlag((String)thing2.get("Holds")))) continue;
                thingArray[j] = null;
            }
        }
    }

    public static void damageInventory(Thing thing, int n, String string, int n2) {
        Thing[] thingArray = thing.inv();
        if (thing.isHero()) {
            thingArray = new Thing[thingArray.length];
            System.arraycopy(thing.inv(), 0, thingArray, 0, thingArray.length);
            Damage.bagProtection(thing, thingArray, n, string);
        }
        for (int i = 0; i < thing.invCount(); ++i) {
            Thing thing2 = thingArray[i];
            if (thing2 == null || RPG.r(100) >= n2 || !thing2.getFlag("IsItem")) continue;
            int n3 = thing.invCount();
            int n4 = Damage.inflict(thing2, n, string);
            if (n3 > thing.invCount()) {
                --i;
            }
            if (!thing.isHero() || n4 <= 0 || thing2.place == null) continue;
            Game.message(thing2.getYourName() + " " + thing2.is() + " damaged");
        }
    }

    private static void itemDamage(Thing thing, int n, String string) {
        if (!thing.hasInventory()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (string.equals("fire") || string.equals("ice")) {
            n2 += 2;
        }
        if (string.equals("water")) {
            n2 += 3;
        }
        if (string.equals("acid")) {
            n2 += 5;
        }
        if (string.equals("disintegrate")) {
            n2 += 20;
        }
        if ((n2 = RPG.middle(0, n2, 100)) > 0 && n > 0) {
            n3 = thing.getArmour(string);
            if (n3 > 0) {
                int n4 = n3 + n;
                n = n * n / n4;
            }
            if (n > 0) {
                Damage.damageInventory(thing, n, string, n2);
            }
        }
    }

    public static String describeState(Thing thing) {
        double d = (double)thing.getStat("HPS") / (double)thing.getStat("HPSMAX");
        if (d == 1.0) {
            return "no";
        }
        if (d > 0.99) {
            return "minimal";
        }
        if (d > 0.9) {
            return "minor";
        }
        if (d > 0.7) {
            return "light";
        }
        if (d > 0.5) {
            return "moderate";
        }
        if (d > 0.25) {
            return "heavy";
        }
        if (d > 0.0) {
            return "critical";
        }
        return "massive";
    }
}

