/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import mikera.tyrant.Game;
import mikera.tyrant.QuestApp;
import mikera.tyrant.Screen;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class ArtScreen
extends Screen {
    private static final long serialVersionUID = 3257568408080953650L;
    String title = "List";
    Thing[] arts = null;
    static int page = 0;
    private static int pagesize = 13;
    private static int lineheight = 20;

    public Thing getArt() {
        char c;
        int n;
        do {
            KeyEvent keyEvent;
            if ((keyEvent = Game.getInput()).getKeyCode() == 27) {
                return null;
            }
            c = Character.toLowerCase(keyEvent.getKeyChar());
            if (c == 'p' && page > 0) {
                --page;
                this.repaint();
            }
            if (c != 'n' && c != ' ' || (page + 1) * pagesize >= this.arts.length) continue;
            ++page;
            this.repaint();
        } while ((n = c - 97) < 0 || n >= pagesize || (n += page * pagesize) < 0 || n >= this.arts.length);
        return this.arts[n];
    }

    public ArtScreen(String string, Thing[] thingArray) {
        super(Game.getQuestapp());
        this.setLayout(new GridLayout(15, 1));
        this.setForeground(QuestApp.INFOTEXTCOLOUR);
        this.setBackground(QuestApp.INFOSCREENCOLOUR);
        this.setFont(QuestApp.mainfont);
        this.arts = thingArray;
        if (this.arts == null) {
            this.arts = new Thing[0];
        }
        this.title = string;
    }

    public void paint(Graphics graphics) {
        Object object;
        if (page * pagesize > this.arts.length) {
            page = 0;
        }
        graphics.drawString(this.title, 20, 1 * lineheight);
        for (int i = 0; i < Math.min(this.arts.length - page * pagesize, pagesize); ++i) {
            object = this.arts[i + page * pagesize];
            String string = "[" + (char)(97 + i) + "] " + ((Thing)object).getName(Game.hero());
            graphics.drawString(string, 50, lineheight * (i + 2));
        }
        String string = "ESC=Cancel ";
        if (page > 0) {
            string = string + " P=Previous ";
        }
        if ((page + 1) * pagesize < this.arts.length) {
            string = string + " N=Next ";
        }
        object = "Power: " + Game.hero().getStat("MPS") + " / " + Game.hero().getStat("MPSMAX");
        graphics.drawString(Text.centrePad(string, (String)object, 55), 20, this.getSize().height - 10);
    }
}

