/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;

public class Armour {
    private static String[] amat = new String[]{"iron", "steel", "silver", "elven steel", "mithril", "krithium", "black steel", "blue steel", "red steel", "crystal", "parillite", "sapphire", "emerald"};
    private static String[] umat = new String[]{null, null, "silvery", "shining", "silvery", "dark", "dark", "silvery", null, "shining", "shining", "shimmering blue", "shimmering green"};
    private static int[] levels = new int[]{3, 7, 9, 12, 20, 16, 22, 15, 18, 60, 28, 25, 31};
    private static int[] weights = new int[]{100, 90, 80, 70, 50, 160, 130, 80, 100, 60, 40, 65, 60};
    private static int[] freqs = new int[]{100, 70, 20, 50, 20, 40, 50, 50, 60, 30, 10, 20, 10};
    private static int[] skills = new int[]{100, 105, 100, 120, 140, 80, 100, 150, 110, 140, 170, 190, 220};
    private static int[] strs = new int[]{100, 110, 90, 120, 150, 140, 180, 140, 160, 140, 200, 210, 250};

    public static int calcArmour(Thing thing, String string) {
        if (string.equals("special")) {
            return 0;
        }
        double d = thing.getStat("ARM");
        int n = thing.getStat("Defence");
        d += (double)thing.getStat("TG") * (0.1 + (double)n * 0.05);
        Thing[] thingArray = thing.getWielded();
        double d2 = 0.0;
        for (int i = 0; i < thingArray.length; ++i) {
            double d3 = thingArray[i].getStat("Armour");
            if (thingArray[i].getFlag("IsBlessed")) {
                d3 *= 1.3;
            }
            if (thingArray[i].getFlag("IsCursed")) {
                d3 *= 0.7;
            }
            d2 += d3;
        }
        d += d2 * (0.6 + 0.2 * (double)n);
        if (!string.equals("normal")) {
            d = string.equals("piercing") ? (d /= 3.0) : (string.equals("acid") ? (d /= 2.0) : (string.equals("unarmed") ? (d *= 2.0) : (d /= 4.0)));
        }
        double d4 = 0.0;
        for (int i = 0; i < thingArray.length; ++i) {
            d4 += (double)thingArray[i].getStat("Armour:" + string);
        }
        d += d4 * (0.6 + 0.2 * (double)n) / 2.0;
        return (int)Math.round(d += (double)thing.getStat("ARM:" + string));
    }

    public static String statString(Thing thing) {
        String string = "";
        if (thing.getFlag("IsShield")) {
            string = string + "[* * +" + thing.getStat("DSKMul") / 10 + "] ";
        }
        string = string + "{arm:" + thing.getStat("Armour") + "}";
        return string;
    }

    public static void init() {
        Thing thing = Lib.extend("base armour", "base item");
        thing.set("Image", 340);
        thing.set("IsArmour", 1);
        thing.set("WieldType", 9);
        thing.set("HPS", 70);
        thing.set("ItemWeight", 20000);
        thing.set("ValueBase", 100);
        thing.set("Frequency", 50);
        thing.set("RES:acid", -12);
        thing.set("DamageLevels", 2);
        thing.set("DefaultThings", "5% [IsArmourRune]");
        thing.set("ASCII", "[");
        Lib.add(thing);
        Armour.initHeadgear();
        Armour.initFootwear();
        Armour.initShields();
        Armour.initLeatherArmour();
        Armour.initGloves();
        Armour.initCloaks();
        Armour.initStandardArmour();
    }

    private static void initCloaks() {
        Thing thing = Lib.extend("base cloak", "base armour");
        thing.set("IsCloak", 1);
        thing.set("WieldType", 12);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 800);
        thing.set("Image", 356);
        thing.multiplyStat("Frequency", 0.8);
        Lib.add(thing);
        thing = Lib.extend("light cloak", "base cloak");
        thing.set("Armour", 0);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("cloak", "base cloak");
        thing.set("Armour", 1);
        thing.set("LevelMin", 3);
        thing.set("ItemWeight", 1200);
        Lib.add(thing);
        thing = Lib.extend("heavy cloak", "base cloak");
        thing.set("Armour", 2);
        thing.set("LevelMin", 7);
        thing.set("ItemWeight", 2000);
        Lib.add(thing);
        thing = Lib.extend("elegant cloak", "base cloak");
        thing.set("Armour", 3);
        thing.set("LevelMin", 9);
        Lib.add(thing);
        thing = Lib.extend("cloak of stealth", "cloak");
        thing.set("UName", "dark cloak");
        thing.set("Armour", 1);
        thing.set("LevelMin", 6);
        thing.add("WieldedModifiers", Modifier.bonus("Stealth", 1));
        Lib.add(thing);
        thing = Lib.extend("cloak of protection", "heavy cloak");
        thing.set("UName", "heavy cloak");
        thing.set("Armour", 5);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("cloak of defence", "cloak");
        thing.set("UName", "ragged cloak");
        thing.set("Armour", 3);
        thing.set("LevelMin", 15);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        Lib.add(thing);
    }

    private static void initGloves() {
        Thing thing = Lib.extend("base gloves", "base armour");
        thing.set("IsGlove", 1);
        thing.set("NameType", 2);
        thing.set("WieldType", 7);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 500);
        thing.set("Image", 370);
        thing.multiplyStat("Frequency", 0.5);
        Lib.add(thing);
        thing = Lib.extend("leather gloves", "base gloves");
        thing.set("Armour", 1);
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("soft gloves", "base gloves");
        thing.set("Armour", 0);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("thieving gloves", "soft gloves");
        thing.set("UName", "soft gloves");
        thing.multiplyStat("Frequency", 0.2);
        thing.add("WieldedModifiers", Modifier.bonus("Pickpocket", 1));
        thing.add("WieldedModifiers", Modifier.bonus("SK", 2));
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("thick leather gloves", "base gloves");
        thing.set("Armour", 2);
        thing.set("LevelMin", 6);
        thing.set("ItemWeight", 800);
        Lib.add(thing);
        thing = Lib.extend("leather gauntlets", "base gloves");
        thing.set("Armour", 3);
        thing.set("LevelMin", 9);
        thing.set("ItemWeight", 900);
        Lib.add(thing);
        thing = Lib.extend("gauntlets of power", "leather gauntlets");
        thing.set("Armour", 4);
        thing.set("LevelMin", 12);
        thing.set("ItemWeight", 900);
        thing.multiplyStat("Frequency", 0.2);
        thing.add("WieldedModifiers", Modifier.bonus("ST", RPG.d(3)));
        Lib.add(thing);
        thing = Lib.extend("gauntlets of protection", "leather gauntlets");
        thing.set("UName", "leather gauntlets");
        thing.set("Armour", 10);
        thing.set("LevelMin", 14);
        thing.set("ItemWeight", 1000);
        thing.multiplyStat("Frequency", 0.2);
        thing.add("WieldedModifiers", Modifier.bonus("Defence", 1));
        Lib.add(thing);
        thing = Lib.extend("red leather gauntlets", "leather gauntlets");
        thing.set("UName", "leather gauntlets");
        thing.set("Image", 371);
        thing.set("Armour", 5);
        thing.set("LevelMin", 16);
        thing.set("ItemWeight", 700);
        Lib.add(thing);
        thing = Lib.extend("red dragon leather gauntlets", "red leather gauntlets");
        thing.set("UName", "red leather gauntlets");
        thing.set("Armour", 12);
        thing.set("Image", 371);
        thing.set("LevelMin", 23);
        thing.set("ItemWeight", 800);
        thing.add("WieldedModifiers", Modifier.bonus("ARM:fire", 8));
        Lib.add(thing);
        thing = Lib.extend("gauntlets", "base gloves");
        thing.set("Image", 372);
        thing.set("LevelMin", 7);
        thing.set("Armour", 4);
        thing.set("ItemWeight", 1500);
        Armour.addWithVariants(thing);
    }

    private static void initLeatherArmour() {
        Thing thing = Lib.extend("base leather armour", "base armour");
        thing.set("Image", 348);
        thing.set("ItemWeight", 2500);
        thing.set("ARM", 4);
        thing.set("LevelMin", 1);
        thing.set("DefaultThings", "2% [IsArmourRune],2% [IsItemRune]");
        Lib.add(thing);
        thing = Lib.extend("leather vest", "base leather armour");
        thing.set("Image", 347);
        thing.set("ItemWeight", 1500);
        thing.set("Armour", 2);
        thing.set("LevelMin", 1);
        Armour.addArmour(thing);
        thing = Lib.extend("leather armour", "base leather armour");
        thing.set("Image", 348);
        thing.set("ItemWeight", 2500);
        thing.set("Armour", 5);
        thing.set("LevelMin", 4);
        Armour.addArmour(thing);
        thing = Lib.extend("studded leather armour", "base leather armour");
        thing.set("Image", 351);
        thing.set("ItemWeight", 2800);
        thing.set("Armour", 6);
        thing.set("LevelMin", 7);
        Armour.addArmour(thing);
        thing = Lib.extend("dragon leather armour", "leather armour");
        thing.set("Image", 348);
        thing.set("ItemWeight", 3000);
        thing.set("Armour", 25);
        thing.set("Armour:fire", 25);
        thing.set("LevelMin", 23);
        Armour.addArmour(thing);
        thing = Lib.extend("red dragon leather armour", "dragon leather armour");
        thing.set("Armour:fire", 80);
        thing.set("LevelMin", 26);
        Armour.addArmour(thing);
    }

    private static void initHeadgear() {
        Thing thing = Lib.extend("base headgear", "base armour");
        thing.set("WieldType", 11);
        thing.set("ItemWeight", 1000);
        thing.set("Image", 323);
        Lib.add(thing);
        thing = Lib.extend("base crown", "base headgear");
        thing.set("ItemWeight", 2000);
        thing.set("Image", 425);
        Lib.add(thing);
        thing = Lib.extend("base helmet", "base headgear");
        thing.set("IsHelmet", 1);
        thing.set("Image", 323);
        thing.set("LevelMin", 1);
        thing.set("HPS", 40);
        thing.set("ItemWeight", 4000);
        Lib.add(thing);
        Armour.initCaps();
    }

    private static void initShields() {
        Thing thing = Lib.extend("base shield", "base armour");
        thing.set("IsShield", 1);
        thing.set("WieldType", 2);
        thing.set("Image", 380);
        thing.set("DSKBonus", 8);
        thing.set("DSKMul", 60);
        thing.set("ItemWeight", 6000);
        thing.set("Armour", 5);
        thing.set("DefaultThings", "2% [IsArmourRune],2% [IsShieldRune]");
        Lib.add(thing);
        thing = Lib.extend("small shield", "base shield");
        thing.set("ItemWeight", 4000);
        thing.set("DSKBonus", 2);
        thing.set("DSKMul", 70);
        thing.set("LevelMin", 1);
        thing.set("Image", 380);
        thing.set("Armour", 4);
        Armour.addWithVariants(thing);
        thing = Lib.extend("buckler", "base shield");
        thing.set("ItemWeight", 2500);
        thing.set("DSKBonus", 0);
        thing.set("DSKMul", 100);
        thing.set("LevelMin", 3);
        thing.set("Image", 388);
        thing.set("Armour", 3);
        Armour.addWithVariants(thing);
        thing = Lib.extend("shield", "base shield");
        thing.set("ItemWeight", 6000);
        thing.set("DSKBonus", 2);
        thing.set("DSKMul", 65);
        thing.set("LevelMin", 3);
        thing.set("Image", 381);
        thing.set("Armour", 6);
        Armour.addWithVariants(thing);
        thing = Lib.extend("large shield", "base shield");
        thing.set("ItemWeight", 10000);
        thing.set("DSKBonus", 0);
        thing.set("DSKMul", 60);
        thing.set("LevelMin", 4);
        thing.set("Image", 381);
        thing.set("Armour", 10);
        Armour.addWithVariants(thing);
    }

    private static void initCaps() {
        Thing thing = Lib.extend("leather cap", "base helmet");
        thing.set("Image", 320);
        thing.set("WieldType", 11);
        thing.set("HPS", 24);
        thing.set("Armour", 1);
        thing.set("ItemWeight", 2000);
        Lib.add(thing);
        thing = Lib.extend("feathered cap", "base helmet");
        thing.set("Image", 321);
        thing.set("WieldType", 11);
        thing.set("HPS", 13);
        thing.set("ItemWeight", 1200);
        Lib.add(thing);
        thing = Lib.extend("magic cap", "base helmet");
        thing.set("UName", "feathered cap");
        thing.set("Image", 321);
        thing.set("WieldType", 11);
        thing.set("HPS", 13);
        thing.set("ItemWeight", 1200);
        thing.set("Armour", 2);
        thing.set("LevelMin", 10);
        thing.set("DefaultThings", "100% [IsArmourRune]");
        thing.multiplyStat("Frequnecy", 0.2);
        Lib.add(thing);
        thing = Lib.extend("mining cap", "base helmet");
        thing.set("UName", "sturdy cap");
        thing.set("Image", 324);
        thing.set("LevelMin", 5);
        thing.set("Armour", 2);
        thing.set("ItemWeight", 2300);
        thing.set("Frequency", 5);
        thing.add("WieldedModifiers", Modifier.bonus("Mining", 1));
        Lib.add(thing);
    }

    private static void addFootwear(Thing thing) {
        String string = thing.getString("Name");
        String string2 = thing.getString("UName");
        if (string != null) {
            thing.set("NamePlural", "pairs of " + string);
        }
        if (string2 != null) {
            thing.set("UNamePlural", "pairs of " + string2);
        }
        Lib.add(thing);
    }

    private static void initFootwear() {
        Thing thing = Lib.extend("base footwear", "base armour");
        thing.set("WieldType", 8);
        thing.set("IsFootwear", 1);
        thing.multiplyStat("Frequency", 0.5);
        Weapon.setStats(thing, 50, 0, 70, 0, 0, 0);
        thing.set("WeaponDamageType", "impact");
        thing.set("HitVerb", "kick/kicks");
        Lib.add(thing);
        thing = Lib.extend("leather boots", "base footwear");
        thing.set("Image", 360);
        thing.set("NameType", 2);
        thing.set("HPS", 24);
        thing.set("LevelMin", 5);
        thing.set("ItemWeight", 2800);
        thing.set("ValueBase", 100);
        thing.set("Material", "leather");
        Armour.addFootwear(thing);
        thing = Lib.extend("old boots", "leather boots");
        thing.set("UName", "worn boots");
        thing.set("LevelMin", 1);
        Armour.addFootwear(thing);
        thing = Lib.extend("boots of agility", "leather boots");
        thing.set("UName", "worn boots");
        thing.set("LevelMin", 6);
        thing.add("WieldedModifiers", Modifier.linear("AG", 100, RPG.d(2, 6)));
        Armour.addFootwear(thing);
        thing = Lib.extend("shoes", "leather boots");
        thing.set("LevelMin", 2);
        thing.set("ItemWeight", 1400);
        thing.set("Image", 362);
        Armour.addFootwear(thing);
        thing = Lib.extend("fine shoes", "shoes");
        thing.set("LevelMin", 12);
        thing.set("ItemWeight", 1200);
        thing.set("Image", 362);
        thing.set("Armour", 1);
        thing.add("WieldedModifiers", Modifier.bonus("CH", 2));
        Armour.addFootwear(thing);
        thing = Lib.extend("dancing shoes", "shoes");
        thing.set("LevelMin", 5);
        thing.add("WieldedModifiers", Modifier.bonus("AG", 3));
        thing.set("Image", 362);
        Armour.addFootwear(thing);
        thing = Lib.extend("ironclad boots", "leather boots");
        thing.set("UName", "iron boots");
        thing.set("LevelMin", 11);
        thing.set("Image", 361);
        thing.set("Armour", 8);
        thing.multiplyStat("ItemWeight", 1.5);
        Weapon.setStats(thing, 50, 0, 80, 0, 0, 0);
        Armour.addFootwear(thing);
        thing = Lib.extend("magic boots", "leather boots");
        thing.set("IsMagicItem", 1);
        thing.set("UName", "worn boots");
        thing.add("WieldedModifiers", Modifier.linear("MoveSpeed", 100, 100));
        thing.set("Armour", 4);
        thing.set("LevelMin", 12);
        Armour.addFootwear(thing);
    }

    public static void addArmour(Thing thing) {
        if (thing.getStat("ValueBase") == 0) {
            thing.set("ValueBase", thing.getStat("ItemWeight") / 10);
        }
        Lib.add(thing);
    }

    public static void addWithVariants(Thing thing) {
        for (int i = 0; i < amat.length; ++i) {
            Thing thing2 = (Thing)thing.clone();
            String string = thing2.name();
            thing2.set("Name", amat[i] + " " + string);
            thing2.set("Material", amat[i]);
            thing2.set("UName", umat[i] == null ? string : umat[i] + " " + string);
            if (string.indexOf("boots") >= 0) {
                String string2 = thing2.getString("Name");
                String string3 = thing2.getString("UName");
                if (string2 != null) {
                    thing2.set("NamePlural", "pairs of " + string2);
                }
                if (string3 != null) {
                    thing2.set("UNamePlural", "pairs of " + string3);
                }
            }
            thing2.multiplyStat("ItemWeight", (double)weights[i] / 100.0);
            thing2.set("LevelMin", RPG.max(1, levels[i] + thing2.getStat("LevelMin")));
            thing2.multiplyStat("Frequency", (double)freqs[i] / 100.0);
            thing2.multiplyStat("DSKMul", (double)skills[i] / 100.0);
            thing2.multiplyStat("DSKBonus", (double)skills[i] / 100.0);
            thing2.multiplyStat("Armour", (double)strs[i] / 100.0 * ((double)strs[i] / 100.0) * ((double)strs[i] / 100.0));
            thing2.set("HPS", thing2.getStat("Armour") * 5);
            Armour.addArmour(thing2);
        }
    }

    private static void initStandardArmour() {
        Thing thing = Lib.extend("base standard armour", "base armour");
        thing.set("DefaultThings", "2% [IsArmourRune],2% [IsItemRune]");
        thing.set("Frequency", 30);
        Lib.add(thing);
        thing = Lib.extend("chain mail", "base standard armour");
        thing.set("Image", 349);
        thing.set("LevelMin", 3);
        thing.set("Armour", 10);
        thing.set("ItemWeight", 8000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("scale mail", "base standard armour");
        thing.set("Image", 350);
        thing.set("LevelMin", 4);
        thing.set("Armour", 14);
        thing.set("ItemWeight", 11000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("banded mail", "base standard armour");
        thing.set("Image", 353);
        thing.set("LevelMin", 5);
        thing.set("Armour", 20);
        thing.set("ItemWeight", 15000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("plate mail", "base standard armour");
        thing.set("Image", 354);
        thing.set("LevelMin", 6);
        thing.set("Armour", 30);
        thing.set("ItemWeight", 20000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("heavy plate mail", "base standard armour");
        thing.set("Image", 354);
        thing.set("LevelMin", 6);
        thing.set("Armour", 40);
        thing.set("ItemWeight", 30000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("plate armour", "base standard armour");
        thing.set("Image", 355);
        thing.set("LevelMin", 6);
        thing.set("Armour", 60);
        thing.set("WieldType", 13);
        thing.set("ItemWeight", 40000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("heavy plate armour", "base standard armour");
        thing.set("Image", 355);
        thing.set("LevelMin", 7);
        thing.set("Armour", 80);
        thing.set("ItemWeight", 60000);
        thing.set("WieldType", 13);
        Armour.addWithVariants(thing);
        thing = Lib.extend("base standard helmet", "base standard armour");
        thing.set("Image", 323);
        thing.set("WieldType", 11);
        thing.set("ItemWeight", 3000);
        thing.set("Frequency", 30);
        Lib.add(thing);
        thing = Lib.extend("cap", "base standard helmet");
        thing.set("Image", 324);
        thing.set("LevelMin", 1);
        thing.set("Armour", 2);
        thing.set("ItemWeight", 2000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("studded cap", "base standard helmet");
        thing.set("Image", 320);
        thing.set("LevelMin", 1);
        thing.set("Armour", 3);
        thing.set("ItemWeight", 2200);
        Armour.addWithVariants(thing);
        thing = Lib.extend("helmet", "base standard helmet");
        thing.set("Image", 323);
        thing.set("LevelMin", 2);
        thing.set("Armour", 4);
        thing.set("ItemWeight", 4000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("horned helm", "base standard helmet");
        thing.set("Image", 330);
        thing.set("LevelMin", 4);
        thing.set("Armour", 7);
        thing.set("ItemWeight", 6000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("spike helm", "base standard helmet");
        thing.set("Image", 329);
        thing.set("LevelMin", 5);
        thing.set("Armour", 6);
        thing.set("ItemWeight", 4500);
        Armour.addWithVariants(thing);
        thing = Lib.extend("large helmet", "base standard helmet");
        thing.set("Image", 339);
        thing.set("LevelMin", 6);
        thing.set("Armour", 10);
        thing.set("ItemWeight", 8000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("base standard boots", "base footwear");
        thing.set("WieldType", 8);
        thing.set("Frequency", 10);
        Weapon.setStats(thing, 50, 0, 70, 0, 0, 0);
        Lib.add(thing);
        thing = Lib.extend("plated shoes", "base standard boots");
        thing.set("LevelMin", 3);
        thing.set("Image", 361);
        thing.set("Armour", 2);
        thing.set("ItemWeight", 1500);
        Armour.addWithVariants(thing);
        thing = Lib.extend("plated boots", "base standard boots");
        thing.set("LevelMin", 3);
        thing.set("Image", 361);
        thing.set("Armour", 3);
        thing.set("ItemWeight", 3000);
        Armour.addWithVariants(thing);
        thing = Lib.extend("plated heavy boots", "base standard boots");
        thing.set("LevelMin", 4);
        thing.set("Image", 361);
        thing.set("Armour", 5);
        thing.set("ItemWeight", 5000);
        Armour.addWithVariants(thing);
    }
}

