/* The JamochaMUD Frame synchroniser:
 * SyncFrame.java handles the synchronising of
 * frame minimize/maximize, and potentially, movement events
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;

public class SyncFrame extends Frame {
  
	public SyncFrame(String title) {
		super(title);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		enableEvents(AWTEvent.COMPONENT_EVENT_MASK);
	}

	public void processWindowEvent(WindowEvent event) {
		super.processWindowEvent(event); // Handle listeners
		
		if (event.getID() == WindowEvent.WINDOW_CLOSING) {
		}

		if (event.getID() == WindowEvent.WINDOW_ICONIFIED) {

			// First, check to see if synchronisation is turned on
			if (MuckMain.tWSyncWindowsItem.getState()) {
				// The windows are to synchronise,
				// so we call the 'universal' minimize event
				
				// minimiseAll(event);
			}
		}

		if (event.getID() == WindowEvent.WINDOW_DEICONIFIED) {
		
			// Check the synchronisation state
			if (MuckMain.tWSyncWindowsItem.getState()) {
				// Call the 'universal' show method
		
				// showAll(event);
			}
		}

		if (event.getID() == WindowEvent.WINDOW_ACTIVATED) {
	
			// Window in focus, check to synchronisation state
			if (MuckMain.tWSyncWindowsItem.getState()) {
				FocusWindow();
			}
		}
	
	}
	
	public void processComponentEvent(ComponentEvent event) {
		super.processComponentEvent(event); // Handle listeners

		if (event.getID() == ComponentEvent.COMPONENT_MOVED) {
			// Component has been moved,
			// check for synchronised frames option

			if (MuckMain.tWSyncWindowsItem.getState()) {
				System.out.println("Frame has been moved.");
				System.out.println(event);
			}
		}

		if (event.getID() == ComponentEvent.COMPONENT_RESIZED) {
			// Check to see if the user wants
			// to use synchronised frames
			if (MuckMain.tWSyncWindowsItem.getState()) {

				// Get the movement of a component to apply
				// it to the other frames
				System.out.println("Component has been resized");
			}
		}

	}

	private void minimiseAll(WindowEvent event) {
		// Go through the list of components and make them invisible
		MuckMain.textWindow.dispatchEvent(new WindowEvent(MuckMain.textWindow, event.getID()));

	}

	private void showAll(WindowEvent event) {
		// Go through the list and make visible
		// all the windows that should be

		System.out.println("Should show main window");
		// MuckMain.textWindow.setVisible(true);
		MuckMain.textWindow.dispatchEvent(new WindowEvent(MuckMain.textWindow, event.getID()));
		// processEvent(event);
		// event.consume;
	}

	private void FocusWindow() {
		// Window is in focus, bring all associated
		// windows to the front
		try {
			MuckMain.textWindow.toFront();
		} catch (Exception e) {}

		try {
			DataIn.dataBar.toFront();
		} catch (Exception e) {}

		try {
			MuMacros.macroFrame.toFront();
		} catch (Exception e) {}
		
	}
}
