/**
 * ManagePlugins.java - A dialogue for managing plugins
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.awt.*;
import java.awt.event.*;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import plugins.PlugInterface;

class ManagePlugins extends Dialog implements ActionListener{

	private Button gButton;
	private GridBagLayout managePluginsLayout;
	private GridBagConstraints constraints;
	private Label gLabel;
	private static List activeList, inactiveList, fullList;

	private ManagePlugins(Frame frameParent) {
		// Create the dialog
		
		super(frameParent, "JamochaMUD - " + RB("title"), true);

		managePluginsLayout = new GridBagLayout();
		constraints = new GridBagConstraints();
		
		// Set new layout
		
		setLayout(managePluginsLayout);

		// Display the list of selected pictures
		gLabel = new Label(RB("activePlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		gLabel = new Label(RB("inactivePlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		gLabel = new Label(RB("allPlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		// Add the 3 list items
		activeList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 0;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(activeList, constraints);
		add(activeList);

		inactiveList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 2;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(inactiveList, constraints);
		add(inactiveList);

		fullList = new List();
			constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 4;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(fullList, constraints);
		add(fullList);

		// Add the button for each column
		gButton = new Button(RB("remove"));
		gButton.setActionCommand("remove");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);


		gButton = new Button(RB("add"));
		gButton.setActionCommand("add");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("refresh"));
		gButton.setActionCommand("refresh");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		// Add the Okay and Cancel buttons
		gButton = new Button(RB("properties"));
		gButton.setActionCommand("properties");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 7, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("okay"));
		gButton.setActionCommand("okay");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 7, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("cancel"));
		gButton.setActionCommand("cancel");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 10;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		pack();
	}

	public static void RunMP(Frame parentFrame) {
		
		ManagePlugins managePluginsFrame = new ManagePlugins(parentFrame);
		managePluginsFrame.setSize(450, 200);

		// Now set up the variables
		ListPlugins();

		managePluginsFrame.setVisible(true);

	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "ManagePlugins", itemTarget);
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();

		if (arg.equals("remove")) {
			// Removed selected from list
			// Check to see if an item is selected first
			if (activeList.getSelectedItem() != null) {
				inactiveList.add(activeList.getSelectedItem());
				activeList.remove(activeList.getSelectedItem());
			}
		}

		if (arg.equals("add")) {
			// Add selected from list
			// Check to see if an item is selected first
			if (inactiveList.getSelectedItem() != null) {
				activeList.add(inactiveList.getSelectedItem());
				inactiveList.remove(inactiveList.getSelectedItem());
			}
		}

		if (arg.equals("okay")) {
			// Change active plugins

			// Loop through the main list and
			// change all instances to false
			for (int i = 0; i < fullList.getItemCount(); i++) {
				EnumPlugIns.plugInStatus.setElementAt("false", i);
			}

			// Now set 'true', the list of active plugins
			if (activeList.getItemCount() > 0) {
				for (int j = 0; j < activeList.getItemCount(); j++) {
					EnumPlugIns.plugInStatus.setElementAt("true", j);
				}
			}

			// Write changes to the .plugins.rc file
			SetPlugInStatus();			

			setVisible(false);
			dispose();
		}

		if (arg.equals("cancel")) {
			// Close dialogue, make no changes
			setVisible(false);
			dispose();
		}

		if (arg.equals("properties")) {
			// Call the properties menu for the selected plugin
			try {
				Object plugClass = EnumPlugIns.plugInClass.elementAt(fullList.getSelectedIndex());
				((PlugInterface)plugClass).PlugInProperties();
			} catch (ArrayIndexOutOfBoundsException e) {
				// The array index was out of bounds
				// Chances are no plugin was selected
				// for properties to be viewed	
			} catch (Exception e) {
				System.out.println("(ManagePlugins) Plugin Property Exception " + e);
			}
		}

	}

	private static void ListPlugins() {
		// This will fill the 3 lists with the appropriate info
		String tempName = new String();

		// First, we empty the existing lists
		activeList.removeAll();
		inactiveList.removeAll();
		fullList.removeAll();

		// Now, loop through the names and fill the lists
		for (int i = 0; i < EnumPlugIns.plugInName.size(); i++) {
			tempName = (String)EnumPlugIns.plugInName.elementAt(i);
			fullList.add(tempName);
			if (EnumPlugIns.plugInStatus.elementAt(i).equals("true")) {
				// Plugin is active
				activeList.add(tempName);
			} else {
				// Plugin is inactive
				inactiveList.add(tempName);
			}	
		}
		
	}

	public static void SetPlugInStatus() {
		// Now write the changes to the .plugins.rc file
		
		try {
			FileOutputStream outputFile = new FileOutputStream(EnumPlugIns.userDirectory + ".plugins.rc");
			ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
			serializeStream.writeObject(activeList);
			serializeStream.flush();
		} catch (Exception e) {
			System.out.println("Serialization error " + e);
		}
	}
}
