
import java.awt.*;
import java.awt.event.*;
// import java.io.*;

/*
 * DataIn
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class DataIn extends Frame implements ActionListener, ComponentListener, KeyListener, MouseListener, WindowListener{

	
	public static SyncFrame dataBar;
	static Panel textPanel;
	private PopupMenu backTrack;		
	protected String typedLine, backComm[], bCPopup[];
	public static String dataBarTitle;
	public static TextArea dataText;
//	public static Rectangle dataBarWindow;
	
	public DataIn(){

	// Create the windows
	dataBarTitle = new String(RB("frameTitle.label"));
	dataBar = new SyncFrame(dataBarTitle);  // Create Frame for Main Window
	dataBar.addComponentListener(this);
	dataBar.addWindowListener(this);

	// Set Gridbag layout
        GridBagLayout dILayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        // this.setLayout(dILayout);
        // setLayout(dILayout);
	
        textPanel = new Panel();
	backTrack = new PopupMenu();
	backComm = new String[10];

	// Add the text field to the box.
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = GridBagConstraints.BOTH;
	dataText = new TextArea("", 3, 70, TextArea.SCROLLBARS_VERTICAL_ONLY);
        // dILayout.setConstraints(dataText, constraints);
	
	dataText.addKeyListener(this);
        // textPanel.add(dataText);
        dataBar.add(dataText);
	
	Menu testMenu = new Menu("TestMenu!");
	backTrack.addActionListener(this);
	dataText.add(backTrack); 		// Adds PopupMenu to data entry area
	dataText.addMouseListener(this);	// Adds MouseListener to data entry area
	
        // dataBar.add(textPanel); 
	pack();

	// Display macroBar
	// Dimension d = MuckConn.ss; // Ask MuckConn for screen resolution

	// Set the icon
//	dataBar.setIconImage(MuckConn.jamochaMUDImage);
	dataBar.setIconImage((Image)MuckConn.jmVars.get("JamochaMUDImage"));

	dataText.setForeground((Color)MuckConn.jmVars.get("ForeGroundColour"));
	dataText.setBackground((Color)MuckConn.jmVars.get("BackGroundColour"));
	dataText.setFont((Font)MuckConn.jmVars.get("ScreenFont"));

	}

	
	public static void Content(){
		DataIn z = new DataIn();
		
	}

	public void keyPressed(KeyEvent event){

		int arg = event.getKeyCode();
		
		if (arg == KeyEvent.VK_ENTER) {
			String str = dataText.getText();
			try {
				// System.out.println("Original string: " + str);
				// try to extract any tabs, form feeds
				// backspaces, new lines, and carraige returns
				str.replace('\t', '*');
				str.replace('\f', '*');
				str.replace('\b', '*');
				str.replace('\n', '*');
				str.replace('\r', '*');


				// System.out.println("Refined string :" + str);

				// Send the string to the remote host
				if (MuckMain.tWUseUnicodeItem.getState()) {
					// Use Unicode output
					FromNet.outStream.writeChars(str + "\n");
				} else {
					// Change this to work with ASCII instead of UniCode
					FromNet.outStream.writeBytes(str + '\n');			 			}

				// Reset the caret to the 0, 0 position
				dataText.setCaretPosition(0);
			} catch (Exception oops) {
				System.out.println("DataIn outStream error: " + oops);
			}
			dataText.setText("");

			// Now add the command to the Popupmenu
			addPopUpEntry(str);

			// Send string to lag timer if active
			if (MuckMain.tWTimers.getState()) {
				// Timers are running, send the string
				Timers.AddOutput(str);
			}
		
			event.consume();
		}

		if (arg == KeyEvent.VK_ALT) 
			MuckMain.mainText.requestFocus();

		if (arg == KeyEvent.VK_UP) {
			// Check to see if the cursor is allowed to move up
			if (dataText.getCaretPosition() <= dataText.getColumns()) {
				// Caret is one first line, can't move up
				event.consume();
			}

		}

		if ((arg == KeyEvent.VK_C) && (event.isControlDown())) {
			// 'Supervisor' key was called.
			// Minimize all the windows
			HideFramesQuick();
		}
	
		if ((arg == KeyEvent.VK_Z) && (event.isControlDown())) {
			// restore minimized windows
			RestoreMinimizedFrames();

		}

		if (event.isControlDown()) {
			// We'll send this to MuckMain, to see if
			// it is supposed to be a menu shortcut
			MuckMain.mainText.dispatchEvent(event);
			
		}

		return;
	}

	public void keyTyped(KeyEvent event){}
	
	public void keyReleased(KeyEvent event){
		if (MuckMain.pauseStatus) {
			SpoolText();
		}				// This spools out any paused text
	}
	
	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		if (arg == "^") {
			typedLine = dataText.getText();
		}

		// Determine if a popupmenu item was selected (until a better way is found)
		for (int i = 0; i < backTrack.getItemCount(); i++) {
				if (arg.equals((backTrack.getItem(i).getLabel()))) {
					dataText.setText(backComm[i]);
				}
		};
		return;
	}

	// Check for mouse actions

	public void mousePressed(MouseEvent e) {
        	checkPopup(e) ;
        }
	public void mouseReleased(MouseEvent e) {
            	checkPopup(e) ;
	}
        public void mouseClicked(MouseEvent e) {
		if (MuckMain.pauseStatus) {
			SpoolText();
		}				// This spools out any paused text
	}
	public void mouseEntered(MouseEvent e) {
	}
	public void mouseExited(MouseEvent e) {
	}

	// Component listeners
	public void componentHidden(ComponentEvent e) {
	}

	public void componentMoved(ComponentEvent e) {
	}

	public void componentResized(ComponentEvent e) {
	}

	public void componentShown(ComponentEvent e) {
	}

	// Check for PopupTrigger

	void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
			backTrack.show(this, (e.getX()) + (dataBar.getLocationOnScreen()).x, (e.getY()) + (dataBar.getLocationOnScreen()).y);
			e.consume();
		}
	}

	public void windowActivated(WindowEvent event) {
		// Bring the focus to this window for typing

		// First we insert a 6 millisecond kludge to make
		// up for the requestFocus timing problem in Java 1.1.7+
		long startTime = java.lang.System.currentTimeMillis();
		long currentTime = java.lang.System.currentTimeMillis();		

		// System.out.println("Start DataIn loop");
		while ((currentTime - startTime) < 7) {
			// Just an empty loop
			// System.out.println("Start: " + startTime + " -  Current: " + currentTime);
			// System.out.println(currentTime - startTime);
			currentTime = java.lang.System.currentTimeMillis();	
		}
		// System.out.println("End DataIn loop" + currentTime);

		// Now request focus
		dataText.requestFocus();

		try {
		} catch (Exception e) {
			// This is nothing to worry about, it just means
			// the key was never there in the first place
		}
	}

	public void windowClosed(WindowEvent event) {}

	public void windowClosing(WindowEvent event) {}

	public void windowDeactivated(WindowEvent event) {}

	public void windowDeiconified(WindowEvent event) {}

	public void windowIconified(WindowEvent event) {
		// record the frame into the hashtable
		MuckConn.jmVars.put("DataBar", dataBar.getBounds());
	}

	public void windowOpened(WindowEvent event) {}

	/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "DataIn", itemTarget);
	}


	/**
	* Spool out any text that may have been paused
	*/
	public static void SpoolText() {

		resetTitles();

		MuckMain.pauseStatus = false;
		while (MuckMain.heldResponse.size() > 0) {
			MuckMain.mainText.append(MuckMain.heldResponse.elementAt(0).toString() + '\n');
			MuckMain.heldResponse.removeElementAt(0);
		}	
	}

	/**
	* Method to hide all the frames.  The 'supervisor' function
	*/
	public static void HideFramesQuick() {
		// Hide all the frames, 
		// the supervisor's here!
		dataBar.setTitle(".");
		dataBar.toBack();
		MuckMain.textWindow.setVisible(false);
		MuMacros.macroFrame.setVisible(false);
		
		// Change the icon to something nice and generic
		// dataBar.setIconImage(null);
		// MuckMain.textWindow.setIconImage(null);
		// Now set pause status true, so we don't miss a lot...
		// MuckMain.pauseStatus = true;
	}

	/**
	* Restore frames hidden by the 'Supervisor' function
	*/
	public static void RestoreMinimizedFrames() {
		// Restore the frames that
		// were minimized by the 'supervisor' key
		MuckMain.textWindow.setVisible(true);

		// Restore frame icons
		// dataBar.setIconImage(MuckConn.jamochaMUDImage);
		// MuckMain.textWindow.setIconImage(MuckConn.jamochaMUDImage);
		
		// Querry the MuckMain **** menu, to
		// see if we should set the Macros visible
		if (MuckMain.tWMacro.getState()) {
			// tWMacro is set to 'true', so show the Macro Frame
			MuMacros.macroFrame.setVisible(true);
		}

		// now reset the title
		resetTitles();
	}

	/**
	* Used to reset the dataBar's title
	*/
	private static void resetTitles() {
		if (MuckMain.dFM.isEnabled()) {
			// We're connected to the muck, so
			// show the muck addy in the title
//			dataBar.setTitle(dataBarTitle + " (" + MuckConn.connMuck + ")");
			dataBar.setTitle(dataBarTitle + " (" + MuckConn.jmVars.get("ConnMuck") + ")");

		} else {
			// Not connected, just have normal title
			dataBar.setTitle(dataBarTitle);
            }
	}

	/**
	* Add an entry to the 'command history' pop-up
	*/
	private void addPopUpEntry(String str) {
		if (backTrack.getItemCount() > 9) {
			backTrack.remove(0);  // Removes first entry to make room
			for(int i = 0; i < backTrack.getItemCount(); i++) {
				backComm[i] = backComm[i + 1];
			}
		}
	
		backComm[backTrack.getItemCount()] = str;
		if (str.length() > 30) {
			backTrack.add(str.substring(0, 30) + "...");
		} else {
			backTrack.add(str);
		}
	}

}
