
import java.awt.*;
import java.awt.event.*;

/*
 * ColourPicker is a reusable dialogue to allow RGB colour selection
 * May 11, 1998
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

public class ColourPicker extends Dialog implements ActionListener, AdjustmentListener, KeyListener{
	private Button cancelButton, okayButton;
	private Color currentColour;
	public static Color newColour;
	protected static Frame cPFrame;
	Graphics boxColour;
	private GridBagLayout nicePanel;
	private GridBagConstraints constraints;
	private int a;
	private Panel cPPanel, cPsubPanel1, cPsubPanel2, cPsubPanel3, cPsubPanel4;
	private Scrollbar redBar, greenBar, blueBar;
	private TextField redText, greenText, blueText;
					
	public ColourPicker(Frame frameParent, String titleName, Color currentColour){

		super(frameParent, titleName, true);
		
		cPPanel = new Panel();
		redText = new TextField(currentColour.getRed() + "", 3);
		greenText = new TextField(currentColour.getGreen() + "", 3);
		blueText = new TextField(currentColour.getBlue() + "", 3);

		// Create a GridBagLayout for this dialog
		nicePanel = new GridBagLayout();
		constraints = new GridBagConstraints();
		setLayout(nicePanel);  // Set the nicePanel layout to the dialog

		Label cPLabel = new Label(RB("red"));
			constraints.gridwidth = 1;
			constraints.gridheight = 1;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.EAST;
			nicePanel.setConstraints(cPLabel, constraints);
			add(cPLabel);

			constraints.weightx = 4;
			constraints.gridwidth = 4;
			constraints.insets = new Insets(7, 2, 2, 2);
			redBar = new Scrollbar(Scrollbar.HORIZONTAL);
			redBar.setMaximum(265);
			constraints.fill = GridBagConstraints.HORIZONTAL;
			constraints.anchor = GridBagConstraints.WEST;
			nicePanel.setConstraints(redBar, constraints);
			redBar.setValue(currentColour.getRed());
			redBar.addAdjustmentListener(this);
			add(redBar);
			
			constraints.weightx = 1;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.fill = GridBagConstraints.NONE;
			nicePanel.setConstraints(redText, constraints);
			add(redText);
			redText.setColumns(3);
			redText.addKeyListener(this);

		cPLabel = new Label(RB("green"));
			constraints.gridwidth = 1;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.EAST;
			nicePanel.setConstraints(cPLabel, constraints);
			add(cPLabel);
			
			greenBar = new Scrollbar(Scrollbar.HORIZONTAL);
			greenBar.setMaximum(265);
			constraints.weightx = 4;
			constraints.gridwidth = 4;
			constraints.insets = new Insets(2, 2, 2, 2);
			constraints.fill = GridBagConstraints.HORIZONTAL;
			constraints.anchor = GridBagConstraints.WEST;
			nicePanel.setConstraints(greenBar, constraints);
			greenBar.setValue(currentColour.getGreen());
			greenBar.addAdjustmentListener(this);
			add(greenBar);

			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.fill = GridBagConstraints.NONE;
			nicePanel.setConstraints(greenText, constraints);
			add(greenText);
			greenText.addKeyListener(this);
	
		cPLabel = new Label(RB("blue"));
			constraints.gridwidth = 1;
			constraints.insets = new Insets(7, 2, 3, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.EAST;
			nicePanel.setConstraints(cPLabel, constraints);
			add(cPLabel);
			
			blueBar = new Scrollbar(Scrollbar.HORIZONTAL);
			blueBar.setMaximum(265);
			constraints.insets = new Insets(2, 2, 3, 2);
			constraints.gridwidth = 4;
			constraints.fill = GridBagConstraints.HORIZONTAL;
			constraints.anchor = GridBagConstraints.WEST;
			nicePanel.setConstraints(blueBar, constraints);
			blueBar.setValue(currentColour.getBlue());
			blueBar.addAdjustmentListener(this);
			add(blueBar);

			constraints.insets = new Insets(2, 2, 3, 7);
			constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.fill = GridBagConstraints.NONE;
			nicePanel.setConstraints(blueText, constraints);
			add(blueText);
			blueText.addKeyListener(this);
			
		okayButton = new Button(RB("okay"));
			constraints.gridwidth = 3;
			constraints.weightx = 3;
			constraints.insets = new Insets(3, 7, 7, 2);
			constraints.anchor = GridBagConstraints.EAST;
			constraints.fill = GridBagConstraints.NONE;
			nicePanel.setConstraints(okayButton, constraints);
			add(okayButton);
			okayButton.addActionListener(this);

		cancelButton = new Button(RB("cancel"));
			constraints.gridwidth = 3;
			constraints.weightx = 3;
			constraints.insets = new Insets(3, 2, 7, 7);
			constraints.anchor = GridBagConstraints.WEST;
			constraints.fill = GridBagConstraints.NONE;
			nicePanel.setConstraints(cancelButton, constraints);
			add(cancelButton);
			cancelButton.addActionListener(this);

		pack();
	}


	public static void RunOkay(Frame frameParent, String titleName, Color currentColour){
		cPFrame = new Frame();
		ColourPicker editIt = new ColourPicker(frameParent, titleName, currentColour);
//		Dimension d = MuckConn.ss; //Call screen size from MuckConn
		Dimension d = (Dimension)MuckConn.jmVars.get("ScreenSize");
		int swidth = (int) d.width; // Cast 'd' to integer
		int bwidth = (int) ((swidth / 2) - 100);
		editIt.setLocation(bwidth, 160);
		editIt.setSize(300, 220);
		editIt.setResizable(false);
		editIt.show();
	}

		/*
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
	private static String RB(String itemTarget) {
		return ResReader.LangString("JamochaMUDBundle", "ColourPicker", itemTarget);
	}


	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(okayButton.getLabel())){
			newColour = new Color((redBar.getValue()), (greenBar.getValue()), 					(blueBar.getValue()));
			setVisible(false);
			dispose();
		}
	
		if (arg.equals(cancelButton.getLabel())){
			newColour = null;
			setVisible(false);
			dispose();
		}
	}


	// This block will process the KeyEvents
	public void keyReleased(KeyEvent event) {
		// This will update the colour sample when the box-values change
		int a = 0;
		
		for (int i = 0; i <= 2; i++) {
			System.out.println(i);
			if (i == 0) {
				a = Integer.parseInt(redText.getText());
			}
			if (i == 1) {
				a = Integer.parseInt(greenText.getText());
			}
			if (i == 2) {	
				a = Integer.parseInt(blueText.getText());
			}

			// determine if number falls within the 0 - 255 parameters
			if (a >= 256 || a <= -1) {
				break;  // Exit loop.  Illegal number
			}

			// Since this number passed the test,
			// set the slider to the correct position

			if (i == 0) {
				redBar.setValue(a);
			}
			if (i == 1) {
				greenBar.setValue(a);
			}
			if (i == 2) {
				blueBar.setValue(a);
			}
			// Now update the colour in the sample box
			repaint();
		}

	}

	public void keyTyped(KeyEvent event){}
	
	public void keyPressed(KeyEvent event) {}


	// Respond to the sliders
	public void adjustmentValueChanged(AdjustmentEvent e) {
		redText.setText(String.valueOf(redBar.getValue()));
		greenText.setText(String.valueOf(greenBar.getValue()));
		blueText.setText(String.valueOf(blueBar.getValue()));
		repaint();
        }

	public void paint(Graphics g) {
		g.setColor(new Color(redBar.getValue(), greenBar.getValue(), blueBar.getValue()));
		g.fill3DRect(25, 180, 250, 30, true);
	}
	
}
