/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : ScaleParms.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/


class ScaleParms implements GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

  int WindowWidth;
  int WindowHeight;
  int SpaceWidthShift;
  int SpaceHeightShift;
  int SpaceWidth;
  int SpaceHeight;
  int RadarWidthShift;
  int RadarHeightShift;
  int RadarWidth;
  int RadarHeight;
  int SpriteWidthShift;
  int SpriteHeightShift;
  int SpriteWidth;
  int SpriteHeight;
  int EnemyShift;
  int ShipAxisMove;
  int ShipDiagMove;

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : ScaleParms
 * DESCRIPTION	  :
 *****************************************************************************/
  ScaleParms(int scale)
  {

    WindowWidth = WSIZE << scale;
    WindowHeight = WSIZE << scale;
    RadarWidthShift = MAP_SIZEX_LOG2 + scale;
    RadarHeightShift = MAP_SIZEY_LOG2 + scale;
    RadarWidth = 1 << RadarWidthShift;
    RadarHeight = 1 << RadarHeightShift;
    SpaceWidth = 1 << (SPRITE_SIZEX_LOG2 + RadarWidthShift);
    SpaceHeight = 1 << (SPRITE_SIZEY_LOG2 + RadarHeightShift);
    SpriteWidthShift = SPRITE_SIZEX_LOG2 + scale;
    SpriteHeightShift = SPRITE_SIZEY_LOG2 + scale;
    SpriteWidth = 1 << SpriteWidthShift;
    SpriteHeight = 1 << SpriteHeightShift;
    EnemyShift = SHIFT + scale;
    ShipAxisMove = 3 << scale;
    ShipDiagMove = 2 << scale;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getWindowWidth
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getWindowWidth()
  {

    return(WindowWidth);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getWindowHeight
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getWindowHeight()
  {

    return(WindowHeight);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarWidthShift
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getRadarWidthShift()
  {

    return(RadarWidthShift);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarHeightShift
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getRadarHeightShift()
  {

    return(RadarHeightShift);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarWidth
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getRadarWidth()
  {

    return(RadarWidth);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarHeight
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getRadarHeight()
  {

    return(RadarHeight);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpaceWidth
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpaceWidth()
  {

    return(SpaceWidth);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpaceHeight
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpaceHeight()
  {

    return(SpaceHeight);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpriteWidthShift
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpriteWidthShift()
  {

    return(SpriteWidthShift);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpriteHeightShift
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpriteHeightShift()
  {

    return(SpriteHeightShift);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpriteWidth
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpriteWidth()
  {

    return(SpriteWidth);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpriteHeight
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSpriteHeight()
  {

    return(SpriteHeight);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemyShift
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getEnemyShift()
  {

    return(EnemyShift);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getShipAxisMove
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getShipAxisMove()
  {

    return(ShipAxisMove);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getShipDiagMove
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getShipDiagMove()
  {

    return(ShipDiagMove);

  }

}  /* END OF CLASS : ScaleParms */


/* END OF FILE : ScaleParms.java */

