/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Map.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;

class Map implements MapDefines
{

/******************************** GLOBAL DATA ********************************/

  int sx, sy;
  int sitex[];
  int sitey[];
  int site_max;
  byte data[];

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Map
 * DESCRIPTION	  :
 *****************************************************************************/
  Map(int sizex, int sizey)
  {

    sitex = new int[SITE_MAX];
    sitey = new int[SITE_MAX];
    sx = sizex;
    sy = sizey;
    data = new byte[sizex * sizey];

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init()
  {
    int i, j;

    for(i=0; i<sx; i++)
      for(j=0; j<sy; j++)
	setPos(i, j, SPACE);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : mazePop
 * DESCRIPTION	  :
 *****************************************************************************/
   private int mazePop()
   {
    int i, tmpx, tmpy;

    if(site_max == 0)
      return(1);
    i = (JKobo.Context.getRandom().nextInt() & 0x7fffffff) % site_max;
    site_max--;
    if(i != site_max)
      {
	tmpx = sitex[site_max];
	tmpy = sitey[site_max];
	sitex[site_max] = sitex[i];
	sitey[site_max] = sitey[i];
	sitex[i] = tmpx;
	sitey[i] = tmpy;
      }

    return(0);

   }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : mazePush
 * DESCRIPTION	  :
 *****************************************************************************/
   private void mazePush(int x, int y)
   {

    sitex[site_max] = x;
    sitey[site_max++] = y;
    setPos(x, y, WALL);

   }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : mazeMoveAndPush
 * DESCRIPTION	  :
 *****************************************************************************/
   private void mazeMoveAndPush(int x, int y, int d)
   {
    int x1 = x;
    int y1 = y;

    switch(d)
      {
      case 1:
	x1 += 2;
	break;
      case 2:
	y1 += 2;
	break;
      case 3:
	x1 -= 2;
	break;
      case 4:
	y1 -= 2;
	break;
      }

    mazePush(x1, y1);
    setPos((x + x1) >> 1, (y + y1) >> 1, WALL);

   }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : mazeJudge
 * DESCRIPTION	  :
 *****************************************************************************/
   private int mazeJudge(int cx, int cy, int dx, int dy, int x, int y)
   {

    if((x < cx-dx) || (x > cx+dx) || (y < cy-dy) || (y > cy+dy))
      return(0);

    if(getPos(x, y) == WALL)
      return(0);

    return(1);

   }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : makeMaze
 * DESCRIPTION	  :
 *****************************************************************************/
  void makeMaze(int x, int y, int difx, int dify)
  {
    int i, j;
    int vx, vy;
    int dirs[];
    int dirs_max;
    Random rand;


    /* clear */
    rand = JKobo.Context.getRandom();
    dirs = new int[4];
    for(i=x-difx; i<=x+difx; i++)
      for(j=y-dify; j<=y+dify; j++)
	setPos(i, j, SPACE);
    setPos(x, y, CORE);

    /* push initial sites */
    site_max = 0;

    if((rand.nextInt() >>> 24) < 128)
      {
	mazePush(x-1, y);
	mazePush(x+1, y);
      }
    else
      {
	mazePush(x, y-1);
	mazePush(x, y+1);
      }


    for(;;)
      {
	/* get one */
	if(mazePop() != 0)
	  break;
	vx = sitex[site_max];
	vy = sitey[site_max];

	for(dirs_max=i=0; i<4; i++)
	   dirs[i] = 0;
	if(mazeJudge(x, y, difx, dify, vx + 2, vy) != 0)
	  dirs[dirs_max++] = 1;
	if(mazeJudge(x, y, difx, dify, vx, vy + 2) != 0)
	  dirs[dirs_max++] = 2;
	if(mazeJudge(x, y, difx, dify, vx - 2, vy) != 0)
	  dirs[dirs_max++] = 3;
	if(mazeJudge(x, y, difx, dify, vx, vy - 2) != 0)
	  dirs[dirs_max++] = 4;
	if(dirs_max == 0)
	  continue; /* there are no places to go */
	i = rand.nextInt();
	i = (i & 0x7fffffff) % dirs_max;
	mazeMoveAndPush(vx, vy, dirs[i]);
	mazePush(vx, vy);
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : convert
 * DESCRIPTION	  :
 *****************************************************************************/
  void convert(int ratio)   /* ratio < 64 */
  {
    int i, j;
    int p;
    Random rand;


    rand = JKobo.Context.getRandom();
    for(i=0; i<sx; i++)
      {
	for(j=0; j<sy; j++)
	  {
	    if(getPos(i,j) != WALL)
	      continue;
	    p = 0;
	    if((j > 0	) && (getPos(i, j-1) != SPACE))
	      p |= U_MASK;
	    if((i < sx-1) && (getPos(i+1, j) != SPACE))
	      p |= R_MASK;
	    if((j < sy-1) && (getPos(i, j+1) != SPACE))
	      p |= D_MASK;
	    if((i > 0	) && (getPos(i-1, j) != SPACE))
	      p |= L_MASK;
	    if((p == U_MASK) || (p == R_MASK) || (p == D_MASK) || (p == L_MASK))
	      {
		if((rand.nextInt() >>> 24) < ratio)
		  p |= HARD;
	      }
	    setPos(i, j, p);
	  }
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getPos
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getPos(int x, int y)
  {
    return((int) data[(y * sx) + x]);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setPos
 * DESCRIPTION	  :
 *****************************************************************************/
  final void setPos(int x, int y, int n)
  {
    data[(y * sx) + x] = (byte) n;
  }

}  /* END OF CLASS : Map */


/* END OF FILE : Map.java */

