/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.input;

import com.golden.gamedev.engine.BaseInput;
import com.golden.gamedev.engine.input.KeyTyped;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

public class AWTInput
implements BaseInput {
    private Component component;
    private InputListener listener;
    private int mouseX;
    private int mouseY;
    private int lastMouseX;
    private int lastMouseY;
    private int mouseDX;
    private int mouseDY;
    private boolean mouseExists;
    private boolean mouseVisible;
    private boolean[] mouseDown;
    private int[] mousePressed;
    private int[] mouseReleased;
    private int pressedMouse;
    private int releasedMouse;
    private boolean[] keyDown;
    int[] keyPressed;
    int[] keyReleased;
    int pressedKey;
    int releasedKey;
    private KeyTyped keyTyped;

    public AWTInput(Component comp) {
        this.component = comp;
        this.component.requestFocus();
        this.listener = this.createInputListener();
        this.component.addKeyListener(this.listener);
        this.component.addMouseListener(this.listener);
        this.component.addMouseMotionListener(this.listener);
        this.component.addFocusListener(this.listener);
        this.keyDown = new boolean[255];
        this.keyReleased = new int[20];
        this.keyPressed = this.keyReleased;
        this.releasedKey = 0;
        this.pressedKey = 0;
        this.keyTyped = new KeyTyped(this);
        this.mouseExists = true;
        this.mouseVisible = true;
        this.mouseDown = new boolean[4];
        this.mouseReleased = new int[4];
        this.mousePressed = this.mouseReleased;
        this.releasedMouse = 0;
        this.pressedMouse = 0;
        this.mouseDY = 0;
        this.mouseDX = 0;
        this.lastMouseY = 0;
        this.lastMouseX = 0;
        this.mouseY = 0;
        this.mouseX = 0;
        try {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            DisplayMode mode = device.getDisplayMode();
            this.mouseX = this.lastMouseX = mode.getWidth() / 2 - 10;
            this.mouseY = this.lastMouseY = mode.getHeight() / 2 - 10;
            new Robot().mouseMove(this.mouseX, this.mouseY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        comp.setFocusTraversalKeysEnabled(false);
    }

    protected InputListener createInputListener() {
        return new InputListener();
    }

    public void update(long elapsedTime) {
        this.keyTyped.update(elapsedTime);
        this.releasedMouse = 0;
        this.pressedMouse = 0;
        this.mouseDX = this.mouseX - this.lastMouseX;
        this.mouseDY = this.mouseY - this.lastMouseY;
        this.lastMouseX = this.mouseX;
        this.lastMouseY = this.mouseY;
        this.releasedKey = 0;
        this.pressedKey = 0;
    }

    public void refresh() {
        int i;
        this.keyTyped.refresh();
        for (i = 0; i < this.mouseDown.length; ++i) {
            this.mouseDown[i] = false;
        }
        this.releasedMouse = 0;
        this.pressedMouse = 0;
        this.mouseDY = 0;
        this.mouseDX = 0;
        for (i = 0; i < this.keyDown.length; ++i) {
            this.keyDown[i] = false;
        }
        this.releasedKey = 0;
        this.pressedKey = 0;
    }

    public void cleanup() {
        try {
            this.component.removeKeyListener(this.listener);
            this.component.removeMouseListener(this.listener);
            this.component.removeMouseMotionListener(this.listener);
            this.component.removeFocusListener(this.listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseMove(int x, int y) {
        try {
            new Robot().mouseMove(x, y);
        }
        catch (Exception e) {
            System.err.println("WARNING: Can't move the mouse pointer to " + x + ", " + y);
        }
    }

    public boolean isMouseExists() {
        return this.mouseExists;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getMouseDX() {
        return this.mouseDX;
    }

    public int getMouseDY() {
        return this.mouseDY;
    }

    public void setMouseVisible(boolean visible) {
        if (this.mouseVisible == visible) {
            return;
        }
        this.mouseVisible = visible;
        if (!visible) {
            Toolkit t = Toolkit.getDefaultToolkit();
            Dimension d = t.getBestCursorSize(1, 1);
            if (d.width == 0 || d.height == 0) {
                d.height = 1;
                d.width = 1;
            }
            BufferedImage nullImg = new BufferedImage(d.width, d.height, 2);
            Cursor c = t.createCustomCursor(nullImg, new Point(0, 0), "null");
            this.component.setCursor(c);
        } else {
            this.component.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean isMouseVisible() {
        return this.mouseVisible;
    }

    public int getMousePressed() {
        return this.pressedMouse > 0 ? this.mousePressed[0] : Integer.MIN_VALUE;
    }

    public boolean isMousePressed(int button) {
        for (int i = 0; i < this.pressedMouse; ++i) {
            if (this.mousePressed[i] != button) continue;
            return true;
        }
        return false;
    }

    public int getMouseReleased() {
        return this.releasedMouse > 0 ? this.mouseReleased[0] : Integer.MIN_VALUE;
    }

    public boolean isMouseReleased(int button) {
        for (int i = 0; i < this.releasedMouse; ++i) {
            if (this.mouseReleased[i] != button) continue;
            return true;
        }
        return false;
    }

    public boolean[] getMouseDown() {
        return this.mouseDown;
    }

    public boolean isMouseDown(int button) {
        return this.mouseDown[button];
    }

    public int getKeyPressed() {
        return this.pressedKey > 0 ? this.keyPressed[0] : Integer.MIN_VALUE;
    }

    public boolean isKeyPressed(int keyCode) {
        for (int i = 0; i < this.pressedKey; ++i) {
            if (this.keyPressed[i] != keyCode) continue;
            return true;
        }
        return false;
    }

    public int getKeyReleased() {
        return this.releasedKey > 0 ? this.keyReleased[0] : Integer.MIN_VALUE;
    }

    public boolean isKeyReleased(int keyCode) {
        for (int i = 0; i < this.releasedKey; ++i) {
            if (this.keyReleased[i] != keyCode) continue;
            return true;
        }
        return false;
    }

    public boolean[] getKeyDown() {
        return this.keyDown;
    }

    public boolean isKeyDown(int keyCode) {
        return this.keyDown[keyCode & 0xFF];
    }

    public int getKeyTyped() {
        return this.keyTyped.getKeyTyped();
    }

    public boolean isKeyTyped(int keyCode) {
        return this.keyTyped.isKeyTyped(keyCode);
    }

    public long getRepeatDelay() {
        return this.keyTyped.getRepeatDelay();
    }

    public void setRepeatDelay(long delay) {
        this.keyTyped.setRepeatDelay(delay);
    }

    public long getRepeatRate() {
        return this.keyTyped.getRepeatRate();
    }

    public void setRepeatRate(long rate) {
        this.keyTyped.setRepeatRate(rate);
    }

    public Component getComponent() {
        return this.component;
    }

    protected class InputListener
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    FocusListener {
        protected InputListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (!AWTInput.this.keyDown[e.getKeyCode() & 0xFF]) {
                ((AWTInput)AWTInput.this).keyDown[e.getKeyCode() & 0xFF] = true;
                AWTInput.this.keyPressed[AWTInput.this.pressedKey] = e.getKeyCode();
                ++AWTInput.this.pressedKey;
            }
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            ((AWTInput)AWTInput.this).keyDown[e.getKeyCode() & 0xFF] = false;
            AWTInput.this.keyReleased[AWTInput.this.releasedKey] = e.getKeyCode();
            ++AWTInput.this.releasedKey;
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            AWTInput.this.mouseExists = true;
        }

        public void mouseExited(MouseEvent e) {
            AWTInput.this.mouseExists = false;
            for (int i = 0; i < 4; ++i) {
                ((AWTInput)AWTInput.this).mouseDown[i] = false;
            }
        }

        public void mousePressed(MouseEvent e) {
            ((AWTInput)AWTInput.this).mouseDown[e.getButton()] = true;
            ((AWTInput)AWTInput.this).mousePressed[((AWTInput)AWTInput.this).pressedMouse] = e.getButton();
            AWTInput.this.pressedMouse++;
        }

        public void mouseReleased(MouseEvent e) {
            ((AWTInput)AWTInput.this).mouseDown[e.getButton()] = false;
            ((AWTInput)AWTInput.this).mouseReleased[((AWTInput)AWTInput.this).releasedMouse] = e.getButton();
            AWTInput.this.releasedMouse++;
        }

        public void mouseDragged(MouseEvent e) {
            AWTInput.this.mouseX = e.getX();
            AWTInput.this.mouseY = e.getY();
        }

        public void mouseMoved(MouseEvent e) {
            AWTInput.this.mouseX = e.getX();
            AWTInput.this.mouseY = e.getY();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            AWTInput.this.refresh();
        }
    }
}

