/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.TurtelShell;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;

public class EnemyTurtlePatrol
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = 6;
    boolean Standing = true;
    int Left = 0;
    int right = 0;
    public boolean Green = false;

    public EnemyTurtlePatrol(int x, int y, Mario g, int Length) {
        this.game = g;
        this.setImages(this.game.bsLoader.getStoredImages("EnemyTurtlePatrol"));
        this.setLocation(x, y);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.Left = x;
        this.right = x + 32 * Length;
        this.setID(102);
    }

    public void update(long l) {
        if (this.getX() < (double)this.Left) {
            this.CollidedWithBrick_GoToRight();
        }
        if (this.getX() > (double)this.right) {
            this.CollidedWithBrick_GoToLeft();
        }
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-2.0);
        } else {
            this.moveX(2.0);
        }
        super.update(l);
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY() + 16.0, this.game, this.MariotoRight(), this.Standing, this.Green));
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
        this.setActive(false);
    }

    public void KilledByFireBall() {
        if (this.Green) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
        } else {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
        }
        this.setActive(false);
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    public void CollidedWithShell() {
    }

    public int getType() {
        return this.getID();
    }

    public void CollidedWithMovingShell() {
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        if (this.Green) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
        } else {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
        }
        this.setActive(false);
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            if (this.Green) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
            }
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            if (this.Green) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
            }
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            if (this.Green) {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShell"), this.MariotoRight()));
            } else {
                this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.game.bsLoader.getStoredImage("TurtelShellRed"), this.MariotoRight()));
            }
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.game.EnemyGroup.add(new TurtelShell(this.getX(), this.getY() + 16.0, this.game, this.MariotoRight(), false, "Jump", this.Green));
        this.Standing = false;
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

