/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/* ToolPanel------------------ */
/**
 * A class to act like a tool bar button a game item.
 * @author mallette
 */
public class ToolPanel extends JPanel
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long serialVersionUID = 1L;
  /** a label for the tool (which shows the icon for the tool) */
  private JLabel            labelTool;
  /** a label for the tool (which shows the number of uses left) */
  private JLabel            labelToolAmount;
  /** the item name for this tool */
  private Item.Type         name;

  /**
   * @param parent the parent component for this component
   * @param layout the layout manager for this component
   * @param toolName the human readable name of the item
   * @param _name the tool name (enum)
   * @param weaponIcon the icon for this tool
   * @param infiniteIcon the icon for this tool when it is unlimited (infinite)
   */
  public ToolPanel(Component parent,LayoutManager layout,String toolName,Item.Type _name,ImageIcon weaponIcon,ImageIcon infiniteIcon)
  {
    super(layout);
    this.labelTool = new JLabel(weaponIcon);
    this.labelToolAmount = new JLabel(infiniteIcon);
    this.setSize(this.getPreferredSize());
    this.setVisible(true);
    this.setToolTipText(toolName);
    this.addKeyListener((KeyListener)parent);
    this.addMouseListener((MouseListener)parent); // allow click on weapon labels to
    // change weapons
    this.labelTool.setSize(this.labelTool.getPreferredSize());
    this.labelTool.setText(" "); //$NON-NLS-1$
    this.labelTool.addMouseListener((MouseListener)parent); // allow click on weapon labels to change weapons
    this.labelToolAmount.setSize(this.labelToolAmount.getPreferredSize());
    this.labelToolAmount.setText(" "); //$NON-NLS-1$
    this.labelToolAmount.addMouseListener((MouseListener)parent); // allow click on weapon labels to change weapons
    this.name = _name;
    this.add(this.labelTool);
    this.add(this.labelToolAmount);
  }

  /**
   * @return the item this represents
   */
  public JLabel getItem()
  {
    return this.labelTool;
  }

  /**
   * @return the number of uses left for this item
   */
  public JLabel getAmount()
  {
    return this.labelToolAmount;
  }

  /**
   * @return the item enum (or number)
   */
  public Item.Type getItemNumber()
  {
    return this.name;
  }

  /**
   * @param toolTip the tool tip to display for this tool
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.JComponent#setToolTipText(java.lang.String)
   */
  @Override
  public void setToolTipText(String toolTip)
  {
    this.labelTool.setToolTipText(toolTip);
    this.labelToolAmount.setToolTipText(toolTip);
    super.setToolTipText(toolTip);
  }

  /**
   * Provide a String representation of this object.
   * @return String A representation of the object for debugging.
   */
  @Override
  public String toString()
  {
    return String.format(Messages.getString("ToolPanel.ToString"),super.toString(),this.labelTool,this.labelToolAmount,this.name); //$NON-NLS-1$
  }
}
/* ToolPanel------------------ */
