/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;

import javax.swing.JOptionPane;

/* TextLoader----------------- */
/**
 * A class to load text files robustly in a thread
 * @author mallette
 */
public class TextLoader extends Thread implements Serializable
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long serialVersionUID = 1L;
  /** The buffer size to use when loading text files (amount read at once). */
  private final static int  BUFFERSIZE       = 32767;                          // optimal size, when 65535 is used it slows down a lot
  /** The maxmimum buffer size to use when storing loaded text files. */
  private final static int  BUFFERMAXIMUM    = TextLoader.BUFFERSIZE * 3;
  /** The buffer to use for loading files. */
  private StringBuffer      fileData         = new StringBuffer(TextLoader.BUFFERMAXIMUM); // currently much greater than length of files needed
  /** The file name to use. */
  private String            fileName;

  /**
   * Constructor
   * @param _fileName the name of the file to load
   */
  public TextLoader(String _fileName)
  {
    this.fileName = _fileName;
  }

  /**
   * Run a separate thread to load the file.
   */
  /*
   * (non-Javadoc)
   * @see java.lang.Thread#run()
   */
  @Override
  public void run()
  {
    System.out.printf(Messages.getString("TextLoader.LoadingFile"),this.fileName); //$NON-NLS-1$
    try
    {
      InputStream inputStream = this.getClass().getResourceAsStream('/' + this.fileName);
      InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
      BufferedReader bufferedReader = new BufferedReader(inputStreamReader,TextLoader.BUFFERSIZE);
      char[] buffer = new char[TextLoader.BUFFERSIZE];
      int size = 0;
      while ((size = bufferedReader.read(buffer,0,TextLoader.BUFFERSIZE)) > 0 && this.fileData.length() < TextLoader.BUFFERMAXIMUM)
        this.fileData.append(buffer,0,size);
      bufferedReader.close();
    }
    catch (IOException iOException)
    {
      JOptionPane.showMessageDialog(null,String.format(Messages.getString("TextLoader.MissingFile"),this.fileName),Messages.getString("TextLoader.MissingTextFile"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
    }
    System.out.printf(Messages.getString("TextLoader.LoadedFile"),this.fileName); //$NON-NLS-1$
  }

  /**
   * @return the text of the file just loaded
   */
  public String getText()
  {
    return this.fileData.toString();
  }

  /**
   * Provide a String representation of this object.
   * @return String A representation of the object for debugging.
   */
  @Override
  public String toString()
  {
    return String.format(Messages.getString("TextLoader.ToString"),this.fileName,this.fileData); //$NON-NLS-1$
  }
}
/* TextLoader----------------- */
