/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
package javoids;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

import javax.swing.JOptionPane;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/* TextLoader----------------- */
/**
 * A class to load and store the original item list.
 * @author mallette
 */
public class ItemLoader extends DefaultHandler implements Serializable
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private static final long       serialVersionUID = 1L;
  /** the file name to load */
  private String                  fileName;
  /** a mapping of item names to items */
  private HashMap<Item.Type,Item> items            = new HashMap<Item.Type,Item>();
  /** a built item */
  private Item                    item;
  /** is an item type being processed? */
  private boolean                 isType;
  /** is an item name being processed? */
  private boolean                 isName;
  /** is an item limitless being processed? */
  private boolean                 isLimitless;
  /** is an item default image being processed? */
  private boolean                 isDefaultImage;
  /** is an item image being processed? */
  private boolean                 isImage;
  /** is an item sound being processed? */
  private boolean                 isSound;
  /** is an item default count being processed? */
  private boolean                 isDefaultCount;
  /** is an item maximum count being processed? */
  private boolean                 isMaximumCount;
  /** is an item size being processed? */
  private boolean                 isSize;
  /** is an item bullet image being processed? */
  private boolean                 isBulletImage;
  /** is an item shielded image being processed? */
  private boolean                 isShieldedImage;
  /** is an item homing image being processed? */
  private boolean                 isHomingImage;
  /** is an item shielded homing image being processed? */
  private boolean                 isShieldedHomingImage;
  /** is an item damage being processed? */
  private boolean                 isDamage;
  /** is an item maximum firred being processed? */
  private boolean                 isMaximumFired;
  /** is an item range being processed? */
  private boolean                 isRange;
  /** is an item velocity being processed? */
  private boolean                 isVelocity;
  /** is an item directions being processed? */
  private boolean                 isDirections;

  /**
   * Load the item properties from an xml file.
   * @param _fileName the file to use to load the item properties
   */
  public ItemLoader(String _fileName)
  {
    super();
    this.fileName = _fileName;
  }

  /**
   * @return a mapping of the item type to the item
   */
  public HashMap<Item.Type,Item> getItems()
  {
    return this.items;
  }

  /**
   * @return a copy of the items that were loaded
   */
  public HashMap<Item.Type,Item> copyItems()
  {
    HashMap<Item.Type,Item> _items = new HashMap<Item.Type,Item>(this.items.size()); // correctly size the HashMap
    for (Item _item : this.items.values())
    {
      if (!Item.Type.NO_TOOL.equals( _item.getType() ))
      {
        if (_item instanceof Weapon)
          _items.put(_item.getType(),new Weapon((Weapon)_item));
        else
          _items.put(_item.getType(),new Item(_item));
      }
    }
    return _items;
  }

  /**
   * run the code needed to load the items from the file in a separate thread.
   */
  public void run()
  {
    System.out.printf(Messages.getString("ItemLoader.FileLoading"),this.fileName); //$NON-NLS-1$
    try
    {
      XMLReader xMLReader = XMLReaderFactory.createXMLReader();
      xMLReader.setContentHandler(this);
      xMLReader.setErrorHandler(this);
      xMLReader.parse(this.getClass().getResource('/' + this.fileName).toString());
    }
    catch (IOException ioException)
    {
      JOptionPane.showMessageDialog(null,String.format(Messages.getString("ItemLoader.MissingFile"),this.fileName),Messages.getString("ItemLoader.ErrorTextFileMissing"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
    }
    catch (SAXException saxException)
    {
      JOptionPane.showMessageDialog(null,String.format(Messages.getString("ItemLoader.ParseError"),this.fileName),Messages.getString("ItemLoader.ErrorTextFileMissing"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
    }
    System.out.printf(Messages.getString("ItemLoader.FileLoaded"),this.fileName); //$NON-NLS-1$
  }

  /**
   * Start processing an XML document.
   */
  /*
   * (non-Javadoc)
   * @see org.xml.sax.helpers.DefaultHandler#startDocument()
   */
  @Override
  public void startDocument()
  {
    /* Do Nothing */
  }

  /**
   * End processing an XML document.
   */
  /*
   * (non-Javadoc)
   * @see org.xml.sax.helpers.DefaultHandler#endDocument()
   */
  @Override
  public void endDocument()
  {
    /* Do Nothing */
  }

  /**
   * @param uri the uri to parse
   * @param name the element name to parse
   * @param itemName the qualified element name
   * @param attributes the attributes for the element
   */
  /*
   * (non-Javadoc)
   * @see org.xml.sax.helpers.DefaultHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
   */
  @Override
  public void startElement(String uri,String name,String itemName,Attributes attributes)
  {
    if (Debug.debugItem)
      System.out.printf(Messages.getString("ItemLoader.DebugUriNameAttributes"),uri,name,attributes); //$NON-NLS-1$
    if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Item"))) //$NON-NLS-1$
    {
      this.item = new Item();
      this.isType = false;
      this.isName = false;
      this.isLimitless = false;
      this.isDefaultImage = false;
      this.isImage = false;
      this.isSound = false;
      this.isDefaultCount = false;
      this.isMaximumCount = false;
      this.isSize = false;
      this.isBulletImage = false;
      this.isShieldedImage = false;
      this.isHomingImage = false;
      this.isShieldedHomingImage = false;
      this.isDamage = false;
      this.isMaximumFired = false;
      this.isRange = false;
      this.isVelocity = false;
      this.isDirections = false;
    }
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Type"))) //$NON-NLS-1$
      this.isType = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Name"))) //$NON-NLS-1$
      this.isName = true;
    else if (itemName.equalsIgnoreCase("limitless")) //$NON-NLS-1$
      this.isLimitless = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.DefaultImage"))) //$NON-NLS-1$
      this.isDefaultImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Image"))) //$NON-NLS-1$
      this.isImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Sound"))) //$NON-NLS-1$
      this.isSound = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.DefaultCount"))) //$NON-NLS-1$
      this.isDefaultCount = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.MaximumCount"))) //$NON-NLS-1$
      this.isMaximumCount = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Size"))) //$NON-NLS-1$
      this.isSize = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.BulletImage"))) //$NON-NLS-1$
      this.isBulletImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.ShieldedImage"))) //$NON-NLS-1$
      this.isShieldedImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.HomingImage"))) //$NON-NLS-1$
      this.isHomingImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.ShieldedHomingImage"))) //$NON-NLS-1$
      this.isShieldedHomingImage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Damage"))) //$NON-NLS-1$
      this.isDamage = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.MaximumFired"))) //$NON-NLS-1$
      this.isMaximumFired = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Range"))) //$NON-NLS-1$
      this.isRange = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Velocity"))) //$NON-NLS-1$
      this.isVelocity = true;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Directions"))) //$NON-NLS-1$
      this.isDirections = true;
  }

  /**
   * @param uri the uri to parse
   * @param name the element name to parse
   * @param itemName the qualified element name
   */
  /*
   * (non-Javadoc)
   * @see org.xml.sax.helpers.DefaultHandler#endElement(java.lang.String, java.lang.String, java.lang.String)
   */
  @Override
  public void endElement(String uri,String name,String itemName)
  {
    if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Item"))) //$NON-NLS-1$
    {
      if (Debug.debugItem)
        System.out.printf(Messages.getString("ItemLoader.DebugUriName"),uri,name); //$NON-NLS-1$
      switch (this.item.getType())
      {
        case GUN1 :
          this.item.setCount(this.item.getDefaultCount());
          break;
        case SHIELD :
          this.item.setCount(this.item.getDefaultCount());
          break;
        case AFTERBURNER :
          this.item.setCount(this.item.getDefaultCount());
          break;
        default :
          break;
      }
      this.items.put(this.item.getType(),this.item);
      this.isType = false;
    }
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Type"))) //$NON-NLS-1$
      this.isType = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Name"))) //$NON-NLS-1$
      this.isName = false;
    else if (itemName.equalsIgnoreCase("limitless")) //$NON-NLS-1$
      this.isLimitless = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.DefaultImage"))) //$NON-NLS-1$
      this.isDefaultImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Image"))) //$NON-NLS-1$
      this.isImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Sound"))) //$NON-NLS-1$
      this.isSound = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.DefaultCount"))) //$NON-NLS-1$
      this.isDefaultCount = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.MaximumCount"))) //$NON-NLS-1$
      this.isMaximumCount = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Size"))) //$NON-NLS-1$
      this.isSize = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.BulletImage"))) //$NON-NLS-1$
      this.isBulletImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.ShieldedImage"))) //$NON-NLS-1$
      this.isShieldedImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.HomingImage"))) //$NON-NLS-1$
      this.isHomingImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.ShieldedHomingImage"))) //$NON-NLS-1$
      this.isShieldedHomingImage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Damage"))) //$NON-NLS-1$
      this.isDamage = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.MaximumFired"))) //$NON-NLS-1$
      this.isMaximumFired = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Range"))) //$NON-NLS-1$
      this.isRange = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Velocity"))) //$NON-NLS-1$
      this.isVelocity = false;
    else if (itemName.equalsIgnoreCase(Messages.getString("ItemLoader.Directions"))) //$NON-NLS-1$
      this.isDirections = false;
  }

  /**
   * @param characters the PCDATA between the tags
   * @param start The start position
   * @param length the length of the data
   */
  /*
   * (non-Javadoc)
   * @see org.xml.sax.helpers.DefaultHandler#characters(char[], int, int)
   */
  @Override
  public void characters(char characters[],int start,int length)
  {
    String value = String.copyValueOf(characters,start,length);
    try
    {
      if (Debug.debugItem && value.trim().length() > 0)
        System.out.printf(Messages.getString("ItemLoader.ValueEquals"),value); //$NON-NLS-1$
      if (this.isType)
      {
        Item.Type type = Item.Type.valueOf(value);
        if (Item.isWeapon(type))
          this.item = new Weapon();
        this.item.setType(type);
      }
      else if (this.isName)
        this.item.setName(value);
      else if (this.isLimitless)
        this.item.setLimitless(value.equalsIgnoreCase(Messages.getString("ItemLoader.True")) ? true : false); //$NON-NLS-1$
      else if (this.isDefaultImage)
      {
        ImageMap.Name image = ImageMap.Name.valueOf(value);
        this.item.setDefaultImage(image);
      }
      else if (this.isImage)
      {
        ImageMap.Name image = ImageMap.Name.valueOf(value);
        this.item.setImage(image);
      }
      else if (this.isSound)
      {
        SoundMap.Sound sound = SoundMap.Sound.valueOf(value);
        this.item.setSound(sound);
      }
      else if (this.isDefaultCount)
        this.item.setDefaultCount(Integer.parseInt(value));
      else if (this.isMaximumCount)
        this.item.setMaximumCount(Integer.parseInt(value));
      else if (this.isSize)
        this.item.setSize(Integer.parseInt(value));
      else if (this.isBulletImage)
      {
        if (this.item instanceof Weapon)
        {
          ImageMap.Name image = ImageMap.Name.valueOf(value);
          ((Weapon)this.item).setBulletImage(image);
        }
      }
      else if (this.isShieldedImage)
      {
        if (this.item instanceof Weapon)
        {
          ImageMap.Name image = ImageMap.Name.valueOf(value);
          ((Weapon)this.item).setShieldedImage(image);
        }
      }
      else if (this.isHomingImage)
      {
        if (this.item instanceof Weapon)
        {
          ImageMap.Name image = ImageMap.Name.valueOf(value);
          ((Weapon)this.item).setHomingImage(image);
        }
      }
      else if (this.isShieldedHomingImage)
      {
        if (this.item instanceof Weapon)
        {
          ImageMap.Name image = ImageMap.Name.valueOf(value);
          ((Weapon)this.item).setShieldedHomingImage(image);
        }
      }
      else if (this.isDamage)
        ((Weapon)this.item).setDamage(Integer.parseInt(value));
      else if (this.isMaximumFired)
        ((Weapon)this.item).setMaximumFired(Integer.parseInt(value));
      else if (this.isRange)
        ((Weapon)this.item).setRange(Integer.parseInt(value));
      else if (this.isVelocity)
        ((Weapon)this.item).setVelocity(Integer.parseInt(value));
      else if (this.isDirections)
        ((Weapon)this.item).setDirections(Integer.parseInt(value));
    }
    catch (IllegalArgumentException illegalArgumentException)
    {
      System.out.printf(Messages.getString("ItemLoader.ErrorItemLoader"),value,Messages.getString("ItemLoader.IsNotDefined")); //$NON-NLS-1$ //$NON-NLS-2$
    }
  }

  /**
   * Provide a String representation of this object.
   * @return String A representation of the object for debugging.
   */
  @Override
  public String toString()
  {
    return this.fileName;
  }
}
/* TextLoader----------------- */
