package jp.ac.nii.icpc2010.playfield;

/**
 * This enum represents the different directions that are possible on the playfield.
 * @author johan
 *
 */
public enum FieldDirection {
	Up, Down, Left, Right;
	
	/**
	 * Return the reverse of a given direction.
	 * @param fd the direction to reverse
	 * @return the reversed direction
	 */
	public static FieldDirection reverse(FieldDirection fd) {
		switch(fd) {
		case Up:
			return Down;
		case Left:
			return Right;
		case Right:
			return Left;
		
		}
		return Up;
	}
}
