package jp.ac.nii.icpc2010.playfield;

import java.awt.event.KeyEvent;
import java.util.Vector;

import jp.ac.nii.icpc2010.AbstractTron;

abstract public class AbstractPlayField implements IPlayField {

	protected int _width;
	protected int _height;


	abstract public int getObjectAt(int x, int y);
	
	public int getWidth() {
		return _width;
	}

	public int getHeight() {
		return _height;
	}

	public int[] stepOne(int x, int y, FieldDirection dir) {
		int[] r = new int[2];
		r[0] = x;
		r[1] = y;

		switch (dir) {
		case Up:
			r[1] -= 1;
			break;
		case Down:
			r[1] += 1; 
			break;
		case Left:
			r[0] -= 1;
			break;
		case Right:
			r[0] += 1;
			break;
		}

		r[0] = (r[0] + _width) % _width;
		r[1] = (r[1] + _height) % _height;

		return r;
	}


	protected KeyEvent keyPressed;
	protected int _round;
	protected int _turn;
	protected int _maxturn;
	protected int _gameround;
	public KeyEvent getKeyPressed(){
		return this.keyPressed; 
	}

	public int getRound() {
		return _round;
	}

	public int getTurn() {
		return _turn;
	}
	
	public int getGameRounds()
	{
		return _gameround;
	}
	
	public int getMaxTurns()
	{
		return _maxturn;
	}

	public static int playerTrail(int playerId){
		return playerId + 256;
	}
	public static int playerId(int playerTrail){
		return playerTrail - 256;
	}
}
