package jp.ac.nii.icpc2010;

import jp.ac.nii.icpc2010.manager.IOptionSource;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.PlayField;

import java.util.Deque;
import java.util.ArrayDeque;


public class Tron extends AbstractTron
{

	private int _lastx;
	private int _lasty;
	private int _nextx;
	private int _nexty;
	private FieldDirection _lastDir;
	private FieldDirection _dir;

	private Deque<Integer> _xTrailDeque;
	private Deque<Integer> _yTrailDeque;

	private IOptionSource _options;

	private TronState _state;
	private enum TronState{
		ALIVE,
		DEAD,
	}

	public Tron(int id, int startx, int starty, FieldDirection startdir, String name, OptionsManager om)
	{
		//_name = name;
		_playerId = id;
		_x = _lastx = _nextx = startx;
		_y = _lasty = _nexty = starty;
//		_lastx = -1;
//		_lasty = -1;
//		_nextx = -1;
//		_nexty = -1;
		_lastDir = startdir;
		_dir = startdir;
		_coins = 0;
		_lifetime = 0;
		_xTrailDeque = new ArrayDeque<Integer>();
		_yTrailDeque = new ArrayDeque<Integer>();

		_xTrailDeque.addFirst(_x);
		_yTrailDeque.addFirst(_y);

		_options = om;

		_state = TronState.ALIVE;

		if (!om.isTournamentMode())
			System.out.println("tron " + _playerId + " created.");
	}

	public int getLastX(){ return _lastx; }
	public int getLastY(){ return _lasty; }
	public int getNextX(){ return _nextx; }
	public int getNextY(){ return _nexty; }
	public FieldDirection getDir() { return _dir; }
	public FieldDirection getLastDir() { return _lastDir; }
	//public String getName() {return _name;}

	public void setCoins(int coins){ _coins = coins; }
	//public void setTraveled(int traveled){ _lifetime = traveled; }

	public void setDirection(FieldDirection dir)
	{
		if(dir != null){
			_lastDir = _dir;
			_dir = dir;
		}
	}


	public int getTrailLength(){
		return _xTrailDeque.size();
	}

	public int getTailX() {
		return _xTrailDeque.getLast();
	}

	public int getTailY() {
		return _yTrailDeque.getLast();
	}

	public int removeTailX() {
		return _xTrailDeque.removeLast();
	}

	public int removeTailY() {
		return _yTrailDeque.removeLast();
	}

	public void nextStep(PlayField field)
	{
		int[] newCoords = field.stepOne(_x, _y, _dir);
		_nextx = newCoords[0];
		_nexty = newCoords[1];
	}

	public void step(){

		_lifetime++;
		_lastx = _x;
		_lasty = _y;
		_x = _nextx;
		_y = _nexty;

		_xTrailDeque.addFirst(_x);
		_yTrailDeque.addFirst(_y);


		/*if (_options.isTrailLimit()){
          	if(_traveled > _options.getTrailLimitAmount()) {
              try {
                  field.clearTrail(this._id, _xTrailDeque.removeLast(), _yTrailDeque.removeLast());
              } catch (NoSuchElementException e) {}
          	}
      	}*/


		if (_options.isLoggingOn()) {
			System.out.println("id: " + getPlayerId() +
					" is now at " + getX() +
					" , " + getY());
		}
	}

	public void die() {
		_state = TronState.DEAD;

		_lastx = _nextx = _x;
		_lasty = _nexty = _y;
	}

	public boolean isAlive() {
		return _state == TronState.ALIVE;
	}
}
