/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.tournament;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.nii.icpc2010.tournament.Logger;
import jp.ac.nii.icpc2010.tournament.Match;
import jp.ac.nii.icpc2010.tournament.Player;

public class Group {
    private boolean computed = false;
    private List<Player> players = new ArrayList<Player>();
    private Map<Player, List<Match>> player2matches = new HashMap<Player, List<Match>>();
    private List<Match> matches = new ArrayList<Match>();

    public void addPlayer(Player p) {
        this.players.add(p);
        this.player2matches.put(p, new ArrayList());
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public void addMatch(Match match) {
        this.matches.add(match);
        this.player2matches.get(match.getPlayerOne()).add(match);
        this.player2matches.get(match.getPlayerTwo()).add(match);
    }

    public List<Match> getMatches(Player p) {
        return this.player2matches.get(p);
    }

    public void flagComputed() {
        this.computed = true;
    }

    public void computeTotalScores() {
        for (Player one : this.players) {
            double totalScore = 0.0;
            for (Match match : this.getMatches(one)) {
                totalScore += match.getResult(one);
            }
            one.setScore(totalScore);
            Logger.log(one + "'s score: " + totalScore);
        }
    }

    public List<Player> getProceedingPlayers() {
        if (!this.computed) {
            return this.players;
        }
        Collections.sort(this.players);
        ArrayList<Player> proceedingPlayers = new ArrayList<Player>();
        int x = 0;
        while (x < 2) {
            proceedingPlayers.add(this.players.get(this.players.size() - 1 - x));
            ++x;
        }
        return proceedingPlayers;
    }

    public String toString() {
        String res = "";
        for (Player p : this.players) {
            res = String.valueOf(res) + p + " ";
        }
        return res;
    }
}

