/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.score;

import java.util.Vector;
import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.playfield.PlayField;
import jp.ac.nii.icpc2010.score.AbstractScore;

public class SurvivalScore
extends AbstractScore {
    private double coinSum;
    private double rankSum;
    private Vector<Double> coins = new Vector();
    private Vector<Double> ranks = new Vector();

    @Override
    public void add(AbstractScore score) {
        this.coinSum += ((SurvivalScore)score).coinSum;
        this.rankSum += ((SurvivalScore)score).rankSum;
        this.coins.addAll(((SurvivalScore)score).coins);
        this.ranks.addAll(((SurvivalScore)score).ranks);
    }

    @Override
    public double getValue() {
        return this.coinSum + this.rankSum;
    }

    @Override
    public String toString() {
        return String.format("%.2f,%.2f", this.coinSum, this.rankSum);
    }

    @Override
    public int compareTo(AbstractScore o) {
        double b;
        double m = 1.0E-7;
        double a = this.getValue();
        if (a > (b = ((SurvivalScore)o).getValue()) + m) {
            return 1;
        }
        if (a + m < b) {
            return -1;
        }
        return 0;
    }

    public static AbstractScore[] getScores(PlayField playField) {
        AbstractScore[] scores = new SurvivalScore[playField.getNumOfPlayers()];
        int numOfPlayers = playField.getNumOfPlayers();
        int numOfCoins = playField.getNumOfCoins();
        int i = 0;
        while (i < numOfPlayers) {
            double rank;
            double coin;
            Tron tron = playField.getTron(i);
            scores[i] = new SurvivalScore();
            ((SurvivalScore)scores[i]).coinSum = coin = numOfCoins > 0 ? (double)tron.getCoins() / (double)numOfCoins : 0.0;
            ((SurvivalScore)scores[i]).coins.add(coin);
            int dead = 0;
            for (Tron t : playField.getTronsNocopy()) {
                if (tron.getLifetime() <= t.getLifetime()) continue;
                ++dead;
            }
            ((SurvivalScore)scores[i]).rankSum = rank = numOfPlayers > 1 ? (double)dead / ((double)playField.getNumOfPlayers() - 1.0) : 0.0;
            ((SurvivalScore)scores[i]).ranks.add(rank);
            ++i;
        }
        return scores;
    }
}

