/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.playfield;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Vector;
import jp.ac.nii.icpc2010.ITron;
import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.display.DisplayDirection;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.manager.QuoteManager;
import jp.ac.nii.icpc2010.playfield.AbstractPlayField;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.PlayerSummary;
import jp.ac.nii.icpc2010.score.AbstractScore;

public class PlayField
extends AbstractPlayField {
    private final int UNDERFIELD_COIN = 1;
    private int[][] _field;
    private DisplayDirection[][] _fieldDirection;
    private int[][] _underField;
    private Vector<PlayerSummary> _players;
    private Vector<Tron> _trons;
    private Vector<Point> _startPoints;
    private Vector<Point> _itemPoints;
    private long _ticks;
    private String _filename;
    private int _numOfCoins;
    private AbstractScore[] _scores;
    private AbstractScore[] _totalScores;
    private Method _getScoresMethod;
    private int _numOfComments;
    private Deque<String> _comments;
    private boolean _displayResized;
    protected GameState _gameState;
    private OptionsManager _options;

    public GameState getGameState() {
        return this._gameState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException, TronException {
        ++this._round;
        this._turn = 0;
        this._numOfCoins = 0;
        this._gameState = GameState.RUNNING;
        PlayField playField = this;
        synchronized (playField) {
            this.loadFromFile(this._filename);
        }
        this.resetTrons();
        this.putItems(this._options.getItemInitProb());
    }

    public void reset(String filename) throws IOException, TronException {
        this._filename = filename;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException, TronException {
        this._gameround = this._options.getGameRounds();
        this._maxturn = this._options.getMaxTurns();
        this._round = 0;
        this._turn = 0;
        this._numOfCoins = 0;
        this._gameState = GameState.RUNNING;
        this._comments = new ArrayDeque<String>();
        this.initPlayers();
        if (!this._options.isTournamentMode()) {
            System.out.println("Load file '" + this._filename + "'");
        }
        PlayField playField = this;
        synchronized (playField) {
            this.loadFromFile(this._filename);
        }
        this.initTrons();
        this.putItems(this._options.getItemInitProb());
        this.initScores();
    }

    public void init(String filename) throws IOException, TronException {
        this._filename = filename;
        this.init();
    }

    public PlayField(OptionsManager om) {
        this._options = om;
        this._numOfComments = this._options.getCommentLines();
        this._displayResized = false;
    }

    public PlayField(String filename, OptionsManager om) throws IOException, TronException {
        this(om);
        this.init(filename);
    }

    public PlayField(PlayField playField, OptionsManager om) {
        this._field = (int[][])playField._field.clone();
        this._options = om;
    }

    private void initPlayers() throws TronException {
        int numOfPlayers = this._options.getNumOfPlayers();
        this._players = new Vector();
        Vector<String> playerNames = this._options.getPlayerClasses();
        if (numOfPlayers > playerNames.size()) {
            throw new TronException("Inconsistent setting -- lack of players");
        }
        int i = 0;
        while (i < numOfPlayers) {
            this._players.add(new PlayerSummary(playerNames.get(i)));
            ++i;
        }
    }

    private void initScores() {
        String scoreClassName = "jp.ac.nii.icpc2010.score." + this._options.getScoreClass();
        Class<?> scoreClass = null;
        try {
            scoreClass = Class.forName(scoreClassName);
            this._getScoresMethod = scoreClass.getMethod("getScores", PlayField.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            this._scores = (AbstractScore[])this._getScoresMethod.invoke(null, this);
            this._totalScores = new AbstractScore[this.getNumOfPlayers()];
            int i = 0;
            while (i < this.getNumOfPlayers()) {
                this._totalScores[i] = (AbstractScore)scoreClass.newInstance();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initTrons() {
        int numOfPlayers = this._players.size();
        this._trons = new Vector();
        int i = 0;
        while (i < numOfPlayers) {
            int x = this._startPoints.get((int)((i + this._round) % numOfPlayers)).x;
            int y = this._startPoints.get((int)((i + this._round) % numOfPlayers)).y;
            this._trons.add(new Tron(i, x, y, FieldDirection.Up, this._players.get(i).getName(), this._options));
            this.setObjectAt(x, y, PlayField.playerTrail(i));
            ++i;
        }
    }

    private void resetTrons() {
        this.initTrons();
    }

    private void loadFromFile(String filename) throws TronException, IOException {
        Vector<String> buffer = new Vector<String>();
        try {
            BufferedReader input = new BufferedReader(new FileReader("./res/" + filename));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    buffer.add(line);
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        int width = ((String)buffer.get(0)).length();
        int height = buffer.size();
        if (width != this._width || height != this._height) {
            this._displayResized = true;
        }
        this._width = width;
        this._height = height;
        this._field = new int[this._width][this._height];
        this._fieldDirection = new DisplayDirection[this._width][this._height];
        this._underField = new int[this._width][this._height];
        this._startPoints = new Vector();
        this._itemPoints = new Vector();
        int lineLength = -1;
        int i = 0;
        for (String s : buffer) {
            if (lineLength == -1) {
                lineLength = s.length();
            } else if (s.length() != lineLength) {
                throw new TronException("Incorrect file format -- lines have different length");
            }
            if (lineLength != this._width) {
                throw new TronException("Incorrect file format -- expected width " + this._width + ", got " + lineLength);
            }
            int j = 0;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (this._field[j] == null) {
                    this._field[j] = new int[this._height];
                }
                switch (c) {
                    case ' ': 
                    case '0': {
                        this.setObjectAt(j, i, 0);
                        break;
                    }
                    case '1': {
                        this.setObjectAt(j, i, 1);
                        break;
                    }
                    case '2': 
                    case '3': {
                        this.setObjectAt(j, i, 0);
                        this._startPoints.add(new Point(j, i));
                        break;
                    }
                    case '4': {
                        this.setUnderObjectAt(j, i, 1);
                        this._itemPoints.add(new Point(j, i));
                    }
                }
                ++j;
                ++n2;
            }
            ++i;
        }
        if (this._startPoints.size() < this._players.size()) {
            throw new TronException("Inconsistent setting -- lack of start points (got " + this._startPoints.size() + ", needed " + this._players.size() + ")");
        }
        if (!this._options.isTournamentMode()) {
            System.out.println("Field size " + this._width + "x" + this._height);
        }
    }

    public void setObjectAt(int x, int y, int object) {
        this._field[x][y] = object;
    }

    public void setDirectionAt(int x, int y, DisplayDirection dir) {
        this._fieldDirection[x][y] = dir;
    }

    @Override
    public int getObjectAt(int x, int y) {
        return this._field[x][y];
    }

    public DisplayDirection getDirectionAt(int x, int y) {
        return this._fieldDirection[x][y];
    }

    public void setUnderObjectAt(int x, int y, int object) {
        this._underField[x][y] = object;
    }

    public int getUnderObjectAt(int x, int y) {
        return this._underField[x][y];
    }

    @Override
    public int getNumOfPlayers() {
        return this._players.size();
    }

    public Vector<String> getPlayerNames() {
        Vector<String> playerNames = new Vector<String>();
        for (PlayerSummary player : this._players) {
            playerNames.add(player.getName());
        }
        return playerNames;
    }

    public Tron getTron(int playerId) {
        return this._trons.get(playerId);
    }

    public Vector<Tron> getTronsNocopy() {
        return this._trons;
    }

    public AbstractScore getScore(int playerId) {
        return this._scores[playerId];
    }

    public AbstractScore[] getScores() {
        return this._scores;
    }

    public AbstractScore getTotalScore(int playerId) {
        return this._totalScores[playerId];
    }

    public AbstractScore[] getTotalScores() {
        return this._totalScores;
    }

    public void update(FieldDirection[] inputs) {
        ++this._turn;
        int i = 0;
        while (i < inputs.length) {
            if (this.getTron(i).isAlive()) {
                this.getTron(i).setDirection(inputs[i]);
            }
            ++i;
        }
        if (!this.checkField()) {
            i = 0;
            while (i < this.getNumOfPlayers()) {
                this._totalScores[i].add(this._scores[i]);
                ++i;
            }
            QuoteManager.Singleton().loadNewQuote();
            this._gameState = GameState.RESULT;
        }
        this.setTicks(System.currentTimeMillis());
    }

    private boolean checkField() {
        Vector<Tron> alives = new Vector<Tron>();
        block11: for (Tron tron : this._trons) {
            if (!tron.isAlive()) continue;
            alives.add(tron);
            tron.nextStep(this);
            int x = tron.getNextX();
            int y = tron.getNextY();
            int object = this.getObjectAt(x, y);
            switch (object) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: {
                    String s = "[" + this._turn + "] Player " + tron.getPlayerId() + " dies: wall (" + x + "," + y + ")";
                    this.putComment(s);
                    tron.die();
                    break;
                }
                default: {
                    if (object < PlayField.playerTrail(0) || object >= PlayField.playerTrail(this._players.size())) continue block11;
                    String s = "[" + this._turn + "] Player " + tron.getPlayerId() + " dies: trail " + PlayField.playerId(object) + " (" + x + "," + y + ")";
                    this.putComment(s);
                    tron.die();
                }
            }
        }
        int i = 0;
        while (i < this._trons.size() - 1) {
            Tron tron1 = this._trons.get(i);
            int j = i + 1;
            while (j < this._trons.size()) {
                Tron tron2 = this._trons.get(j);
                if (tron1.getNextX() == tron2.getNextX() && tron1.getNextY() == tron2.getNextY()) {
                    String s = "[" + this._turn + "] Players " + tron1.getPlayerId() + " and " + tron2.getPlayerId() + " die: collision (" + tron1.getNextX() + "," + tron1.getNextY() + ")";
                    this.putComment(s);
                    tron1.die();
                    tron2.die();
                }
                ++j;
            }
            ++i;
        }
        boolean gameEnd = true;
        for (Tron tron : alives) {
            if (!tron.isAlive()) continue;
            gameEnd = false;
        }
        if (this._options.getMaxTurns() > 0 && this._turn > this._options.getMaxTurns()) {
            gameEnd = true;
        }
        if (gameEnd) {
            return false;
        }
        int aliveCount = 0;
        for (Tron tron : alives) {
            if (!tron.isAlive()) continue;
            ++aliveCount;
            tron.step();
            int x = tron.getX();
            int y = tron.getY();
            int object = this.getObjectAt(x, y);
            switch (object) {
                case 2: {
                    this.putComment("[" + this._turn + "] Player " + tron.getPlayerId() + " gets: coin (" + x + "," + y + ")");
                    tron.setCoins(tron.getCoins() + 1);
                }
            }
            this.setObjectAt(x, y, PlayField.playerTrail(tron.getPlayerId()));
            int lastX = tron.getLastX();
            int lastY = tron.getLastY();
            FieldDirection lastDir = tron.getLastDir();
            FieldDirection dir = tron.getDir();
            DisplayDirection dd = null;
            dd = lastDir == dir && (lastDir == FieldDirection.Up || lastDir == FieldDirection.Down) ? DisplayDirection.UpDown : (lastDir == dir ? DisplayDirection.LeftRight : (lastDir == FieldDirection.Down && dir == FieldDirection.Left || lastDir == FieldDirection.Right && dir == FieldDirection.Up ? DisplayDirection.LeftUp : (lastDir == FieldDirection.Up && dir == FieldDirection.Right || lastDir == FieldDirection.Left && dir == FieldDirection.Down ? DisplayDirection.RightDown : (lastDir == FieldDirection.Right && dir == FieldDirection.Down || lastDir == FieldDirection.Up && dir == FieldDirection.Left ? DisplayDirection.LeftDown : (lastDir == FieldDirection.Left && dir == FieldDirection.Up || lastDir == FieldDirection.Down && dir == FieldDirection.Right ? DisplayDirection.RightUp : (dir == FieldDirection.Up || dir == FieldDirection.Down ? DisplayDirection.UpDown : DisplayDirection.LeftRight))))));
            this.setDirectionAt(lastX, lastY, dd);
            if (!this._options.hasTrailLimit() || tron.getTrailLength() <= this._width * this._height * this._options.getTrailLimitAmount() / 1000) continue;
            try {
                this.clearTrail(PlayField.playerTrail(tron.getPlayerId()), tron.removeTailX(), tron.removeTailY());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.putItems(this._options.getItemRegenProb());
        try {
            this._scores = (AbstractScore[])this._getScoresMethod.invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (aliveCount == 1 && this._options.isLastmanStanding()) {
            return false;
        }
        if (this._options.isLoggingOn()) {
            System.out.println("some trons are alive.");
        }
        return true;
    }

    private void setCoin(int x, int y) {
        this._field[x][y] = 2;
        ++this._numOfCoins;
    }

    public void scatterCoins() {
        double prob = 1.0;
        int i = 0;
        while (i < this.getWidth()) {
            int j = 0;
            while (j < this.getHeight()) {
                if (this._field[i][j] == 0 && Math.random() > 1.0 - prob) {
                    this.setCoin(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void putItems(double prob) {
        for (Point p : this._itemPoints) {
            int x = p.x;
            int y = p.y;
            if (this.getObjectAt(x, y) != 0 || !(Math.random() < prob)) continue;
            switch (this.getUnderObjectAt(x, y)) {
                case 1: {
                    this.setCoin(x, y);
                }
            }
        }
    }

    public void clearTrail(int id, int x, int y) {
        this.setObjectAt(x, y, 0);
    }

    private void setTicks(long ticks) {
        this._ticks = ticks;
    }

    public long getTicks() {
        return this._ticks;
    }

    public void setKeyPressed(KeyEvent e) {
        this.keyPressed = e;
    }

    public boolean isRunning() {
        return this._gameState == GameState.RUNNING;
    }

    public String getPlayerName(int playerId) {
        return this._players.get(playerId).getName();
    }

    public int getNumOfCoins() {
        return this._numOfCoins;
    }

    @Override
    public Vector<ITron> getTrons() {
        Vector<ITron> trons = new Vector<ITron>();
        for (Tron tron : this._trons) {
            trons.add(tron);
        }
        return trons;
    }

    public Deque<String> getComments() {
        return this._comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putComment(String comment) {
        Deque<String> deque = this._comments;
        synchronized (deque) {
            if (this._comments.size() >= this._numOfComments) {
                this._comments.removeFirst();
            }
            this._comments.addLast(comment);
        }
    }

    public void setNumOfComments(int n) {
        this._numOfComments = n;
    }

    public boolean isDisplayResized() {
        return this._displayResized;
    }

    public void clearDisplayResized() {
        this._displayResized = false;
    }

    @Override
    public int getRemainingRounds() {
        return this._options.getGameRounds() - this.getRound() - 1;
    }

    @Override
    public int getRemainingTurns() {
        return this._options.getMaxTurns() - this.getTurn() - 1;
    }

    public static enum GameState {
        RUNNING,
        RESULT;

    }
}

