/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.playfield;

import java.awt.event.KeyEvent;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

public abstract class AbstractPlayField
implements IPlayField {
    protected int _width;
    protected int _height;
    protected KeyEvent keyPressed;
    protected int _round;
    protected int _turn;
    protected int _maxturn;
    protected int _gameround;

    @Override
    public abstract int getObjectAt(int var1, int var2);

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public int[] stepOne(int x, int y, FieldDirection dir) {
        int[] r = new int[]{x, y};
        switch (dir) {
            case Up: {
                r[1] = r[1] - 1;
                break;
            }
            case Down: {
                r[1] = r[1] + 1;
                break;
            }
            case Left: {
                r[0] = r[0] - 1;
                break;
            }
            case Right: {
                r[0] = r[0] + 1;
            }
        }
        r[0] = (r[0] + this._width) % this._width;
        r[1] = (r[1] + this._height) % this._height;
        return r;
    }

    public KeyEvent getKeyPressed() {
        return this.keyPressed;
    }

    @Override
    public int getRound() {
        return this._round;
    }

    @Override
    public int getTurn() {
        return this._turn;
    }

    public int getGameRounds() {
        return this._gameround;
    }

    public int getMaxTurns() {
        return this._maxturn;
    }

    public static int playerTrail(int playerId) {
        return playerId + 256;
    }

    public static int playerId(int playerTrail) {
        return playerTrail - 256;
    }
}

