/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.manager;

import java.lang.reflect.Constructor;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.manager.TimeKeeper;
import jp.ac.nii.icpc2010.manager.TimeoutAction;
import jp.ac.nii.icpc2010.players.AbstractPlayer;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;
import jp.ac.nii.icpc2010.playfield.PlayField;
import jp.ac.nii.icpc2010.playfield.RefPlayField;
import jp.ac.nii.icpc2010.recorder.FileRecorder;
import jp.ac.nii.icpc2010.recorder.IRecorder;
import jp.ac.nii.icpc2010.recorder.PlayerEvent;
import jp.ac.nii.icpc2010.recorder.ReplayPlayer;

public class PlayerManager {
    private PlayField _field;
    private Vector<AbstractPlayer> _players;
    private TimeKeeper _timeKeeper;
    private OptionsManager _options;
    private IRecorder _recorder;
    private IRecorder _playbackRecorder;
    private int _startTurn;

    public PlayerManager(PlayField field, IRecorder recorder, OptionsManager om) throws TronException {
        this(field, recorder, 0, om);
    }

    public PlayerManager(PlayField field, IRecorder recorder, int startTurn, OptionsManager om) throws TronException {
        this._field = field;
        this._recorder = recorder;
        this._options = om;
        this._players = new Vector();
        new Vector();
        this._timeKeeper = new TimeKeeper();
        this._startTurn = startTurn;
        this.initialize();
    }

    private void initialize() throws TronException {
        this._players.clear();
        String[] playerNames = new String[this._field.getNumOfPlayers()];
        String playbackFile = this._options.getPlaybackFile();
        if (playbackFile != null) {
            System.out.println("Playback from " + playbackFile);
            this._playbackRecorder = new FileRecorder(playerNames, playbackFile, this._options);
            this._playbackRecorder.load();
        }
        int i = 0;
        while (i < this._field.getNumOfPlayers()) {
            block8: {
                String playerClassName;
                playerNames[i] = playerClassName = this._field.getPlayerName(i);
                try {
                    RefPlayField ref = new RefPlayField(this._field.getWidth(), this._field.getHeight(), this._players.size());
                    ref.copy(this._field);
                    if (this._playbackRecorder != null) {
                        ReplayPlayer obj = new ReplayPlayer(i, ref, this._playbackRecorder.getEvents(), this._startTurn);
                        this._players.add(obj);
                        break block8;
                    }
                    String tronClass = "";
                    tronClass = playerClassName.contains(".") ? playerClassName : "jp.ac.nii.icpc2010.players." + playerClassName;
                    Constructor<?> constructor = Class.forName(tronClass).getConstructor(Integer.TYPE, IPlayField.class);
                    AbstractPlayer player = null;
                    try {
                        player = this._timeKeeper.getInstance(constructor, i, ref, this._options.getInitTimeout(), this._options);
                    }
                    catch (TimeoutException e) {
                        this._field.putComment("Player " + i + " dies: initilization time out");
                        this._field.getTron(i).die();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this._field.getTron(i).die();
                    }
                    this._players.add(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            ++i;
        }
    }

    public FieldDirection[] getInputs() {
        long timeout = this._options.getRunTimeout();
        TimeoutAction timeoutAction = this._options.getTimeoutAction();
        RefPlayField ref = new RefPlayField(this._field.getWidth(), this._field.getHeight(), this._players.size());
        ref.copy(this._field);
        FieldDirection[] inputs = new FieldDirection[this._players.size()];
        PlayerEvent[] events = new PlayerEvent[this._players.size()];
        int i = 0;
        while (i < this._players.size()) {
            Tron tron = this._field.getTron(i);
            if (tron.isAlive()) {
                AbstractPlayer player = this._players.get(i);
                player.setPlayField(ref);
                if (timeout > 0L) {
                    try {
                        inputs[i] = this._timeKeeper.getInput(player, timeout);
                        events[i] = PlayerEvent.fromFieldDirection(inputs[i]);
                    }
                    catch (TimeoutException e) {
                        this._field.putComment("[" + (this._field.getTurn() + 1) + "] Player " + i + " timed out");
                        inputs[i] = timeoutAction == TimeoutAction.Die ? FieldDirection.reverse(tron.getDir()) : tron.getDir();
                        events[i] = PlayerEvent.Timeout;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        inputs[i] = FieldDirection.reverse(tron.getDir());
                    }
                } else {
                    inputs[i] = player.getInput();
                    events[i] = PlayerEvent.fromFieldDirection(inputs[i]);
                }
            } else {
                inputs[i] = null;
                events[i] = null;
            }
            ++i;
        }
        ++this._startTurn;
        if (this._recorder != null) {
            try {
                this._recorder.addEvents(events);
            }
            catch (TronException te) {
                System.err.println("Error while recording events");
                te.printStackTrace();
            }
        }
        return inputs;
    }

    int getStartTurn() {
        return this._startTurn;
    }

    public int getPlayerSize() {
        return this._players.size();
    }

    public void finishRecording() {
        if (this._recorder != null) {
            try {
                this._recorder.closeWriting();
            }
            catch (TronException e) {
                System.err.println("Error while recording events");
                e.printStackTrace();
            }
        }
    }
}

