/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.manager;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.KeyListener;
import jp.ac.nii.icpc2010.display.AWTGameDisplay;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.playfield.PlayField;

public class DisplayManager
extends Frame
implements Runnable {
    private PlayField playField;
    private AWTGameDisplay gameDisplay;
    private OptionsManager om;

    public DisplayManager(String s, PlayField playField, OptionsManager om) {
        super(s);
        this.playField = playField;
        this.om = om;
        this.gameDisplay = new AWTGameDisplay(this.playField, om);
        this.resizeWindow();
        this.add(this.gameDisplay);
        this.setVisible(true);
    }

    private void resizeWindow() {
        Insets insets = this.getInsets();
        Dimension d = this.gameDisplay.getDimension();
        int idealWidth = d.width + insets.left + insets.right;
        int idealHeight = d.height + insets.top + insets.bottom;
        this.setSize(idealWidth, idealHeight);
        this.playField.setNumOfComments(this.gameDisplay.getMaxNumOfComments());
        this.gameDisplay.reset();
    }

    @Override
    public void run() {
        while (true) {
            if (this.playField.isDisplayResized()) {
                this.playField.clearDisplayResized();
                this.resizeWindow();
            }
            this.gameDisplay.repaint();
            try {
                Thread.sleep(this.om.getDisplayInterval());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.gameDisplay.addKeyListener(listener);
        super.addKeyListener(listener);
    }

    public void incrementCellWidth() {
        this.gameDisplay.setCellSize(this.gameDisplay.getCellWidth() + 1, this.gameDisplay.getCellHeight());
        this.resizeWindow();
    }

    public void incrementCellHeight() {
        this.gameDisplay.setCellSize(this.gameDisplay.getCellWidth(), this.gameDisplay.getCellHeight() + 1);
        this.resizeWindow();
    }

    public void decrementCellWidth() {
        this.gameDisplay.setCellSize(this.gameDisplay.getCellWidth() - 1, this.gameDisplay.getCellHeight());
        this.resizeWindow();
    }

    public void decrementCellHeight() {
        this.gameDisplay.setCellSize(this.gameDisplay.getCellWidth(), this.gameDisplay.getCellHeight() - 1);
        this.resizeWindow();
    }
}

