/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.display;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.display.DisplayDirection;
import jp.ac.nii.icpc2010.display.IGameDisplay;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.manager.QuoteManager;
import jp.ac.nii.icpc2010.playfield.PlayField;

public class AWTGameDisplay
extends Canvas
implements IGameDisplay {
    private static final long serialVersionUID = 1L;
    private PlayField playField;
    private PlayField oldPlayField;
    boolean displayScore = true;
    private Vector<BufferedImage> background;
    private BufferedImage wall;
    private Vector<BufferedImage> trons;
    private Vector<BufferedImage> tronsHeads;
    private Vector<BufferedImage> tronsTrailCorners;
    private BufferedImage coin;
    private Graphics g;
    private static final int CELLS_X_OFFSET = 256;
    private static final int CELLS_Y_OFFSET = 0;
    private static final int BOARD_X_OFFSET = 5;
    public static final int BOARD_Y_OFFSET = 0;
    public static final int BOARD_LINE_HEIGHT = 16;
    public static final int BOARD_LINE_MARGIN = 4;
    private int cellWidth;
    private int cellHeight;
    private boolean resetBackbufferFlag;
    private OptionsManager om;
    private Image dbImage = null;
    private Graphics dbg;
    private long aho = 0L;

    public AWTGameDisplay(PlayField playField, OptionsManager om) {
        this.playField = playField;
        this.om = om;
        try {
            this.initImages();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.cellWidth = om.getCellWidth();
        this.cellHeight = om.getCellHeight();
        this.resetBackbufferFlag = true;
    }

    public void init() {
        try {
            this.initImages();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.setBackground(Color.black);
        this.resetBackbufferFlag = true;
    }

    @Override
    public void update(Graphics g) {
        if (this.om.getBackbufferEnabled()) {
            if (this.resetBackbufferFlag || this.dbImage == null) {
                this.resetBackbufferFlag = false;
                System.out.println("New backbuffer screen created");
                this.dbImage = this.createImage(this.getWidth(), this.getHeight());
                this.dbg = this.dbImage.getGraphics();
                this.oldPlayField = null;
            }
            this.paint(this.dbg);
            g.drawImage(this.dbImage, 0, 0, this);
        } else {
            super.update(g);
        }
    }

    @Override
    public void reset() {
        this.resetBackbufferFlag = true;
    }

    public void setCellSize(int cellWidth, int cellHeight) {
        if (cellWidth >= 0) {
            this.cellWidth = cellWidth;
        }
        if (cellHeight >= 0) {
            this.cellHeight = cellHeight;
        }
        this.reset();
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    private BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gfx_config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(gfx_config.getColorModel())) {
            return image;
        }
        BufferedImage new_image = gfx_config.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = (Graphics2D)new_image.getGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return new_image;
    }

    private BufferedImage readImage(String file) throws IOException {
        return this.toCompatibleImage(ImageIO.read(new File(file)));
    }

    private void initImages() throws IOException {
        this.background = new Vector();
        String[] stringArray = this.om.getBackgroundImageName();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.background.add(this.readImage("./res/" + s));
            ++n2;
        }
        this.wall = this.readImage("./res/" + this.om.getWallImageName());
        int nPlayer = this.om.getNumOfPlayers();
        this.trons = new Vector();
        this.tronsHeads = new Vector();
        this.tronsTrailCorners = new Vector();
        int i = 0;
        while (i < nPlayer) {
            this.trons.add(this.readImage("./res/" + this.om.getTronImageName(i)));
            if (this.om.isTronHeadImage()) {
                this.tronsHeads.add(this.readImage("./res/" + this.om.getTronHeadImageName(i)));
            }
            this.tronsTrailCorners.add(this.readImage("./res/" + this.om.getTronTrailCornerImageName(i)));
            ++i;
        }
        this.coin = this.readImage("./res/" + this.om.getCoinImageName());
    }

    @Override
    public void paint(Graphics g) {
        ++this.aho;
        switch (this.playField.getGameState()) {
            case RUNNING: {
                this.paintRunning(g);
                break;
            }
            case RESULT: {
                if (this.om.isDisplayQuote()) {
                    this.paintResult(g);
                    break;
                }
                this.paintRunning(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintRunning(Graphics g) {
        this.g = g;
        PlayField playField = this.playField;
        synchronized (playField) {
            int i = 0;
            while (i < this.playField.getWidth()) {
                int j = 0;
                while (j < this.playField.getHeight()) {
                    this.drawCell(i, j);
                    ++j;
                }
                ++i;
            }
            for (Tron tron : this.playField.getTronsNocopy()) {
                this.drawTron(tron);
            }
            if (this.displayScore) {
                this.drawScore();
            }
        }
        this.oldPlayField = new PlayField(this.playField, this.om);
    }

    /*
     * Unable to fully structure code
     */
    private void paintResult(Graphics g) {
        this.oldPlayField = null;
        this.paintRunning(g);
        x1 = (double)this.getWidth() / 5.0;
        y1 = (double)this.getWidth() / 5.0;
        g.setColor(Color.black);
        y = (int)y1;
        while (y < this.getHeight() - (int)y1) {
            x = (int)x1;
            while (x < this.getWidth() - (int)x1) {
                if ((x % 2 == 0 ? y + 1 : y) % 2 == 0) {
                    g.drawRect(x, y, 0, 0);
                }
                ++x;
            }
            ++y;
        }
        g.setColor(Color.white);
        f = new Font(g.getFont().getName(), 0, 20);
        g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(f);
        g.drawString(String.valueOf(QuoteManager.Singleton().getWinner()) + " says to " + QuoteManager.Singleton().getLoser() + ":", (int)x1 + 20, (int)y1 + 20);
        text = QuoteManager.Singleton().getQuote();
        st = new StringTokenizer(text);
        index = 0;
        offset = 50;
        met = g2.getFontMetrics();
        currentLine = "";
        currentWord = "";
        ** GOTO lbl43
        {
            currentLine = String.valueOf(currentLine) + currentWord + " ";
            if (!st.hasMoreTokens()) ** GOTO lbl35
            currentWord = st.nextToken();
            do {
                if (met.getStringBounds(String.valueOf(currentLine) + " " + currentWord, g2).getWidth() < (double)this.getWidth() - x1 - x1 - 40.0) continue block2;
lbl35:
                // 2 sources

                if (currentLine.startsWith(" ")) {
                    currentLine = currentLine.substring(1);
                }
                g2.drawString(currentLine, (int)x1 + 20, (int)y1 + offset);
                offset += 20;
                ++index;
                if (currentLine.contains(currentWord)) {
                    currentWord = "";
                }
                currentLine = "";
lbl43:
                // 2 sources

            } while (st.hasMoreTokens() || !currentWord.equals(""));
        }
        g.drawString(String.valueOf(QuoteManager.Singleton().getWinner()) + " wins!!!", (int)x1 + 20, (int)y1 + offset + 20);
    }

    private void drawAtCellXYCellSize(int xpos, int ypos, Graphics g, BufferedImage im, AffineTransform aff) {
        if (aff == null) {
            g.drawImage(im, this.cellStartX(xpos), this.cellStartY(ypos), this.cellWidth, this.cellHeight, this);
        } else {
            AffineTransformOp ato = new AffineTransformOp(aff, 1);
            BufferedImage dst = new BufferedImage(im.getWidth(), im.getHeight(), 2);
            ato.filter(im, dst);
            g.drawImage(dst, this.cellStartX(xpos), this.cellStartY(ypos), this.cellWidth, this.cellHeight, this);
        }
    }

    public void drawBackGround(int xpos, int ypos) {
        assert (this.g != null);
        BufferedImage cellImage = this.background.get(0);
        this.drawAtCellXYCellSize(xpos, ypos, this.g, cellImage, null);
    }

    public void drawCell(int xpos, int ypos) {
        if (this.om.getDrawOnlyChanges() && this.oldPlayField != null) {
            try {
                if (this.oldPlayField.getObjectAt(xpos, ypos) == this.playField.getObjectAt(xpos, ypos)) {
                    boolean occupied = false;
                    for (Tron tron : this.playField.getTronsNocopy()) {
                        if (Math.abs(tron.getLastX() - xpos) < 3 && Math.abs(tron.getLastY() - ypos) < 3) {
                            occupied = true;
                        }
                        if (Math.abs(tron.getTailX() - xpos) >= 3 || Math.abs(tron.getTailY() - ypos) >= 3) continue;
                        occupied = true;
                    }
                    if (!occupied) {
                        return;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.dbImage = null;
                this.oldPlayField = null;
            }
        }
        BufferedImage cellImage = null;
        assert (this.g != null);
        int object = this.playField.getObjectAt(xpos, ypos);
        boolean drawBG = false;
        AffineTransform aff = null;
        block1 : switch (object) {
            case 0: {
                drawBG = true;
                break;
            }
            case 1: {
                cellImage = this.wall;
                break;
            }
            case 2: {
                cellImage = this.coin;
                drawBG = true;
                break;
            }
            default: {
                drawBG = true;
                if (object < PlayField.playerTrail(0) || object >= PlayField.playerTrail(this.playField.getNumOfPlayers())) break;
                int playerId = PlayField.playerId(object);
                if (xpos == this.playField.getTron(playerId).getX() && ypos == this.playField.getTron(playerId).getY()) {
                    cellImage = null;
                    break;
                }
                DisplayDirection dd = this.playField.getDirectionAt(xpos, ypos);
                aff = new AffineTransform();
                if (dd == null) {
                    cellImage = null;
                    break;
                }
                switch (dd) {
                    case LeftRight: {
                        cellImage = this.trons.get(playerId);
                        break block1;
                    }
                    case UpDown: {
                        cellImage = this.trons.get(playerId);
                        aff.quadrantRotate(1, cellImage.getWidth() / 2, cellImage.getHeight() / 2);
                        break block1;
                    }
                    case LeftUp: {
                        cellImage = this.tronsTrailCorners.get(playerId);
                        aff.quadrantRotate(2, cellImage.getWidth() / 2, cellImage.getHeight() / 2);
                        break block1;
                    }
                    case RightUp: {
                        cellImage = this.tronsTrailCorners.get(playerId);
                        aff.quadrantRotate(3, cellImage.getWidth() / 2, cellImage.getHeight() / 2);
                        break block1;
                    }
                    case LeftDown: {
                        cellImage = this.tronsTrailCorners.get(playerId);
                        aff.quadrantRotate(1, cellImage.getWidth() / 2, cellImage.getHeight() / 2);
                        break block1;
                    }
                    case RightDown: {
                        cellImage = this.tronsTrailCorners.get(playerId);
                    }
                }
            }
        }
        if (drawBG) {
            this.drawBackGround(xpos, ypos);
        }
        if (cellImage != null) {
            this.drawAtCellXYCellSize(xpos, ypos, this.g, cellImage, aff);
        }
    }

    private int cellStartX(int cellX) {
        return cellX * this.cellWidth + 256;
    }

    private int cellStartY(int cellY) {
        return cellY * this.cellHeight + 0;
    }

    public void drawTron(Tron t) {
        int x1 = t.getLastX();
        int x2 = x1 + 1;
        int y1 = t.getLastY();
        int y2 = y1 + 1;
        x1 = this.cellStartX(x1);
        x2 = this.cellStartX(x2);
        y1 = this.cellStartY(y1);
        y2 = this.cellStartY(y2);
        int angleStart = 0;
        if (this.playField.getGameState() == PlayField.GameState.RUNNING && t.isAlive() && this.playField.getTurn() > 0) {
            double animeRate = Math.min(1.0, (double)(System.currentTimeMillis() - this.playField.getTicks()) / (double)this.om.getTurnTimeslot());
            switch (t.getDir()) {
                case Up: {
                    y1 -= (int)(animeRate * (double)this.cellHeight);
                    y2 -= (int)(animeRate * (double)this.cellHeight);
                    break;
                }
                case Down: {
                    y1 += (int)(animeRate * (double)this.cellHeight);
                    y2 += (int)(animeRate * (double)this.cellHeight);
                    break;
                }
                case Left: {
                    x1 -= (int)(animeRate * (double)this.cellWidth);
                    x2 -= (int)(animeRate * (double)this.cellWidth);
                    break;
                }
                case Right: {
                    x1 += (int)(animeRate * (double)this.cellWidth);
                    x2 += (int)(animeRate * (double)this.cellWidth);
                }
            }
        }
        switch (t.getDir()) {
            case Up: {
                angleStart = 90;
                break;
            }
            case Down: {
                angleStart = 270;
                break;
            }
            case Left: {
                angleStart = 180;
                break;
            }
            case Right: {
                angleStart = 0;
            }
        }
        int step = (int)(this.aho % 10L);
        if (step >= 5) {
            step = 10 - step;
        }
        int angleMove = 20 + step * 10;
        int xBegin = this.cellStartX(0);
        int xEnd = this.cellStartX(this.playField.getWidth());
        int yBegin = this.cellStartY(0);
        int yEnd = this.cellStartY(this.playField.getHeight());
        if (x1 < xBegin || y1 < yBegin || x2 > xEnd || y2 > yEnd) {
            int xWidth = xEnd - xBegin;
            int yWidth = yEnd - yBegin;
            if (!this.om.isTronHeadImage()) {
                this.g.setColor(Color.black);
                this.g.drawArc(xBegin + (x1 - xBegin + xWidth) % xWidth, yBegin + (y1 - yBegin + yWidth) % yWidth, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
                this.g.drawArc(xBegin + (x2 - xBegin) % xWidth - this.cellWidth, yBegin + (y2 - yBegin) % yWidth - this.cellWidth, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
                this.g.setColor(this.om.getTronColor(PlayField.playerTrail(t.getPlayerId())));
                this.g.fillArc(xBegin + (x1 - xBegin + xWidth) % xWidth, yBegin + (y1 - yBegin + yWidth) % yWidth, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
                this.g.fillArc(xBegin + (x2 - xBegin) % xWidth - this.cellWidth, yBegin + (y2 - yBegin) % yWidth - this.cellWidth, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
            }
        } else if (this.om.isTronHeadImage()) {
            AffineTransform aff = new AffineTransform();
            BufferedImage tronhead = this.tronsHeads.get(t.getPlayerId());
            BufferedImage dst = new BufferedImage(tronhead.getWidth(), tronhead.getHeight(), 2);
            switch (t.getDir()) {
                case Up: {
                    aff.quadrantRotate(3, tronhead.getWidth() / 2, tronhead.getHeight() / 2);
                    break;
                }
                case Down: {
                    aff.quadrantRotate(1, tronhead.getWidth() / 2, tronhead.getHeight() / 2);
                    break;
                }
                case Right: {
                    break;
                }
                case Left: {
                    aff.quadrantRotate(2, tronhead.getWidth() / 2, tronhead.getHeight() / 2);
                }
            }
            AffineTransformOp ato = new AffineTransformOp(aff, 1);
            ato.filter(tronhead, dst);
            this.g.drawImage(dst, x1, y1, this.cellWidth, this.cellHeight, this);
        } else {
            this.g.setColor(Color.black);
            this.g.drawArc(x1, y1, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
            this.g.setColor(this.om.getTronColor(PlayField.playerTrail(t.getPlayerId())));
            this.g.fillArc(x1, y1, this.cellWidth, this.cellHeight, angleStart + angleMove, 360 - (angleMove << 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScore() {
        this.g.setColor(this.om.getBoardBgColor());
        this.g.fillRect(0, 0, this.getSize().width, 0);
        this.g.fillRect(0, 0, 256, this.getSize().height);
        this.g.setFont(new Font("Monospaced", 1, 12));
        Graphics2D g2 = (Graphics2D)this.g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color counterColor = this.om.getCounterColor();
        this.g.setColor(counterColor);
        this.g.drawString(String.format("Round:%2d Turn:%4d (%4d)", this.playField.getRound(), this.playField.getTurn(), this.om.getMaxTurns()), 5, 14);
        Color scoreColor = this.om.getScoreColor();
        this.g.setColor(scoreColor);
        int i = 0;
        while (i < this.playField.getNumOfPlayers()) {
            int l = i + 2;
            this.g.drawString("Player " + i + ": " + this.playField.getScore(i).toString() + " (" + this.playField.getTotalScore(i).toString() + ")", 5, 0 + l * 16 - 2);
            ++i;
        }
        Color commentColor = this.om.getCommentColor();
        this.g.setColor(commentColor);
        Deque<String> deque = this.playField.getComments();
        synchronized (deque) {
            int i2 = this.playField.getNumOfPlayers() + 2;
            for (String comment : this.playField.getComments()) {
                this.g.drawString(comment, 5, 0 + i2 * 16 - 2);
                ++i2;
            }
        }
    }

    public int getMaxNumOfComments() {
        return (this.getDimension().height - 0) / 16 - 1 - this.playField.getNumOfPlayers();
    }

    public Dimension getDimension() {
        return new Dimension(this.cellWidth * this.playField.getWidth() + 256, this.cellHeight * this.playField.getHeight() + 0);
    }
}

