/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.DisplayManager;
import jp.ac.nii.icpc2010.manager.GameManager;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.playfield.PlayField;

public class Main
implements KeyListener {
    private final PlayField _field;
    private DisplayManager _dmanager;
    private OptionsManager om;

    public static void main(String[] args) {
        OptionsManager om = new OptionsManager(args);
        Main main = new Main(om);
        if (!om.isTournamentMode()) {
            DisplayManager dmanager = main._dmanager = new DisplayManager("Tron", main._field, om);
            dmanager.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dmanager.addKeyListener(main);
            Thread thDisplay = new Thread(dmanager);
            thDisplay.start();
        }
        try {
            Thread.sleep(om.getOpeningTime());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        GameManager gmanager = null;
        try {
            gmanager = new GameManager(main._field, om);
        }
        catch (TronException te) {
            te.printStackTrace();
            System.exit(1);
        }
        Thread thGame = new Thread(gmanager);
        thGame.start();
        while (thGame.isAlive()) {
            try {
                thGame.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (!om.isTournamentMode()) {
            System.out.println("game ends");
        }
    }

    private Main(OptionsManager om) {
        this.om = om;
        this._field = new PlayField(om);
        try {
            this._field.init(om.getOpeningName());
        }
        catch (TronException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 49: {
                long timeslot = this.om.getTurnTimeslot() + 50L;
                this.om.setTurnTimeslot(timeslot);
                System.out.println("Timeslot " + timeslot + ".");
                break;
            }
            case 50: {
                long oldTimeslot = this.om.getTurnTimeslot();
                long timeslot = Math.max(oldTimeslot - 50L, 0L);
                this.om.setTurnTimeslot(timeslot);
                if (timeslot == oldTimeslot) break;
                System.out.println("Timeslot " + timeslot + ".");
                break;
            }
            case 65: {
                if (this._dmanager == null) break;
                this._dmanager.incrementCellWidth();
                break;
            }
            case 83: {
                if (this._dmanager == null) break;
                this._dmanager.incrementCellHeight();
                break;
            }
            case 68: {
                if (this._dmanager == null) break;
                this._dmanager.decrementCellWidth();
                break;
            }
            case 70: {
                if (this._dmanager == null) break;
                this._dmanager.decrementCellHeight();
                break;
            }
            default: {
                this._field.setKeyPressed(e);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

