/*
 * Calcul.java
 * SKELETON GENERATED BY XELFI VISUAL IDE
 */

import java.awt.*;
import xelfi.awt.Panel3D;

// Here go your own imports:

public class Calcul extends Frame {
  public Calcul() {
    super();
    setBackground(Color.lightGray);
    setForeground(Color.black);
    setTitle("Calculator");
    displayPanel = new Panel3D();
    displayPanel.setLayout(new BorderLayout());
    add("North", displayPanel);
    display = new Label("0");
    display.enable();
    display.show();
    display.setFont(new Font("Courier", Font.BOLD, 24));
    display.setAlignment(Label.RIGHT);
    displayPanel.add("Center", display);
    controlPanel = new Panel3D();
    controlPanel.setLayout(new BorderLayout());
    add("Center", controlPanel);
    mainPanel = new Panel3D();
    mainPanel.setLayout(new FlowLayout());
    controlPanel.add("North", mainPanel);
    but_C = new Button("C");
    but_C.enable();
    but_C.show();
    mainPanel.add(but_C);
    but_back = new Button("Back");
    but_back.enable();
    but_back.show();
    mainPanel.add(but_back);
    operPanel = new Panel3D();
    operPanel.setLayout(new GridLayout(4, 2));
    controlPanel.add("Center", operPanel);
    but_7 = new Button("7");
    but_7.enable();
    but_7.show();
    operPanel.add(but_7);
    but_8 = new Button("8");
    but_8.enable();
    but_8.show();
    operPanel.add(but_8);
    but_9 = new Button("9");
    but_9.enable();
    but_9.show();
    operPanel.add(but_9);
    but_4 = new Button("4");
    but_4.enable();
    but_4.show();
    operPanel.add(but_4);
    but_5 = new Button("5");
    but_5.enable();
    but_5.show();
    operPanel.add(but_5);
    but_6 = new Button("6");
    but_6.enable();
    but_6.show();
    operPanel.add(but_6);
    but_1 = new Button("1");
    but_1.enable();
    but_1.show();
    operPanel.add(but_1);
    but_2 = new Button("2");
    but_2.enable();
    but_2.show();
    operPanel.add(but_2);
    but_3 = new Button("3");
    but_3.enable();
    but_3.show();
    operPanel.add(but_3);
    but_0 = new Button("0");
    but_0.enable();
    but_0.show();
    operPanel.add(but_0);
    but_dot = new Button(",");
    but_dot.enable();
    but_dot.show();
    operPanel.add(but_dot);
    but_sgn = new Button("+/-");
    but_sgn.enable();
    but_sgn.show();
    operPanel.add(but_sgn);
    numPanel = new Panel3D();
    numPanel.setLayout(new GridLayout(5, 2));
    controlPanel.add("East", numPanel);
    but_plus = new Button("+");
    numPanel.add(but_plus);
    but_minus = new Button("-");
    numPanel.add(but_minus);
    but_mul = new Button("*");
    numPanel.add(but_mul);
    but_div = new Button("/");
    numPanel.add(but_div);
    but_eq = new Button("=");
    numPanel.add(but_eq);
    // Here goes your own init code:
    setDefaults();

    addNotify();
    reshape(0, 0, 360, 439);
    show();
  }

  public boolean handleEvent(Event evt) {
    if ((evt.target == this) && (evt.id == Event.WINDOW_DESTROY)) {
      hide();
      dispose();
      System.exit(0);
    }
     if (evt.id == Event.ACTION_EVENT && evt.target == but_eq)
      return but_eqOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_div)
      return but_divOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_mul)
      return but_mulOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_minus)
      return but_minusOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_plus)
      return but_plusOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_sgn)
      return but_sgnOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_dot)
      return but_dotOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_0)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_3)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_2)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_1)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_6)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_5)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_4)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_9)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_8)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_7)
      return but_numOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_back)
      return but_backOnClick(evt);
    if (evt.id == Event.ACTION_EVENT && evt.target == but_C)
      return but_COnClick(evt);
   return super.handleEvent(evt);
  }

// Event handlers

  public boolean but_numOnClick(Event evt) {
    // Here you can write your own handling code
    if (!perzist) {
        perzist = true;
        clearDisplay();
    }
    if (state == ST_B)
        state = ST_C;
    if (state == ST_D)
        state = ST_A;
    int pressedButton = -1;
    if (evt.target == but_0)
        pressedButton = 0;
    if (evt.target == but_1)
        pressedButton = 1;
    if (evt.target == but_2)
        pressedButton = 2;
    if (evt.target == but_3)
        pressedButton = 3;
    if (evt.target == but_4)
        pressedButton = 4;
    if (evt.target == but_5)
        pressedButton = 5;
    if (evt.target == but_6)
        pressedButton = 6;
    if (evt.target == but_7)
        pressedButton = 7;
    if (evt.target == but_8)
        pressedButton = 8;
    if (evt.target == but_9)
        pressedButton = 9;
    if (dot) {
        if (value2 > (Long.MAX_VALUE / 10))
            return true;
        value2 *= 10;
        value2 += pressedButton;
        size2++;
    }
    else {
        if (value1 > (Long.MAX_VALUE / 10))
            return true;
        value1 *= 10;
        value1 += pressedButton;
    }
    updateDisplay();
    return true;
  }

  public boolean but_COnClick(Event evt) {
    // Here you can write your own handling code
    setDefaults();
    updateDisplay();
    return true;
  }

  public boolean but_backOnClick(Event evt) {
    // Here you can write your own handling code
    if (((state != ST_A) && (state != ST_C)) || (!perzist))
          return true;
    if (dot) {
        if (size2 == 0) {
            dot = false;
        }
        else {
            size2--;
            value2 /= 10;
        }
    }
    else {
        value1 /= 10;
    }
    updateDisplay();
    return true;
  }

  public boolean but_plusOnClick(Event evt) {
    // Here you can write your own handling code
    operation(OP_PLUS);
    return true;
  }

  public boolean but_minusOnClick(Event evt) {
    // Here you can write your own handling code
    operation(OP_MINUS);
    return true;
  }

  public boolean but_mulOnClick(Event evt) {
    // Here you can write your own handling code
    operation(OP_MUL);
    return true;
  }

  public boolean but_divOnClick(Event evt) {
    // Here you can write your own handling code
    operation(OP_DIV);
    return true;
  }

  public boolean but_eqOnClick(Event evt) {
    // Here you can write your own handling code
    switch (state) {
        case ST_A: break;
        case ST_B:
        case ST_C: if (calculate()) {
                       state = ST_D;
                       perzist = false;
                   }
                   break;
        case ST_D:
        case ST_E: break;
    }
    return true;
  }

  public boolean but_sgnOnClick(Event evt) {
    // Here you can write your own handling code
    if (state == ST_E)
         return true;
    sgn = !sgn;
    updateDisplay();
    return true;
  }

  public boolean but_dotOnClick(Event evt) {
    // Here you can write your own handling code
    if ((state == ST_E) || (perzist && dot))
        return true;
    if (!perzist) {
        perzist = true;
        clearDisplay();
    }
    if (state == ST_B)
        state = ST_C;
    if (state == ST_D)
        state = ST_A;
    dot = true;
    updateDisplay();
    return true;
  }

// End of event handlers

  public static void main(String args[]) {
    new Calcul();
  }

  Panel3D displayPanel;
  Label display;
  Panel3D controlPanel;
  Panel3D mainPanel;
  Button but_C;
  Button but_back;
  Panel3D operPanel;
  Button but_7;
  Button but_8;
  Button but_9;
  Button but_4;
  Button but_5;
  Button but_6;
  Button but_1;
  Button but_2;
  Button but_3;
  Button but_0;
  Button but_dot;
  Button but_sgn;
  Panel3D numPanel;
  Button but_plus;
  Button but_minus;
  Button but_mul;
  Button but_div;
  Button but_eq;

// Place for other methods/variables:
  long value1, value2;
  int size2;
  boolean sgn;
  boolean dot;

  double current, buffer;

  boolean perzist;

  int state;
  static final int ST_A = 0;
  static final int ST_B = 1;
  static final int ST_C = 2;
  static final int ST_D = 3;
  static final int ST_E = 4;

  int oper;
  static final int OP_NOTHING = 0;
  static final int OP_PLUS = 1;
  static final int OP_MINUS = 2;
  static final int OP_MUL = 3;
  static final int OP_DIV = 4;

  void setDefaults() {
       clearDisplay();
       current = 0;
       buffer = 0;
       int oper = OP_NOTHING;
       perzist = true;
       state = ST_A;
  }

  void clearDisplay() {
      value1 = 0;
      value2 = 0;
      size2 = 0;
      sgn = true;
      dot = false;
  }

  void updateDisplay() {
       String s = "";
       if (state != ST_E) {
           if (!sgn)
               s += "-";
           s += Long.toString(value1);
           if (dot) {
               s += ".";
               if (size2 > 0) {
                   String s2 = Long.toString(value2);
                   int dif = size2 - s2.length();
                   if (dif > 0)
                       for (int i = 1; i <= dif; i++)
                           s += "0";
                   s += s2;
               }
           }
           try {
              current = new Double(s).doubleValue();
           }
           catch (NumberFormatException e) {
               System.out.println("Internal error.");
           }
       }
       else {
           s = "Error";
       }
       display.setText(s);
  }

  void error() {
       state = ST_E;
       updateDisplay();
  }

  void operation(int aOper) {
    switch (state) {
        case ST_C: if (!calculate())
                        return;
                   break;
        case ST_E: return;
    }
    state = ST_B;
    oper = aOper;
    perzist = false;
    updateDisplay();
    buffer = current;
    return;
  }

  boolean calculate() {
    if ((oper == OP_NOTHING) || ((state != ST_B)&&(state != ST_C)))
         return false;
    switch (oper) {
        case OP_PLUS:  if (buffer+current > Long.MAX_VALUE) {
                       error();
                       return false;
                  }
                  current += buffer;
                  break;
        case OP_MINUS: if (buffer-current < Long.MIN_VALUE) {
                       error();
                       return false;
                  }
                  current = buffer - current;
                  break;
        case OP_MUL: if (buffer*current > Long.MAX_VALUE) {
                       error();
                       return false;
                  }
                  current = buffer * current;
                  break;
        case OP_DIV: if ((current == 0) || (buffer/current < Long.MIN_VALUE)) {
                       error();
                       return false;
                  }
                  current = buffer / current;
                  break;
    }
    buffer = current;
    double tmp = current;
    clearDisplay();
    if (current < 0) {
        sgn = false;
        tmp = -tmp;
    }
    value1 = new Double(tmp).longValue();
    tmp -= value1;
    String s = Double.toString(tmp);
    int pos = s.indexOf(".");
    try {
        if (pos != -1) {
            value2 = new Long(s.substring(pos+1)).longValue();
            size2 = s.substring(pos).length()-1;
            if (value2 == 0) {
                size2 = 0;
                dot = false;
            }
            else
                dot = true;
        }
    }
    catch (NumberFormatException e) {
        error();
        return false;
    }
    oper = OP_NOTHING;
    updateDisplay();
    return true;
  }

}


