/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) CharacterConverter.java 1.6 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

/**
 * Converts Character objects to strings and back again.
 *
 * @see Character
 * @version 	1.6, 07/18/96
 */
public class CharacterConverter extends Converter {
  /**
   * Converts a Character to a string.
   *
   * @param obj a instance of Character
   */
  public String convertToString(Object obj) {
    Character c = (Character)obj;
    if (c.charValue() == (char)0)
      return "";
    else
      return(c.toString());
  }

  /**
   * Converts a string into a Character.  Uses only the first letter in the
   * string.
   */
  public Object convertFromString(String s) {
    if (s == null || s.equals("")) {
      return new Character((char)0);
    }
    else {
      return new Character(s.charAt(0));
    }
  }

  /**
   * Returns a block of code that will create a Character liek the one given.
   *
   * @param obj a instance of Character
   */
  public String convertToCode(Object obj) {
    return("new Character('" + ((Character) obj).toString() + "')");
  }
}
