/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) TextFieldShadow.java 1.28 - last change made 08/08/96 
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import java.awt.*;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    numColumns      java.lang.Integer         10 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see TextField
 * @version 	1.28, 08/08/96
 */
public class TextFieldShadow extends TextComponentShadow {

  public TextFieldShadow() {
    attributes.add("text", "java.lang.String", "", NOEDITOR);
    attributes.add("numColumns", "java.lang.Integer", new Integer(10),
		   CONSTRUCTOR);

    // This is a constructor attribute because the "setEchoCharater"
    // method does not actually update the text on Windows.  Also,
    // the workaround which is to set the text again does not
    // work on Motif!

// doesn't work so remove it for 1.0 FCS
// when it is added back in make sure to add the following to the
// javadoc section above
//    echoCharacter   java.lang.Character       new Character((char) 0)
//
//    attributes.add("echoCharacter", "java.lang.Character",
//		   new Character((char)0), CONSTRUCTOR);

    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.HORIZONTAL;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);

    // Workaround for layout problems caused by the fact that
    // textfields on all platforms except WindowsNT have gaps around
    // the border of the textfield.
    if (Global.isWindowsNT()) {
      attributes.add("insets", "java.awt.Insets", new Insets(2, 2, 2, 2));
    }
  }

  protected Object getOnBody(String key) {
    if (key.equals("numColumns"))
      return(new Integer((((TextField) body).getColumns())));
    // if (key.equals("echoCharacter"))
    //   return(new Character((((TextField) body).getEchoChar())));
    // else
    return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    if (key.equals("numColumns"))
      return;	// can't set this attribute dynamically
    // else if (key.equals("echoCharacter")) 
    //   return;	// can't set this attribute dynamically
    // else
    super.setOnBody(key, value);
  }

  public void createBody() {
    boolean initText, initColumns;
    String initTextValue;
    Integer initColumnsValue;
    Character echoChar;

    initTextValue = (String) (getFromTable("text"));
    initText = (initTextValue != null);

    initColumnsValue = (Integer) (getFromTable("numColumns"));
    initColumns = (initColumnsValue != null);

    if (initText & initColumns)
      body = new TextField (initTextValue, initColumnsValue.intValue());
    else if (initColumns)
      body = new TextField (initColumnsValue.intValue());
    else if (initText)
      body = new TextField (initTextValue);
    else
      body = new TextField();

    // echoChar = (Character) get ("echoCharacter");
    // if (echoChar != null) {
    //   ((TextField) body).setEchoCharacter(echoChar.charValue());
    // }
  }
}
